/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class JSONUtils {
    JSONUtils() {
    }

    protected static boolean getBooleanFromJSON(JSONObject json, String key, boolean defaultValue) {
        boolean ret = json.optBoolean(key, defaultValue);
        return ret;
    }

    protected static String getStringFromJSON(JSONObject json, String key, String defaultValue) {
        String ret = json.optString(key, defaultValue);
        return ret;
    }

    protected static int getIntegerFromJSON(JSONObject json, String key, int defaultValue) {
        int ret = json.optInt(key, defaultValue);
        return ret;
    }

    protected static long getLongFromJSON(JSONObject json, String key, long defaultValue) {
        long ret = json.optLong(key, defaultValue);
        return ret;
    }

    protected static JSONArray getJSONArrayFromJSON(JSONObject json, String key) {
        JSONArray ret = json.optJSONArray(key);
        return ret;
    }

    protected static int getIntegerFromJSONArray(JSONArray jsonArray, int index, int defaultValue) {
        int ret = jsonArray.optInt(index, defaultValue);
        return ret;
    }

    protected static JSONObject getJSONObjectFromJSONArray(JSONArray jsonArray, int index) {
        try {
            return jsonArray.getJSONObject(index);
        }
        catch (JSONException jSONException) {
            return null;
        }
    }

    protected static void put(JSONObject json, String key, String value) {
        if (value != null && !value.equals("")) {
            try {
                json.put(key, (Object)value);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
    }

    protected static void put(JSONObject json, String key, int value) {
        try {
            json.put(key, value);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    protected static void put(JSONObject json, String key, long value) {
        try {
            json.put(key, value);
        }
        catch (JSONException e) {
            // empty catch block
        }
    }

    protected static JSONObject getJSONObjectFromString(String str) {
        try {
            return new JSONObject(str);
        }
        catch (JSONException e) {
            return null;
        }
    }
}

