/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.AsyncTask;
import android.os.Build;
import android.util.DisplayMetrics;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.webkit.WebView;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import com.amazon.device.ads.AdUtils;
import com.amazon.device.ads.AdView;
import com.amazon.device.ads.AdWebViewClient;
import com.amazon.device.ads.AndroidTargetUtils;
import com.amazon.device.ads.Assets;
import com.amazon.device.ads.DeviceInfo;
import com.amazon.device.ads.IAdActivityAdapter;
import com.amazon.device.ads.MraidView;
import com.amazon.device.ads.ThreadUtils;
import com.amazon.device.ads.WebViewFactory;

class InterstitialAdActivityAdapter
implements IAdActivityAdapter,
AdView {
    private Activity activity = null;
    private String uniqueId = null;
    private final int CLOSE_BUTTON_SIZE_DP = 60;
    private final int CLOSE_BUTTON_TAP_TARGET_SIZE_DP = 80;

    InterstitialAdActivityAdapter() {
    }

    public void setActivity(Activity activity) {
        this.activity = activity;
    }

    public void preOnCreate() {
        this.activity.requestWindowFeature(1);
        this.activity.getWindow().setFlags(1024, 1024);
        if (Build.VERSION.SDK_INT > 11) {
            AndroidTargetUtils.hideActionAndStatusBars(this.activity);
        }
    }

    public void onCreate() {
        WebView webView = WebViewFactory.getInstance().createWebView((Context)this.activity);
        if (DeviceInfo.getUserAgentString() == null) {
            String userAgent = webView.getSettings().getUserAgentString();
            DeviceInfo.setUserAgentString(userAgent);
        }
        this.uniqueId = this.activity.getIntent().getStringExtra("uniqueIdentifier");
        String html = this.activity.getIntent().getStringExtra("creative");
        html = html.replace("<head>", "<head>\n  <script type='text/javascript'>\n  function fireImpression(a) {\n    var container = document.createElement('div');\n    var pix = document.createElement('img');\n    pix.setAttribute('src', a);\n    pix.style.position = 'absolute';\n    pix.style.top = '0px';\n    pix.style.right = '0px';\n    pix.style.display = 'none';\n    container.appendChild(pix);\n    document.body.appendChild(container);\n  }\n  </script>\n");
        MraidView mraidView = MraidView.removeCachedMraidView(this.uniqueId);
        if (mraidView == null) {
            webView.setBackgroundColor(0);
            mraidView = new MraidView(this, (Context)this.activity, webView);
        } else {
            mraidView.registerReceivers();
            mraidView.setAdView(this);
        }
        mraidView.loadHtmlData("http://amazon-adsystem.amazon.com/", html);
        this.addNativeCloseButton(mraidView);
        this.activity.setContentView((View)mraidView);
    }

    private void addNativeCloseButton(final FrameLayout parentView) {
        DisplayMetrics metrics = new DisplayMetrics();
        WindowManager wm = (WindowManager)this.activity.getSystemService("window");
        wm.getDefaultDisplay().getMetrics(metrics);
        final int buttonSize = (int)(60.0f * metrics.density + 0.5f);
        final int tapTargetSize = (int)(80.0f * metrics.density + 0.5f);
        final BitmapDrawable closeNormal = AndroidTargetUtils.getNewBitmapDrawable(this.activity.getResources(), Assets.getInstance().getFilePath("amazon_ads_interstitial_close_normal.png"));
        final BitmapDrawable closePressed = AndroidTargetUtils.getNewBitmapDrawable(this.activity.getResources(), Assets.getInstance().getFilePath("amazon_ads_interstitial_close_pressed.png"));
        AsyncTask<Void, Void, RelativeLayout> closeButtonTask = new AsyncTask<Void, Void, RelativeLayout>(){

            protected RelativeLayout doInBackground(Void ... empty) {
                RelativeLayout tapTarget = new RelativeLayout(parentView.getContext());
                ImageButton closeButton = new ImageButton(parentView.getContext());
                closeButton.setImageDrawable((Drawable)closeNormal);
                closeButton.setScaleType(ImageView.ScaleType.FIT_CENTER);
                closeButton.setBackgroundDrawable(null);
                View.OnClickListener onClickListener = new View.OnClickListener(){

                    public void onClick(View v) {
                        InterstitialAdActivityAdapter.this.activity.finish();
                    }
                };
                closeButton.setOnClickListener(onClickListener);
                tapTarget.setOnClickListener(onClickListener);
                View.OnTouchListener onTouchListener = new View.OnTouchListener((ImageView)closeButton){
                    final /* synthetic */ ImageView val$closeButton;
                    {
                        this.val$closeButton = imageView;
                    }

                    public boolean onTouch(View v, MotionEvent event) {
                        switch (event.getAction()) {
                            case 0: {
                                this.val$closeButton.setImageDrawable((Drawable)closePressed);
                                break;
                            }
                            case 1: {
                                this.val$closeButton.setImageDrawable((Drawable)closeNormal);
                            }
                        }
                        return false;
                    }
                };
                tapTarget.setOnTouchListener(onTouchListener);
                closeButton.setOnTouchListener(onTouchListener);
                RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(buttonSize, buttonSize);
                params.addRule(13);
                tapTarget.addView((View)closeButton, (ViewGroup.LayoutParams)params);
                return tapTarget;
            }

            protected void onPostExecute(RelativeLayout tapTarget) {
                FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(tapTargetSize, tapTargetSize, 5);
                layoutParams.topMargin = 0;
                layoutParams.rightMargin = 0;
                parentView.addView((View)tapTarget, (ViewGroup.LayoutParams)layoutParams);
            }
        };
        ThreadUtils.executeAsyncTask(closeButtonTask, new Void[0]);
    }

    public void onPause() {
    }

    public void onResume() {
    }

    public void onStop() {
        if (this.activity.isFinishing()) {
            this.sendBroadcast("dismissed");
        }
    }

    Activity getActivity() {
        return this.activity;
    }

    public boolean isAdViewRenderable() {
        return true;
    }

    public void onPageFinished() {
        this.sendBroadcast("finished");
    }

    private void sendBroadcast(String broadcastAction) {
        Intent intent = new Intent("amazon.mobile.ads.interstitial");
        intent.putExtra("action", broadcastAction);
        intent.putExtra("uniqueIdentifier", this.uniqueId);
        this.activity.sendBroadcast(intent);
    }

    public boolean launchExternalBrowserForLink(String url) {
        if (this.isAdViewRenderable()) {
            return AdUtils.launchActivityForIntentLink(url, (Context)this.activity);
        }
        return false;
    }

    public int getHeight() {
        return 0;
    }

    public AdWebViewClient.UrlExecutor getSpecialUrlExecutor() {
        return new AdWebViewClient.AmazonMobileExecutor(this, (Context)this.activity);
    }

    public boolean shouldDisableWebViewHardwareAcceleration() {
        return false;
    }
}

