/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Handler;
import android.webkit.WebView;
import com.amazon.device.ads.Ad;
import com.amazon.device.ads.AdActivity;
import com.amazon.device.ads.AdData;
import com.amazon.device.ads.AdError;
import com.amazon.device.ads.AdListener;
import com.amazon.device.ads.AdLoader;
import com.amazon.device.ads.AdProperties;
import com.amazon.device.ads.AdSize;
import com.amazon.device.ads.AdSlot;
import com.amazon.device.ads.AdTargetingOptions;
import com.amazon.device.ads.AdUtils;
import com.amazon.device.ads.AdView;
import com.amazon.device.ads.AdWebViewClient;
import com.amazon.device.ads.DefaultAdListener;
import com.amazon.device.ads.IAdLoaderCallback;
import com.amazon.device.ads.InternalAdRegistration;
import com.amazon.device.ads.InterstitialAdActivityAdapter;
import com.amazon.device.ads.Log;
import com.amazon.device.ads.Metrics;
import com.amazon.device.ads.MraidView;
import com.amazon.device.ads.WebRequest;
import com.amazon.device.ads.WebViewFactory;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;

public class InterstitialAd
implements Ad {
    private static final String LOG_TAG = "InterstitialAd";
    protected static final String BROADCAST_INTENT = "amazon.mobile.ads.interstitial";
    protected static final String BROADCAST_ACTION = "action";
    protected static final String ACTION_INTERSTITIAL_DISMISSED = "dismissed";
    protected static final String ACTION_INTERSTITIAL_FINISHED_LOADING = "finished";
    protected static final String BROADCAST_UNIQUE_IDENTIFIER_KEY = "uniqueIdentifier";
    protected static final String BROADCAST_CREATIVE = "creative";
    protected static final String MSG_PREPARE_AD_DESTROYED = "This interstitial ad has been destroyed and can no longer be used. Create a new InterstitialAd object to load a new ad.";
    protected static final String MSG_PREPARE_AD_SHOWING = "An interstitial ad is currently showing. Please wait for the user to dismiss the ad before loading an ad.";
    protected static final String MSG_PREPARE_AD_READY_TO_SHOW = "An interstitial ad is ready to show. Please call showAd() to show the ad before loading another ad.";
    protected static final String MSG_PREPARE_AD_LOADING = "An interstitial ad is currently loading. Please wait for the ad to finish loading and showing before loading another ad.";
    protected static final String MSG_SHOW_AD_EXPIRED = "This interstitial ad has expired. Please load another ad.";
    protected static final String MSG_SHOW_AD_ANOTHER_SHOWING = "Another interstitial ad is currently showing. Please wait for the InterstitialAdListener.onAdDismissed callback of the other ad.";
    protected static final String MSG_SHOW_AD_DESTROYED = "The interstitial ad cannot be shown because it has been destroyed. Create a new InterstitialAd object to load a new ad.";
    protected static final String MSG_SHOW_AD_DISMISSED = "The interstitial ad cannot be shown because it has already been displayed to the user. Please call loadAd(AdTargetingOptions) to load a new ad.";
    protected static final String MSG_SHOW_AD_READY_TO_LOAD = "The interstitial ad cannot be shown because it has not loaded successfully. Please call loadAd(AdTargetingOptions) to load an ad first.";
    protected static final String MSG_SHOW_AD_LOADING = "The interstitial ad cannot be shown because it is still loading. Please wait for the AdListener.onAdLoaded() callback before showing the ad.";
    protected static final String MSG_SHOW_AD_SHOWING = "The interstitial ad cannot be shown because it is already displayed on the screen. Please wait for the InterstitialAdListener.onAdDismissed() callback and then load a new ad.";
    private static final AtomicBoolean isAdShowing = new AtomicBoolean(false);
    private final Activity activity;
    private final String uniqueIdentifier;
    private IAdLoaderCallback adLoaderCallback;
    private AdListener adListener = null;
    private State state;
    private AdData adData = null;
    private int timeout = 20000;
    private BroadcastReceiver broadcastReceiver = null;
    private boolean hasPassedActivityValidationCheck;
    private final AtomicBoolean isPrerendering = new AtomicBoolean(false);
    private final AtomicBoolean hasFinishedLoading = new AtomicBoolean(false);
    private Timer timer;
    private MraidView mraidView;

    InterstitialAd(Activity activity, String uniqueIdentifier) {
        if (activity == null) {
            throw new IllegalArgumentException("InterstitialAd requires a non-null Activity");
        }
        this.activity = activity;
        this.uniqueIdentifier = uniqueIdentifier;
        this.adLoaderCallback = new InterstitialAdLoaderCallback(this);
        this.initialize();
    }

    public InterstitialAd(Activity activity) {
        this(activity, InterstitialAd.generateUniqueIdentifier());
    }

    private void initialize() {
        InternalAdRegistration.getInstance().contextReceived(this.activity.getApplicationContext());
        this.setState(State.READY_TO_LOAD);
        this.adListener = new DefaultAdListener(LOG_TAG);
        this.hasPassedActivityValidationCheck = AdUtils.checkDefinedActivities(this.activity.getApplicationContext());
    }

    private static String generateUniqueIdentifier() {
        return UUID.randomUUID().toString();
    }

    static void resetIsAdShowing() {
        isAdShowing.set(false);
    }

    AdData getAdData() {
        return this.adData;
    }

    public void setListener(AdListener adListener) {
        this.adListener = adListener == null ? new DefaultAdListener(LOG_TAG) : adListener;
    }

    void setAdLoaderCallback(IAdLoaderCallback adLoaderCallback) {
        this.adLoaderCallback = adLoaderCallback;
    }

    public boolean loadAd() {
        return this.loadAd(null);
    }

    public boolean loadAd(AdTargetingOptions options) {
        return AdLoader.loadAds(this.getTimeout(), options, new AdSlot(this, options))[0];
    }

    int prepareAd(AdLoader.AdReadyToLoadListener listener) {
        long loadAdStartTime = System.nanoTime();
        if (!this.hasPassedActivityValidationCheck) {
            String msg = "Ads cannot load unless \"com.amazon.device.ads.AdActivity\" is correctly declared as an activity in AndroidManifest.xml. Consult the online documentation for more info.";
            this.onRequestError("Ads cannot load unless \"com.amazon.device.ads.AdActivity\" is correctly declared as an activity in AndroidManifest.xml. Consult the online documentation for more info.");
            return 1;
        }
        if (!this.isReadyToLoad()) {
            boolean failLoad = true;
            if (this.isShowing()) {
                Log.e(LOG_TAG, MSG_PREPARE_AD_SHOWING);
            } else if (this.isReadyToShow()) {
                if (this.getAdData() != null && this.getAdData().isExpired()) {
                    failLoad = false;
                } else {
                    Log.e(LOG_TAG, MSG_PREPARE_AD_READY_TO_SHOW);
                }
            } else if (this.isLoading()) {
                Log.e(LOG_TAG, MSG_PREPARE_AD_LOADING);
            }
            if (failLoad) {
                return -1;
            }
        }
        this.isPrerendering.set(false);
        this.setHasFinishedLoading(false);
        if (this.timer != null) {
            this.timer.purge();
        }
        this.timer = new Timer();
        this.timer.schedule(new TimerTask(){

            public void run() {
                if (!InterstitialAd.this.getAndSetHasFinishedLoading(true)) {
                    InterstitialAd.this.onAdTimedOut();
                }
            }
        }, this.getTimeout());
        this.setState(State.LOADING);
        this.setAdData(new AdData(AdSize.SIZE_INTERSTITIAL));
        this.getAdData().getMetricsCollector().startMetricInMillisecondsFromNanoseconds(Metrics.MetricType.AD_LATENCY_TOTAL, loadAdStartTime);
        this.getAdData().getMetricsCollector().startMetricInMillisecondsFromNanoseconds(Metrics.MetricType.AD_LATENCY_TOTAL_FAILURE, loadAdStartTime);
        this.getAdData().getMetricsCollector().startMetricInMillisecondsFromNanoseconds(Metrics.MetricType.AD_LATENCY_TOTAL_SUCCESS, loadAdStartTime);
        this.getAdData().getMetricsCollector().startMetricInMillisecondsFromNanoseconds(Metrics.MetricType.AD_LOAD_LATENCY_LOADAD_TO_FETCH_THREAD_REQUEST_START, loadAdStartTime);
        listener.onAdReady(this);
        return 0;
    }

    public static boolean isAdShowing() {
        return isAdShowing.get();
    }

    public boolean isLoading() {
        return this.getState() == State.LOADING;
    }

    public boolean isShowing() {
        return this.getState() == State.SHOWING;
    }

    boolean isReadyToLoad() {
        return this.getState() == State.READY_TO_LOAD || this.hasDismissed();
    }

    boolean isReadyToShow() {
        return this.getState() == State.READY_TO_SHOW;
    }

    boolean hasDismissed() {
        return this.getState() == State.DISMISSED;
    }

    boolean isExpired() {
        return this.getAdData().isExpired();
    }

    State getState() {
        return this.state;
    }

    void setState(State state) {
        this.state = state;
    }

    void setAdData(AdData adData) {
        this.adData = adData;
    }

    public boolean showAd() {
        long renderLatencyStartTime = System.nanoTime();
        if (this.isReadyToShow()) {
            if (this.isExpired()) {
                Log.w(LOG_TAG, MSG_SHOW_AD_EXPIRED);
                this.setState(State.READY_TO_LOAD);
                return false;
            }
            if (isAdShowing.getAndSet(true)) {
                Log.w(LOG_TAG, MSG_SHOW_AD_ANOTHER_SHOWING);
                return false;
            }
            this.getAdData().getMetricsCollector().stopMetricInMillisecondsFromNanoseconds(Metrics.MetricType.AD_LOADED_TO_AD_SHOW_TIME, renderLatencyStartTime);
            this.getAdData().getMetricsCollector().startMetricInMillisecondsFromNanoseconds(Metrics.MetricType.AD_SHOW_LATENCY, renderLatencyStartTime);
            this.registerBroadcastReceiver();
            MraidView.cacheMraidView(this.uniqueIdentifier, this.mraidView);
            this.mraidView = null;
            boolean activityShown = this.showAdInActivity();
            if (activityShown) {
                this.setState(State.SHOWING);
            } else {
                MraidView.removeCachedMraidView(this.uniqueIdentifier);
                this.unregisterBroadcastReceiver();
                this.setState(State.READY_TO_LOAD);
                isAdShowing.set(false);
                this.getAdData().getMetricsCollector().stopMetric(Metrics.MetricType.AD_LATENCY_RENDER_FAILED);
            }
            return activityShown;
        }
        if (this.hasDismissed()) {
            Log.w(LOG_TAG, MSG_SHOW_AD_DISMISSED);
        } else if (this.isReadyToLoad()) {
            Log.w(LOG_TAG, MSG_SHOW_AD_READY_TO_LOAD);
        } else if (this.isLoading()) {
            Log.w(LOG_TAG, MSG_SHOW_AD_LOADING);
        } else if (this.isShowing()) {
            Log.w(LOG_TAG, MSG_SHOW_AD_SHOWING);
        }
        return false;
    }

    boolean showAdInActivity() {
        try {
            Intent intent = new Intent(this.activity.getApplicationContext(), AdActivity.class);
            intent.putExtra("adapter", InterstitialAdActivityAdapter.class.getName());
            intent.putExtra(BROADCAST_UNIQUE_IDENTIFIER_KEY, this.uniqueIdentifier);
            intent.putExtra(BROADCAST_CREATIVE, this.adData.getCreative());
            this.activity.startActivity(intent);
        }
        catch (ActivityNotFoundException e) {
            Log.e(LOG_TAG, "Failed to show the interstitial ad because AdActivity could not be found.");
            return false;
        }
        return true;
    }

    void prerenderHtml() {
        this.isPrerendering.set(true);
        String html = AdUtils.encloseHtml(this.adData.getCreative(), true).replace("<head>", "<head>\n  <script type='text/javascript'>\n  var connectionType=\"" + this.adData.getConnectionType() + "\";\n" + "  var screenWidth=" + this.adData.getScreenWidth() + ";\n" + "  var screenHeight=" + this.adData.getScreenHeight() + ";\n" + "  </script>\n");
        this.adData.setCreative(html);
        WebView webView = WebViewFactory.getInstance().createWebView((Context)this.activity);
        webView.setBackgroundColor(0);
        this.mraidView = this.constructMraidView(webView);
        long renderLatencyStartTime = System.nanoTime();
        this.getAdData().getMetricsCollector().stopMetricInMillisecondsFromNanoseconds(Metrics.MetricType.AD_LOAD_LATENCY_FINALIZE_FETCH_START_TO_RENDER_START, renderLatencyStartTime);
        this.getAdData().getMetricsCollector().startMetricInMillisecondsFromNanoseconds(Metrics.MetricType.AD_LATENCY_RENDER, renderLatencyStartTime);
        this.loadHtml(html);
    }

    MraidView constructMraidView(WebView webView) {
        MraidView mraidView = new MraidView(new AdView(){

            public boolean isAdViewRenderable() {
                return true;
            }

            public void onPageFinished() {
                long renderStopTime = System.nanoTime();
                InterstitialAd.this.getAdData().getMetricsCollector().stopMetricInMillisecondsFromNanoseconds(Metrics.MetricType.AD_LATENCY_RENDER, renderStopTime);
                InterstitialAd.this.getAdData().getMetricsCollector().stopMetricInMillisecondsFromNanoseconds(Metrics.MetricType.AD_LATENCY_TOTAL, renderStopTime);
                InterstitialAd.this.getAdData().getMetricsCollector().stopMetricInMillisecondsFromNanoseconds(Metrics.MetricType.AD_LATENCY_TOTAL_SUCCESS, renderStopTime);
                InterstitialAd.this.onAdPrerendered();
            }

            public boolean launchExternalBrowserForLink(String url) {
                return false;
            }

            public int getHeight() {
                return 0;
            }

            public AdWebViewClient.UrlExecutor getSpecialUrlExecutor() {
                return null;
            }

            public boolean shouldDisableWebViewHardwareAcceleration() {
                return false;
            }
        }, (Context)this.activity, webView);
        return mraidView;
    }

    void loadHtml(String html) {
        this.mraidView.loadHtmlData("http://amazon-adsystem.amazon.com/", html);
    }

    void executePostActivityShown() {
        this.getAdLoaderCallback().adShown();
    }

    void registerBroadcastReceiver() {
        this.broadcastReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                InterstitialAd.this.onBroadcastReceived(intent);
            }
        };
        IntentFilter filter = new IntentFilter(BROADCAST_INTENT);
        this.activity.getApplicationContext().registerReceiver(this.broadcastReceiver, filter);
    }

    void unregisterBroadcastReceiver() {
        this.activity.getApplicationContext().unregisterReceiver(this.broadcastReceiver);
        this.broadcastReceiver = null;
    }

    void onBroadcastReceived(Intent intent) {
        if (this.uniqueIdentifier.equals(intent.getStringExtra(BROADCAST_UNIQUE_IDENTIFIER_KEY)) && BROADCAST_INTENT.equals(intent.getAction())) {
            String action = intent.getStringExtra(BROADCAST_ACTION);
            if (ACTION_INTERSTITIAL_DISMISSED.equals(action)) {
                this.handleDismissed();
            } else if (ACTION_INTERSTITIAL_FINISHED_LOADING.equals(action)) {
                this.handlePageFinished();
            }
        }
    }

    void handleDismissed() {
        this.getAdData().getMetricsCollector().stopMetric(Metrics.MetricType.AD_SHOW_DURATION);
        this.setState(State.DISMISSED);
        isAdShowing.set(false);
        this.callOnAdDismissedOnMainThread();
        this.unregisterBroadcastReceiver();
    }

    void handlePageFinished() {
        this.getAdData().getMetricsCollector().stopMetric(Metrics.MetricType.AD_SHOW_LATENCY);
        this.executePostActivityShown();
        this.submitAndResetMetricsOnMainThreadAndStartMetric(Metrics.MetricType.AD_SHOW_DURATION, System.nanoTime());
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    IAdLoaderCallback getAdLoaderCallback() {
        return this.adLoaderCallback;
    }

    private void onRequestError(String message) {
        Log.e(LOG_TAG, message);
        this.getAdLoaderCallback().adFailed(new AdError(AdError.ErrorCode.REQUEST_ERROR, message));
    }

    void onAdPrerendered() {
        if (this.mraidView != null) {
            this.mraidView.unregisterReceivers();
        }
        if (!this.getAndSetHasFinishedLoading(true)) {
            this.isPrerendering.set(false);
            this.cancelTimer();
            this.setState(State.READY_TO_SHOW);
            this.callOnAdLoadedOnMainThread();
            long adLoadedStartTime = System.nanoTime();
            this.submitAndResetMetricsOnMainThreadAndStartMetric(Metrics.MetricType.AD_LOADED_TO_AD_SHOW_TIME, adLoadedStartTime);
        }
    }

    void cancelTimer() {
        this.timer.cancel();
    }

    void setHasFinishedLoading(boolean hasFinishedLoading) {
        this.hasFinishedLoading.set(hasFinishedLoading);
    }

    boolean getAndSetHasFinishedLoading(boolean hasFinishedLoading) {
        return this.hasFinishedLoading.getAndSet(hasFinishedLoading);
    }

    void onAdTimedOut() {
        boolean timedOutInPrerender = this.isPrerendering.get();
        final MraidView mraidView = MraidView.removeCachedMraidView(this.uniqueIdentifier);
        if (mraidView != null) {
            Handler handler = new Handler(this.activity.getApplicationContext().getMainLooper());
            handler.post(new Runnable(){

                public void run() {
                    mraidView.destroy();
                }
            });
        }
        if (timedOutInPrerender) {
            this.getAdData().getMetricsCollector().incrementMetric(Metrics.MetricType.AD_LOAD_FAILED_ON_PRERENDERING_TIMEOUT);
        }
        this.failAd(new AdError(AdError.ErrorCode.NETWORK_ERROR, "Ad Load Timed Out"));
    }

    void callOnAdLoaded() {
        this.adListener.onAdLoaded(this, this.adData.getProperties());
    }

    void callOnAdLoadedOnMainThread() {
        Handler h = new Handler(this.activity.getApplicationContext().getMainLooper());
        h.post(new Runnable(){

            public void run() {
                InterstitialAd.this.callOnAdLoaded();
            }
        });
    }

    void callOnAdFailedToLoad(AdError error) {
        this.adListener.onAdFailedToLoad(this, error);
    }

    void callOnAdFailedToLoadOnMainThread(final AdError error) {
        Handler h = new Handler(this.activity.getApplicationContext().getMainLooper());
        h.post(new Runnable(){

            public void run() {
                InterstitialAd.this.callOnAdFailedToLoad(error);
                InterstitialAd.this.submitAndResetMetrics();
            }
        });
    }

    private void failAd(AdError error) {
        this.setState(State.READY_TO_LOAD);
        long renderStopTime = System.nanoTime();
        if (this.getAdData() != null && this.getAdData().getMetricsCollector() != null) {
            this.getAdData().getMetricsCollector().stopMetricInMillisecondsFromNanoseconds(Metrics.MetricType.AD_LATENCY_TOTAL, renderStopTime);
            this.getAdData().getMetricsCollector().stopMetricInMillisecondsFromNanoseconds(Metrics.MetricType.AD_LOAD_LATENCY_FINALIZE_FETCH_START_TO_FAILURE, renderStopTime);
            this.getAdData().getMetricsCollector().stopMetricInMillisecondsFromNanoseconds(Metrics.MetricType.AD_LATENCY_TOTAL_FAILURE, renderStopTime);
            if (error != null && (error.getCode() == AdError.ErrorCode.NO_FILL || error.getCode() == AdError.ErrorCode.NETWORK_ERROR || error.getCode() == AdError.ErrorCode.NETWORK_TIMEOUT)) {
                this.getAdData().getMetricsCollector().incrementMetric(Metrics.MetricType.AD_LOAD_FAILED);
                if (error.getCode() == AdError.ErrorCode.NETWORK_TIMEOUT) {
                    this.getAdData().getMetricsCollector().incrementMetric(Metrics.MetricType.AD_LOAD_FAILED_ON_AAX_CALL_TIMEOUT);
                }
            }
        }
        this.callOnAdFailedToLoadOnMainThread(error);
    }

    void callOnAdDismissed() {
        this.adListener.onAdDismissed(this);
    }

    void callOnAdDismissedOnMainThread() {
        Handler h = new Handler(this.activity.getApplicationContext().getMainLooper());
        h.post(new Runnable(){

            public void run() {
                InterstitialAd.this.callOnAdDismissed();
                InterstitialAd.this.submitAndResetMetrics();
            }
        });
    }

    void submitAndResetMetricsOnMainThread() {
        this.submitAndResetMetricsOnMainThreadAndStartMetric(null, 0L);
    }

    void submitAndResetMetricsOnMainThreadAndStartMetric(final Metrics.MetricType metricType, final long startTime) {
        Handler h = new Handler(this.activity.getApplicationContext().getMainLooper());
        h.post(new Runnable(){

            public void run() {
                InterstitialAd.this.submitAndResetMetrics();
                if (metricType != null) {
                    InterstitialAd.this.getAdData().getMetricsCollector().startMetricInMillisecondsFromNanoseconds(metricType, startTime);
                }
            }
        });
    }

    protected void submitAndResetMetrics() {
        if (this.getAdData() != null && this.getAdData().getMetricsCollector() != null && !this.getAdData().getMetricsCollector().isMetricsCollectorEmpty()) {
            this.setAdditionalMetrics();
            Metrics.getInstance().submitAndResetMetrics(this.getAdData());
        }
    }

    private void setAdditionalMetrics() {
        this.getAdData().getMetricsCollector().setAdType(AdProperties.AdType.INTERSTITIAL);
        this.getAdData().getMetricsCollector().incrementMetric(Metrics.MetricType.AD_IS_INTERSTITIAL);
        AdUtils.setConnectionMetrics(this.getAdData());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum State {
        READY_TO_LOAD,
        LOADING,
        READY_TO_SHOW,
        SHOWING,
        DISMISSED;

    }

    class InterstitialAdLoaderCallback
    implements IAdLoaderCallback {
        private final InterstitialAd interstitialAd;

        public InterstitialAdLoaderCallback(InterstitialAd interstitialAd2) {
            this.interstitialAd = interstitialAd2;
        }

        public void handleResponse() {
            InterstitialAd.this.prerenderHtml();
        }

        public void adFailed(AdError error) {
            if (!InterstitialAd.this.getAndSetHasFinishedLoading(true)) {
                InterstitialAd.this.failAd(error);
            }
        }

        public int getTimeout() {
            return this.interstitialAd.getTimeout();
        }

        public void adShown() {
            WebRequest.executeWebRequestInThread(InterstitialAd.this.getAdData().getImpressionPixelUrl());
        }
    }
}

