/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import com.amazon.device.ads.Log;
import com.amazon.device.ads.WebRequest;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;

class HttpClientWebRequest
extends WebRequest {
    private static final String LOG_TAG = HttpClientWebRequest.class.getSimpleName();
    private static final int DEFAULT_SOCKET_BUFFER_SIZE = 8192;

    HttpClientWebRequest() {
    }

    protected WebRequest.WebResponse doHttpNetworkCall(URL url) throws WebRequest.WebRequestException {
        HttpRequestBase httpRequest = this.createHttpRequest(url);
        HttpParams httpParams = this.createHttpParams();
        DefaultHttpClient client = new DefaultHttpClient(httpParams);
        HttpResponse response = null;
        try {
            response = client.execute((HttpUriRequest)httpRequest);
        }
        catch (ClientProtocolException e) {
            Log.e(this.getLogTag(), "Invalid client protocol: %s", e.getMessage());
            throw new WebRequest.WebRequestException(this, WebRequest.WebRequestStatus.INVALID_CLIENT_PROTOCOL, "Invalid client protocol", e);
        }
        catch (IOException e) {
            Log.e(this.getLogTag(), "IOException during client execution: %s", e.getMessage());
            throw new WebRequest.WebRequestException(this, WebRequest.WebRequestStatus.NETWORK_FAILURE, "IOException during client execution", e);
        }
        return this.parseResponse(response);
    }

    protected HttpRequestBase createHttpRequest(URL url) throws WebRequest.WebRequestException {
        HttpGet httpRequest = null;
        URI uri = null;
        try {
            uri = this.createURI(url);
        }
        catch (URISyntaxException e) {
            Log.e(this.getLogTag(), "Problem with URI syntax: %s", e.getMessage());
            throw new WebRequest.WebRequestException(this, WebRequest.WebRequestStatus.MALFORMED_URL, "Problem with URI syntax", e);
        }
        switch (this.getHttpMethod()) {
            case GET: {
                httpRequest = new HttpGet(uri);
                break;
            }
            case POST: {
                httpRequest = new HttpPost(uri);
                this.prepareRequestBody((HttpPost)httpRequest);
            }
        }
        for (Map.Entry header : this.headers.entrySet()) {
            if (header.getValue() == null || ((String)header.getValue()).equals("")) continue;
            httpRequest.addHeader((String)header.getKey(), (String)header.getValue());
        }
        this.logUrl(uri.toString());
        if (this.logRequestBodyEnabled && this.getRequestBody() != null) {
            Log.d(this.getLogTag(), "Request Body: %s", this.getRequestBody());
        }
        return httpRequest;
    }

    private void prepareRequestBody(HttpPost httpPost) throws WebRequest.WebRequestException {
        String contentType;
        String charset = this.charset;
        if (charset == null) {
            charset = "UTF-8";
        }
        if ((contentType = this.contentType) == null) {
            contentType = "text/plain";
        }
        if (this.requestBody != null) {
            this.prepareStringRequestBody(httpPost, contentType, charset);
        } else {
            this.prepareFormRequestBody(httpPost, charset);
        }
    }

    private void prepareStringRequestBody(HttpPost requestBase, String contentType, String charset) throws WebRequest.WebRequestException {
        try {
            StringEntity entity = new StringEntity(this.requestBody, charset);
            entity.setContentType(contentType);
            requestBase.setEntity((HttpEntity)entity);
        }
        catch (UnsupportedEncodingException e) {
            Log.e(this.getLogTag(), "Unsupported character encoding used while creating the request. ", e.getMessage());
            throw new WebRequest.WebRequestException(this, WebRequest.WebRequestStatus.UNSUPPORTED_ENCODING, "Unsupported character encoding used while creating the request.", e);
        }
    }

    private void prepareFormRequestBody(HttpPost httpPost, String charset) throws WebRequest.WebRequestException {
        ArrayList<BasicNameValuePair> postParams = new ArrayList<BasicNameValuePair>();
        for (Map.Entry param : this.postParameters.entrySet()) {
            postParams.add(new BasicNameValuePair((String)param.getKey(), (String)param.getValue()));
        }
        try {
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(postParams, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            Log.e(this.getLogTag(), "Unsupported character encoding used while creating the request: %s", e.getMessage());
            throw new WebRequest.WebRequestException(this, WebRequest.WebRequestStatus.UNSUPPORTED_ENCODING, "Unsupported character encoding used while creating the request", e);
        }
    }

    protected HttpParams createHttpParams() {
        BasicHttpParams httpParams = new BasicHttpParams();
        HttpConnectionParams.setConnectionTimeout((HttpParams)httpParams, (int)this.getTimeout());
        HttpConnectionParams.setSoTimeout((HttpParams)httpParams, (int)this.getTimeout());
        HttpConnectionParams.setSocketBufferSize((HttpParams)httpParams, (int)8192);
        return httpParams;
    }

    protected WebRequest.WebResponse parseResponse(HttpResponse response) throws WebRequest.WebRequestException {
        HttpEntity entity;
        WebRequest.WebResponse webResponse = new WebRequest.WebResponse(this);
        webResponse.setLogTag(this.getLogTag());
        webResponse.enableLog(this.logResponseEnabled);
        webResponse.setHttpStatusCode(response.getStatusLine().getStatusCode());
        webResponse.setHttpStatus(response.getStatusLine().getReasonPhrase());
        if (webResponse.getHttpStatusCode() == 200 && (entity = response.getEntity()) != null && entity.getContentLength() != 0L) {
            try {
                webResponse.setInputStream(entity.getContent());
            }
            catch (IOException e) {
                Log.e(this.getLogTag(), "IOException while reading the input stream from response: %s", e.getMessage());
                throw new WebRequest.WebRequestException(this, WebRequest.WebRequestStatus.NETWORK_FAILURE, "IOException while reading the input stream from response", e);
            }
        }
        return webResponse;
    }

    protected String getSubLogTag() {
        return LOG_TAG;
    }
}

