/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import android.content.Context;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.FrameLayout;
import com.amazon.device.ads.AdData;
import com.amazon.device.ads.AdProperties;
import com.amazon.device.ads.AdRenderer;
import com.amazon.device.ads.AdUtils;
import com.amazon.device.ads.AdWebViewClient;
import com.amazon.device.ads.AndroidTargetUtils;
import com.amazon.device.ads.IAdController;
import com.amazon.device.ads.Log;
import com.amazon.device.ads.WebViewFactory;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HtmlRenderer
extends AdRenderer {
    public static final String LOG_TAG = HtmlRenderer.class.getSimpleName();
    protected WebView adView_;
    protected boolean hasLoadedAd = false;
    protected boolean shouldForceRenderFailure = false;

    protected HtmlRenderer(AdData ad, IAdController controller, WebView webView, Context context) {
        super(ad, controller, context);
        this.adView_ = webView;
        this.setupAdView();
        if (Build.VERSION.SDK_INT >= 11 && this.controller.shouldDisableWebViewHardwareAcceleration()) {
            this.disableHardwareAcceleration();
        }
    }

    @Override
    public void initialize() {
        this.setupAdView();
        super.initialize();
    }

    protected void setupAdView() {
        this.adView_.setHorizontalScrollBarEnabled(false);
        this.adView_.setHorizontalScrollbarOverlay(false);
        this.adView_.setVerticalScrollBarEnabled(false);
        this.adView_.setVerticalScrollbarOverlay(false);
        this.adView_.getSettings().setSupportZoom(false);
        this.shouldForceRenderFailure = !WebViewFactory.setJavaScriptEnabledForWebView(true, this.adView_, LOG_TAG);
        this.adView_.setBackgroundColor(0);
        AdWebViewClient adWebViewClient = new AdWebViewClient(this, this.context);
        adWebViewClient.putUrlExecutor("amazonmobile", this.controller.getSpecialUrlExecutor());
        this.adView_.setWebViewClient((WebViewClient)adWebViewClient);
    }

    protected void disableHardwareAcceleration() {
        AndroidTargetUtils.disableHardwareAcceleration((View)this.adView_);
    }

    @Override
    protected boolean getAdState(AdRenderer.AdState c) {
        return false;
    }

    @Override
    protected boolean render() {
        if (this.isAdViewNull() || this.isAdViewDestroyed() || this.shouldForceRenderFailure) {
            return false;
        }
        this.renderAdView();
        return true;
    }

    protected void renderAdView() {
        this.adView_.loadUrl("about:blank");
        this.hasLoadedAd = false;
        String html = this.adData.getCreative();
        html = "<html><meta name=\"viewport\" content=\"width=" + this.controller.getWindowWidth() + ", height=" + this.controller.getWindowHeight() + ", initial-scale=" + AdUtils.getViewportInitialScale(this.getScalingMultiplier()) + ", minimum-scale=" + this.getScalingMultiplier() + ", maximum-scale=" + this.getScalingMultiplier() + "\">" + html + "</html>";
        html = html.replace("<head>", "<head><script type=\"text/javascript\">htmlWillCallFinishLoad = 1;</script>");
        this.adView_.loadDataWithBaseURL("http://amazon-adsystem.amazon.com/", html, "text/html", "utf-8", null);
    }

    @Override
    public void onPageFinished() {
        if (!this.isDestroyed && !this.hasLoadedAd) {
            this.hasLoadedAd = true;
            this.adLoaded(this.adData.getProperties());
        }
    }

    @Override
    protected void prepareToGoAway() {
    }

    @Override
    protected void adLoaded(AdProperties props) {
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-2, -2, 17);
        this.controller.getAdLayout().addView((View)this.adView_, (ViewGroup.LayoutParams)layoutParams);
        super.adLoaded(props);
    }

    @Override
    protected boolean sendCommand(String command, Map<String, String> args) {
        return true;
    }

    @Override
    protected void removeView() {
        if (this.controller.getAdLayout() != null) {
            this.controller.getAdLayout().removeView((View)this.adView_);
        }
        this.viewRemoved = true;
    }

    @Override
    protected void destroy() {
        if (this.isAdViewNull()) {
            Log.w(LOG_TAG, "Called destroy(), but view is already null.");
        } else {
            this.adView_.destroy();
            this.adView_ = null;
        }
        this.isDestroyed = true;
    }

    @Override
    protected boolean shouldReuse() {
        return true;
    }

    protected boolean isAdViewNull() {
        return this.adView_ == null;
    }

    @Override
    public boolean launchExternalBrowserForLink(String url) {
        AdUtils.launchActivityForIntentLink(url, this.context);
        return true;
    }
}

