/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import android.content.ContentResolver;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.util.DisplayMetrics;
import android.view.WindowManager;
import com.amazon.device.ads.InternalAdRegistration;
import com.amazon.device.ads.JSONUtils;
import com.amazon.device.ads.Log;
import com.amazon.device.ads.Size;
import com.amazon.device.ads.Utils;
import java.lang.reflect.Field;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONObject;

class DeviceInfo {
    private static final String LOG_TAG = "DeviceInfo";
    public static final String WIFI_NAME = "Wifi";
    public static final String ORIENTATION_PORTRAIT = "portrait";
    public static final String ORIENTATION_LANDSCAPE = "landscape";
    public static final String ORIENTATION_UNKNOWN = "unknown";
    private static final String dt = "android";
    private static final String make = Build.MANUFACTURER;
    private static final String model = Build.MODEL;
    private static final String os = "Android";
    private static final String osVersion = Build.VERSION.RELEASE;
    private static String userAgent;
    private String sha1_mac;
    private String md5_mac;
    private boolean bad_mac;
    private boolean macFetched;
    private String sha1_serial;
    private String md5_serial;
    private boolean bad_serial;
    private boolean serialFetched;
    private String udid;
    private String sha1_udid;
    private String md5_udid;
    private boolean bad_udid;
    private boolean udidFetched;
    private String scalingFactorAsString;
    private float scalingFactor;
    private String carrier;
    private String country;
    private String language;
    private Size landscapeScreenSize;
    private Size portraitScreenSize;

    public DeviceInfo(Context context) {
        this.setCountry();
        this.setCarrier(context);
        this.setLanguage();
        this.setScalingFactor(context);
    }

    protected DeviceInfo() {
    }

    private void setMacAddressIfNotFetched() {
        if (!this.macFetched) {
            this.setMacAddress();
        }
    }

    protected void setMacAddress() {
        Context context = InternalAdRegistration.getInstance().getApplicationContext();
        WifiManager wifiManager = (WifiManager)context.getSystemService("wifi");
        WifiInfo wifiInfo = null;
        if (wifiManager != null) {
            try {
                wifiInfo = wifiManager.getConnectionInfo();
            }
            catch (SecurityException e) {
                Log.d(LOG_TAG, "Unable to get Wifi connection information: %s", e);
            }
            catch (ExceptionInInitializerError e) {
                Log.d(LOG_TAG, "Unable to get Wifi connection information: %s", e);
            }
        }
        if (wifiInfo == null) {
            this.sha1_mac = null;
        } else {
            String macAddress = wifiInfo.getMacAddress();
            if (macAddress == null || macAddress.length() == 0) {
                this.sha1_mac = null;
                this.bad_mac = true;
            } else {
                Pattern macAddressPattern = Pattern.compile("((([0-9a-fA-F]){1,2}[-:]){5}([0-9a-fA-F]){1,2})");
                Matcher matcher = macAddressPattern.matcher(macAddress);
                if (!matcher.find()) {
                    this.sha1_mac = null;
                    this.bad_mac = true;
                } else {
                    this.sha1_mac = Utils.getURLEncodedString(Utils.sha1(macAddress));
                }
            }
        }
        this.macFetched = true;
    }

    private void setSerialIfNotFetched() {
        if (!this.serialFetched) {
            this.setSerial();
        }
    }

    private void setSerial() {
        String serial = null;
        try {
            Field f = Build.class.getDeclaredField("SERIAL");
            serial = (String)f.get(Build.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (serial == null || serial.length() == 0 || serial.equalsIgnoreCase(ORIENTATION_UNKNOWN)) {
            this.bad_serial = true;
        } else {
            this.sha1_serial = Utils.getURLEncodedString(Utils.sha1(serial));
        }
        this.serialFetched = true;
    }

    private void setUdidIfNotFetched() {
        if (!this.udidFetched) {
            this.setUdid();
        }
    }

    private void setUdid() {
        Context context = InternalAdRegistration.getInstance().getApplicationContext();
        String udid = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
        if (Utils.isNullOrEmpty(udid) || udid.equalsIgnoreCase("9774d56d682e549c")) {
            this.udid = null;
            this.sha1_udid = null;
            this.bad_udid = true;
        } else {
            this.udid = Utils.getURLEncodedString(udid);
            this.sha1_udid = Utils.getURLEncodedString(Utils.sha1(udid));
        }
        this.udidFetched = true;
    }

    private void setLanguage() {
        String language = Locale.getDefault().getLanguage();
        this.language = language != null && language.length() > 0 ? language : null;
    }

    private void setCountry() {
        String country = Locale.getDefault().getCountry();
        this.country = country != null && country.length() > 0 ? country : null;
    }

    private void setCarrier(Context context) {
        TelephonyManager tManager = (TelephonyManager)context.getSystemService("phone");
        if (tManager != null) {
            String carrier = tManager.getNetworkOperatorName();
            this.carrier = carrier != null && carrier.length() > 0 ? carrier : null;
        }
    }

    private void setScalingFactor(Context context) {
        if (make.equals("motorola") && model.equals("MB502")) {
            this.scalingFactor = 1.0f;
        } else {
            WindowManager windowManager = (WindowManager)context.getSystemService("window");
            DisplayMetrics metrics = new DisplayMetrics();
            windowManager.getDefaultDisplay().getMetrics(metrics);
            this.scalingFactor = metrics.scaledDensity;
        }
        this.scalingFactorAsString = Float.toString(this.scalingFactor);
    }

    public static String getDeviceType() {
        return dt;
    }

    public static String getMake() {
        return make;
    }

    public static String getModel() {
        return model;
    }

    public static String getOS() {
        return os;
    }

    public static String getOSVersion() {
        return osVersion;
    }

    public String getMacSha1() {
        this.setMacAddressIfNotFetched();
        return this.sha1_mac;
    }

    public String getMacMd5() {
        this.setMacAddressIfNotFetched();
        return this.md5_mac;
    }

    public boolean isMacBad() {
        this.setMacAddressIfNotFetched();
        return this.bad_mac;
    }

    public String getSerialSha1() {
        this.setSerialIfNotFetched();
        return this.sha1_serial;
    }

    public String getSerialMd5() {
        this.setSerialIfNotFetched();
        return this.md5_serial;
    }

    public boolean isSerialBad() {
        this.setSerialIfNotFetched();
        return this.bad_serial;
    }

    public String getUdid() {
        this.setUdidIfNotFetched();
        return this.udid;
    }

    public String getUdidSha1() {
        this.setUdidIfNotFetched();
        return this.sha1_udid;
    }

    public String getUdidMd5() {
        this.setUdidIfNotFetched();
        return this.md5_udid;
    }

    public boolean isUdidBad() {
        this.setUdidIfNotFetched();
        return this.bad_udid;
    }

    public String getConnectionType() {
        Context context = InternalAdRegistration.getInstance().getApplicationContext();
        ConnectivityManager cManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo networkInfo = null;
        String connectionType = null;
        try {
            if (cManager != null) {
                networkInfo = cManager.getActiveNetworkInfo();
            }
        }
        catch (SecurityException e) {
            Log.d(LOG_TAG, "Unable to get active network information: %s", e);
        }
        connectionType = networkInfo != null ? (networkInfo.getType() == 1 ? WIFI_NAME : Integer.toString(networkInfo.getSubtype())) : Integer.toString(0);
        return connectionType;
    }

    public String getCarrier() {
        return this.carrier;
    }

    public String getCountry() {
        return this.country;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getScalingFactorAsString() {
        return this.scalingFactorAsString;
    }

    public float getScalingFactorAsFloat() {
        return this.scalingFactor;
    }

    public static String getUserAgentString() {
        return userAgent;
    }

    public static void setUserAgentString(String ua) {
        if (ua != null && !ua.equals(userAgent)) {
            userAgent = ua;
        }
    }

    public String getOrientation() {
        String orientation = null;
        int canonicalOrientation = Utils.determineCanonicalScreenOrientation();
        switch (canonicalOrientation) {
            case 1: 
            case 9: {
                orientation = ORIENTATION_PORTRAIT;
                break;
            }
            case 0: 
            case 8: {
                orientation = ORIENTATION_LANDSCAPE;
                break;
            }
            default: {
                orientation = ORIENTATION_UNKNOWN;
            }
        }
        return orientation;
    }

    public Size getScreenSize(String orientation) {
        if (orientation.equals(ORIENTATION_PORTRAIT) && this.portraitScreenSize != null) {
            return this.portraitScreenSize;
        }
        if (orientation.equals(ORIENTATION_LANDSCAPE) && this.landscapeScreenSize != null) {
            return this.landscapeScreenSize;
        }
        Context context = InternalAdRegistration.getInstance().getApplicationContext();
        WindowManager wm = (WindowManager)context.getSystemService("window");
        DisplayMetrics metrics = new DisplayMetrics();
        wm.getDefaultDisplay().getMetrics(metrics);
        String screenSize = String.valueOf(metrics.widthPixels) + "x" + String.valueOf(metrics.heightPixels);
        if (orientation.equals(ORIENTATION_PORTRAIT)) {
            this.portraitScreenSize = new Size(screenSize);
            return this.portraitScreenSize;
        }
        if (orientation.equals(ORIENTATION_LANDSCAPE)) {
            this.landscapeScreenSize = new Size(screenSize);
            return this.landscapeScreenSize;
        }
        return new Size(screenSize);
    }

    public JSONObject getDInfoProperty() {
        JSONObject json = new JSONObject();
        JSONUtils.put(json, "make", DeviceInfo.getMake());
        JSONUtils.put(json, "model", DeviceInfo.getModel());
        JSONUtils.put(json, "os", DeviceInfo.getOS());
        JSONUtils.put(json, "osVersion", DeviceInfo.getOSVersion());
        JSONUtils.put(json, "scalingFactor", this.getScalingFactorAsString());
        JSONUtils.put(json, "language", this.getLanguage());
        JSONUtils.put(json, "country", this.getCountry());
        JSONUtils.put(json, "carrier", this.getCarrier());
        return json;
    }

    public String toJsonString() {
        String orientation = this.getOrientation();
        return this.toJsonObject(orientation).toString();
    }

    JSONObject toJsonObject(String orientation) {
        JSONObject json = this.getDInfoProperty();
        JSONUtils.put(json, "orientation", orientation);
        JSONUtils.put(json, "screenSize", this.getScreenSize(orientation).toString());
        JSONUtils.put(json, "connectionType", this.getConnectionType());
        return json;
    }
}

