/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import com.amazon.device.ads.Utils;

public class Base64 {
    private static final String ENCODE_CHARSET = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";

    public static byte[] decode(String s) {
        int code;
        if (Utils.isNullOrWhiteSpace(s)) {
            throw new IllegalArgumentException("Encoded String must not be null or white space");
        }
        int decodedLength = Base64.getDecodedLength(s);
        if (decodedLength <= 0) {
            throw new IllegalArgumentException("Encoded String decodes to zero bytes");
        }
        byte[] decoded = new byte[decodedLength];
        int current = 0;
        block6: for (int i = 0; i < s.length() && current < decodedLength && (i % 4 != 0 || s.length() >= i + 4) && (code = ENCODE_CHARSET.indexOf(s.charAt(i))) != -1; ++i) {
            switch (i % 4) {
                case 0: {
                    decoded[current] = (byte)(code << 2);
                    continue block6;
                }
                case 1: {
                    int n = current++;
                    decoded[n] = (byte)(decoded[n] | (byte)(code >> 4 & 3));
                    if (current >= decodedLength) continue block6;
                    decoded[current] = (byte)(code << 4);
                    continue block6;
                }
                case 2: {
                    int n = current++;
                    decoded[n] = (byte)(decoded[n] | (byte)(code >> 2 & 0xF));
                    if (current >= decodedLength) continue block6;
                    decoded[current] = (byte)(code << 6);
                    continue block6;
                }
                case 3: {
                    int n = current++;
                    decoded[n] = (byte)(decoded[n] | (byte)(code & 0x3F));
                }
            }
        }
        return decoded;
    }

    private static int getDecodedLength(String s) {
        int index = s.indexOf("=");
        int end = 0;
        if (index > -1) {
            end = s.length() - index;
        }
        int decodedLength = (s.length() + 3) / 4 * 3 - end;
        return decodedLength;
    }
}

