/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.amazon.device.ads.AdView;
import com.amazon.device.ads.AmazonDeviceLauncher;
import com.amazon.device.ads.Log;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

class AdWebViewClient
extends WebViewClient {
    private static final String LOG_TAG = AdWebViewClient.class.getSimpleName();
    public static final String MOPUB = "mopub";
    public static final String MRAID = "mraid";
    public static final String AMAZON_MOBILE = "amazonmobile";
    public static final String TELEPHONE = "tel";
    public static final String VOICEMAIL = "voicemail";
    public static final String SMS = "sms";
    public static final String MAILTO = "mailto";
    public static final String GEO = "geo";
    public static final String GOOGLE_STREETVIEW = "google.streetview";
    protected static final HashSet<String> intentSchemes = new HashSet();
    private final Context context;
    private final AdView adView;
    private final HashMap<String, UrlExecutor> urlExecutors;
    protected static Set<String> redirectHosts;

    public AdWebViewClient(AdView adView, Context context) {
        this.context = context;
        this.adView = adView;
        this.urlExecutors = new HashMap();
        this.setupUrlExecutors();
    }

    private void setupUrlExecutors() {
        this.urlExecutors.put(MOPUB, new MopubExecutor());
        this.urlExecutors.put(AMAZON_MOBILE, new AmazonMobileExecutor(this.adView, this.context));
        IntentExecutor intentExecutor = new IntentExecutor();
        for (String scheme : intentSchemes) {
            this.putUrlExecutor(scheme, intentExecutor);
        }
    }

    public void putUrlExecutor(String scheme, UrlExecutor executor) {
        this.urlExecutors.put(scheme, executor);
    }

    public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
        Log.e(LOG_TAG, "Error: %s", description);
        super.onReceivedError(view, errorCode, description, failingUrl);
    }

    public boolean shouldOverrideUrlLoading(WebView view, String url) {
        if (this.adView == null) {
            return false;
        }
        if (!this.adView.isAdViewRenderable()) {
            return true;
        }
        Uri uri = Uri.parse((String)url);
        boolean ret = true;
        if (redirectHosts.contains(uri.getHost()) && !AdWebViewClient.isHoneycombVersion()) {
            ret = false;
        }
        if (this.interpretScheme(url, this.getScheme(url))) {
            return true;
        }
        return ret;
    }

    protected String getScheme(String url) {
        Uri uri = Uri.parse((String)url);
        return uri.getScheme();
    }

    protected boolean interpretScheme(String url, String scheme) {
        if (scheme != null) {
            if (this.urlExecutors.containsKey(scheme)) {
                return this.urlExecutors.get(scheme).execute(url);
            }
            Log.d(LOG_TAG, "Scheme %s unrecognized. Launching external browser.", scheme);
            return this.adView.launchExternalBrowserForLink(url);
        }
        return false;
    }

    public void onPageFinished(WebView view, String url) {
        if (this.adView == null) {
            Log.w(LOG_TAG, "Call to onPageFinished() ignored because view is null.");
            return;
        }
        this.adView.onPageFinished();
    }

    public void onLoadResource(WebView view, String url) {
        Log.d(LOG_TAG, "Loaded resource: %s", url);
    }

    private static boolean isHoneycombVersion() {
        return Build.VERSION.SDK_INT >= 11 && Build.VERSION.SDK_INT <= 13;
    }

    static {
        intentSchemes.add(TELEPHONE);
        intentSchemes.add(VOICEMAIL);
        intentSchemes.add(SMS);
        intentSchemes.add(MAILTO);
        intentSchemes.add(GEO);
        intentSchemes.add(GOOGLE_STREETVIEW);
        redirectHosts = new HashSet<String>();
        redirectHosts.add("aax-us-east.amazon-adsystem.com");
        redirectHosts.add("aax-us-east.amazon-adsystem.com");
        redirectHosts.add("aax-beta.integ.amazon.com");
        redirectHosts.add("pda-bes.amazon.com");
        redirectHosts.add("d16g-cornerstone-bes.integ.amazon.com");
    }

    class DefaultExecutor
    implements UrlExecutor {
        DefaultExecutor() {
        }

        public boolean execute(String url) {
            AdWebViewClient.this.adView.launchExternalBrowserForLink(url);
            return true;
        }
    }

    static class AmazonMobileExecutor
    implements UrlExecutor {
        private final AdView adView;
        private final Context context;

        AmazonMobileExecutor(AdView adView, Context context) {
            this.adView = adView;
            this.context = context;
        }

        public boolean execute(String url) {
            this.specialUrlClicked(url);
            return true;
        }

        public void specialUrlClicked(String url) {
            if (this.adView == null || !this.adView.isAdViewRenderable()) {
                Log.d(LOG_TAG, "AdView is Null");
                return;
            }
            Log.d(LOG_TAG, "Executing AmazonMobile Intent");
            Uri uri = Uri.parse((String)url);
            List intents = null;
            try {
                intents = uri.getQueryParameters("intent");
            }
            catch (UnsupportedOperationException e) {
                intents = null;
            }
            if (intents != null && intents.size() > 0) {
                for (String intent : intents) {
                    if (!this.launchExternalActivity(intent)) continue;
                    return;
                }
                this.handleApplicationDefinedSpecialURL(url);
            } else if (AmazonDeviceLauncher.isWindowshopPresent(this.context)) {
                if (uri.getHost().equals("shopping")) {
                    String action = uri.getQueryParameter("app-action");
                    if (action == null || action.length() == 0) {
                        return;
                    }
                    if (action.equals("detail")) {
                        String asin = uri.getQueryParameter("asin");
                        if (asin == null || asin.length() == 0) {
                            return;
                        }
                        AmazonDeviceLauncher.launchWindowshopDetailPage(this.context, asin);
                    } else if (action.equals("search")) {
                        String keyword = uri.getQueryParameter("keyword");
                        if (keyword == null || keyword.length() == 0) {
                            return;
                        }
                        AmazonDeviceLauncher.launchWindowshopSearchPage(this.context, keyword);
                    } else if (action.equals("webview")) {
                        this.handleApplicationDefinedSpecialURL(url);
                    }
                }
            } else {
                this.handleApplicationDefinedSpecialURL(url);
            }
        }

        protected void handleApplicationDefinedSpecialURL(String url) {
            Log.i(LOG_TAG, "Special url clicked, but was not handled by SDK. Url: %s", url);
        }

        protected boolean launchExternalActivity(String url) {
            Intent intent = new Intent();
            if (url.startsWith("intent:")) {
                try {
                    intent = Intent.parseUri((String)url, (int)1);
                }
                catch (URISyntaxException e) {
                    return false;
                }
            } else {
                intent.setData(Uri.parse((String)url));
            }
            try {
                intent.setAction("android.intent.action.VIEW");
                intent.addFlags(0x10000000);
                this.context.startActivity(intent);
                return true;
            }
            catch (ActivityNotFoundException exe) {
                return false;
            }
        }
    }

    class IntentExecutor
    implements UrlExecutor {
        IntentExecutor() {
        }

        public boolean execute(String url) {
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
            intent.addFlags(0x10000000);
            try {
                AdWebViewClient.this.context.startActivity(intent);
            }
            catch (ActivityNotFoundException e) {
                Log.w(LOG_TAG, "Could not handle intent with URI: %s", url);
            }
            return true;
        }
    }

    class MopubExecutor
    implements UrlExecutor {
        MopubExecutor() {
        }

        public boolean execute(String url) {
            return true;
        }
    }

    static interface UrlExecutor {
        public boolean execute(String var1);
    }
}

