/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import com.amazon.device.ads.Log;
import com.amazon.device.ads.Utils;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdTargetingOptions {
    private static final String LOGTAG = AdTargetingOptions.class.getSimpleName();
    private long floorPrice;
    private Map<String, String> advanced;
    private boolean enableGeoTargeting = false;
    private int age = Integer.MIN_VALUE;

    public AdTargetingOptions() {
        this.floorPrice = Long.MIN_VALUE;
        this.advanced = new HashMap<String, String>();
    }

    public AdTargetingOptions setFloorPrice(long floorPrice) {
        this.floorPrice = floorPrice;
        return this;
    }

    public long getFloorPrice() {
        return this.floorPrice;
    }

    boolean hasFloorPrice() {
        return this.floorPrice > -1L;
    }

    public AdTargetingOptions setAdvancedOption(String key, String value) {
        if (Utils.isNullOrWhiteSpace(key)) {
            throw new IllegalArgumentException("Option Key must not be null or empty string");
        }
        if (value != null) {
            this.advanced.put(key, value);
        } else {
            this.advanced.remove(key);
        }
        return this;
    }

    public boolean containsAdvancedOption(String key) {
        return this.advanced.containsKey(key);
    }

    public String getAdvancedOption(String key) {
        return this.advanced.get(key);
    }

    HashMap<String, String> getCopyOfAdvancedOptions() {
        HashMap<String, String> ret = new HashMap<String, String>(this.advanced);
        return ret;
    }

    public AdTargetingOptions enableGeoLocation(boolean enable) {
        this.enableGeoTargeting = enable;
        return this;
    }

    public boolean isGeoLocationEnabled() {
        return this.enableGeoTargeting;
    }

    public AdTargetingOptions setGender(Gender gender) {
        Log.d(LOGTAG, "Gender information has been deprecated and is no longer used for targeting.");
        return this;
    }

    public Gender getGender() {
        return Gender.UNKNOWN;
    }

    public AdTargetingOptions setAge(int age) {
        this.age = age;
        return this;
    }

    public int getAge() {
        return this.age;
    }

    boolean hasAge() {
        return this.age > -1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Gender {
        UNKNOWN("unknown"),
        MALE("male"),
        FEMALE("female");

        final String gender;

        private Gender(String gender) {
            this.gender = gender;
        }
    }
}

