/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import android.annotation.SuppressLint;
import com.amazon.device.ads.AAXParameter;
import com.amazon.device.ads.AdData;
import com.amazon.device.ads.AdTargetingOptions;
import com.amazon.device.ads.AdvertisingIdentifier;
import com.amazon.device.ads.Configuration;
import com.amazon.device.ads.DebugProperties;
import com.amazon.device.ads.DeviceInfo;
import com.amazon.device.ads.InternalAdRegistration;
import com.amazon.device.ads.Log;
import com.amazon.device.ads.Metrics;
import com.amazon.device.ads.Size;
import com.amazon.device.ads.Utils;
import com.amazon.device.ads.WebRequest;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class AdRequest {
    private static final String LOG_TAG = AdRequest.class.getSimpleName();
    private static final String AAX_ENDPOINT = "/e/msdk/ads";
    private static final AAXParameter<?>[] PARAMETERS = new AAXParameter[]{AAXParameter.APP_KEY, AAXParameter.CHANNEL, AAXParameter.PUBLISHER_KEYWORDS, AAXParameter.PUBLISHER_ASINS, AAXParameter.USER_AGENT, AAXParameter.SDK_VERSION, AAXParameter.GEOLOCATION, AAXParameter.USER_INFO, AAXParameter.DEVICE_INFO, AAXParameter.PACKAGE_INFO, AAXParameter.TEST, AAXParameter.SIS_DEVICE_IDENTIFIER, AAXParameter.SHA1_UDID, AAXParameter.MD5_UDID, AAXParameter.ADVERTISING_IDENTIFIER, AAXParameter.OPT_OUT};
    private final JSONObjectBuilder jsonObjectBuilder;
    private final AdTargetingOptions opt;
    private final String orientation;
    private final Size screenSize;
    private final String connectionType;
    private String instrPixelUrl;
    private AdvertisingIdentifier.Info advertisingIdentifierInfo;
    protected final Map<Integer, LOISlot> slots;

    @SuppressLint(value={"UseSparseArrays"})
    AdRequest(AdTargetingOptions opt) {
        this.opt = opt;
        this.slots = new HashMap<Integer, LOISlot>();
        DeviceInfo deviceInfo = InternalAdRegistration.getInstance().getDeviceInfo();
        this.orientation = deviceInfo.getOrientation();
        this.screenSize = deviceInfo.getScreenSize(this.orientation);
        this.connectionType = deviceInfo.getConnectionType();
        HashMap<String, String> advancedOptions = this.opt.getCopyOfAdvancedOptions();
        AAXParameter.ParameterData parameterData = new AAXParameter.ParameterData().setAdvancedOptions(advancedOptions).setAdRequest(this);
        this.jsonObjectBuilder = new JSONObjectBuilder().setAAXParameters(PARAMETERS).setAdvancedOptions(advancedOptions).setParameterData(parameterData);
    }

    public void setInstrumentationPixelURL(String instrPixelUrl) {
        this.instrPixelUrl = instrPixelUrl;
    }

    public String getInstrumentationPixelURL() {
        return this.instrPixelUrl;
    }

    AdTargetingOptions getAdTargetingOptions() {
        return this.opt;
    }

    String getOrientation() {
        return this.orientation;
    }

    AdvertisingIdentifier.Info getAdvertisingIdentifierInfo() {
        return this.advertisingIdentifierInfo;
    }

    AdRequest setAdvertisingIdentifierInfo(AdvertisingIdentifier.Info advertisingIdentifierInfo) {
        this.advertisingIdentifierInfo = advertisingIdentifierInfo;
        return this;
    }

    public void putSlot(AdData adData, AdTargetingOptions adTargetingOptions) {
        adData.setConnectionType(this.connectionType);
        adData.setScreenHeight(this.screenSize.getHeight());
        adData.setScreenWidth(this.screenSize.getWidth());
        if (this.getAdvertisingIdentifierInfo().hasSISDeviceIdentifier()) {
            adData.getMetricsCollector().incrementMetric(Metrics.MetricType.AD_COUNTER_IDENTIFIED_DEVICE);
        }
        LOISlot slot = new LOISlot(adData, adTargetingOptions, this);
        this.slots.put(slot.getAdData().getSlotId(), slot);
    }

    protected JSONArray getSlots() {
        JSONArray array = new JSONArray();
        for (LOISlot slot : this.slots.values()) {
            array.put((Object)slot.getJSON());
        }
        return array;
    }

    public WebRequest getWebRequest() {
        WebRequest request = WebRequest.createNewWebRequest();
        request.setExternalLogTag(LOG_TAG);
        request.setHttpMethod(WebRequest.HttpMethod.POST);
        request.setHost(Configuration.getInstance().getString(Configuration.ConfigOption.AAX_HOSTNAME));
        request.setPath(AAX_ENDPOINT);
        request.enableLog(true);
        request.setContentType("application/json");
        this.setParametersInWebRequest(request);
        return request;
    }

    protected void setParametersInWebRequest(WebRequest request) {
        this.jsonObjectBuilder.build();
        JSONArray slots = AAXParameter.SLOTS.getValue(this.jsonObjectBuilder.getParameterData());
        if (slots == null) {
            slots = this.getSlots();
        }
        this.jsonObjectBuilder.putIntoJSON(AAXParameter.SLOTS, (Object)slots);
        JSONObject json = this.jsonObjectBuilder.getJSON();
        String additionalTargetingParams = DebugProperties.getDebugPropertyAsString("debug.aaxAdParams", null);
        if (!Utils.isNullOrEmpty(additionalTargetingParams)) {
            request.setAdditionalQueryParamsString(additionalTargetingParams);
        }
        this.setRequestBodyString(request, json);
    }

    protected void setRequestBodyString(WebRequest request, JSONObject json) {
        request.setRequestBodyString(json.toString());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class JSONObjectBuilder {
        private final JSONObject json = new JSONObject();
        private AAXParameter<?>[] aaxParameters;
        private Map<String, String> advancedOptions;
        private AAXParameter.ParameterData parameterData;

        JSONObjectBuilder() {
        }

        JSONObjectBuilder setAAXParameters(AAXParameter<?>[] aaxParameters) {
            this.aaxParameters = aaxParameters;
            return this;
        }

        JSONObjectBuilder setAdvancedOptions(Map<String, String> advancedOptions) {
            this.advancedOptions = advancedOptions;
            return this;
        }

        JSONObjectBuilder setParameterData(AAXParameter.ParameterData parameterData) {
            this.parameterData = parameterData;
            return this;
        }

        AAXParameter.ParameterData getParameterData() {
            return this.parameterData;
        }

        JSONObject getJSON() {
            return this.json;
        }

        void build() {
            for (AAXParameter<?> parameter : this.aaxParameters) {
                Object value = parameter.getValue(this.parameterData);
                this.putIntoJSON(parameter, value);
            }
            if (this.advancedOptions != null) {
                for (Map.Entry<String, String> entry : this.advancedOptions.entrySet()) {
                    if (Utils.isNullOrWhiteSpace(entry.getValue())) continue;
                    this.putIntoJSON(entry.getKey(), (Object)entry.getValue());
                }
            }
        }

        void putIntoJSON(AAXParameter<?> parameter, Object value) {
            this.putIntoJSON(parameter.getName(), value);
        }

        void putIntoJSON(String key, Object value) {
            if (value != null) {
                try {
                    this.json.put(key, value);
                }
                catch (JSONException e) {
                    Log.d(LOG_TAG, "Could not add parameter to JSON %s: %s", key, value);
                }
            }
        }
    }

    static class LOISlot {
        static final AAXParameter<?>[] PARAMETERS = new AAXParameter[]{AAXParameter.SIZE, AAXParameter.PAGE_TYPE, AAXParameter.SLOT, AAXParameter.SLOT_POSITION, AAXParameter.MAX_SIZE, AAXParameter.SLOT_ID, AAXParameter.FLOOR_PRICE};
        private final AdData adData;
        private final AdTargetingOptions opt;
        private final JSONObjectBuilder jsonObjectBuilder;

        LOISlot(AdData adData, AdTargetingOptions opt, AdRequest adRequest) {
            this.adData = adData;
            this.opt = opt;
            HashMap<String, String> advancedOptions = this.opt.getCopyOfAdvancedOptions();
            AAXParameter.ParameterData parameterData = new AAXParameter.ParameterData().setAdvancedOptions(advancedOptions).setLOISlot(this).setAdRequest(adRequest);
            this.jsonObjectBuilder = new JSONObjectBuilder().setAAXParameters(PARAMETERS).setAdvancedOptions(advancedOptions).setParameterData(parameterData);
        }

        AdData getAdData() {
            return this.adData;
        }

        AdTargetingOptions getAdTargetingOptions() {
            return this.opt;
        }

        JSONObject getJSON() {
            this.jsonObjectBuilder.build();
            return this.jsonObjectBuilder.getJSON();
        }
    }
}

