/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import android.content.Context;
import android.webkit.WebView;
import com.amazon.device.ads.AdController;
import com.amazon.device.ads.AdData;
import com.amazon.device.ads.AdRenderer;
import com.amazon.device.ads.HtmlRenderer;
import com.amazon.device.ads.MraidRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AdRendererFactory {
    public static final String LOG_TAG = "AdRendererFactory";

    public boolean shouldCreateNewRenderer(AdData.AAXCreative adType, AdRenderer currentRenderer) {
        return currentRenderer == null || !currentRenderer.shouldReuse() || currentRenderer.getClass() != this.getAdRendererClass(adType);
    }

    public AdRenderer getAdRenderer(AdData.AAXCreative adType, AdData ad, AdController controller, WebView webView, Context context) {
        AdRenderer adRenderer = null;
        switch (adType) {
            case HTML: {
                adRenderer = this.createHtmlRenderer(ad, controller, webView, context);
                break;
            }
            case MRAID1: {
                adRenderer = this.createMraidRenderer(ad, controller, webView, context);
                break;
            }
        }
        return adRenderer;
    }

    protected Class<?> getAdRendererClass(AdData.AAXCreative adType) {
        Class clazz = null;
        switch (adType) {
            case HTML: {
                clazz = HtmlRenderer.class;
                break;
            }
            case MRAID1: {
                clazz = MraidRenderer.class;
                break;
            }
        }
        return clazz;
    }

    protected AdRenderer createHtmlRenderer(AdData ad, AdController controller, WebView webView, Context context) {
        HtmlRenderer adRenderer = new HtmlRenderer(ad, controller, webView, context);
        return adRenderer;
    }

    protected AdRenderer createMraidRenderer(AdData ad, AdController controller, WebView webView, Context context) {
        MraidRenderer adRenderer = new MraidRenderer(ad, controller, webView, context);
        return adRenderer;
    }
}

