/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import com.amazon.device.ads.Log;
import org.json.JSONArray;
import org.json.JSONException;

public class AdProperties {
    private static final String LOG_TAG = "AdProperties";
    private AdType adType_;
    private boolean canExpand_ = false;
    private boolean canPlayAudio_ = false;
    private boolean canPlayVideo_ = false;

    protected AdProperties() {
    }

    AdProperties(JSONArray creativeTypes) {
        if (creativeTypes != null) {
            for (int i = 0; i < creativeTypes.length(); ++i) {
                try {
                    switch (creativeTypes.getInt(i)) {
                        case 1001: 
                        case 1002: {
                            this.canPlayAudio_ = true;
                            break;
                        }
                        case 1003: 
                        case 1004: {
                            this.canExpand_ = true;
                            break;
                        }
                        case 1007: {
                            this.adType_ = AdType.IMAGE_BANNER;
                            break;
                        }
                        case 1008: {
                            this.adType_ = AdType.INTERSTITIAL;
                            break;
                        }
                        case 1014: {
                            this.canPlayVideo_ = true;
                            break;
                        }
                        case 1016: {
                            this.adType_ = AdType.MRAID_1;
                            break;
                        }
                        case 1017: {
                            this.adType_ = AdType.MRAID_2;
                        }
                    }
                    continue;
                }
                catch (JSONException e) {
                    Log.w(LOG_TAG, "Unable to parse creative type: %s", e.getMessage());
                }
            }
        }
    }

    void setAdType(AdType adType) {
        this.adType_ = adType;
    }

    public AdType getAdType() {
        return this.adType_;
    }

    void setCanExpand(boolean canExpand) {
        this.canExpand_ = canExpand;
    }

    public boolean canExpand() {
        return this.canExpand_;
    }

    void setCanPlayAudio(boolean canPlayAudio) {
        this.canPlayAudio_ = canPlayAudio;
    }

    public boolean canPlayAudio() {
        return this.canPlayAudio_;
    }

    void setCanPlayVideo(boolean canPlayVideo) {
        this.canPlayVideo_ = canPlayVideo;
    }

    public boolean canPlayVideo() {
        return this.canPlayVideo_;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AdType {
        IMAGE_BANNER("Image Banner"),
        MRAID_1("MRAID 1.0"),
        MRAID_2("MRAID 2.0"),
        INTERSTITIAL("Interstitial", "i");

        private final String type;
        private final String adTypeMetricTag;

        private AdType(String type) {
            this(type, null);
        }

        private AdType(String type, String metricTag) {
            this.type = type;
            this.adTypeMetricTag = metricTag;
        }

        String getAdTypeMetricTag() {
            return this.adTypeMetricTag;
        }

        public String toString() {
            return this.type;
        }
    }
}

