/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import android.content.Context;
import android.location.Location;
import android.location.LocationManager;
import com.amazon.device.ads.InternalAdRegistration;
import com.amazon.device.ads.Log;

class AdLocation {
    private static final String LOG_TAG = "AdLocation";
    private static final float MAX_DISTANCE_IN_KILOMETERS = 3.0f;
    private LocationAwareness locationAwareness = LocationAwareness.LOCATION_AWARENESS_TRUNCATED;
    private int arcminutePrecision = 6;

    private static double roundToArcminutes(double coordinate) {
        return (double)Math.round(coordinate * 60.0) / 60.0;
    }

    public Location getLocation() {
        Location result = null;
        Context context = InternalAdRegistration.getInstance().getApplicationContext();
        if (this.locationAwareness == LocationAwareness.LOCATION_AWARENESS_DISABLED) {
            return null;
        }
        LocationManager lm = (LocationManager)context.getSystemService("location");
        Location gpsLocation = null;
        try {
            gpsLocation = lm.getLastKnownLocation("gps");
        }
        catch (SecurityException e) {
            Log.d(LOG_TAG, "Failed to retrieve GPS location: No permissions to access GPS");
        }
        catch (IllegalArgumentException e) {
            Log.d(LOG_TAG, "Failed to retrieve GPS location: No GPS found");
        }
        Location networkLocation = null;
        try {
            networkLocation = lm.getLastKnownLocation("network");
        }
        catch (SecurityException e) {
            Log.d(LOG_TAG, "Failed to retrieve network location: No permissions to access network location");
        }
        catch (IllegalArgumentException e) {
            Log.d(LOG_TAG, "Failed to retrieve network location: No network provider found");
        }
        if (gpsLocation == null && networkLocation == null) {
            return null;
        }
        if (gpsLocation != null && networkLocation != null) {
            float distanceInMeters = gpsLocation.distanceTo(networkLocation);
            float distanceInKilometers = distanceInMeters / 1000.0f;
            if (distanceInKilometers <= 3.0f) {
                float networkLocationAccuracy;
                float gpsLocationAccuracy = gpsLocation.hasAccuracy() ? gpsLocation.getAccuracy() : Float.MAX_VALUE;
                float f = networkLocationAccuracy = networkLocation.hasAccuracy() ? networkLocation.getAccuracy() : Float.MAX_VALUE;
                if (gpsLocationAccuracy < networkLocationAccuracy) {
                    Log.d(LOG_TAG, "Setting lat/long using GPS determined by distance");
                    result = gpsLocation;
                } else {
                    Log.d(LOG_TAG, "Setting lat/long using network determined by distance");
                    result = networkLocation;
                }
            } else if (gpsLocation.getTime() > networkLocation.getTime()) {
                Log.d(LOG_TAG, "Setting lat/long using GPS");
                result = gpsLocation;
            } else {
                Log.d(LOG_TAG, "Setting lat/long using network");
                result = networkLocation;
            }
        } else if (gpsLocation != null) {
            Log.d(LOG_TAG, "Setting lat/long using GPS, not network");
            result = gpsLocation;
        } else {
            Log.d(LOG_TAG, "Setting lat/long using network location, not GPS");
            result = networkLocation;
        }
        if (this.locationAwareness == LocationAwareness.LOCATION_AWARENESS_TRUNCATED) {
            double lat = AdLocation.roundToArcminutes(result.getLatitude());
            double truncatedLat = (double)Math.round(Math.pow(10.0, this.arcminutePrecision) * lat) / Math.pow(10.0, this.arcminutePrecision);
            result.setLatitude(truncatedLat);
            double lon = AdLocation.roundToArcminutes(result.getLongitude());
            double truncatedLon = (double)Math.round(Math.pow(10.0, this.arcminutePrecision) * lon) / Math.pow(10.0, this.arcminutePrecision);
            result.setLongitude(truncatedLon);
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum LocationAwareness {
        LOCATION_AWARENESS_NORMAL,
        LOCATION_AWARENESS_TRUNCATED,
        LOCATION_AWARENESS_DISABLED;

    }
}

