/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.webkit.WebView;
import com.amazon.device.ads.AdData;
import com.amazon.device.ads.AdError;
import com.amazon.device.ads.AdLayout;
import com.amazon.device.ads.AdListener;
import com.amazon.device.ads.AdProperties;
import com.amazon.device.ads.AdRenderer;
import com.amazon.device.ads.AdRendererFactory;
import com.amazon.device.ads.AdSize;
import com.amazon.device.ads.AdUtils;
import com.amazon.device.ads.AdWebViewClient;
import com.amazon.device.ads.DefaultAdListener;
import com.amazon.device.ads.DeviceInfo;
import com.amazon.device.ads.IAdController;
import com.amazon.device.ads.IAdLoaderCallback;
import com.amazon.device.ads.Log;
import com.amazon.device.ads.Metrics;
import com.amazon.device.ads.WebRequest;
import com.amazon.device.ads.WebViewFactory;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AdController
implements IAdController,
IAdLoaderCallback {
    private static final String LOG_TAG = "AdController";
    private AdData adData;
    private final AdLayout adLayout;
    private final Context context;
    private final AdSize adSize;
    private int timeout = 20000;
    private AdListener adListener;
    private AdRenderer currentAdRenderer;
    private WebView webView;
    private int adWindowHeight;
    private int adWindowWidth;
    private boolean isLoading;

    AdController(AdLayout adLayout, AdSize adSize, Context context) {
        this.adLayout = adLayout;
        this.context = context;
        this.adSize = adSize;
        this.adListener = this.createAdListener();
    }

    protected AdController() {
        this.adLayout = null;
        this.context = null;
        this.adSize = null;
    }

    protected AdListener createAdListener() {
        return new DefaultAdListener(LOG_TAG);
    }

    protected AdListener getAdListener() {
        return this.adListener;
    }

    protected AdData getAdData() {
        return this.adData;
    }

    protected void setAdData(AdData adData) {
        this.adData = adData;
    }

    @Override
    public boolean isAdLoading() {
        return this.isLoading;
    }

    @Override
    public AdLayout getAdLayout() {
        return this.adLayout;
    }

    @Override
    public int getTimeout() {
        return this.timeout;
    }

    @Override
    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    @Override
    public AdSize getAdSize() {
        return this.adSize;
    }

    @Override
    public boolean isAdExpanded() {
        if (this.currentAdRenderer == null) {
            return false;
        }
        return this.currentAdRenderer.getAdState(AdRenderer.AdState.valueOf("EXPANDED"));
    }

    @Override
    public int getWindowHeight() {
        return this.adWindowHeight;
    }

    @Override
    public int getWindowWidth() {
        return this.adWindowWidth;
    }

    @Override
    public void setWindowDimensions(int width, int height) {
        this.adWindowWidth = width;
        this.adWindowHeight = height;
    }

    @Override
    public String getMaxSize() {
        if (!this.adSize.isAuto()) {
            return null;
        }
        return AdController.getAsSizeString(this.getWindowWidth(), this.getWindowHeight());
    }

    protected static String getAsSizeString(int w, int h) {
        return Integer.toString(w) + "x" + Integer.toString(h);
    }

    @Override
    public void setListener(AdListener listener) {
        this.adListener = listener == null ? this.createAdListener() : listener;
    }

    @Override
    public void prepareToGoAway() {
        if (this.currentAdRenderer != null) {
            this.currentAdRenderer.prepareToGoAway();
        }
    }

    @Override
    public boolean sendCommand(String command, HashMap<String, String> args) {
        if (this.currentAdRenderer != null) {
            return this.currentAdRenderer.sendCommand(command, args);
        }
        return false;
    }

    @Override
    public void destroy() {
        this.destroyCurrentAdRenderer();
    }

    private void destroyCurrentAdRenderer() {
        if (this.currentAdRenderer != null) {
            this.currentAdRenderer.removeView();
            this.currentAdRenderer.destroy();
            this.currentAdRenderer = null;
        }
    }

    @Override
    public void prepareAd(long loadAdStartTime) {
        this.setNewAdData();
        this.getAdData().getMetricsCollector().startMetricInMillisecondsFromNanoseconds(Metrics.MetricType.AD_LATENCY_TOTAL, loadAdStartTime);
        this.getAdData().getMetricsCollector().startMetricInMillisecondsFromNanoseconds(Metrics.MetricType.AD_LATENCY_TOTAL_FAILURE, loadAdStartTime);
        this.getAdData().getMetricsCollector().startMetricInMillisecondsFromNanoseconds(Metrics.MetricType.AD_LATENCY_TOTAL_SUCCESS, loadAdStartTime);
        this.getAdData().getMetricsCollector().startMetricInMillisecondsFromNanoseconds(Metrics.MetricType.AD_LOAD_LATENCY_LOADAD_TO_FETCH_THREAD_REQUEST_START, loadAdStartTime);
        if (this.adSize.isAuto()) {
            this.getAdData().setMaxSize(this.getMaxSize());
        }
        this.isLoading = true;
        if (DeviceInfo.getUserAgentString() == null) {
            Looper looper = Looper.getMainLooper();
            if (Thread.currentThread() == looper.getThread()) {
                this.retrieveAndSetUserAgentString();
            } else {
                Handler handler = new Handler(looper);
                handler.post(new Runnable(){

                    public void run() {
                        if (DeviceInfo.getUserAgentString() == null) {
                            AdController.this.retrieveAndSetUserAgentString();
                        }
                    }
                });
            }
        }
    }

    protected void setNewAdData() {
        AdData adData = new AdData(this.adSize);
        this.setAdData(adData);
    }

    private void retrieveAndSetUserAgentString() {
        this.createAndCacheWebView();
        String userAgent = this.webView.getSettings().getUserAgentString();
        DeviceInfo.setUserAgentString(userAgent);
    }

    @Override
    public void handleResponse() {
        if (this.currentAdRenderer != null) {
            this.currentAdRenderer.removeView();
        }
        AdData.AAXCreative creativeType = null;
        if (this.adData == null) {
            String msg = "We are unable to load the ad due to an internal error.";
            Log.d(LOG_TAG, "We are unable to load the ad due to an internal error.");
            this.adFailed(new AdError(AdError.ErrorCode.INTERNAL_ERROR, "We are unable to load the ad due to an internal error."));
        } else if (this.adData.getCreativeTypes() == null || this.adData.getCreativeTypes().isEmpty() || (creativeType = AdData.AAXCreative.getTopCreative(this.adData.getCreativeTypes())) == null) {
            String msg = "There were no valid creative types returned, and we are unable to load the ad.";
            Log.d(LOG_TAG, "There were no valid creative types returned, and we are unable to load the ad.");
            this.adFailed(new AdError(AdError.ErrorCode.INTERNAL_ERROR, "There were no valid creative types returned, and we are unable to load the ad."));
        } else {
            this.prepareRenderer(creativeType);
        }
    }

    private void prepareRenderer(AdData.AAXCreative creativeType) {
        this.currentAdRenderer = this.createAdRendererFromFactory(creativeType, this.currentAdRenderer);
        if (this.currentAdRenderer == null) {
            String msg = "No renderer returned, not loading an ad";
            Log.d(LOG_TAG, "No renderer returned, not loading an ad");
            this.adFailed(new AdError(AdError.ErrorCode.INTERNAL_ERROR, "No renderer returned, not loading an ad"));
        } else {
            this.currentAdRenderer.initialize();
            this.getAdData().setIsRendering(true);
            long renderLatencyStartTime = System.nanoTime();
            this.getAdData().getMetricsCollector().stopMetricInMillisecondsFromNanoseconds(Metrics.MetricType.AD_LOAD_LATENCY_FINALIZE_FETCH_START_TO_RENDER_START, renderLatencyStartTime);
            this.getAdData().getMetricsCollector().startMetricInMillisecondsFromNanoseconds(Metrics.MetricType.AD_LATENCY_RENDER, renderLatencyStartTime);
            this.getAdData().getMetricsCollector().startMetricInMillisecondsFromNanoseconds(Metrics.MetricType.AD_LATENCY_RENDER_FAILED, renderLatencyStartTime);
            if (!this.currentAdRenderer.render()) {
                this.destroyCurrentAdRenderer();
                String msg = "Ad could not render";
                Log.d(LOG_TAG, "Ad could not render");
                this.adFailed(new AdError(AdError.ErrorCode.INTERNAL_ERROR, "Ad could not render"));
            }
        }
    }

    protected AdRenderer createAdRendererFromFactory(AdData.AAXCreative creativeType, AdRenderer adRenderer) {
        AdRendererFactory adRendererFactory = new AdRendererFactory();
        if (adRendererFactory.shouldCreateNewRenderer(creativeType, adRenderer)) {
            Log.d(LOG_TAG, "Creating new renderer");
            if (adRenderer != null) {
                adRenderer.destroy();
            }
            if (this.webView == null) {
                this.createAndCacheWebView();
            }
            adRenderer = adRendererFactory.getAdRenderer(creativeType, this.adData, this, this.webView, this.context);
            this.webView = null;
        } else {
            Log.d(LOG_TAG, "Re-using renderer");
            adRenderer.setAd(this.adData);
        }
        return adRenderer;
    }

    private void createAndCacheWebView() {
        this.webView = WebViewFactory.getInstance().createWebView(this.context);
    }

    @Override
    public void adLoaded(final AdProperties props) {
        long renderStopTime = System.nanoTime();
        this.adShown();
        this.getAdData().getMetricsCollector().stopMetricInMillisecondsFromNanoseconds(Metrics.MetricType.AD_LATENCY_TOTAL, renderStopTime);
        this.getAdData().getMetricsCollector().stopMetricInMillisecondsFromNanoseconds(Metrics.MetricType.AD_LATENCY_TOTAL_SUCCESS, renderStopTime);
        this.getAdData().getMetricsCollector().stopMetricInMillisecondsFromNanoseconds(Metrics.MetricType.AD_LATENCY_RENDER, renderStopTime);
        this.setAdditionalMetrics();
        this.getAdData().setIsRendering(false);
        this.isLoading = false;
        Handler h = new Handler(this.context.getMainLooper());
        h.post(new Runnable(){

            public void run() {
                AdController.this.adListener.onAdLoaded(AdController.this.adLayout, props);
                AdController.this.submitAndResetMetricsIfNecessary(true);
            }
        });
    }

    @Override
    public void adShown() {
        WebRequest.executeWebRequestInThread(this.getAdData().getImpressionPixelUrl());
    }

    @Override
    public void adFailed(AdError error) {
        if (this.getAdData() == null || this.getAdData().getMetricsCollector().isMetricsCollectorEmpty()) {
            this.adFailedBeforeAdMetricsStart(error);
        } else {
            this.adFailedAfterAdMetricsStart(error);
        }
    }

    protected void adFailedBeforeAdMetricsStart(AdError error) {
        this.processAdFailure();
        this.callListenerOnAdFailedToLoad(error, false);
    }

    protected void adFailedAfterAdMetricsStart(AdError error) {
        this.processAdFailure();
        this.accumulateAdFailureMetrics(error);
        this.callListenerOnAdFailedToLoad(error, true);
    }

    private void processAdFailure() {
        if (this.webView != null) {
            this.webView.destroy();
            this.webView = null;
        }
        this.isLoading = false;
    }

    protected void accumulateAdFailureMetrics(AdError error) {
        long renderStopTime = System.nanoTime();
        this.getAdData().getMetricsCollector().stopMetricInMillisecondsFromNanoseconds(Metrics.MetricType.AD_LATENCY_RENDER_FAILED, renderStopTime);
        if (error.getCode() != AdError.ErrorCode.NO_FILL) {
            this.getAdData().getMetricsCollector().incrementMetric(Metrics.MetricType.AD_LOAD_FAILED);
        }
        if (this.getAdData().getIsRendering()) {
            this.getAdData().getMetricsCollector().incrementMetric(Metrics.MetricType.AD_COUNTER_RENDERING_FATAL);
            this.getAdData().setIsRendering(false);
        }
        this.getAdData().getMetricsCollector().stopMetricInMillisecondsFromNanoseconds(Metrics.MetricType.AD_LOAD_LATENCY_FINALIZE_FETCH_START_TO_FAILURE, renderStopTime);
        this.getAdData().getMetricsCollector().stopMetricInMillisecondsFromNanoseconds(Metrics.MetricType.AD_LATENCY_TOTAL, renderStopTime);
        this.getAdData().getMetricsCollector().stopMetricInMillisecondsFromNanoseconds(Metrics.MetricType.AD_LATENCY_TOTAL_FAILURE, renderStopTime);
        this.setAdditionalMetrics();
    }

    protected void callListenerOnAdFailedToLoad(final AdError error, final boolean shouldSubmitMetrics) {
        Handler h = new Handler(this.context.getMainLooper());
        h.post(new Runnable(){

            public void run() {
                AdController.this.adListener.onAdFailedToLoad(AdController.this.adLayout, error);
                AdController.this.submitAndResetMetricsIfNecessary(shouldSubmitMetrics);
            }
        });
    }

    @Override
    public void adExpanded() {
        Handler h = new Handler(this.context.getMainLooper());
        h.post(new Runnable(){

            public void run() {
                AdController.this.adListener.onAdExpanded(AdController.this.adLayout);
            }
        });
    }

    @Override
    public void adClosedExpansion() {
        Handler h = new Handler(this.context.getMainLooper());
        h.post(new Runnable(){

            public void run() {
                AdController.this.adListener.onAdCollapsed(AdController.this.adLayout);
            }
        });
    }

    protected void setAdditionalMetrics() {
        AdUtils.setConnectionMetrics(this.getAdData());
        if (this.getAdLayout().isParentViewMissingAtLoadTime()) {
            this.getAdData().getMetricsCollector().incrementMetric(Metrics.MetricType.AD_COUNTER_PARENT_VIEW_MISSING);
        }
        if (this.getWindowHeight() == 0) {
            this.getAdData().getMetricsCollector().incrementMetric(Metrics.MetricType.ADLAYOUT_HEIGHT_ZERO);
        }
        if (this.currentAdRenderer != null) {
            this.getAdData().getMetricsCollector().setMetricString(Metrics.MetricType.VIEWPORT_SCALE, this.currentAdRenderer.getScalingMultiplierDescription());
        }
    }

    protected Context getContext() {
        return this.context;
    }

    protected AdRenderer getCurrentAdRenderer() {
        return this.currentAdRenderer;
    }

    private void submitAndResetMetricsIfNecessary(boolean shouldSubmitMetrics) {
        if (shouldSubmitMetrics) {
            Metrics.getInstance().submitAndResetMetrics(this.getAdData());
        }
    }

    @Override
    public boolean shouldDisableWebViewHardwareAcceleration() {
        return this.getAdLayout().shouldDisableWebViewHardwareAcceleration();
    }

    @Override
    public AdWebViewClient.UrlExecutor getSpecialUrlExecutor() {
        return new AdWebViewClient.AmazonMobileExecutor(this.currentAdRenderer, this.context);
    }
}

