/*
 * Decompiled with CFR 0.152.
 */
package io.card.payment;

import android.os.Parcel;
import android.os.Parcelable;
import io.card.payment.CardType;
import io.card.payment.CreditCard$1;
import io.card.payment.P;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.UUID;
import org.apache.http.message.BasicNameValuePair;
import org.json.JSONArray;
import org.json.JSONObject;

public class CreditCard
implements Parcelable {
    public static final int EXPIRY_MAX_FUTURE_YEARS = 15;
    private static final String TAG = "CardIOCreditCardResults";
    public String cardNumber;
    public int expiryMonth = 0;
    public int expiryYear = 0;
    public String cvv;
    public String zip;
    public String postalCode;
    String scanId;
    boolean flipped = false;
    int yoff;
    int[] xoff;
    public static final Parcelable.Creator CREATOR = new CreditCard$1();

    public CreditCard() {
        this.xoff = new int[16];
        this.scanId = UUID.randomUUID().toString();
    }

    CreditCard(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        try {
            string = new JSONObject(string);
            this.cardNumber = string.optString("numbers");
            String cfr_ignored_0 = "- number: " + this.getRedactedCardNumber();
            JSONArray jSONArray = string.optJSONArray("expiry");
            if (jSONArray != null && jSONArray.length() == 2) {
                this.expiryYear = jSONArray.getInt(0);
                String cfr_ignored_1 = "- year: " + this.expiryYear;
                this.expiryMonth = jSONArray.getInt(1);
                String cfr_ignored_2 = "- month: " + this.expiryMonth;
            }
            this.flipped = string.optBoolean("is_flipped");
            String cfr_ignored_3 = "- isFlipped: " + this.flipped;
            this.scanId = string.optString("scan_id");
            String cfr_ignored_4 = "- scanId: " + this.scanId;
            this.yoff = string.optInt("y_offset");
            string = string.optJSONArray("x_offsets");
            this.xoff = new int[string.length()];
            for (int i2 = 0; i2 < string.length(); ++i2) {
                this.xoff[i2] = string.getInt(i2);
            }
            return;
        }
        catch (Exception exception) {
            if (!(this.cardNumber == null || this.cardNumber.length() >= 15 && P.a(this.cardNumber))) {
                this.cardNumber = null;
            }
            return;
        }
    }

    public CreditCard(String string, int n2, int n3, String string2, String string3) {
        this.cardNumber = string;
        this.expiryMonth = n2;
        this.expiryYear = n3;
        this.cvv = string2;
        this.zip = string3;
        this.postalCode = string3;
    }

    private CreditCard(Parcel parcel) {
        this.cardNumber = parcel.readString();
        this.expiryMonth = parcel.readInt();
        this.expiryYear = parcel.readInt();
        this.cvv = parcel.readString();
        this.zip = this.postalCode = parcel.readString();
        this.scanId = parcel.readString();
        this.yoff = parcel.readInt();
        this.xoff = parcel.createIntArray();
    }

    public int describeContents() {
        return 0;
    }

    public final void writeToParcel(Parcel parcel, int n2) {
        parcel.writeString(this.cardNumber);
        parcel.writeInt(this.expiryMonth);
        parcel.writeInt(this.expiryYear);
        parcel.writeString(this.cvv);
        parcel.writeString(this.postalCode);
        parcel.writeString(this.scanId);
        parcel.writeInt(this.yoff);
        parcel.writeIntArray(this.xoff);
    }

    public String getLastFourDigitsOfCardNumber() {
        if (this.cardNumber != null) {
            int n2 = Math.min(4, this.cardNumber.length());
            return this.cardNumber.substring(this.cardNumber.length() - n2);
        }
        return "";
    }

    public String getRedactedCardNumber() {
        if (this.cardNumber != null) {
            String string = "";
            if (this.cardNumber.length() > 4) {
                string = string + String.format("%" + (this.cardNumber.length() - 4) + "s", "").replace(' ', '\u2022');
            }
            return P.a(string + this.getLastFourDigitsOfCardNumber(), false, CardType.fromCardNumber(this.cardNumber));
        }
        return "";
    }

    public CardType getCardType() {
        return CardType.fromCardNumber(this.cardNumber);
    }

    public String getFormattedCardNumber() {
        String string = this.cardNumber;
        return P.a(string, true, null);
    }

    List toNameValueList() {
        ArrayList<BasicNameValuePair> arrayList = new ArrayList<BasicNameValuePair>();
        arrayList.add(new BasicNameValuePair("card_number", this.cardNumber));
        if (this.expiryMonth > 0 && this.expiryYear > 0) {
            arrayList.add(new BasicNameValuePair("card_exp_month", String.valueOf(this.expiryMonth)));
            arrayList.add(new BasicNameValuePair("card_exp_year", String.valueOf(this.expiryYear)));
        }
        if (this.cvv != null) {
            arrayList.add(new BasicNameValuePair("card_cvv", this.cvv));
        }
        if (this.zip != null) {
            arrayList.add(new BasicNameValuePair("card_zip", this.zip));
        }
        if (this.postalCode != null) {
            arrayList.add(new BasicNameValuePair("card_postal_code", this.postalCode));
        }
        if (this.scanId != null) {
            arrayList.add(new BasicNameValuePair("scan_id", this.scanId));
        }
        return arrayList;
    }

    public boolean isExpiryValid() {
        int n2 = this.expiryYear;
        int n3 = this.expiryMonth;
        if (n3 <= 0 || 12 < n3) {
            return false;
        }
        Calendar calendar = Calendar.getInstance();
        int n4 = calendar.get(1);
        int n5 = calendar.get(2) + 1;
        if (n2 < n4) {
            return false;
        }
        if (n2 == n4 && n3 < n5) {
            return false;
        }
        return n2 <= n4 + 15;
    }

    boolean failed() {
        return this.cardNumber == null || this.cardNumber.length() == 0;
    }

    public String toString() {
        String string = "{" + (Object)((Object)this.getCardType()) + ": " + this.getRedactedCardNumber();
        if (this.expiryMonth > 0 || this.expiryYear > 0) {
            string = string + "  expiry:" + this.expiryMonth + "/" + this.expiryYear;
        }
        if (this.zip != null) {
            string = string + "  zip:" + this.zip;
        }
        if (this.postalCode != null) {
            string = string + "  postalCode:" + this.postalCode;
        }
        if (this.cvv != null) {
            string = string + "  cvvLength:" + (this.cvv != null ? this.cvv.length() : 0);
        }
        return string + "}";
    }

    /* synthetic */ CreditCard(Parcel parcel, CreditCard$1 creditCard$1) {
        this(parcel);
    }
}

