/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wearable;

import android.app.Service;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.Binder;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.util.Log;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.internal.kh;
import com.google.android.gms.internal.ki;
import com.google.android.gms.internal.kk;
import com.google.android.gms.wearable.b;
import com.google.android.gms.wearable.e;
import com.google.android.gms.wearable.f;

public abstract class WearableListenerService
extends Service {
    public static final String BIND_LISTENER_INTENT_ACTION = "com.google.android.gms.wearable.BIND_LISTENER";
    private volatile int adu = -1;
    private String adv;
    private Handler adw;
    private IBinder DB;

    public void onCreate() {
        super.onCreate();
        if (Log.isLoggable((String)"WearableLS", (int)3)) {
            Log.d((String)"WearableLS", (String)("onCreate: " + this.getPackageName()));
        }
        this.adv = this.getPackageName();
        HandlerThread handlerThread = new HandlerThread("WearableListenerService");
        handlerThread.start();
        this.adw = new Handler(handlerThread.getLooper());
        this.DB = new a();
    }

    public void onDestroy() {
        this.adw.getLooper().quit();
        super.onDestroy();
    }

    public IBinder onBind(Intent intent) {
        if (BIND_LISTENER_INTENT_ACTION.equals(intent.getAction())) {
            return this.DB;
        }
        return null;
    }

    public void onDataChanged(b dataEvents) {
    }

    public void onMessageReceived(e messageEvent) {
    }

    public void onPeerConnected(f peer) {
    }

    public void onPeerDisconnected(f peer) {
    }

    private void md() throws SecurityException {
        int n2 = Binder.getCallingUid();
        if (n2 == this.adu) {
            return;
        }
        boolean bl2 = GooglePlayServicesUtil.b(this.getPackageManager(), "com.google.android.gms");
        if (bl2 && this.cM(n2)) {
            this.adu = n2;
            return;
        }
        throw new SecurityException("Caller is not GooglePlayServices");
    }

    private boolean cM(int n2) {
        String string2 = "com.google.android.gms";
        PackageManager packageManager = this.getPackageManager();
        String[] stringArray = packageManager.getPackagesForUid(n2);
        if (stringArray != null) {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                if (!string2.equals(stringArray[i2])) continue;
                return true;
            }
        }
        return false;
    }

    private class a
    extends kh.a {
        private a() {
        }

        @Override
        public void M(final DataHolder dataHolder) {
            if (Log.isLoggable((String)"WearableLS", (int)3)) {
                Log.d((String)"WearableLS", (String)("onDataItemChanged: " + WearableListenerService.this.adv + ": " + dataHolder));
            }
            WearableListenerService.this.md();
            WearableListenerService.this.adw.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    b b2 = new b(dataHolder);
                    try {
                        WearableListenerService.this.onDataChanged(b2);
                    }
                    finally {
                        b2.close();
                    }
                }
            });
        }

        @Override
        public void a(final ki ki2) {
            if (Log.isLoggable((String)"WearableLS", (int)3)) {
                Log.d((String)"WearableLS", (String)("onMessageReceived: " + ki2));
            }
            WearableListenerService.this.md();
            WearableListenerService.this.adw.post(new Runnable(){

                @Override
                public void run() {
                    WearableListenerService.this.onMessageReceived(ki2);
                }
            });
        }

        @Override
        public void a(final kk kk2) {
            if (Log.isLoggable((String)"WearableLS", (int)3)) {
                Log.d((String)"WearableLS", (String)("onPeerConnected: " + WearableListenerService.this.adv + ": " + kk2));
            }
            WearableListenerService.this.md();
            WearableListenerService.this.adw.post(new Runnable(){

                @Override
                public void run() {
                    WearableListenerService.this.onPeerConnected(kk2);
                }
            });
        }

        @Override
        public void b(final kk kk2) {
            if (Log.isLoggable((String)"WearableLS", (int)3)) {
                Log.d((String)"WearableLS", (String)("onPeerDisconnected: " + WearableListenerService.this.adv + ": " + kk2));
            }
            WearableListenerService.this.md();
            WearableListenerService.this.adw.post(new Runnable(){

                @Override
                public void run() {
                    WearableListenerService.this.onPeerDisconnected(kk2);
                }
            });
        }
    }
}

