/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet.fragment;

import android.app.Activity;
import android.app.Fragment;
import android.app.FragmentManager;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.RemoteException;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import com.google.android.gms.R;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.dynamic.LifecycleDelegate;
import com.google.android.gms.dynamic.d;
import com.google.android.gms.dynamic.e;
import com.google.android.gms.dynamic.f;
import com.google.android.gms.internal.iz;
import com.google.android.gms.internal.ja;
import com.google.android.gms.internal.jh;
import com.google.android.gms.wallet.MaskedWalletRequest;
import com.google.android.gms.wallet.fragment.WalletFragmentInitParams;
import com.google.android.gms.wallet.fragment.WalletFragmentOptions;
import com.google.android.gms.wallet.fragment.WalletFragmentStyle;

public final class WalletFragment
extends Fragment {
    private b acH;
    private boolean mCreated = false;
    private final com.google.android.gms.dynamic.b acI = com.google.android.gms.dynamic.b.a(this);
    private final c acJ = new c();
    private a acK = new a(this);
    private final Fragment Hv = this;
    private WalletFragmentOptions acz;
    private WalletFragmentInitParams acA;
    private MaskedWalletRequest acB;
    private Boolean acC;

    public static WalletFragment newInstance(WalletFragmentOptions options) {
        WalletFragment walletFragment = new WalletFragment();
        Bundle bundle = new Bundle();
        bundle.putParcelable("extraWalletFragmentOptions", (Parcelable)options);
        walletFragment.Hv.setArguments(bundle);
        return walletFragment;
    }

    public void initialize(WalletFragmentInitParams initParams) {
        if (this.acH != null) {
            this.acH.initialize(initParams);
            this.acA = null;
        } else if (this.acA == null) {
            this.acA = initParams;
            if (this.acB != null) {
                Log.w((String)"WalletFragment", (String)"updateMaskedWallet() was called before initialize()");
            }
        } else {
            Log.w((String)"WalletFragment", (String)"initialize(WalletFragmentInitParams) was called more than once. Ignoring.");
        }
    }

    public void updateMaskedWalletRequest(MaskedWalletRequest request) {
        if (this.acH != null) {
            this.acH.updateMaskedWalletRequest(request);
            this.acB = null;
        } else {
            this.acB = request;
        }
    }

    public void setEnabled(boolean enabled) {
        if (this.acH != null) {
            this.acH.setEnabled(enabled);
            this.acC = null;
        } else {
            this.acC = enabled;
        }
    }

    public void setOnStateChangedListener(OnStateChangedListener listener) {
        this.acK.a(listener);
    }

    public int getState() {
        return this.acH != null ? this.acH.getState() : 0;
    }

    public void onInflate(Activity activity, AttributeSet attrs, Bundle savedInstanceState) {
        super.onInflate(activity, attrs, savedInstanceState);
        if (this.acz == null) {
            this.acz = WalletFragmentOptions.a((Context)activity, attrs);
        }
        Bundle bundle = new Bundle();
        bundle.putParcelable("attrKeyWalletFragmentOptions", (Parcelable)this.acz);
        this.acJ.onInflate(activity, bundle, savedInstanceState);
    }

    public void onCreate(Bundle savedInstanceState) {
        WalletFragmentOptions walletFragmentOptions;
        super.onCreate(savedInstanceState);
        if (savedInstanceState != null) {
            savedInstanceState.setClassLoader(WalletFragmentOptions.class.getClassLoader());
            WalletFragmentInitParams walletFragmentInitParams = (WalletFragmentInitParams)savedInstanceState.getParcelable("walletFragmentInitParams");
            if (walletFragmentInitParams != null) {
                if (this.acA != null) {
                    Log.w((String)"WalletFragment", (String)"initialize(WalletFragmentInitParams) was called more than once.Ignoring.");
                }
                this.acA = walletFragmentInitParams;
            }
            if (this.acB == null) {
                this.acB = (MaskedWalletRequest)savedInstanceState.getParcelable("maskedWalletRequest");
            }
            if (savedInstanceState.containsKey("walletFragmentOptions")) {
                this.acz = (WalletFragmentOptions)savedInstanceState.getParcelable("walletFragmentOptions");
            }
            if (savedInstanceState.containsKey("enabled")) {
                this.acC = savedInstanceState.getBoolean("enabled");
            }
        } else if (this.Hv.getArguments() != null && (walletFragmentOptions = (WalletFragmentOptions)this.Hv.getArguments().getParcelable("extraWalletFragmentOptions")) != null) {
            walletFragmentOptions.I((Context)this.Hv.getActivity());
            this.acz = walletFragmentOptions;
        }
        this.mCreated = true;
        this.acJ.onCreate(savedInstanceState);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return this.acJ.onCreateView(inflater, container, savedInstanceState);
    }

    public void onStart() {
        super.onStart();
        this.acJ.onStart();
    }

    public void onResume() {
        super.onResume();
        this.acJ.onResume();
        FragmentManager fragmentManager = this.Hv.getActivity().getFragmentManager();
        Fragment fragment = fragmentManager.findFragmentByTag("GooglePlayServicesErrorDialog");
        if (fragment != null) {
            fragmentManager.beginTransaction().remove(fragment).commit();
            int n2 = GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)this.Hv.getActivity());
            GooglePlayServicesUtil.showErrorDialogFragment(n2, this.Hv.getActivity(), -1);
        }
    }

    public void onPause() {
        super.onPause();
        this.acJ.onPause();
    }

    public void onStop() {
        super.onStop();
        this.acJ.onStop();
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.setClassLoader(WalletFragmentOptions.class.getClassLoader());
        this.acJ.onSaveInstanceState(outState);
        if (this.acA != null) {
            outState.putParcelable("walletFragmentInitParams", (Parcelable)this.acA);
            this.acA = null;
        }
        if (this.acB != null) {
            outState.putParcelable("maskedWalletRequest", (Parcelable)this.acB);
            this.acB = null;
        }
        if (this.acz != null) {
            outState.putParcelable("walletFragmentOptions", (Parcelable)this.acz);
            this.acz = null;
        }
        if (this.acC != null) {
            outState.putBoolean("enabled", this.acC.booleanValue());
            this.acC = null;
        }
    }

    public void onDestroy() {
        super.onDestroy();
        this.mCreated = false;
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (this.acH != null) {
            this.acH.onActivityResult(requestCode, resultCode, data);
        }
    }

    public static interface OnStateChangedListener {
        public void onStateChanged(WalletFragment var1, int var2, int var3, Bundle var4);
    }

    static class a
    extends ja.a {
        private OnStateChangedListener acL;
        private final WalletFragment acM;

        a(WalletFragment walletFragment) {
            this.acM = walletFragment;
        }

        @Override
        public void a(int n2, int n3, Bundle bundle) {
            if (this.acL != null) {
                this.acL.onStateChanged(this.acM, n2, n3, bundle);
            }
        }

        public void a(OnStateChangedListener onStateChangedListener) {
            this.acL = onStateChangedListener;
        }
    }

    private static class b
    implements LifecycleDelegate {
        private final iz acF;

        private b(iz iz2) {
            this.acF = iz2;
        }

        private void initialize(WalletFragmentInitParams startParams) {
            try {
                this.acF.initialize(startParams);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private void setEnabled(boolean enabled) {
            try {
                this.acF.setEnabled(enabled);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private void updateMaskedWalletRequest(MaskedWalletRequest request) {
            try {
                this.acF.updateMaskedWalletRequest(request);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private int getState() {
            try {
                return this.acF.getState();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        @Override
        public void onInflate(Activity activity, Bundle attrs, Bundle savedInstanceState) {
            WalletFragmentOptions walletFragmentOptions = (WalletFragmentOptions)attrs.getParcelable("extraWalletFragmentOptions");
            try {
                this.acF.a(e.h(activity), walletFragmentOptions, savedInstanceState);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        @Override
        public void onCreate(Bundle savedInstanceState) {
            try {
                this.acF.onCreate(savedInstanceState);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        @Override
        public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
            try {
                d d2 = this.acF.onCreateView(e.h(inflater), e.h(container), savedInstanceState);
                return (View)e.d(d2);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        @Override
        public void onStart() {
            try {
                this.acF.onStart();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        @Override
        public void onResume() {
            try {
                this.acF.onResume();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        @Override
        public void onPause() {
            try {
                this.acF.onPause();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        @Override
        public void onStop() {
            try {
                this.acF.onStop();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        @Override
        public void onDestroyView() {
        }

        @Override
        public void onDestroy() {
        }

        @Override
        public void onLowMemory() {
        }

        @Override
        public void onSaveInstanceState(Bundle outState) {
            try {
                this.acF.onSaveInstanceState(outState);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }

        private void onActivityResult(int requestCode, int resultCode, Intent data) {
            try {
                this.acF.onActivityResult(requestCode, resultCode, data);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException(remoteException);
            }
        }
    }

    private class c
    extends com.google.android.gms.dynamic.a<b>
    implements View.OnClickListener {
        private c() {
        }

        @Override
        protected void a(f<b> f2) {
            Activity activity = WalletFragment.this.Hv.getActivity();
            if (WalletFragment.this.acH == null && WalletFragment.this.mCreated && activity != null) {
                try {
                    iz iz2 = jh.a(activity, WalletFragment.this.acI, WalletFragment.this.acz, WalletFragment.this.acK);
                    WalletFragment.this.acH = new b(iz2);
                    WalletFragment.this.acz = null;
                }
                catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {
                    return;
                }
                f2.a(WalletFragment.this.acH);
                if (WalletFragment.this.acA != null) {
                    WalletFragment.this.acH.initialize(WalletFragment.this.acA);
                    WalletFragment.this.acA = null;
                }
                if (WalletFragment.this.acB != null) {
                    WalletFragment.this.acH.updateMaskedWalletRequest(WalletFragment.this.acB);
                    WalletFragment.this.acB = null;
                }
                if (WalletFragment.this.acC != null) {
                    WalletFragment.this.acH.setEnabled(WalletFragment.this.acC);
                    WalletFragment.this.acC = null;
                }
            }
        }

        @Override
        protected void a(FrameLayout frameLayout) {
            WalletFragmentStyle walletFragmentStyle;
            Button button = new Button((Context)WalletFragment.this.Hv.getActivity());
            button.setText(R.string.wallet_buy_button_place_holder);
            int n2 = -1;
            int n3 = -2;
            if (WalletFragment.this.acz != null && (walletFragmentStyle = WalletFragment.this.acz.getFragmentStyle()) != null) {
                DisplayMetrics displayMetrics = WalletFragment.this.Hv.getResources().getDisplayMetrics();
                n2 = walletFragmentStyle.a("buyButtonWidth", displayMetrics, n2);
                n3 = walletFragmentStyle.a("buyButtonHeight", displayMetrics, n3);
            }
            button.setLayoutParams(new ViewGroup.LayoutParams(n2, n3));
            button.setOnClickListener((View.OnClickListener)this);
            frameLayout.addView((View)button);
        }

        public void onClick(View view) {
            Activity activity = WalletFragment.this.Hv.getActivity();
            int n2 = GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)activity);
            GooglePlayServicesUtil.showErrorDialogFragment(n2, activity, -1);
        }
    }
}

