/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.maps.internal.v;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.PolygonOptionsCreator;
import com.google.android.gms.maps.model.g;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class PolygonOptions
implements SafeParcelable {
    public static final PolygonOptionsCreator CREATOR = new PolygonOptionsCreator();
    private final int xH;
    private final List<LatLng> Tn;
    private final List<List<LatLng>> To;
    private float SK = 10.0f;
    private int SL = -16777216;
    private int SM = 0;
    private float SN = 0.0f;
    private boolean SO = true;
    private boolean Tp = false;

    public PolygonOptions() {
        this.xH = 1;
        this.Tn = new ArrayList<LatLng>();
        this.To = new ArrayList<List<LatLng>>();
    }

    PolygonOptions(int versionCode, List<LatLng> points, List holes, float strokeWidth, int strokeColor, int fillColor, float zIndex, boolean visible, boolean geodesic) {
        this.xH = versionCode;
        this.Tn = points;
        this.To = holes;
        this.SK = strokeWidth;
        this.SL = strokeColor;
        this.SM = fillColor;
        this.SN = zIndex;
        this.SO = visible;
        this.Tp = geodesic;
    }

    int getVersionCode() {
        return this.xH;
    }

    List iF() {
        return this.To;
    }

    public void writeToParcel(Parcel out, int flags) {
        if (v.iB()) {
            g.a(this, out, flags);
        } else {
            PolygonOptionsCreator.a(this, out, flags);
        }
    }

    public int describeContents() {
        return 0;
    }

    public PolygonOptions add(LatLng point) {
        this.Tn.add(point);
        return this;
    }

    public PolygonOptions add(LatLng ... points) {
        this.Tn.addAll(Arrays.asList(points));
        return this;
    }

    public PolygonOptions addAll(Iterable<LatLng> points) {
        for (LatLng latLng : points) {
            this.Tn.add(latLng);
        }
        return this;
    }

    public PolygonOptions addHole(Iterable<LatLng> points) {
        ArrayList<LatLng> arrayList = new ArrayList<LatLng>();
        for (LatLng latLng : points) {
            arrayList.add(latLng);
        }
        this.To.add(arrayList);
        return this;
    }

    public PolygonOptions strokeWidth(float width) {
        this.SK = width;
        return this;
    }

    public PolygonOptions strokeColor(int color2) {
        this.SL = color2;
        return this;
    }

    public PolygonOptions fillColor(int color2) {
        this.SM = color2;
        return this;
    }

    public PolygonOptions zIndex(float zIndex) {
        this.SN = zIndex;
        return this;
    }

    public PolygonOptions visible(boolean visible) {
        this.SO = visible;
        return this;
    }

    public PolygonOptions geodesic(boolean geodesic) {
        this.Tp = geodesic;
        return this;
    }

    public List<LatLng> getPoints() {
        return this.Tn;
    }

    public List<List<LatLng>> getHoles() {
        return this.To;
    }

    public float getStrokeWidth() {
        return this.SK;
    }

    public int getStrokeColor() {
        return this.SL;
    }

    public int getFillColor() {
        return this.SM;
    }

    public float getZIndex() {
        return this.SN;
    }

    public boolean isVisible() {
        return this.SO;
    }

    public boolean isGeodesic() {
        return this.Tp;
    }
}

