/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.os.Parcel;
import android.os.SystemClock;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.internal.fo;
import com.google.android.gms.location.LocationRequestCreator;

public final class LocationRequest
implements SafeParcelable {
    public static final int PRIORITY_HIGH_ACCURACY = 100;
    public static final int PRIORITY_BALANCED_POWER_ACCURACY = 102;
    public static final int PRIORITY_LOW_POWER = 104;
    public static final int PRIORITY_NO_POWER = 105;
    private final int xH;
    int mPriority;
    long Oc;
    long Od;
    boolean Oe;
    long NV;
    int Of;
    float Og;
    public static final LocationRequestCreator CREATOR = new LocationRequestCreator();

    public static LocationRequest create() {
        return new LocationRequest();
    }

    public LocationRequest() {
        this.xH = 1;
        this.mPriority = 102;
        this.Oc = 3600000L;
        this.Od = 600000L;
        this.Oe = false;
        this.NV = Long.MAX_VALUE;
        this.Of = Integer.MAX_VALUE;
        this.Og = 0.0f;
    }

    public LocationRequest setPriority(int priority) {
        LocationRequest.bw(priority);
        this.mPriority = priority;
        return this;
    }

    public int getPriority() {
        return this.mPriority;
    }

    public LocationRequest setInterval(long millis) {
        LocationRequest.s(millis);
        this.Oc = millis;
        if (!this.Oe) {
            this.Od = (long)((double)this.Oc / 6.0);
        }
        return this;
    }

    public long getInterval() {
        return this.Oc;
    }

    public LocationRequest setFastestInterval(long millis) {
        LocationRequest.s(millis);
        this.Oe = true;
        this.Od = millis;
        return this;
    }

    public long getFastestInterval() {
        return this.Od;
    }

    public LocationRequest setExpirationDuration(long millis) {
        long l2 = SystemClock.elapsedRealtime();
        this.NV = millis > Long.MAX_VALUE - l2 ? Long.MAX_VALUE : millis + l2;
        if (this.NV < 0L) {
            this.NV = 0L;
        }
        return this;
    }

    public LocationRequest setExpirationTime(long millis) {
        this.NV = millis;
        if (this.NV < 0L) {
            this.NV = 0L;
        }
        return this;
    }

    public long getExpirationTime() {
        return this.NV;
    }

    public LocationRequest setNumUpdates(int numUpdates) {
        if (numUpdates <= 0) {
            throw new IllegalArgumentException("invalid numUpdates: " + numUpdates);
        }
        this.Of = numUpdates;
        return this;
    }

    public int getNumUpdates() {
        return this.Of;
    }

    public LocationRequest setSmallestDisplacement(float smallestDisplacementMeters) {
        LocationRequest.a(smallestDisplacementMeters);
        this.Og = smallestDisplacementMeters;
        return this;
    }

    public float getSmallestDisplacement() {
        return this.Og;
    }

    private static void s(long l2) {
        if (l2 < 0L) {
            throw new IllegalArgumentException("invalid interval: " + l2);
        }
    }

    private static void bw(int n2) {
        switch (n2) {
            case 100: 
            case 102: 
            case 104: 
            case 105: {
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid quality: " + n2);
            }
        }
    }

    private static void a(float f2) {
        if (f2 < 0.0f) {
            throw new IllegalArgumentException("invalid displacement: " + f2);
        }
    }

    LocationRequest(int versionCode, int priority, long interval, long fastestInterval, boolean explicitFastestInterval, long expireAt, int numUpdates, float smallestDisplacement) {
        this.xH = versionCode;
        this.mPriority = priority;
        this.Oc = interval;
        this.Od = fastestInterval;
        this.Oe = explicitFastestInterval;
        this.NV = expireAt;
        this.Of = numUpdates;
        this.Og = smallestDisplacement;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        LocationRequestCreator.a(this, parcel, flags);
    }

    public static String bx(int n2) {
        switch (n2) {
            case 100: {
                return "PRIORITY_HIGH_ACCURACY";
            }
            case 102: {
                return "PRIORITY_BALANCED_POWER_ACCURACY";
            }
            case 104: {
                return "PRIORITY_LOW_POWER";
            }
            case 105: {
                return "PRIORITY_NO_POWER";
            }
        }
        return "???";
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Request[").append(LocationRequest.bx(this.mPriority));
        if (this.mPriority != 105) {
            stringBuilder.append(" requested=");
            stringBuilder.append(this.Oc + "ms");
        }
        stringBuilder.append(" fastest=");
        stringBuilder.append(this.Od + "ms");
        if (this.NV != Long.MAX_VALUE) {
            long l2 = this.NV - SystemClock.elapsedRealtime();
            stringBuilder.append(" expireIn=");
            stringBuilder.append(l2 + "ms");
        }
        if (this.Of != Integer.MAX_VALUE) {
            stringBuilder.append(" num=").append(this.Of);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public int hashCode() {
        return fo.hashCode(this.mPriority, this.Oc, this.Od, this.Oe, this.NV, this.Of, Float.valueOf(this.Og));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof LocationRequest)) {
            return false;
        }
        LocationRequest locationRequest = (LocationRequest)object;
        return this.mPriority == locationRequest.mPriority && this.Oc == locationRequest.Oc && this.Od == locationRequest.Od && this.Oe == locationRequest.Oe && this.NV == locationRequest.NV && this.Of == locationRequest.Of && this.Og == locationRequest.Og;
    }

    int getVersionCode() {
        return this.xH;
    }
}

