/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.os.SystemClock;
import com.google.android.gms.internal.hd;

public interface Geofence {
    public static final int GEOFENCE_TRANSITION_ENTER = 1;
    public static final int GEOFENCE_TRANSITION_EXIT = 2;
    public static final int GEOFENCE_TRANSITION_DWELL = 4;
    public static final long NEVER_EXPIRE = -1L;

    public String getRequestId();

    public static final class Builder {
        private String Jo = null;
        private int NU = 0;
        private long NV = Long.MIN_VALUE;
        private short NW = (short)-1;
        private double NX;
        private double NY;
        private float NZ;
        private int Oa = 0;
        private int Ob = -1;

        public Builder setRequestId(String requestId) {
            this.Jo = requestId;
            return this;
        }

        public Builder setTransitionTypes(int transitionTypes) {
            this.NU = transitionTypes;
            return this;
        }

        public Builder setExpirationDuration(long durationMillis) {
            this.NV = durationMillis < 0L ? -1L : SystemClock.elapsedRealtime() + durationMillis;
            return this;
        }

        public Builder setCircularRegion(double latitude, double longitude, float radius) {
            this.NW = 1;
            this.NX = latitude;
            this.NY = longitude;
            this.NZ = radius;
            return this;
        }

        public Builder setNotificationResponsiveness(int notificationResponsivenessMs) {
            this.Oa = notificationResponsivenessMs;
            return this;
        }

        public Builder setLoiteringDelay(int loiteringDelayMs) {
            this.Ob = loiteringDelayMs;
            return this;
        }

        public Geofence build() {
            if (this.Jo == null) {
                throw new IllegalArgumentException("Request ID not set.");
            }
            if (this.NU == 0) {
                throw new IllegalArgumentException("Transitions types not set.");
            }
            if ((this.NU & 4) != 0 && this.Ob < 0) {
                throw new IllegalArgumentException("Non-negative loitering delay needs to be set when transition types include GEOFENCE_TRANSITION_DWELLING.");
            }
            if (this.NV == Long.MIN_VALUE) {
                throw new IllegalArgumentException("Expiration not set.");
            }
            if (this.NW == -1) {
                throw new IllegalArgumentException("Geofence region not set.");
            }
            if (this.Oa < 0) {
                throw new IllegalArgumentException("Notification responsiveness should be nonnegative.");
            }
            return new hd(this.Jo, this.NU, 1, this.NX, this.NY, this.NZ, this.NV, this.Oa, this.Ob);
        }
    }
}

