/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.content.Intent;
import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.internal.fq;
import com.google.android.gms.location.ActivityRecognitionResultCreator;
import com.google.android.gms.location.DetectedActivity;
import java.util.Collections;
import java.util.List;

public class ActivityRecognitionResult
implements SafeParcelable {
    public static final String EXTRA_ACTIVITY_RESULT = "com.google.android.location.internal.EXTRA_ACTIVITY_RESULT";
    public static final ActivityRecognitionResultCreator CREATOR = new ActivityRecognitionResultCreator();
    private final int xH;
    List<DetectedActivity> NP;
    long NQ;
    long NR;

    public ActivityRecognitionResult(List<DetectedActivity> probableActivities, long time, long elapsedRealtimeMillis) {
        fq.b(probableActivities != null && probableActivities.size() > 0, (Object)"Must have at least 1 detected activity");
        this.xH = 1;
        this.NP = probableActivities;
        this.NQ = time;
        this.NR = elapsedRealtimeMillis;
    }

    public ActivityRecognitionResult(DetectedActivity mostProbableActivity, long time, long elapsedRealtimeMillis) {
        this(Collections.singletonList(mostProbableActivity), time, elapsedRealtimeMillis);
    }

    public static boolean hasResult(Intent intent) {
        if (intent == null) {
            return false;
        }
        return intent.hasExtra(EXTRA_ACTIVITY_RESULT);
    }

    public static ActivityRecognitionResult extractResult(Intent intent) {
        if (!ActivityRecognitionResult.hasResult(intent)) {
            return null;
        }
        return (ActivityRecognitionResult)intent.getExtras().get(EXTRA_ACTIVITY_RESULT);
    }

    public DetectedActivity getMostProbableActivity() {
        return this.NP.get(0);
    }

    public int getActivityConfidence(int activityType) {
        for (DetectedActivity detectedActivity : this.NP) {
            if (detectedActivity.getType() != activityType) continue;
            return detectedActivity.getConfidence();
        }
        return 0;
    }

    public List<DetectedActivity> getProbableActivities() {
        return this.NP;
    }

    public long getTime() {
        return this.NQ;
    }

    public long getElapsedRealtimeMillis() {
        return this.NR;
    }

    public String toString() {
        return "ActivityRecognitionResult [probableActivities=" + this.NP + ", timeMillis=" + this.NQ + ", elapsedRealtimeMillis=" + this.NR + "]";
    }

    public ActivityRecognitionResult(int versionCode, List<DetectedActivity> probableActivities, long timeMillis, long elapsedRealtimeMillis) {
        this.xH = 1;
        this.NP = probableActivities;
        this.NQ = timeMillis;
        this.NR = elapsedRealtimeMillis;
    }

    public int getVersionCode() {
        return this.xH;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        ActivityRecognitionResultCreator.a(this, out, flags);
    }
}

