/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GooglePlayServicesClient;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.internal.fg;
import com.google.android.gms.internal.fh;
import com.google.android.gms.internal.fl;
import com.google.android.gms.internal.fm;
import com.google.android.gms.internal.fq;
import java.util.ArrayList;

public abstract class ff<T extends IInterface>
implements GooglePlayServicesClient,
Api.a,
fg.b {
    private final Context mContext;
    private final Looper AS;
    final Handler mHandler;
    private T Da;
    private final ArrayList<b<?>> Db = new ArrayList();
    private f Dc;
    private volatile int Dd = 1;
    private final String[] De;
    boolean Df = false;
    private final fg Bc;
    public static final String[] Dg = new String[]{"service_esmobile", "service_googleme"};

    protected ff(Context context, Looper looper, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener, String ... stringArray) {
        this.mContext = fq.f(context);
        this.AS = fq.b(looper, (Object)"Looper must not be null");
        this.Bc = new fg(context, looper, this);
        this.mHandler = new a(looper);
        this.b(stringArray);
        this.De = stringArray;
        this.registerConnectionCallbacks(fq.f(connectionCallbacks));
        this.registerConnectionFailedListener(fq.f(onConnectionFailedListener));
    }

    protected ff(Context context, GooglePlayServicesClient.ConnectionCallbacks connectionCallbacks, GooglePlayServicesClient.OnConnectionFailedListener onConnectionFailedListener, String ... stringArray) {
        this(context, context.getMainLooper(), new c(connectionCallbacks), new g(onConnectionFailedListener), stringArray);
    }

    protected void b(String ... stringArray) {
    }

    protected abstract String bg();

    protected abstract String bh();

    protected abstract T r(IBinder var1);

    private void M(int n2) {
        int n3 = this.Dd;
        this.Dd = n2;
        if (n3 != n2) {
            if (n2 == 3) {
                this.onConnected();
            } else if (n3 == 3 && n2 == 1) {
                this.onDisconnected();
            }
        }
    }

    protected void onConnected() {
    }

    protected void onDisconnected() {
    }

    @Override
    public void connect() {
        this.Df = true;
        this.M(2);
        int n2 = GooglePlayServicesUtil.isGooglePlayServicesAvailable(this.mContext);
        if (n2 != 0) {
            this.M(1);
            this.mHandler.sendMessage(this.mHandler.obtainMessage(3, (Object)n2));
            return;
        }
        if (this.Dc != null) {
            Log.e((String)"GmsClient", (String)"Calling connect() while still connected, missing disconnect().");
            this.Da = null;
            fh.x(this.mContext).b(this.bg(), this.Dc);
        }
        this.Dc = new f();
        boolean bl2 = fh.x(this.mContext).a(this.bg(), this.Dc);
        if (!bl2) {
            Log.e((String)"GmsClient", (String)("unable to connect to service: " + this.bg()));
            this.mHandler.sendMessage(this.mHandler.obtainMessage(3, (Object)9));
            return;
        }
    }

    @Override
    public boolean isConnected() {
        return this.Dd == 3;
    }

    @Override
    public boolean isConnecting() {
        return this.Dd == 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect() {
        this.Df = false;
        ArrayList<b<?>> arrayList = this.Db;
        synchronized (arrayList) {
            int n2 = this.Db.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                this.Db.get(i2).eO();
            }
            this.Db.clear();
        }
        this.M(1);
        this.Da = null;
        if (this.Dc != null) {
            fh.x(this.mContext).b(this.bg(), this.Dc);
            this.Dc = null;
        }
    }

    public void N(int n2) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(4, (Object)n2));
    }

    public final Context getContext() {
        return this.mContext;
    }

    @Override
    public final Looper getLooper() {
        return this.AS;
    }

    public final String[] eL() {
        return this.De;
    }

    protected final void z(IBinder iBinder) {
        try {
            fm fm2 = fm.a.C(iBinder);
            this.a(fm2, new e(this));
        }
        catch (RemoteException remoteException) {
            Log.w((String)"GmsClient", (String)"service died");
        }
    }

    protected abstract void a(fm var1, e var2) throws RemoteException;

    protected void a(int n2, IBinder iBinder, Bundle bundle) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(1, (Object)new h(n2, iBinder, bundle)));
    }

    protected final void bT() {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected. Call connect() and wait for onConnected() to be called.");
        }
    }

    @Override
    public Bundle dG() {
        return null;
    }

    protected final T eM() {
        this.bT();
        return this.Da;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void a(b<?> b2) {
        ArrayList<b<?>> arrayList = this.Db;
        synchronized (arrayList) {
            this.Db.add(b2);
        }
        this.mHandler.sendMessage(this.mHandler.obtainMessage(2, b2));
    }

    @Override
    public boolean em() {
        return this.Df;
    }

    public void registerConnectionCallbacks(GoogleApiClient.ConnectionCallbacks listener) {
        this.Bc.registerConnectionCallbacks(listener);
    }

    public void registerConnectionFailedListener(GoogleApiClient.OnConnectionFailedListener listener) {
        this.Bc.registerConnectionFailedListener(listener);
    }

    @Override
    public void registerConnectionCallbacks(GooglePlayServicesClient.ConnectionCallbacks listener) {
        this.Bc.registerConnectionCallbacks(new c(listener));
    }

    @Override
    public boolean isConnectionCallbacksRegistered(GooglePlayServicesClient.ConnectionCallbacks listener) {
        return this.Bc.isConnectionCallbacksRegistered(new c(listener));
    }

    @Override
    public void unregisterConnectionCallbacks(GooglePlayServicesClient.ConnectionCallbacks listener) {
        this.Bc.unregisterConnectionCallbacks(new c(listener));
    }

    @Override
    public void registerConnectionFailedListener(GooglePlayServicesClient.OnConnectionFailedListener listener) {
        this.Bc.registerConnectionFailedListener(listener);
    }

    @Override
    public boolean isConnectionFailedListenerRegistered(GooglePlayServicesClient.OnConnectionFailedListener listener) {
        return this.Bc.isConnectionFailedListenerRegistered(listener);
    }

    @Override
    public void unregisterConnectionFailedListener(GooglePlayServicesClient.OnConnectionFailedListener listener) {
        this.Bc.unregisterConnectionFailedListener(listener);
    }

    public static final class e
    extends fl.a {
        private ff Dk;

        public e(ff ff2) {
            this.Dk = ff2;
        }

        @Override
        public void b(int n2, IBinder iBinder, Bundle bundle) {
            fq.b("onPostInitComplete can be called only once per call to getServiceFromBroker", (Object)this.Dk);
            this.Dk.a(n2, iBinder, bundle);
            this.Dk = null;
        }
    }

    protected final class h
    extends b<Boolean> {
        public final int statusCode;
        public final Bundle Dm;
        public final IBinder Dn;

        public h(int n2, IBinder iBinder, Bundle bundle) {
            super(true);
            this.statusCode = n2;
            this.Dn = iBinder;
            this.Dm = bundle;
        }

        protected void b(Boolean bl2) {
            if (bl2 == null) {
                ff.this.M(1);
                return;
            }
            switch (this.statusCode) {
                case 0: {
                    String string2 = null;
                    try {
                        string2 = this.Dn.getInterfaceDescriptor();
                        if (ff.this.bh().equals(string2)) {
                            ff.this.Da = ff.this.r(this.Dn);
                            if (ff.this.Da != null) {
                                ff.this.M(3);
                                ff.this.Bc.bV();
                                return;
                            }
                        }
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                    fh.x(ff.this.mContext).b(ff.this.bg(), ff.this.Dc);
                    ff.this.Dc = null;
                    ff.this.M(1);
                    ff.this.Da = null;
                    ff.this.Bc.a(new ConnectionResult(8, null));
                    break;
                }
                case 10: {
                    ff.this.M(1);
                    throw new IllegalStateException("A fatal developer error has occurred. Check the logs for further information.");
                }
                default: {
                    PendingIntent pendingIntent = null;
                    if (this.Dm != null) {
                        pendingIntent = (PendingIntent)this.Dm.getParcelable("pendingIntent");
                    }
                    if (ff.this.Dc != null) {
                        fh.x(ff.this.mContext).b(ff.this.bg(), ff.this.Dc);
                        ff.this.Dc = null;
                    }
                    ff.this.M(1);
                    ff.this.Da = null;
                    ff.this.Bc.a(new ConnectionResult(this.statusCode, pendingIntent));
                }
            }
        }

        @Override
        protected void dx() {
        }

        @Override
        protected /* synthetic */ void a(Object object) {
            this.b((Boolean)object);
        }
    }

    public static final class g
    implements GoogleApiClient.OnConnectionFailedListener {
        private final GooglePlayServicesClient.OnConnectionFailedListener Dl;

        public g(GooglePlayServicesClient.OnConnectionFailedListener onConnectionFailedListener) {
            this.Dl = onConnectionFailedListener;
        }

        @Override
        public void onConnectionFailed(ConnectionResult result) {
            this.Dl.onConnectionFailed(result);
        }

        public boolean equals(Object other) {
            if (other instanceof g) {
                return this.Dl.equals(((g)other).Dl);
            }
            return this.Dl.equals(other);
        }
    }

    public static final class c
    implements GoogleApiClient.ConnectionCallbacks {
        private final GooglePlayServicesClient.ConnectionCallbacks Dj;

        public c(GooglePlayServicesClient.ConnectionCallbacks connectionCallbacks) {
            this.Dj = connectionCallbacks;
        }

        @Override
        public void onConnected(Bundle connectionHint) {
            this.Dj.onConnected(connectionHint);
        }

        @Override
        public void onConnectionSuspended(int cause) {
            this.Dj.onDisconnected();
        }

        public boolean equals(Object other) {
            if (other instanceof c) {
                return this.Dj.equals(((c)other).Dj);
            }
            return this.Dj.equals(other);
        }
    }

    public abstract class d<TListener>
    extends b<TListener> {
        private final DataHolder BB;

        public d(TListener TListener, DataHolder dataHolder) {
            super(TListener);
            this.BB = dataHolder;
        }

        @Override
        protected final void a(TListener TListener) {
            this.a(TListener, this.BB);
        }

        protected abstract void a(TListener var1, DataHolder var2);

        @Override
        protected void dx() {
            if (this.BB != null) {
                this.BB.close();
            }
        }
    }

    protected abstract class b<TListener> {
        private TListener mListener;
        private boolean Di;

        public b(TListener TListener) {
            this.mListener = TListener;
            this.Di = false;
        }

        protected abstract void a(TListener var1);

        protected abstract void dx();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void eN() {
            TListener TListener;
            b b2 = this;
            synchronized (b2) {
                TListener = this.mListener;
                if (this.Di) {
                    Log.w((String)"GmsClient", (String)("Callback proxy " + this + " being reused. This is not safe."));
                }
            }
            if (TListener != null) {
                try {
                    this.a(TListener);
                }
                catch (RuntimeException runtimeException) {
                    this.dx();
                    throw runtimeException;
                }
            } else {
                this.dx();
            }
            b2 = this;
            synchronized (b2) {
                this.Di = true;
            }
            this.unregister();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unregister() {
            this.eO();
            ArrayList arrayList = ff.this.Db;
            synchronized (arrayList) {
                ff.this.Db.remove(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void eO() {
            b b2 = this;
            synchronized (b2) {
                this.mListener = null;
            }
        }
    }

    final class a
    extends Handler {
        public a(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message msg) {
            if (msg.what == 1 && !ff.this.isConnecting()) {
                b b2 = (b)msg.obj;
                b2.dx();
                b2.unregister();
                return;
            }
            if (msg.what == 3) {
                ff.this.Bc.a(new ConnectionResult((Integer)msg.obj, null));
                return;
            }
            if (msg.what == 4) {
                ff.this.M(1);
                ff.this.Da = null;
                ff.this.Bc.O((Integer)msg.obj);
                return;
            }
            if (msg.what == 2 && !ff.this.isConnected()) {
                b b3 = (b)msg.obj;
                b3.dx();
                b3.unregister();
                return;
            }
            if (msg.what == 2 || msg.what == 1) {
                b b4 = (b)msg.obj;
                b4.eN();
                return;
            }
            Log.wtf((String)"GmsClient", (String)"Don't know how to handle this message.");
        }
    }

    final class f
    implements ServiceConnection {
        f() {
        }

        public void onServiceConnected(ComponentName component, IBinder binder) {
            ff.this.z(binder);
        }

        public void onServiceDisconnected(ComponentName component) {
            ff.this.mHandler.sendMessage(ff.this.mHandler.obtainMessage(4, (Object)1));
        }
    }
}

