/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.SystemClock;
import com.google.android.gms.internal.gr;

public final class ex
extends Drawable
implements Drawable.Callback {
    private int Cv = 0;
    private long Cw;
    private int Cx;
    private int Cy;
    private int Cz = 255;
    private int CA;
    private int CB = 0;
    private boolean Cp = true;
    private boolean CC;
    private b CD;
    private Drawable CE;
    private Drawable CF;
    private boolean CG;
    private boolean CH;
    private boolean CI;
    private int CJ;

    public ex(Drawable drawable2, Drawable drawable3) {
        this(null);
        if (drawable2 == null) {
            drawable2 = a.CK;
        }
        this.CE = drawable2;
        drawable2.setCallback((Drawable.Callback)this);
        this.CD.CN |= drawable2.getChangingConfigurations();
        if (drawable3 == null) {
            drawable3 = a.CK;
        }
        this.CF = drawable3;
        drawable3.setCallback((Drawable.Callback)this);
        this.CD.CN |= drawable3.getChangingConfigurations();
    }

    ex(b b2) {
        this.CD = new b(b2);
    }

    public void invalidateDrawable(Drawable who) {
        Drawable.Callback callback;
        if (gr.fu() && (callback = this.getCallback()) != null) {
            callback.invalidateDrawable((Drawable)this);
        }
    }

    public void scheduleDrawable(Drawable who, Runnable what, long when) {
        Drawable.Callback callback;
        if (gr.fu() && (callback = this.getCallback()) != null) {
            callback.scheduleDrawable((Drawable)this, what, when);
        }
    }

    public void unscheduleDrawable(Drawable who, Runnable what) {
        Drawable.Callback callback;
        if (gr.fu() && (callback = this.getCallback()) != null) {
            callback.unscheduleDrawable((Drawable)this, what);
        }
    }

    public int getChangingConfigurations() {
        return super.getChangingConfigurations() | this.CD.CM | this.CD.CN;
    }

    public void setAlpha(int alpha) {
        if (this.CB == this.Cz) {
            this.CB = alpha;
        }
        this.Cz = alpha;
        this.invalidateSelf();
    }

    public void setColorFilter(ColorFilter cf2) {
        this.CE.setColorFilter(cf2);
        this.CF.setColorFilter(cf2);
    }

    public int getIntrinsicWidth() {
        return Math.max(this.CE.getIntrinsicWidth(), this.CF.getIntrinsicWidth());
    }

    public int getIntrinsicHeight() {
        return Math.max(this.CE.getIntrinsicHeight(), this.CF.getIntrinsicHeight());
    }

    protected void onBoundsChange(Rect bounds) {
        this.CE.setBounds(bounds);
        this.CF.setBounds(bounds);
    }

    public Drawable.ConstantState getConstantState() {
        if (this.canConstantState()) {
            this.CD.CM = this.getChangingConfigurations();
            return this.CD;
        }
        return null;
    }

    public int getOpacity() {
        if (!this.CI) {
            this.CJ = Drawable.resolveOpacity((int)this.CE.getOpacity(), (int)this.CF.getOpacity());
            this.CI = true;
        }
        return this.CJ;
    }

    public boolean canConstantState() {
        if (!this.CG) {
            this.CH = this.CE.getConstantState() != null && this.CF.getConstantState() != null;
            this.CG = true;
        }
        return this.CH;
    }

    public Drawable mutate() {
        if (!this.CC && super.mutate() == this) {
            if (!this.canConstantState()) {
                throw new IllegalStateException("One or more children of this LayerDrawable does not have constant state; this drawable cannot be mutated.");
            }
            this.CE.mutate();
            this.CF.mutate();
            this.CC = true;
        }
        return this;
    }

    public Drawable ez() {
        return this.CF;
    }

    public void startTransition(int durationMillis) {
        this.Cx = 0;
        this.Cy = this.Cz;
        this.CB = 0;
        this.CA = durationMillis;
        this.Cv = 1;
        this.invalidateSelf();
    }

    public void draw(Canvas canvas) {
        boolean bl2 = true;
        switch (this.Cv) {
            case 1: {
                this.Cw = SystemClock.uptimeMillis();
                bl2 = false;
                this.Cv = 2;
                break;
            }
            case 2: {
                if (this.Cw < 0L) break;
                float f2 = (float)(SystemClock.uptimeMillis() - this.Cw) / (float)this.CA;
                boolean bl3 = bl2 = f2 >= 1.0f;
                if (bl2) {
                    this.Cv = 0;
                }
                f2 = Math.min(f2, 1.0f);
                this.CB = (int)((float)this.Cx + (float)(this.Cy - this.Cx) * f2);
            }
        }
        int n2 = this.CB;
        boolean bl4 = this.Cp;
        Drawable drawable2 = this.CE;
        Drawable drawable3 = this.CF;
        if (bl2) {
            if (!bl4 || n2 == 0) {
                drawable2.draw(canvas);
            }
            if (n2 == this.Cz) {
                drawable3.setAlpha(this.Cz);
                drawable3.draw(canvas);
            }
            return;
        }
        if (bl4) {
            drawable2.setAlpha(this.Cz - n2);
        }
        drawable2.draw(canvas);
        if (bl4) {
            drawable2.setAlpha(this.Cz);
        }
        if (n2 > 0) {
            drawable3.setAlpha(n2);
            drawable3.draw(canvas);
            drawable3.setAlpha(this.Cz);
        }
        this.invalidateSelf();
    }

    private static final class com.google.android.gms.internal.ex$a
    extends Drawable {
        private static final com.google.android.gms.internal.ex$a CK = new com.google.android.gms.internal.ex$a();
        private static final a CL = new a();

        private com.google.android.gms.internal.ex$a() {
        }

        public void draw(Canvas canvas) {
        }

        public void setAlpha(int alpha) {
        }

        public void setColorFilter(ColorFilter cf2) {
        }

        public int getOpacity() {
            return -2;
        }

        public Drawable.ConstantState getConstantState() {
            return CL;
        }

        private static final class a
        extends Drawable.ConstantState {
            private a() {
            }

            public Drawable newDrawable() {
                return CK;
            }

            public int getChangingConfigurations() {
                return 0;
            }
        }
    }

    static final class b
    extends Drawable.ConstantState {
        int CM;
        int CN;

        b(b b2) {
            if (b2 != null) {
                this.CM = b2.CM;
                this.CN = b2.CN;
            }
        }

        public Drawable newDrawable() {
            return new ex(this);
        }

        public int getChangingConfigurations() {
            return this.CM;
        }
    }
}

