/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.MediaStatus;
import com.google.android.gms.internal.em;
import com.google.android.gms.internal.eo;
import com.google.android.gms.internal.eu;
import com.google.android.gms.internal.ev;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class es
extends em {
    private static final String NAMESPACE = eo.X("com.google.cast.media");
    private static final long zG = TimeUnit.HOURS.toMillis(24L);
    private static final long zH = TimeUnit.HOURS.toMillis(24L);
    private static final long zI = TimeUnit.HOURS.toMillis(24L);
    private static final long zJ = TimeUnit.SECONDS.toMillis(1L);
    private long zK;
    private MediaStatus zL;
    private final Handler mHandler = new Handler(Looper.getMainLooper());
    private final ev zM;
    private final ev zN;
    private final ev zO;
    private final ev zP;
    private final ev zQ;
    private final ev zR;
    private final ev zS;
    private final ev zT;
    private final Runnable zU = new a();
    private boolean zV;

    public es() {
        this(null);
    }

    public es(String string2) {
        super(NAMESPACE, "MediaControlChannel", string2);
        this.zM = new ev(zH);
        this.zN = new ev(zG);
        this.zO = new ev(zG);
        this.zP = new ev(zG);
        this.zQ = new ev(zI);
        this.zR = new ev(zG);
        this.zS = new ev(zG);
        this.zT = new ev(zG);
        this.dS();
    }

    public long a(eu eu2, MediaInfo mediaInfo, boolean bl2, long l2, JSONObject jSONObject) throws IOException {
        JSONObject jSONObject2 = new JSONObject();
        long l3 = this.dE();
        this.zM.a(l3, eu2);
        this.w(true);
        try {
            jSONObject2.put("requestId", l3);
            jSONObject2.put("type", (Object)"LOAD");
            jSONObject2.put("media", (Object)mediaInfo.dB());
            jSONObject2.put("autoplay", bl2);
            jSONObject2.put("currentTime", eo.m(l2));
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.a(jSONObject2.toString(), l3, null);
        return l3;
    }

    public long a(eu eu2, JSONObject jSONObject) throws IOException {
        JSONObject jSONObject2 = new JSONObject();
        long l2 = this.dE();
        this.zN.a(l2, eu2);
        this.w(true);
        try {
            jSONObject2.put("requestId", l2);
            jSONObject2.put("type", (Object)"PAUSE");
            jSONObject2.put("mediaSessionId", this.dC());
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.a(jSONObject2.toString(), l2, null);
        return l2;
    }

    public long b(eu eu2, JSONObject jSONObject) throws IOException {
        JSONObject jSONObject2 = new JSONObject();
        long l2 = this.dE();
        this.zP.a(l2, eu2);
        this.w(true);
        try {
            jSONObject2.put("requestId", l2);
            jSONObject2.put("type", (Object)"STOP");
            jSONObject2.put("mediaSessionId", this.dC());
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.a(jSONObject2.toString(), l2, null);
        return l2;
    }

    public long c(eu eu2, JSONObject jSONObject) throws IOException, IllegalStateException {
        JSONObject jSONObject2 = new JSONObject();
        long l2 = this.dE();
        this.zO.a(l2, eu2);
        this.w(true);
        try {
            jSONObject2.put("requestId", l2);
            jSONObject2.put("type", (Object)"PLAY");
            jSONObject2.put("mediaSessionId", this.dC());
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.a(jSONObject2.toString(), l2, null);
        return l2;
    }

    public long a(eu eu2, long l2, int n2, JSONObject jSONObject) throws IOException, IllegalStateException {
        JSONObject jSONObject2 = new JSONObject();
        long l3 = this.dE();
        this.zQ.a(l3, eu2);
        this.w(true);
        try {
            jSONObject2.put("requestId", l3);
            jSONObject2.put("type", (Object)"SEEK");
            jSONObject2.put("mediaSessionId", this.dC());
            jSONObject2.put("currentTime", eo.m(l2));
            if (n2 == 1) {
                jSONObject2.put("resumeState", (Object)"PLAYBACK_START");
            } else if (n2 == 2) {
                jSONObject2.put("resumeState", (Object)"PLAYBACK_PAUSE");
            }
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.a(jSONObject2.toString(), l3, null);
        return l3;
    }

    public long a(eu eu2, double d2, JSONObject jSONObject) throws IOException, IllegalStateException, IllegalArgumentException {
        if (Double.isInfinite(d2) || Double.isNaN(d2)) {
            throw new IllegalArgumentException("Volume cannot be " + d2);
        }
        JSONObject jSONObject2 = new JSONObject();
        long l2 = this.dE();
        this.zR.a(l2, eu2);
        this.w(true);
        try {
            jSONObject2.put("requestId", l2);
            jSONObject2.put("type", (Object)"SET_VOLUME");
            jSONObject2.put("mediaSessionId", this.dC());
            JSONObject jSONObject3 = new JSONObject();
            jSONObject3.put("level", d2);
            jSONObject2.put("volume", (Object)jSONObject3);
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.a(jSONObject2.toString(), l2, null);
        return l2;
    }

    public long a(eu eu2, boolean bl2, JSONObject jSONObject) throws IOException, IllegalStateException {
        JSONObject jSONObject2 = new JSONObject();
        long l2 = this.dE();
        this.zS.a(l2, eu2);
        this.w(true);
        try {
            jSONObject2.put("requestId", l2);
            jSONObject2.put("type", (Object)"SET_VOLUME");
            jSONObject2.put("mediaSessionId", this.dC());
            JSONObject jSONObject3 = new JSONObject();
            jSONObject3.put("muted", bl2);
            jSONObject2.put("volume", (Object)jSONObject3);
            if (jSONObject != null) {
                jSONObject2.put("customData", (Object)jSONObject);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.a(jSONObject2.toString(), l2, null);
        return l2;
    }

    public long a(eu eu2) throws IOException {
        JSONObject jSONObject = new JSONObject();
        long l2 = this.dE();
        this.zT.a(l2, eu2);
        this.w(true);
        try {
            jSONObject.put("requestId", l2);
            jSONObject.put("type", (Object)"GET_STATUS");
            if (this.zL != null) {
                jSONObject.put("mediaSessionId", this.zL.dC());
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.a(jSONObject.toString(), l2, null);
        return l2;
    }

    public long getApproximateStreamPosition() {
        MediaInfo mediaInfo = this.getMediaInfo();
        if (mediaInfo == null) {
            return 0L;
        }
        if (this.zK == 0L) {
            return 0L;
        }
        double d2 = this.zL.getPlaybackRate();
        long l2 = this.zL.getStreamPosition();
        int n2 = this.zL.getPlayerState();
        if (d2 == 0.0 || n2 != 2) {
            return l2;
        }
        long l3 = SystemClock.elapsedRealtime() - this.zK;
        if (l3 < 0L) {
            l3 = 0L;
        }
        if (l3 == 0L) {
            return l2;
        }
        long l4 = l2 + (long)((double)l3 * d2);
        long l5 = mediaInfo.getStreamDuration();
        if (l4 > l5) {
            l4 = l5;
        } else if (l4 < 0L) {
            l4 = 0L;
        }
        return l4;
    }

    public long getStreamDuration() {
        MediaInfo mediaInfo = this.getMediaInfo();
        return mediaInfo != null ? mediaInfo.getStreamDuration() : 0L;
    }

    public MediaStatus getMediaStatus() {
        return this.zL;
    }

    public MediaInfo getMediaInfo() {
        return this.zL == null ? null : this.zL.getMediaInfo();
    }

    @Override
    public final void U(String string2) {
        this.yY.b("message received: %s", string2);
        try {
            JSONObject jSONObject = new JSONObject(string2);
            String string3 = jSONObject.getString("type");
            long l2 = jSONObject.optLong("requestId", -1L);
            if (string3.equals("MEDIA_STATUS")) {
                JSONArray jSONArray = jSONObject.getJSONArray("status");
                if (jSONArray.length() > 0) {
                    this.a(l2, jSONArray.getJSONObject(0));
                } else {
                    this.zL = null;
                    this.onStatusUpdated();
                    this.onMetadataUpdated();
                    this.zT.c(l2, 0);
                }
            } else if (string3.equals("INVALID_PLAYER_STATE")) {
                this.yY.d("received unexpected error: Invalid Player State.", new Object[0]);
                JSONObject jSONObject2 = jSONObject.optJSONObject("customData");
                this.zM.b(l2, 1, jSONObject2);
                this.zN.b(l2, 1, jSONObject2);
                this.zO.b(l2, 1, jSONObject2);
                this.zP.b(l2, 1, jSONObject2);
                this.zQ.b(l2, 1, jSONObject2);
                this.zR.b(l2, 1, jSONObject2);
                this.zS.b(l2, 1, jSONObject2);
                this.zT.b(l2, 1, jSONObject2);
            } else if (string3.equals("LOAD_FAILED")) {
                JSONObject jSONObject3 = jSONObject.optJSONObject("customData");
                this.zM.b(l2, 1, jSONObject3);
            } else if (string3.equals("LOAD_CANCELLED")) {
                JSONObject jSONObject4 = jSONObject.optJSONObject("customData");
                this.zM.b(l2, 2, jSONObject4);
            } else if (string3.equals("INVALID_REQUEST")) {
                this.yY.d("received unexpected error: Invalid Request.", new Object[0]);
                JSONObject jSONObject5 = jSONObject.optJSONObject("customData");
                this.zM.b(l2, 1, jSONObject5);
                this.zN.b(l2, 1, jSONObject5);
                this.zO.b(l2, 1, jSONObject5);
                this.zP.b(l2, 1, jSONObject5);
                this.zQ.b(l2, 1, jSONObject5);
                this.zR.b(l2, 1, jSONObject5);
                this.zS.b(l2, 1, jSONObject5);
                this.zT.b(l2, 1, jSONObject5);
            }
        }
        catch (JSONException jSONException) {
            this.yY.d("Message is malformed (%s); ignoring: %s", jSONException.getMessage(), string2);
        }
    }

    @Override
    public void a(long l2, int n2) {
        this.zM.c(l2, n2);
        this.zN.c(l2, n2);
        this.zO.c(l2, n2);
        this.zP.c(l2, n2);
        this.zQ.c(l2, n2);
        this.zR.c(l2, n2);
        this.zS.c(l2, n2);
        this.zT.c(l2, n2);
    }

    private void a(long l2, JSONObject jSONObject) throws JSONException {
        boolean bl2 = this.zM.n(l2);
        boolean bl3 = this.zQ.dU() && !this.zQ.n(l2);
        boolean bl4 = this.zR.dU() && !this.zR.n(l2) || this.zS.dU() && !this.zS.n(l2);
        int n2 = 0;
        if (bl3) {
            n2 |= 2;
        }
        if (bl4) {
            n2 |= 1;
        }
        int n3 = 0;
        if (bl2 || this.zL == null) {
            this.zL = new MediaStatus(jSONObject);
            this.zK = SystemClock.elapsedRealtime();
            n3 = 7;
        } else {
            n3 = this.zL.a(jSONObject, n2);
        }
        if ((n3 & 1) != 0) {
            this.zK = SystemClock.elapsedRealtime();
            this.onStatusUpdated();
        }
        if ((n3 & 2) != 0) {
            this.zK = SystemClock.elapsedRealtime();
            this.onStatusUpdated();
        }
        if ((n3 & 4) != 0) {
            this.onMetadataUpdated();
        }
        this.zM.c(l2, 0);
        this.zN.c(l2, 0);
        this.zO.c(l2, 0);
        this.zP.c(l2, 0);
        this.zQ.c(l2, 0);
        this.zR.c(l2, 0);
        this.zS.c(l2, 0);
        this.zT.c(l2, 0);
    }

    public long dC() throws IllegalStateException {
        if (this.zL == null) {
            throw new IllegalStateException("No current media session");
        }
        return this.zL.dC();
    }

    protected void onStatusUpdated() {
    }

    protected void onMetadataUpdated() {
    }

    private void dS() {
        this.w(false);
        this.zK = 0L;
        this.zL = null;
        this.zM.clear();
        this.zQ.clear();
        this.zR.clear();
    }

    @Override
    public void dF() {
        this.dS();
    }

    private void w(boolean bl2) {
        if (this.zV != bl2) {
            this.zV = bl2;
            if (bl2) {
                this.mHandler.postDelayed(this.zU, zJ);
            } else {
                this.mHandler.removeCallbacks(this.zU);
            }
        }
    }

    private class a
    implements Runnable {
        private a() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            es.this.zV = false;
            long l2 = SystemClock.elapsedRealtime();
            es.this.zM.d(l2, 3);
            es.this.zN.d(l2, 3);
            es.this.zO.d(l2, 3);
            es.this.zP.d(l2, 3);
            es.this.zQ.d(l2, 3);
            es.this.zR.d(l2, 3);
            es.this.zS.d(l2, 3);
            es.this.zT.d(l2, 3);
            boolean bl2 = false;
            Object object = ev.Ab;
            synchronized (object) {
                bl2 = es.this.zM.dU() || es.this.zQ.dU() || es.this.zR.dU() || es.this.zS.dU() || es.this.zT.dU();
            }
            es.this.w(bl2);
        }
    }
}

