/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.MutableContextWrapper;
import android.net.Uri;
import android.os.Build;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.MotionEvent;
import android.view.View;
import android.view.WindowManager;
import android.webkit.DownloadListener;
import android.webkit.WebSettings;
import android.webkit.WebView;
import com.google.android.gms.internal.ak;
import com.google.android.gms.internal.cc;
import com.google.android.gms.internal.dq;
import com.google.android.gms.internal.ds;
import com.google.android.gms.internal.dt;
import com.google.android.gms.internal.dw;
import com.google.android.gms.internal.dx;
import com.google.android.gms.internal.ea;
import com.google.android.gms.internal.eb;
import com.google.android.gms.internal.ec;
import com.google.android.gms.internal.ed;
import com.google.android.gms.internal.l;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class dz
extends WebView
implements DownloadListener {
    private final ea ru;
    private final a rv;
    private final Object li = new Object();
    private final l oJ;
    private final dx nr;
    private cc rw;
    private ak nq;
    private boolean rx;
    private boolean ry;
    private final WindowManager ls;

    public static dz a(Context context, ak ak2, boolean bl2, boolean bl3, l l2, dx dx2) {
        a a2 = new a(context);
        return new dz(a2, ak2, bl2, bl3, l2, dx2);
    }

    private dz(a a2, ak ak2, boolean bl2, boolean bl3, l l2, dx dx2) {
        super((Context)a2);
        this.rv = a2;
        this.nq = ak2;
        this.rx = bl2;
        this.oJ = l2;
        this.nr = dx2;
        this.ls = (WindowManager)this.getContext().getSystemService("window");
        this.setBackgroundColor(0);
        WebSettings webSettings = this.getSettings();
        webSettings.setJavaScriptEnabled(true);
        webSettings.setSavePassword(false);
        webSettings.setSupportMultipleWindows(true);
        webSettings.setJavaScriptCanOpenWindowsAutomatically(true);
        dq.a((Context)a2, dx2.rq, webSettings);
        if (Build.VERSION.SDK_INT >= 17) {
            dt.a(this.getContext(), webSettings);
        } else if (Build.VERSION.SDK_INT >= 11) {
            ds.a(this.getContext(), webSettings);
        }
        this.setDownloadListener(this);
        this.ru = Build.VERSION.SDK_INT >= 11 ? new ec(this, bl3) : new ea(this, bl3);
        this.setWebViewClient(this.ru);
        if (Build.VERSION.SDK_INT >= 14) {
            this.setWebChromeClient(new ed(this));
        } else if (Build.VERSION.SDK_INT >= 11) {
            this.setWebChromeClient(new eb(this));
        }
        this.bM();
    }

    public void bE() {
        if (!this.bI().bP()) {
            return;
        }
        DisplayMetrics displayMetrics = new DisplayMetrics();
        Display display = this.ls.getDefaultDisplay();
        display.getMetrics(displayMetrics);
        try {
            JSONObject jSONObject = new JSONObject().put("width", displayMetrics.widthPixels).put("height", displayMetrics.heightPixels).put("density", (double)displayMetrics.density).put("rotation", display.getRotation());
            this.b("onScreenInfoChanged", jSONObject);
        }
        catch (JSONException jSONException) {
            dw.b("Error occured while obtaining screen information.", jSONException);
        }
    }

    public void a(String string2, Map<String, ?> map) {
        JSONObject jSONObject;
        try {
            jSONObject = dq.p(map);
        }
        catch (JSONException jSONException) {
            dw.z("Could not convert parameters to JSON.");
            return;
        }
        this.b(string2, jSONObject);
    }

    public void a(String string2, JSONObject jSONObject) {
        if (jSONObject == null) {
            jSONObject = new JSONObject();
        }
        String string3 = jSONObject.toString();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("javascript:" + string2 + "(");
        stringBuilder.append(string3);
        stringBuilder.append(");");
        this.loadUrl(stringBuilder.toString());
    }

    public void b(String string2, JSONObject jSONObject) {
        if (jSONObject == null) {
            jSONObject = new JSONObject();
        }
        String string3 = jSONObject.toString();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("javascript:AFMA_ReceiveMessage('");
        stringBuilder.append(string2);
        stringBuilder.append("'");
        stringBuilder.append(",");
        stringBuilder.append(string3);
        stringBuilder.append(");");
        dw.y("Dispatching AFMA event: " + stringBuilder);
        this.loadUrl(stringBuilder.toString());
    }

    public void bF() {
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        hashMap.put("version", this.nr.rq);
        this.a("onhide", hashMap);
    }

    public void bG() {
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        hashMap.put("version", this.nr.rq);
        this.a("onshow", hashMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public cc bH() {
        Object object = this.li;
        synchronized (object) {
            return this.rw;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ak R() {
        Object object = this.li;
        synchronized (object) {
            return this.nq;
        }
    }

    public ea bI() {
        return this.ru;
    }

    public l bJ() {
        return this.oJ;
    }

    public dx bK() {
        return this.nr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean bL() {
        Object object = this.li;
        synchronized (object) {
            return this.rx;
        }
    }

    public void onDownloadStart(String url, String userAgent, String contentDisposition, String mimeType, long size) {
        try {
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.setDataAndType(Uri.parse((String)url), mimeType);
            this.getContext().startActivity(intent);
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            dw.v("Couldn't find an Activity to view url/mimetype: " + url + " / " + mimeType);
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.oJ != null) {
            this.oJ.a(event);
        }
        return super.onTouchEvent(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        Object object = this.li;
        synchronized (object) {
            if (this.isInEditMode() || this.rx) {
                super.onMeasure(widthMeasureSpec, heightMeasureSpec);
                return;
            }
            int n2 = View.MeasureSpec.getMode((int)widthMeasureSpec);
            int n3 = View.MeasureSpec.getSize((int)widthMeasureSpec);
            int n4 = View.MeasureSpec.getMode((int)heightMeasureSpec);
            int n5 = View.MeasureSpec.getSize((int)heightMeasureSpec);
            int n6 = Integer.MAX_VALUE;
            if (n2 == Integer.MIN_VALUE || n2 == 0x40000000) {
                n6 = n3;
            }
            int n7 = Integer.MAX_VALUE;
            if (n4 == Integer.MIN_VALUE || n4 == 0x40000000) {
                n7 = n5;
            }
            if (this.nq.widthPixels > n6 || this.nq.heightPixels > n7) {
                dw.z("Not enough space to show ad. Needs " + this.nq.widthPixels + "x" + this.nq.heightPixels + " pixels, but only has " + n3 + "x" + n5 + " pixels.");
                if (this.getVisibility() != 8) {
                    this.setVisibility(4);
                }
                this.setMeasuredDimension(0, 0);
            } else {
                if (this.getVisibility() != 8) {
                    this.setVisibility(0);
                }
                this.setMeasuredDimension(this.nq.widthPixels, this.nq.heightPixels);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void a(Context context, ak ak2) {
        Object object = this.li;
        synchronized (object) {
            this.rv.setBaseContext(context);
            this.rw = null;
            this.nq = ak2;
            this.rx = false;
            dq.b(this);
            this.loadUrl("about:blank");
            this.ru.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void a(cc cc2) {
        Object object = this.li;
        synchronized (object) {
            this.rw = cc2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void a(ak ak2) {
        Object object = this.li;
        synchronized (object) {
            this.nq = ak2;
            this.requestLayout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void p(boolean bl2) {
        Object object = this.li;
        synchronized (object) {
            this.rx = bl2;
            this.bM();
        }
    }

    public void setContext(Context context) {
        this.rv.setBaseContext(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bM() {
        Object object = this.li;
        synchronized (object) {
            if (this.rx || this.nq.lT) {
                if (Build.VERSION.SDK_INT < 14) {
                    dw.v("Disabling hardware acceleration on an overlay.");
                    this.bN();
                } else {
                    dw.v("Enabling hardware acceleration on an overlay.");
                    this.bO();
                }
            } else if (Build.VERSION.SDK_INT < 18) {
                dw.v("Disabling hardware acceleration on an AdView.");
                this.bN();
            } else {
                dw.v("Enabling hardware acceleration on an AdView.");
                this.bO();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bN() {
        Object object = this.li;
        synchronized (object) {
            if (!this.ry && Build.VERSION.SDK_INT >= 11) {
                ds.d((View)this);
            }
            this.ry = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bO() {
        Object object = this.li;
        synchronized (object) {
            if (this.ry && Build.VERSION.SDK_INT >= 11) {
                ds.e((View)this);
            }
            this.ry = false;
        }
    }

    private static class a
    extends MutableContextWrapper {
        private Activity rz;
        private Context lp;

        public a(Context context) {
            super(context);
            this.setBaseContext(context);
        }

        public void setBaseContext(Context base) {
            this.lp = base.getApplicationContext();
            this.rz = base instanceof Activity ? (Activity)base : null;
            super.setBaseContext(this.lp);
        }

        public void startActivity(Intent intent) {
            if (this.rz != null) {
                this.rz.startActivity(intent);
            } else {
                intent.setFlags(0x10000000);
                this.lp.startActivity(intent);
            }
        }
    }
}

