/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.net.UrlQuerySanitizer;
import android.os.Build;
import android.os.Bundle;
import android.webkit.WebSettings;
import android.webkit.WebView;
import com.google.android.gms.internal.ds;
import com.google.android.gms.internal.dt;
import com.google.android.gms.internal.du;
import com.google.android.gms.internal.dv;
import com.google.android.gms.internal.dw;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.nio.CharBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class dq {
    private static final Object px = new Object();
    private static boolean re = true;
    private static String rf;
    private static boolean rg;

    public static void a(Context context, String string2, boolean bl2, HttpURLConnection httpURLConnection) {
        httpURLConnection.setConnectTimeout(60000);
        httpURLConnection.setInstanceFollowRedirects(bl2);
        httpURLConnection.setReadTimeout(60000);
        httpURLConnection.setRequestProperty("User-Agent", dq.b(context, string2));
        httpURLConnection.setUseCaches(false);
    }

    public static boolean h(Context context) {
        Intent intent = new Intent();
        intent.setClassName(context, "com.google.android.gms.ads.AdActivity");
        PackageManager packageManager = context.getPackageManager();
        ResolveInfo resolveInfo = packageManager.resolveActivity(intent, 65536);
        boolean bl2 = true;
        if (resolveInfo == null || resolveInfo.activityInfo == null) {
            dw.z("Could not find com.google.android.gms.ads.AdActivity, please make sure it is declared in AndroidManifest.xml.");
            bl2 = false;
        } else {
            String string2 = "com.google.android.gms.ads.AdActivity requires the android:configChanges value to contain \"%s\".";
            if ((resolveInfo.activityInfo.configChanges & 0x10) == 0) {
                dw.z(String.format(string2, "keyboard"));
                bl2 = false;
            }
            if ((resolveInfo.activityInfo.configChanges & 0x20) == 0) {
                dw.z(String.format(string2, "keyboardHidden"));
                bl2 = false;
            }
            if ((resolveInfo.activityInfo.configChanges & 0x80) == 0) {
                dw.z(String.format(string2, "orientation"));
                bl2 = false;
            }
            if ((resolveInfo.activityInfo.configChanges & 0x100) == 0) {
                dw.z(String.format(string2, "screenLayout"));
                bl2 = false;
            }
            if ((resolveInfo.activityInfo.configChanges & 0x200) == 0) {
                dw.z(String.format(string2, "uiMode"));
                bl2 = false;
            }
            if ((resolveInfo.activityInfo.configChanges & 0x400) == 0) {
                dw.z(String.format(string2, "screenSize"));
                bl2 = false;
            }
            if ((resolveInfo.activityInfo.configChanges & 0x800) == 0) {
                dw.z(String.format(string2, "smallestScreenSize"));
                bl2 = false;
            }
        }
        return bl2;
    }

    public static boolean a(PackageManager packageManager, String string2, String string3) {
        return packageManager.checkPermission(string3, string2) == 0;
    }

    public static boolean by() {
        return re;
    }

    public static int bz() {
        return Build.VERSION.SDK_INT >= 9 ? 6 : 0;
    }

    public static int bA() {
        return Build.VERSION.SDK_INT >= 9 ? 7 : 1;
    }

    public static void a(Context context, String string2, List<String> list) {
        for (String string3 : list) {
            new du(context, string2, string3).start();
        }
    }

    public static String a(Readable readable) throws IOException {
        int n2;
        StringBuilder stringBuilder = new StringBuilder();
        CharBuffer charBuffer = CharBuffer.allocate(2048);
        while ((n2 = readable.read(charBuffer)) != -1) {
            charBuffer.flip();
            stringBuilder.append(charBuffer, 0, n2);
        }
        return stringBuilder.toString();
    }

    public static void i(Context context) {
        if (rg) {
            return;
        }
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.USER_PRESENT");
        intentFilter.addAction("android.intent.action.SCREEN_OFF");
        context.getApplicationContext().registerReceiver((BroadcastReceiver)new a(), intentFilter);
        rg = true;
    }

    public static void a(Context context, String string2, WebSettings webSettings) {
        webSettings.setUserAgentString(dq.b(context, string2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String b(final Context context, String string2) {
        Object object = px;
        synchronized (object) {
            if (rf != null) {
                return rf;
            }
            if (Build.VERSION.SDK_INT >= 17) {
                rf = dt.getDefaultUserAgent(context);
            } else if (!dv.bD()) {
                dv.rp.post(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Object object = px;
                        synchronized (object) {
                            rf = dq.j(context);
                            px.notifyAll();
                        }
                    }
                });
                while (rf == null) {
                    try {
                        px.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        return rf;
                    }
                }
            } else {
                rf = dq.j(context);
            }
            rf = rf + " (Mobile; " + string2 + ")";
            return rf;
        }
    }

    private static String j(Context context) {
        return new WebView(context).getSettings().getUserAgentString();
    }

    public static boolean a(ClassLoader classLoader, Class<?> clazz, String string2) {
        try {
            Class<?> clazz2 = Class.forName(string2, false, classLoader);
            return clazz.isAssignableFrom(clazz2);
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static String r(String string2) {
        return Uri.parse((String)string2).buildUpon().query(null).build().toString();
    }

    public static JSONObject p(Map<String, ?> map) throws JSONException {
        try {
            JSONObject jSONObject = new JSONObject();
            for (String string2 : map.keySet()) {
                dq.a(jSONObject, string2, map.get(string2));
            }
            return jSONObject;
        }
        catch (ClassCastException classCastException) {
            throw new JSONException("Could not convert map to JSON: " + classCastException.getMessage());
        }
    }

    private static JSONObject a(Bundle bundle) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        for (String string2 : bundle.keySet()) {
            dq.a(jSONObject, string2, bundle.get(string2));
        }
        return jSONObject;
    }

    private static JSONArray a(Collection<?> collection) throws JSONException {
        JSONArray jSONArray = new JSONArray();
        for (Object obj : collection) {
            dq.a(jSONArray, obj);
        }
        return jSONArray;
    }

    static JSONArray a(Object[] objectArray) throws JSONException {
        JSONArray jSONArray = new JSONArray();
        for (Object object : objectArray) {
            dq.a(jSONArray, object);
        }
        return jSONArray;
    }

    private static void a(JSONArray jSONArray, Object object) throws JSONException {
        if (object instanceof Bundle) {
            jSONArray.put((Object)dq.a((Bundle)object));
        } else if (object instanceof Map) {
            Map map = (Map)object;
            jSONArray.put((Object)dq.p(map));
        } else if (object instanceof Collection) {
            jSONArray.put((Object)dq.a((Collection)object));
        } else if (object instanceof Object[]) {
            jSONArray.put((Object)dq.a((Object[])object));
        } else {
            jSONArray.put(object);
        }
    }

    private static void a(JSONObject jSONObject, String string2, Object object) throws JSONException {
        if (object instanceof Bundle) {
            jSONObject.put(string2, (Object)dq.a((Bundle)object));
        } else if (object instanceof Map) {
            Map map = (Map)object;
            jSONObject.put(string2, (Object)dq.p(map));
        } else if (object instanceof Collection) {
            jSONObject.put(string2 != null ? string2 : "null", (Object)dq.a((Collection)object));
        } else if (object instanceof Object[]) {
            jSONObject.put(string2, (Object)dq.a(Arrays.asList((Object[])object)));
        } else {
            jSONObject.put(string2, object);
        }
    }

    public static Map<String, String> b(Uri uri) {
        if (uri == null) {
            return null;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        UrlQuerySanitizer urlQuerySanitizer = new UrlQuerySanitizer();
        urlQuerySanitizer.setAllowUnregisteredParamaters(true);
        urlQuerySanitizer.setUnregisteredParameterValueSanitizer(UrlQuerySanitizer.getAllButNulLegal());
        urlQuerySanitizer.parseUrl(uri.toString());
        List list = urlQuerySanitizer.getParameterList();
        for (UrlQuerySanitizer.ParameterValuePair parameterValuePair : list) {
            hashMap.put(parameterValuePair.mParameter, parameterValuePair.mValue);
        }
        return hashMap;
    }

    public static void a(WebView webView) {
        if (Build.VERSION.SDK_INT >= 11) {
            ds.a(webView);
        }
    }

    public static void b(WebView webView) {
        if (Build.VERSION.SDK_INT >= 11) {
            ds.b(webView);
        }
    }

    static {
        rg = false;
    }

    private static final class a
    extends BroadcastReceiver {
        private a() {
        }

        public void onReceive(Context context, Intent intent) {
            if ("android.intent.action.USER_PRESENT".equals(intent.getAction())) {
                re = true;
            } else if ("android.intent.action.SCREEN_OFF".equals(intent.getAction())) {
                re = false;
            }
        }
    }
}

