/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.request;

import android.os.Parcel;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.data.b;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameRef;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerRef;
import com.google.android.gms.games.request.GameRequest;
import com.google.android.gms.games.request.GameRequestEntity;
import java.util.ArrayList;
import java.util.List;

public final class GameRequestRef
extends b
implements GameRequest {
    private final int LE;

    public GameRequestRef(DataHolder holder, int dataRow, int numChildren) {
        super(holder, dataRow);
        this.LE = numChildren;
    }

    @Override
    public String getRequestId() {
        return this.getString("external_request_id");
    }

    @Override
    public Game getGame() {
        return new GameRef(this.BB, this.BD);
    }

    @Override
    public Player getSender() {
        return new PlayerRef(this.BB, this.BD, "sender_");
    }

    @Override
    public List<Player> getRecipients() {
        ArrayList<Player> arrayList = new ArrayList<Player>(this.LE);
        for (int i2 = 0; i2 < this.LE; ++i2) {
            arrayList.add(new PlayerRef(this.BB, this.BD + i2, "recipient_"));
        }
        return arrayList;
    }

    @Override
    public boolean isConsumed(String playerId) {
        return this.getRecipientStatus(playerId) == 1;
    }

    @Override
    public byte[] getData() {
        return this.getByteArray("data");
    }

    @Override
    public int getType() {
        return this.getInteger("type");
    }

    @Override
    public long getCreationTimestamp() {
        return this.getLong("creation_timestamp");
    }

    @Override
    public long getExpirationTimestamp() {
        return this.getLong("expiration_timestamp");
    }

    @Override
    public int getRecipientStatus(String playerId) {
        for (int i2 = this.BD; i2 < this.BD + this.LE; ++i2) {
            int n2 = this.BB.G(i2);
            String string2 = this.BB.getString("recipient_external_player_id", i2, n2);
            if (!string2.equals(playerId)) continue;
            return this.BB.getInteger("recipient_status", i2, n2);
        }
        return -1;
    }

    @Override
    public int getStatus() {
        return this.getInteger("status");
    }

    @Override
    public GameRequest freeze() {
        return new GameRequestEntity(this);
    }

    @Override
    public int hashCode() {
        return GameRequestEntity.a(this);
    }

    @Override
    public boolean equals(Object obj) {
        return GameRequestEntity.a(this, obj);
    }

    public String toString() {
        return GameRequestEntity.c(this);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        GameRequestEntity gameRequestEntity = (GameRequestEntity)this.freeze();
        gameRequestEntity.writeToParcel(dest, flags);
    }
}

