/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer.turnbased;

import android.database.CharArrayBuffer;
import android.os.Bundle;
import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.ParticipantEntity;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatch;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatchEntityCreator;
import com.google.android.gms.internal.fo;
import com.google.android.gms.internal.gm;
import java.util.ArrayList;

public final class TurnBasedMatchEntity
implements SafeParcelable,
TurnBasedMatch {
    public static final TurnBasedMatchEntityCreator CREATOR = new TurnBasedMatchEntityCreator();
    private final int xH;
    private final GameEntity Lt;
    private final String Jb;
    private final String MS;
    private final long Mu;
    private final String Na;
    private final long Nb;
    private final String Nc;
    private final int Nd;
    private final int My;
    private final int Ne;
    private final byte[] Nf;
    private final ArrayList<ParticipantEntity> Mx;
    private final String Ng;
    private final byte[] Nh;
    private final int Ni;
    private final Bundle MO;
    private final int Nj;
    private final boolean Nk;
    private final String HD;
    private final String Nl;

    public TurnBasedMatchEntity(TurnBasedMatch match) {
        this.xH = 2;
        this.Lt = new GameEntity(match.getGame());
        this.Jb = match.getMatchId();
        this.MS = match.getCreatorId();
        this.Mu = match.getCreationTimestamp();
        this.Na = match.getLastUpdaterId();
        this.Nb = match.getLastUpdatedTimestamp();
        this.Nc = match.getPendingParticipantId();
        this.Nd = match.getStatus();
        this.Nj = match.getTurnStatus();
        this.My = match.getVariant();
        this.Ne = match.getVersion();
        this.Ng = match.getRematchId();
        this.Ni = match.getMatchNumber();
        this.MO = match.getAutoMatchCriteria();
        this.Nk = match.isLocallyModified();
        this.HD = match.getDescription();
        this.Nl = match.getDescriptionParticipantId();
        byte[] byArray = match.getData();
        if (byArray == null) {
            this.Nf = null;
        } else {
            this.Nf = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.Nf, 0, byArray.length);
        }
        byte[] byArray2 = match.getPreviousMatchData();
        if (byArray2 == null) {
            this.Nh = null;
        } else {
            this.Nh = new byte[byArray2.length];
            System.arraycopy(byArray2, 0, this.Nh, 0, byArray2.length);
        }
        ArrayList arrayList = match.getParticipants();
        int n2 = arrayList.size();
        this.Mx = new ArrayList(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            this.Mx.add((ParticipantEntity)((Participant)arrayList.get(i2)).freeze());
        }
    }

    TurnBasedMatchEntity(int versionCode, GameEntity game, String matchId, String creatorId, long creationTimestamp, String lastUpdaterId, long lastUpdatedTimestamp, String pendingParticipantId, int matchStatus, int variant, int version, byte[] data, ArrayList<ParticipantEntity> participants, String rematchId, byte[] previousData, int matchNumber, Bundle autoMatchCriteria, int turnStatus, boolean isLocallyModified, String description, String descriptionParticipantId) {
        this.xH = versionCode;
        this.Lt = game;
        this.Jb = matchId;
        this.MS = creatorId;
        this.Mu = creationTimestamp;
        this.Na = lastUpdaterId;
        this.Nb = lastUpdatedTimestamp;
        this.Nc = pendingParticipantId;
        this.Nd = matchStatus;
        this.Nj = turnStatus;
        this.My = variant;
        this.Ne = version;
        this.Nf = data;
        this.Mx = participants;
        this.Ng = rematchId;
        this.Nh = previousData;
        this.Ni = matchNumber;
        this.MO = autoMatchCriteria;
        this.Nk = isLocallyModified;
        this.HD = description;
        this.Nl = descriptionParticipantId;
    }

    public int getVersionCode() {
        return this.xH;
    }

    @Override
    public Game getGame() {
        return this.Lt;
    }

    @Override
    public String getMatchId() {
        return this.Jb;
    }

    @Override
    public String getCreatorId() {
        return this.MS;
    }

    @Override
    public long getCreationTimestamp() {
        return this.Mu;
    }

    @Override
    public String getLastUpdaterId() {
        return this.Na;
    }

    @Override
    public long getLastUpdatedTimestamp() {
        return this.Nb;
    }

    @Override
    public String getPendingParticipantId() {
        return this.Nc;
    }

    @Override
    public int getStatus() {
        return this.Nd;
    }

    @Override
    public int getTurnStatus() {
        return this.Nj;
    }

    @Override
    public String getDescription() {
        return this.HD;
    }

    @Override
    public String getDescriptionParticipantId() {
        return this.Nl;
    }

    @Override
    public Participant getDescriptionParticipant() {
        return this.getParticipant(this.getDescriptionParticipantId());
    }

    @Override
    public void getDescription(CharArrayBuffer dataOut) {
        gm.b(this.HD, dataOut);
    }

    @Override
    public int getVariant() {
        return this.My;
    }

    @Override
    public byte[] getData() {
        return this.Nf;
    }

    @Override
    public int getVersion() {
        return this.Ne;
    }

    @Override
    public String getRematchId() {
        return this.Ng;
    }

    @Override
    public byte[] getPreviousMatchData() {
        return this.Nh;
    }

    @Override
    public int getMatchNumber() {
        return this.Ni;
    }

    @Override
    public Bundle getAutoMatchCriteria() {
        return this.MO;
    }

    @Override
    public int getAvailableAutoMatchSlots() {
        if (this.MO == null) {
            return 0;
        }
        return this.MO.getInt("max_automatch_players");
    }

    @Override
    public boolean canRematch() {
        return this.Nd == 2 && this.Ng == null;
    }

    @Override
    public boolean isLocallyModified() {
        return this.Nk;
    }

    @Override
    public int getParticipantStatus(String participantId) {
        return TurnBasedMatchEntity.a((TurnBasedMatch)this, participantId);
    }

    @Override
    public ArrayList<String> getParticipantIds() {
        return TurnBasedMatchEntity.c(this);
    }

    @Override
    public String getParticipantId(String playerId) {
        return TurnBasedMatchEntity.b(this, playerId);
    }

    @Override
    public Participant getParticipant(String participantId) {
        return TurnBasedMatchEntity.c(this, participantId);
    }

    @Override
    public ArrayList<Participant> getParticipants() {
        return new ArrayList<Participant>(this.Mx);
    }

    @Override
    public TurnBasedMatch freeze() {
        return this;
    }

    @Override
    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return TurnBasedMatchEntity.a(this);
    }

    static int a(TurnBasedMatch turnBasedMatch) {
        return fo.hashCode(turnBasedMatch.getGame(), turnBasedMatch.getMatchId(), turnBasedMatch.getCreatorId(), turnBasedMatch.getCreationTimestamp(), turnBasedMatch.getLastUpdaterId(), turnBasedMatch.getLastUpdatedTimestamp(), turnBasedMatch.getPendingParticipantId(), turnBasedMatch.getStatus(), turnBasedMatch.getTurnStatus(), turnBasedMatch.getDescription(), turnBasedMatch.getVariant(), turnBasedMatch.getVersion(), turnBasedMatch.getParticipants(), turnBasedMatch.getRematchId(), turnBasedMatch.getMatchNumber(), turnBasedMatch.getAutoMatchCriteria(), turnBasedMatch.getAvailableAutoMatchSlots(), turnBasedMatch.isLocallyModified());
    }

    public boolean equals(Object obj) {
        return TurnBasedMatchEntity.a((TurnBasedMatch)this, obj);
    }

    static boolean a(TurnBasedMatch turnBasedMatch, Object object) {
        if (!(object instanceof TurnBasedMatch)) {
            return false;
        }
        if (turnBasedMatch == object) {
            return true;
        }
        TurnBasedMatch turnBasedMatch2 = (TurnBasedMatch)object;
        return fo.equal(turnBasedMatch2.getGame(), turnBasedMatch.getGame()) && fo.equal(turnBasedMatch2.getMatchId(), turnBasedMatch.getMatchId()) && fo.equal(turnBasedMatch2.getCreatorId(), turnBasedMatch.getCreatorId()) && fo.equal(turnBasedMatch2.getCreationTimestamp(), turnBasedMatch.getCreationTimestamp()) && fo.equal(turnBasedMatch2.getLastUpdaterId(), turnBasedMatch.getLastUpdaterId()) && fo.equal(turnBasedMatch2.getLastUpdatedTimestamp(), turnBasedMatch.getLastUpdatedTimestamp()) && fo.equal(turnBasedMatch2.getPendingParticipantId(), turnBasedMatch.getPendingParticipantId()) && fo.equal(turnBasedMatch2.getStatus(), turnBasedMatch.getStatus()) && fo.equal(turnBasedMatch2.getTurnStatus(), turnBasedMatch.getTurnStatus()) && fo.equal(turnBasedMatch2.getDescription(), turnBasedMatch.getDescription()) && fo.equal(turnBasedMatch2.getVariant(), turnBasedMatch.getVariant()) && fo.equal(turnBasedMatch2.getVersion(), turnBasedMatch.getVersion()) && fo.equal(turnBasedMatch2.getParticipants(), turnBasedMatch.getParticipants()) && fo.equal(turnBasedMatch2.getRematchId(), turnBasedMatch.getRematchId()) && fo.equal(turnBasedMatch2.getMatchNumber(), turnBasedMatch.getMatchNumber()) && fo.equal(turnBasedMatch2.getAutoMatchCriteria(), turnBasedMatch.getAutoMatchCriteria()) && fo.equal(turnBasedMatch2.getAvailableAutoMatchSlots(), turnBasedMatch.getAvailableAutoMatchSlots()) && fo.equal(turnBasedMatch2.isLocallyModified(), turnBasedMatch.isLocallyModified());
    }

    public String toString() {
        return TurnBasedMatchEntity.b(this);
    }

    static String b(TurnBasedMatch turnBasedMatch) {
        return fo.e(turnBasedMatch).a("Game", turnBasedMatch.getGame()).a("MatchId", turnBasedMatch.getMatchId()).a("CreatorId", turnBasedMatch.getCreatorId()).a("CreationTimestamp", turnBasedMatch.getCreationTimestamp()).a("LastUpdaterId", turnBasedMatch.getLastUpdaterId()).a("LastUpdatedTimestamp", turnBasedMatch.getLastUpdatedTimestamp()).a("PendingParticipantId", turnBasedMatch.getPendingParticipantId()).a("MatchStatus", turnBasedMatch.getStatus()).a("TurnStatus", turnBasedMatch.getTurnStatus()).a("Description", turnBasedMatch.getDescription()).a("Variant", turnBasedMatch.getVariant()).a("Data", turnBasedMatch.getData()).a("Version", turnBasedMatch.getVersion()).a("Participants", turnBasedMatch.getParticipants()).a("RematchId", turnBasedMatch.getRematchId()).a("PreviousData", turnBasedMatch.getPreviousMatchData()).a("MatchNumber", turnBasedMatch.getMatchNumber()).a("AutoMatchCriteria", turnBasedMatch.getAutoMatchCriteria()).a("AvailableAutoMatchSlots", turnBasedMatch.getAvailableAutoMatchSlots()).a("LocallyModified", turnBasedMatch.isLocallyModified()).a("DescriptionParticipantId", turnBasedMatch.getDescriptionParticipantId()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        TurnBasedMatchEntityCreator.a(this, out, flags);
    }

    static int a(TurnBasedMatch turnBasedMatch, String string2) {
        ArrayList arrayList = turnBasedMatch.getParticipants();
        int n2 = arrayList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Participant participant = (Participant)arrayList.get(i2);
            if (!participant.getParticipantId().equals(string2)) continue;
            return participant.getStatus();
        }
        throw new IllegalStateException("Participant " + string2 + " is not in match " + turnBasedMatch.getMatchId());
    }

    static ArrayList<String> c(TurnBasedMatch turnBasedMatch) {
        ArrayList arrayList = turnBasedMatch.getParticipants();
        int n2 = arrayList.size();
        ArrayList<String> arrayList2 = new ArrayList<String>(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            Participant participant = (Participant)arrayList.get(i2);
            arrayList2.add(participant.getParticipantId());
        }
        return arrayList2;
    }

    static String b(TurnBasedMatch turnBasedMatch, String string2) {
        String string3 = null;
        ArrayList arrayList = turnBasedMatch.getParticipants();
        int n2 = arrayList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Participant participant = (Participant)arrayList.get(i2);
            Player player = participant.getPlayer();
            if (player == null || !player.getPlayerId().equals(string2)) continue;
            string3 = participant.getParticipantId();
            break;
        }
        return string3;
    }

    static Participant c(TurnBasedMatch turnBasedMatch, String string2) {
        ArrayList arrayList = turnBasedMatch.getParticipants();
        int n2 = arrayList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Participant participant = (Participant)arrayList.get(i2);
            if (!participant.getParticipantId().equals(string2)) continue;
            return participant;
        }
        throw new IllegalStateException("Participant " + string2 + " is not in match " + turnBasedMatch.getMatchId());
    }
}

