/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer.turnbased;

import android.os.Bundle;
import com.google.android.gms.internal.fq;
import java.util.ArrayList;

public final class TurnBasedMatchConfig {
    private final int My;
    private final String[] MN;
    private final Bundle MO;
    private final int MZ;

    private TurnBasedMatchConfig(Builder builder) {
        this.My = builder.My;
        this.MZ = builder.MZ;
        this.MO = builder.MO;
        int n2 = builder.MR.size();
        this.MN = builder.MR.toArray(new String[n2]);
    }

    public int getVariant() {
        return this.My;
    }

    public int getMinPlayers() {
        return this.MZ;
    }

    public String[] getInvitedPlayerIds() {
        return this.MN;
    }

    public Bundle getAutoMatchCriteria() {
        return this.MO;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Bundle createAutoMatchCriteria(int minAutoMatchPlayers, int maxAutoMatchPlayers, long exclusiveBitMask) {
        Bundle bundle = new Bundle();
        bundle.putInt("min_automatch_players", minAutoMatchPlayers);
        bundle.putInt("max_automatch_players", maxAutoMatchPlayers);
        bundle.putLong("exclusive_bit_mask", exclusiveBitMask);
        return bundle;
    }

    public static final class Builder {
        int My = -1;
        ArrayList<String> MR = new ArrayList();
        Bundle MO = null;
        int MZ = 2;

        private Builder() {
        }

        public Builder addInvitedPlayer(String playerId) {
            fq.f(playerId);
            this.MR.add(playerId);
            return this;
        }

        public Builder addInvitedPlayers(ArrayList<String> playerIds) {
            fq.f(playerIds);
            this.MR.addAll(playerIds);
            return this;
        }

        public Builder setVariant(int variant) {
            fq.b(variant == -1 || variant > 0, (Object)"Variant must be a positive integer or TurnBasedMatch.MATCH_VARIANT_ANY");
            this.My = variant;
            return this;
        }

        public Builder setMinPlayers(int minPlayers) {
            this.MZ = minPlayers;
            return this;
        }

        public Builder setAutoMatchCriteria(Bundle autoMatchCriteria) {
            this.MO = autoMatchCriteria;
            return this;
        }

        public TurnBasedMatchConfig build() {
            return new TurnBasedMatchConfig(this);
        }
    }
}

