/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer.turnbased;

import android.os.Bundle;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.games.internal.constants.TurnBasedMatchTurnStatus;
import com.google.android.gms.games.multiplayer.InvitationBuffer;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatchBuffer;

public final class LoadMatchesResponse {
    private final InvitationBuffer MV;
    private final TurnBasedMatchBuffer MW;
    private final TurnBasedMatchBuffer MX;
    private final TurnBasedMatchBuffer MY;

    public LoadMatchesResponse(Bundle matchData) {
        DataHolder dataHolder = LoadMatchesResponse.a(matchData, 0);
        this.MV = dataHolder != null ? new InvitationBuffer(dataHolder) : null;
        DataHolder dataHolder2 = LoadMatchesResponse.a(matchData, 1);
        this.MW = dataHolder2 != null ? new TurnBasedMatchBuffer(dataHolder2) : null;
        DataHolder dataHolder3 = LoadMatchesResponse.a(matchData, 2);
        this.MX = dataHolder3 != null ? new TurnBasedMatchBuffer(dataHolder3) : null;
        DataHolder dataHolder4 = LoadMatchesResponse.a(matchData, 3);
        this.MY = dataHolder4 != null ? new TurnBasedMatchBuffer(dataHolder4) : null;
    }

    private static DataHolder a(Bundle bundle, int n2) {
        String string2 = TurnBasedMatchTurnStatus.bd(n2);
        if (!bundle.containsKey(string2)) {
            return null;
        }
        return (DataHolder)bundle.getParcelable(string2);
    }

    public InvitationBuffer getInvitations() {
        return this.MV;
    }

    public TurnBasedMatchBuffer getMyTurnMatches() {
        return this.MW;
    }

    public TurnBasedMatchBuffer getTheirTurnMatches() {
        return this.MX;
    }

    public TurnBasedMatchBuffer getCompletedMatches() {
        return this.MY;
    }

    public void close() {
        if (this.MV != null) {
            this.MV.close();
        }
        if (this.MW != null) {
            this.MW.close();
        }
        if (this.MX != null) {
            this.MX.close();
        }
        if (this.MY != null) {
            this.MY.close();
        }
    }

    public boolean hasData() {
        if (this.MV != null && this.MV.getCount() > 0) {
            return true;
        }
        if (this.MW != null && this.MW.getCount() > 0) {
            return true;
        }
        if (this.MX != null && this.MX.getCount() > 0) {
            return true;
        }
        return this.MY != null && this.MY.getCount() > 0;
    }
}

