/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer.realtime;

import android.os.Bundle;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMessageReceivedListener;
import com.google.android.gms.games.multiplayer.realtime.RoomStatusUpdateListener;
import com.google.android.gms.games.multiplayer.realtime.RoomUpdateListener;
import com.google.android.gms.internal.fq;
import java.util.ArrayList;
import java.util.Arrays;

public final class RoomConfig {
    private final RoomUpdateListener MK;
    private final RoomStatusUpdateListener ML;
    private final RealTimeMessageReceivedListener MM;
    private final String IV;
    private final int My;
    private final String[] MN;
    private final Bundle MO;
    private final boolean MP;

    private RoomConfig(Builder builder) {
        this.MK = builder.MK;
        this.ML = builder.ML;
        this.MM = builder.MM;
        this.IV = builder.MQ;
        this.My = builder.My;
        this.MO = builder.MO;
        this.MP = builder.MP;
        int n2 = builder.MR.size();
        this.MN = builder.MR.toArray(new String[n2]);
        if (this.MM == null) {
            fq.a(this.MP, "Must either enable sockets OR specify a message listener");
        }
    }

    public RoomUpdateListener getRoomUpdateListener() {
        return this.MK;
    }

    public String getInvitationId() {
        return this.IV;
    }

    public RoomStatusUpdateListener getRoomStatusUpdateListener() {
        return this.ML;
    }

    public RealTimeMessageReceivedListener getMessageReceivedListener() {
        return this.MM;
    }

    public int getVariant() {
        return this.My;
    }

    public String[] getInvitedPlayerIds() {
        return this.MN;
    }

    public Bundle getAutoMatchCriteria() {
        return this.MO;
    }

    public boolean isSocketEnabled() {
        return this.MP;
    }

    public static Builder builder(RoomUpdateListener listener) {
        return new Builder(listener);
    }

    public static Bundle createAutoMatchCriteria(int minAutoMatchPlayers, int maxAutoMatchPlayers, long exclusiveBitMask) {
        Bundle bundle = new Bundle();
        bundle.putInt("min_automatch_players", minAutoMatchPlayers);
        bundle.putInt("max_automatch_players", maxAutoMatchPlayers);
        bundle.putLong("exclusive_bit_mask", exclusiveBitMask);
        return bundle;
    }

    public static final class Builder {
        final RoomUpdateListener MK;
        RoomStatusUpdateListener ML;
        RealTimeMessageReceivedListener MM;
        String MQ = null;
        int My = -1;
        ArrayList<String> MR = new ArrayList();
        Bundle MO;
        boolean MP = false;

        private Builder(RoomUpdateListener updateListener) {
            this.MK = fq.b(updateListener, (Object)"Must provide a RoomUpdateListener");
        }

        public Builder setInvitationIdToAccept(String invitationId) {
            fq.f(invitationId);
            this.MQ = invitationId;
            return this;
        }

        public Builder setRoomStatusUpdateListener(RoomStatusUpdateListener listener) {
            this.ML = listener;
            return this;
        }

        public Builder setMessageReceivedListener(RealTimeMessageReceivedListener listener) {
            this.MM = listener;
            return this;
        }

        public Builder addPlayersToInvite(String ... playerIds) {
            fq.f(playerIds);
            this.MR.addAll(Arrays.asList(playerIds));
            return this;
        }

        public Builder addPlayersToInvite(ArrayList<String> playerIds) {
            fq.f(playerIds);
            this.MR.addAll(playerIds);
            return this;
        }

        public Builder setVariant(int variant) {
            fq.b(variant == -1 || variant > 0, (Object)"Variant must be a positive integer or Room.ROOM_VARIANT_ANY");
            this.My = variant;
            return this;
        }

        public Builder setSocketCommunicationEnabled(boolean enableSockets) {
            this.MP = enableSockets;
            return this;
        }

        public Builder setAutoMatchCriteria(Bundle autoMatchCriteria) {
            this.MO = autoMatchCriteria;
            return this;
        }

        public RoomConfig build() {
            return new RoomConfig(this);
        }
    }
}

