/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.internal;

import android.net.LocalSocket;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import com.google.android.gms.games.multiplayer.realtime.RealTimeSocket;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

final class RealTimeSocketImpl
implements RealTimeSocket {
    private final LocalSocket JP;
    private final String Jg;
    private ParcelFileDescriptor Cj;

    RealTimeSocketImpl(LocalSocket localSocket, String participantId) {
        this.JP = localSocket;
        this.Jg = participantId;
    }

    @Override
    public ParcelFileDescriptor getParcelFileDescriptor() throws IOException {
        if (this.Cj == null && !this.isClosed()) {
            Parcel parcel = Parcel.obtain();
            parcel.writeFileDescriptor(this.JP.getFileDescriptor());
            parcel.setDataPosition(0);
            this.Cj = parcel.readFileDescriptor();
        }
        return this.Cj;
    }

    @Override
    public void close() throws IOException {
        this.JP.close();
    }

    @Override
    public boolean isClosed() {
        return !this.JP.isConnected() && !this.JP.isBound();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.JP.getInputStream();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.JP.getOutputStream();
    }
}

