/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.internal;

import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.LocalSocket;
import android.net.LocalSocketAddress;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.RemoteException;
import android.view.View;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Releasable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.a;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameBuffer;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.GamesMetadata;
import com.google.android.gms.games.Notifications;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerBuffer;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.Players;
import com.google.android.gms.games.achievement.AchievementBuffer;
import com.google.android.gms.games.achievement.Achievements;
import com.google.android.gms.games.internal.AbstractGamesCallbacks;
import com.google.android.gms.games.internal.GamesLog;
import com.google.android.gms.games.internal.IGamesCallbacks;
import com.google.android.gms.games.internal.IGamesService;
import com.google.android.gms.games.internal.LibjingleNativeSocket;
import com.google.android.gms.games.internal.PopupManager;
import com.google.android.gms.games.internal.RealTimeSocketImpl;
import com.google.android.gms.games.internal.constants.RequestType;
import com.google.android.gms.games.internal.game.Acls;
import com.google.android.gms.games.internal.game.ExtendedGameBuffer;
import com.google.android.gms.games.internal.game.GameInstanceBuffer;
import com.google.android.gms.games.internal.player.ExtendedPlayerBuffer;
import com.google.android.gms.games.internal.request.RequestUpdateOutcomes;
import com.google.android.gms.games.leaderboard.Leaderboard;
import com.google.android.gms.games.leaderboard.LeaderboardBuffer;
import com.google.android.gms.games.leaderboard.LeaderboardEntity;
import com.google.android.gms.games.leaderboard.LeaderboardScore;
import com.google.android.gms.games.leaderboard.LeaderboardScoreBuffer;
import com.google.android.gms.games.leaderboard.LeaderboardScoreEntity;
import com.google.android.gms.games.leaderboard.Leaderboards;
import com.google.android.gms.games.leaderboard.ScoreSubmissionData;
import com.google.android.gms.games.multiplayer.Invitation;
import com.google.android.gms.games.multiplayer.InvitationBuffer;
import com.google.android.gms.games.multiplayer.Invitations;
import com.google.android.gms.games.multiplayer.OnInvitationReceivedListener;
import com.google.android.gms.games.multiplayer.ParticipantResult;
import com.google.android.gms.games.multiplayer.ParticipantUtils;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMessage;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMessageReceivedListener;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMultiplayer;
import com.google.android.gms.games.multiplayer.realtime.RealTimeSocket;
import com.google.android.gms.games.multiplayer.realtime.Room;
import com.google.android.gms.games.multiplayer.realtime.RoomBuffer;
import com.google.android.gms.games.multiplayer.realtime.RoomConfig;
import com.google.android.gms.games.multiplayer.realtime.RoomEntity;
import com.google.android.gms.games.multiplayer.realtime.RoomStatusUpdateListener;
import com.google.android.gms.games.multiplayer.realtime.RoomUpdateListener;
import com.google.android.gms.games.multiplayer.turnbased.LoadMatchesResponse;
import com.google.android.gms.games.multiplayer.turnbased.OnTurnBasedMatchUpdateReceivedListener;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatch;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatchBuffer;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMatchConfig;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMultiplayer;
import com.google.android.gms.games.request.GameRequest;
import com.google.android.gms.games.request.GameRequestBuffer;
import com.google.android.gms.games.request.OnRequestReceivedListener;
import com.google.android.gms.games.request.Requests;
import com.google.android.gms.internal.ff;
import com.google.android.gms.internal.fm;
import com.google.android.gms.internal.fq;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public final class GamesClientImpl
extends ff<IGamesService>
implements GoogleApiClient.ConnectionCallbacks,
GoogleApiClient.OnConnectionFailedListener {
    private final String Iu;
    private final String wG;
    private final Map<String, RealTimeSocket> Iv;
    private PlayerEntity Iw;
    private GameEntity Ix;
    private final PopupManager Iy;
    private boolean Iz = false;
    private boolean IA = false;
    private int IB;
    private final Binder IC;
    private final long IE;
    private final boolean IF;
    private final int IG;
    private final boolean IH;

    public GamesClientImpl(Context context, Looper looper, String gamePackageName, String accountName, GoogleApiClient.ConnectionCallbacks connectedListener, GoogleApiClient.OnConnectionFailedListener connectionFailedListener, String[] scopes, int gravity, View gamesContentView, boolean isHeadless, boolean showConnectingPopup, int connectingPopupGravity, boolean retryingSignIn, int sdkVariant) {
        super(context, looper, connectedListener, connectionFailedListener, scopes);
        this.Iu = gamePackageName;
        this.wG = fq.f(accountName);
        this.IC = new Binder();
        this.Iv = new HashMap<String, RealTimeSocket>();
        this.Iy = PopupManager.a(this, gravity);
        this.f(gamesContentView);
        this.IA = showConnectingPopup;
        this.IB = connectingPopupGravity;
        this.IE = this.hashCode();
        this.IF = isHeadless;
        this.IH = retryingSignIn;
        this.IG = sdkVariant;
        this.registerConnectionCallbacks(this);
        this.registerConnectionFailedListener(this);
    }

    @Override
    public void onConnected(Bundle connectionHint) {
        if (this.Iz) {
            this.Iy.gS();
            this.Iz = false;
        }
    }

    @Override
    public void onConnectionSuspended(int cause) {
    }

    @Override
    public void onConnectionFailed(ConnectionResult result) {
        this.Iz = false;
    }

    public void aX(int n2) {
        this.Iy.setGravity(n2);
    }

    public void f(View view) {
        this.Iy.g(view);
    }

    @Override
    protected void b(String ... stringArray) {
        boolean bl2 = false;
        boolean bl3 = false;
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string2 = stringArray[i2];
            if (string2.equals("https://www.googleapis.com/auth/games")) {
                bl2 = true;
                continue;
            }
            if (!string2.equals("https://www.googleapis.com/auth/games.firstparty")) continue;
            bl3 = true;
        }
        if (bl3) {
            fq.a(!bl2, String.format("Cannot have both %s and %s!", "https://www.googleapis.com/auth/games", "https://www.googleapis.com/auth/games.firstparty"));
        } else {
            fq.a(bl2, String.format("Games APIs requires %s to function.", "https://www.googleapis.com/auth/games"));
        }
    }

    @Override
    public void connect() {
        this.gk();
        super.connect();
    }

    @Override
    public void disconnect() {
        this.Iz = false;
        if (this.isConnected()) {
            try {
                IGamesService iGamesService = (IGamesService)this.eM();
                iGamesService.gF();
                iGamesService.o(this.IE);
            }
            catch (RemoteException remoteException) {
                GamesLog.g("GamesClientImpl", "Failed to notify client disconnect.");
            }
        }
        this.gE();
        super.disconnect();
    }

    @Override
    protected String bg() {
        return "com.google.android.gms.games.service.START";
    }

    @Override
    protected String bh() {
        return "com.google.android.gms.games.internal.IGamesService";
    }

    protected IGamesService L(IBinder iBinder) {
        return IGamesService.Stub.N(iBinder);
    }

    @Override
    public Bundle dG() {
        try {
            Bundle bundle = ((IGamesService)this.eM()).dG();
            if (bundle != null) {
                bundle.setClassLoader(GamesClientImpl.class.getClassLoader());
            }
            return bundle;
        }
        catch (RemoteException remoteException) {
            GamesLog.g("GamesClientImpl", "service died");
            return null;
        }
    }

    private void gk() {
        this.Iw = null;
    }

    @Override
    protected void a(fm fm2, ff.e e2) throws RemoteException {
        String string2 = this.getContext().getResources().getConfiguration().locale.toString();
        Bundle bundle = new Bundle();
        bundle.putBoolean("com.google.android.gms.games.key.isHeadless", this.IF);
        bundle.putBoolean("com.google.android.gms.games.key.showConnectingPopup", this.IA);
        bundle.putInt("com.google.android.gms.games.key.connectingPopupGravity", this.IB);
        bundle.putBoolean("com.google.android.gms.games.key.retryingSignIn", this.IH);
        bundle.putInt("com.google.android.gms.games.key.sdkVariant", this.IG);
        fm2.a(e2, 4452000, this.getContext().getPackageName(), this.wG, this.eL(), this.Iu, this.Iy.gU(), string2, bundle);
    }

    public String gl() {
        try {
            return ((IGamesService)this.eM()).gl();
        }
        catch (RemoteException remoteException) {
            GamesLog.g("GamesClientImpl", "service died");
            return null;
        }
    }

    public String gm() {
        try {
            return ((IGamesService)this.eM()).gm();
        }
        catch (RemoteException remoteException) {
            GamesLog.g("GamesClientImpl", "service died");
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Player gn() {
        this.bT();
        GamesClientImpl gamesClientImpl = this;
        synchronized (gamesClientImpl) {
            if (this.Iw == null) {
                try {
                    PlayerBuffer playerBuffer = new PlayerBuffer(((IGamesService)this.eM()).gG());
                    try {
                        if (playerBuffer.getCount() > 0) {
                            this.Iw = (PlayerEntity)playerBuffer.get(0).freeze();
                        }
                    }
                    finally {
                        playerBuffer.close();
                    }
                }
                catch (RemoteException remoteException) {
                    GamesLog.g("GamesClientImpl", "service died");
                }
            }
        }
        return this.Iw;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Game go() {
        this.bT();
        GamesClientImpl gamesClientImpl = this;
        synchronized (gamesClientImpl) {
            if (this.Ix == null) {
                try {
                    GameBuffer gameBuffer = new GameBuffer(((IGamesService)this.eM()).gI());
                    try {
                        if (gameBuffer.getCount() > 0) {
                            this.Ix = (GameEntity)gameBuffer.get(0).freeze();
                        }
                    }
                    finally {
                        gameBuffer.close();
                    }
                }
                catch (RemoteException remoteException) {
                    GamesLog.g("GamesClientImpl", "service died");
                }
            }
        }
        return this.Ix;
    }

    public void a(a.d<Players.LoadPlayersResult> d2, String string2) {
        try {
            ((IGamesService)this.eM()).a((IGamesCallbacks)new PlayersLoadedBinderCallback(d2), string2);
        }
        catch (RemoteException remoteException) {
            GamesLog.g("GamesClientImpl", "service died");
        }
    }

    public void a(a.d<Players.LoadPlayersResult> d2, String[] stringArray) {
        try {
            ((IGamesService)this.eM()).c((IGamesCallbacks)new PlayersLoadedBinderCallback(d2), stringArray);
        }
        catch (RemoteException remoteException) {
            GamesLog.g("GamesClientImpl", "service died");
        }
    }

    public void a(a.d<Players.LoadPlayersResult> d2, int n2, boolean bl2, boolean bl3) {
        try {
            ((IGamesService)this.eM()).a((IGamesCallbacks)new PlayersLoadedBinderCallback(d2), n2, bl2, bl3);
        }
        catch (RemoteException remoteException) {
            GamesLog.g("GamesClientImpl", "service died");
        }
    }

    public void a(a.d<Players.LoadPlayersResult> d2, String string2, int n2, boolean bl2, boolean bl3) {
        if (!string2.equals("playedWith")) {
            throw new IllegalArgumentException("Invalid player collection: " + string2);
        }
        try {
            ((IGamesService)this.eM()).d(new PlayersLoadedBinderCallback(d2), string2, n2, bl2, bl3);
        }
        catch (RemoteException remoteException) {
            GamesLog.g("GamesClientImpl", "service died");
        }
    }

    public void a(a.d<Players.LoadPlayersResult> d2, String string2, String string3, int n2, boolean bl2, boolean bl3) {
        if (!string2.equals("playedWith") && !string2.equals("circled")) {
            throw new IllegalArgumentException("Invalid player collection: " + string2);
        }
        try {
            ((IGamesService)this.eM()).a((IGamesCallbacks)new PlayersLoadedBinderCallback(d2), string2, string3, n2, bl2, bl3);
        }
        catch (RemoteException remoteException) {
            GamesLog.g("GamesClientImpl", "service died");
        }
    }

    public void a(a.d<Players.LoadPlayersResult> d2, boolean bl2) {
        try {
            ((IGamesService)this.eM()).c((IGamesCallbacks)new PlayersLoadedBinderCallback(d2), bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.g("GamesClientImpl", "service died");
        }
    }

    public Intent gp() {
        Intent intent;
        try {
            intent = ((IGamesService)this.eM()).gp();
        }
        catch (RemoteException remoteException) {
            GamesLog.g("GamesClientImpl", "service died");
            intent = null;
        }
        return intent;
    }

    public Intent aA(String string2) {
        Intent intent;
        try {
            intent = ((IGamesService)this.eM()).aA(string2);
        }
        catch (RemoteException remoteException) {
            GamesLog.g("GamesClientImpl", "service died");
            intent = null;
        }
        return intent;
    }

    public void b(a.d<Leaderboards.LeaderboardMetadataResult> d2, boolean bl2) {
        try {
            ((IGamesService)this.eM()).b((IGamesCallbacks)new LeaderboardsLoadedBinderCallback(d2), bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.g("GamesClientImpl", "service died");
        }
    }

    public void a(a.d<Leaderboards.LeaderboardMetadataResult> d2, String string2, boolean bl2) {
        try {
            ((IGamesService)this.eM()).c((IGamesCallbacks)new LeaderboardsLoadedBinderCallback(d2), string2, bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.g("GamesClientImpl", "service died");
        }
    }

    public void a(a.d<Leaderboards.LoadPlayerScoreResult> d2, String string2, String string3, int n2, int n3) {
        try {
            ((IGamesService)this.eM()).a((IGamesCallbacks)new PlayerLeaderboardScoreLoadedBinderCallback(d2), string2, string3, n2, n3);
        }
        catch (RemoteException remoteException) {
            GamesLog.g("GamesClientImpl", "service died");
        }
    }

    public void a(a.d<Leaderboards.LoadScoresResult> d2, String string2, int n2, int n3, int n4, boolean bl2) {
        try {
            ((IGamesService)this.eM()).a((IGamesCallbacks)new LeaderboardScoresLoadedBinderCallback(d2), string2, n2, n3, n4, bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.g("GamesClientImpl", "service died");
        }
    }

    public void b(a.d<Leaderboards.LoadScoresResult> d2, String string2, int n2, int n3, int n4, boolean bl2) {
        try {
            ((IGamesService)this.eM()).b(new LeaderboardScoresLoadedBinderCallback(d2), string2, n2, n3, n4, bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.g("GamesClientImpl", "service died");
        }
    }

    public void a(a.d<Leaderboards.LoadScoresResult> d2, LeaderboardScoreBuffer leaderboardScoreBuffer, int n2, int n3) {
        try {
            ((IGamesService)this.eM()).a((IGamesCallbacks)new LeaderboardScoresLoadedBinderCallback(d2), leaderboardScoreBuffer.hD().hE(), n2, n3);
        }
        catch (RemoteException remoteException) {
            GamesLog.g("GamesClientImpl", "service died");
        }
    }

    public void a(a.d<Leaderboards.SubmitScoreResult> d2, String string2, long l2, String string3) {
        try {
            SubmitScoreBinderCallbacks submitScoreBinderCallbacks = d2 == null ? null : new SubmitScoreBinderCallbacks(d2);
            ((IGamesService)this.eM()).a((IGamesCallbacks)submitScoreBinderCallbacks, string2, l2, string3);
        }
        catch (RemoteException remoteException) {
            GamesLog.g("GamesClientImpl", "service died");
        }
    }

    public Intent gq() {
        Intent intent;
        try {
            intent = ((IGamesService)this.eM()).gq();
        }
        catch (RemoteException remoteException) {
            GamesLog.g("GamesClientImpl", "service died");
            intent = null;
        }
        return intent;
    }

    public void c(a.d<Achievements.LoadAchievementsResult> d2, boolean bl2) {
        try {
            ((IGamesService)this.eM()).a((IGamesCallbacks)new AchievementsLoadedBinderCallback(d2), bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.g("GamesClientImpl", "service died");
        }
    }

    public void b(a.d<Achievements.UpdateAchievementResult> d2, String string2) {
        try {
            AchievementUpdatedBinderCallback achievementUpdatedBinderCallback = d2 == null ? null : new AchievementUpdatedBinderCallback(d2);
            ((IGamesService)this.eM()).a((IGamesCallbacks)achievementUpdatedBinderCallback, string2, this.Iy.gU(), this.Iy.gT());
        }
        catch (RemoteException remoteException) {
            GamesLog.g("GamesClientImpl", "service died");
        }
    }

    public void c(a.d<Achievements.UpdateAchievementResult> d2, String string2) {
        try {
            AchievementUpdatedBinderCallback achievementUpdatedBinderCallback = d2 == null ? null : new AchievementUpdatedBinderCallback(d2);
            ((IGamesService)this.eM()).b((IGamesCallbacks)achievementUpdatedBinderCallback, string2, this.Iy.gU(), this.Iy.gT());
        }
        catch (RemoteException remoteException) {
            GamesLog.g("GamesClientImpl", "service died");
        }
    }

    public void a(a.d<Achievements.UpdateAchievementResult> d2, String string2, int n2) {
        try {
            AchievementUpdatedBinderCallback achievementUpdatedBinderCallback = d2 == null ? null : new AchievementUpdatedBinderCallback(d2);
            ((IGamesService)this.eM()).a((IGamesCallbacks)achievementUpdatedBinderCallback, string2, n2, this.Iy.gU(), this.Iy.gT());
        }
        catch (RemoteException remoteException) {
            GamesLog.g("GamesClientImpl", "service died");
        }
    }

    public void b(a.d<Achievements.UpdateAchievementResult> d2, String string2, int n2) {
        try {
            AchievementUpdatedBinderCallback achievementUpdatedBinderCallback = d2 == null ? null : new AchievementUpdatedBinderCallback(d2);
            ((IGamesService)this.eM()).b((IGamesCallbacks)achievementUpdatedBinderCallback, string2, n2, this.Iy.gU(), this.Iy.gT());
        }
        catch (RemoteException remoteException) {
            GamesLog.g("GamesClientImpl", "service died");
        }
    }

    public Intent gr() {
        Intent intent;
        try {
            intent = ((IGamesService)this.eM()).gr();
        }
        catch (RemoteException remoteException) {
            GamesLog.g("GamesClientImpl", "service died");
            intent = null;
        }
        return intent;
    }

    public Intent gs() {
        Intent intent;
        try {
            intent = ((IGamesService)this.eM()).gs();
        }
        catch (RemoteException remoteException) {
            GamesLog.g("GamesClientImpl", "service died");
            intent = null;
        }
        return intent;
    }

    public void a(OnInvitationReceivedListener onInvitationReceivedListener) {
        try {
            InvitationReceivedBinderCallback invitationReceivedBinderCallback = new InvitationReceivedBinderCallback(onInvitationReceivedListener);
            ((IGamesService)this.eM()).a((IGamesCallbacks)invitationReceivedBinderCallback, this.IE);
        }
        catch (RemoteException remoteException) {
            GamesLog.g("GamesClientImpl", "service died");
        }
    }

    public void gt() {
        try {
            ((IGamesService)this.eM()).p(this.IE);
        }
        catch (RemoteException remoteException) {
            GamesLog.g("GamesClientImpl", "service died");
        }
    }

    public void a(OnTurnBasedMatchUpdateReceivedListener onTurnBasedMatchUpdateReceivedListener) {
        try {
            MatchUpdateReceivedBinderCallback matchUpdateReceivedBinderCallback = new MatchUpdateReceivedBinderCallback(onTurnBasedMatchUpdateReceivedListener);
            ((IGamesService)this.eM()).b((IGamesCallbacks)matchUpdateReceivedBinderCallback, this.IE);
        }
        catch (RemoteException remoteException) {
            GamesLog.g("GamesClientImpl", "service died");
        }
    }

    public void gu() {
        try {
            ((IGamesService)this.eM()).q(this.IE);
        }
        catch (RemoteException remoteException) {
            GamesLog.g("GamesClientImpl", "service died");
        }
    }

    public void a(OnRequestReceivedListener onRequestReceivedListener) {
        try {
            RequestReceivedBinderCallback requestReceivedBinderCallback = new RequestReceivedBinderCallback(onRequestReceivedListener);
            ((IGamesService)this.eM()).c((IGamesCallbacks)requestReceivedBinderCallback, this.IE);
        }
        catch (RemoteException remoteException) {
            GamesLog.g("GamesClientImpl", "service died");
        }
    }

    public void gv() {
        try {
            ((IGamesService)this.eM()).r(this.IE);
        }
        catch (RemoteException remoteException) {
            GamesLog.g("GamesClientImpl", "service died");
        }
    }

    public Intent gw() {
        Intent intent;
        try {
            intent = ((IGamesService)this.eM()).gw();
        }
        catch (RemoteException remoteException) {
            GamesLog.g("GamesClientImpl", "service died");
            intent = null;
        }
        return intent;
    }

    public Intent a(Room room, int n2) {
        Intent intent;
        try {
            intent = ((IGamesService)this.eM()).a((RoomEntity)room.freeze(), n2);
        }
        catch (RemoteException remoteException) {
            GamesLog.g("GamesClientImpl", "service died");
            intent = null;
        }
        return intent;
    }

    public Intent gx() {
        Intent intent;
        try {
            intent = ((IGamesService)this.eM()).gx();
        }
        catch (RemoteException remoteException) {
            GamesLog.g("GamesClientImpl", "service died");
            intent = null;
        }
        return intent;
    }

    public void g(a.d<GamesMetadata.LoadGamesResult> d2) {
        try {
            ((IGamesService)this.eM()).d(new GamesLoadedBinderCallback(d2));
        }
        catch (RemoteException remoteException) {
            GamesLog.g("GamesClientImpl", "service died");
        }
    }

    public void b(a.d<Status> d2) {
        try {
            ((IGamesService)this.eM()).a(new SignOutCompleteBinderCallbacks(d2));
        }
        catch (RemoteException remoteException) {
            GamesLog.g("GamesClientImpl", "service died");
        }
    }

    public int gy() {
        int n2 = 4368;
        try {
            n2 = ((IGamesService)this.eM()).gy();
        }
        catch (RemoteException remoteException) {
            GamesLog.g("GamesClientImpl", "service died");
        }
        return n2;
    }

    public String gz() {
        try {
            return ((IGamesService)this.eM()).gz();
        }
        catch (RemoteException remoteException) {
            GamesLog.g("GamesClientImpl", "service died");
            return null;
        }
    }

    public void c(a.d<Invitations.LoadInvitationsResult> d2, int n2) {
        try {
            ((IGamesService)this.eM()).a((IGamesCallbacks)new InvitationsLoadedBinderCallback(d2), n2);
        }
        catch (RemoteException remoteException) {
            GamesLog.g("GamesClientImpl", "service died");
        }
    }

    public void l(String string2, int n2) {
        try {
            ((IGamesService)this.eM()).l(string2, n2);
        }
        catch (RemoteException remoteException) {
            GamesLog.g("GamesClientImpl", "service died");
        }
    }

    public void m(String string2, int n2) {
        try {
            ((IGamesService)this.eM()).m(string2, n2);
        }
        catch (RemoteException remoteException) {
            GamesLog.g("GamesClientImpl", "service died");
        }
    }

    public Intent a(int n2, int n3, boolean bl2) {
        Intent intent;
        try {
            intent = ((IGamesService)this.eM()).a(n2, n3, bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.g("GamesClientImpl", "service died");
            intent = null;
        }
        return intent;
    }

    public void a(a.d<TurnBasedMultiplayer.InitiateMatchResult> d2, TurnBasedMatchConfig turnBasedMatchConfig) {
        try {
            ((IGamesService)this.eM()).a((IGamesCallbacks)new TurnBasedMatchInitiatedBinderCallbacks(d2), turnBasedMatchConfig.getVariant(), turnBasedMatchConfig.getMinPlayers(), turnBasedMatchConfig.getInvitedPlayerIds(), turnBasedMatchConfig.getAutoMatchCriteria());
        }
        catch (RemoteException remoteException) {
            GamesLog.g("GamesClientImpl", "service died");
        }
    }

    public void d(a.d<TurnBasedMultiplayer.InitiateMatchResult> d2, String string2) {
        try {
            ((IGamesService)this.eM()).l(new TurnBasedMatchInitiatedBinderCallbacks(d2), string2);
        }
        catch (RemoteException remoteException) {
            GamesLog.g("GamesClientImpl", "service died");
        }
    }

    public void e(a.d<TurnBasedMultiplayer.InitiateMatchResult> d2, String string2) {
        try {
            ((IGamesService)this.eM()).m(new TurnBasedMatchInitiatedBinderCallbacks(d2), string2);
        }
        catch (RemoteException remoteException) {
            GamesLog.g("GamesClientImpl", "service died");
        }
    }

    public int gA() {
        int n2 = 2;
        try {
            n2 = ((IGamesService)this.eM()).gA();
        }
        catch (RemoteException remoteException) {
            GamesLog.g("GamesClientImpl", "service died");
        }
        return n2;
    }

    public void a(a.d<TurnBasedMultiplayer.UpdateMatchResult> d2, String string2, byte[] byArray, String string3, ParticipantResult[] participantResultArray) {
        try {
            ((IGamesService)this.eM()).a((IGamesCallbacks)new TurnBasedMatchUpdatedBinderCallbacks(d2), string2, byArray, string3, participantResultArray);
        }
        catch (RemoteException remoteException) {
            GamesLog.g("GamesClientImpl", "service died");
        }
    }

    public void a(a.d<TurnBasedMultiplayer.UpdateMatchResult> d2, String string2, byte[] byArray, ParticipantResult[] participantResultArray) {
        try {
            ((IGamesService)this.eM()).a((IGamesCallbacks)new TurnBasedMatchUpdatedBinderCallbacks(d2), string2, byArray, participantResultArray);
        }
        catch (RemoteException remoteException) {
            GamesLog.g("GamesClientImpl", "service died");
        }
    }

    public void f(a.d<TurnBasedMultiplayer.LeaveMatchResult> d2, String string2) {
        try {
            ((IGamesService)this.eM()).o(new TurnBasedMatchLeftBinderCallbacks(d2), string2);
        }
        catch (RemoteException remoteException) {
            GamesLog.g("GamesClientImpl", "service died");
        }
    }

    public void a(a.d<TurnBasedMultiplayer.LeaveMatchResult> d2, String string2, String string3) {
        try {
            ((IGamesService)this.eM()).c((IGamesCallbacks)new TurnBasedMatchLeftBinderCallbacks(d2), string2, string3);
        }
        catch (RemoteException remoteException) {
            GamesLog.g("GamesClientImpl", "service died");
        }
    }

    public void g(a.d<TurnBasedMultiplayer.CancelMatchResult> d2, String string2) {
        try {
            ((IGamesService)this.eM()).n(new TurnBasedMatchCanceledBinderCallbacks(d2), string2);
        }
        catch (RemoteException remoteException) {
            GamesLog.g("GamesClientImpl", "service died");
        }
    }

    public void aB(String string2) {
        try {
            ((IGamesService)this.eM()).aI(string2);
        }
        catch (RemoteException remoteException) {
            GamesLog.g("GamesClientImpl", "service died");
        }
    }

    public void a(a.d<TurnBasedMultiplayer.LoadMatchesResult> d2, int n2, int[] nArray) {
        try {
            ((IGamesService)this.eM()).a((IGamesCallbacks)new TurnBasedMatchesLoadedBinderCallbacks(d2), n2, nArray);
        }
        catch (RemoteException remoteException) {
            GamesLog.g("GamesClientImpl", "service died");
        }
    }

    public void h(a.d<TurnBasedMultiplayer.LoadMatchResult> d2, String string2) {
        try {
            ((IGamesService)this.eM()).p(new TurnBasedMatchLoadedBinderCallbacks(d2), string2);
        }
        catch (RemoteException remoteException) {
            GamesLog.g("GamesClientImpl", "service died");
        }
    }

    public Intent b(int n2, int n3, boolean bl2) {
        Intent intent;
        try {
            intent = ((IGamesService)this.eM()).b(n2, n3, bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.g("GamesClientImpl", "service died");
            intent = null;
        }
        return intent;
    }

    public void a(RoomConfig roomConfig) {
        try {
            RoomBinderCallbacks roomBinderCallbacks = new RoomBinderCallbacks(roomConfig.getRoomUpdateListener(), roomConfig.getRoomStatusUpdateListener(), roomConfig.getMessageReceivedListener());
            ((IGamesService)this.eM()).a((IGamesCallbacks)roomBinderCallbacks, (IBinder)this.IC, roomConfig.getVariant(), roomConfig.getInvitedPlayerIds(), roomConfig.getAutoMatchCriteria(), roomConfig.isSocketEnabled(), this.IE);
        }
        catch (RemoteException remoteException) {
            GamesLog.g("GamesClientImpl", "service died");
        }
    }

    public void b(RoomConfig roomConfig) {
        try {
            RoomBinderCallbacks roomBinderCallbacks = new RoomBinderCallbacks(roomConfig.getRoomUpdateListener(), roomConfig.getRoomStatusUpdateListener(), roomConfig.getMessageReceivedListener());
            ((IGamesService)this.eM()).a((IGamesCallbacks)roomBinderCallbacks, (IBinder)this.IC, roomConfig.getInvitationId(), roomConfig.isSocketEnabled(), this.IE);
        }
        catch (RemoteException remoteException) {
            GamesLog.g("GamesClientImpl", "service died");
        }
    }

    public void a(RoomUpdateListener roomUpdateListener, String string2) {
        try {
            ((IGamesService)this.eM()).c((IGamesCallbacks)new RoomBinderCallbacks(roomUpdateListener), string2);
            this.gE();
        }
        catch (RemoteException remoteException) {
            GamesLog.g("GamesClientImpl", "service died");
        }
    }

    public int a(RealTimeMultiplayer.ReliableMessageSentCallback reliableMessageSentCallback, byte[] byArray, String string2, String string3) {
        try {
            return ((IGamesService)this.eM()).a((IGamesCallbacks)new RealTimeReliableMessageBinderCallbacks(reliableMessageSentCallback), byArray, string2, string3);
        }
        catch (RemoteException remoteException) {
            GamesLog.g("GamesClientImpl", "service died");
            return -1;
        }
    }

    public int a(byte[] byArray, String string2, String[] stringArray) {
        fq.b(stringArray, (Object)"Participant IDs must not be null");
        try {
            return ((IGamesService)this.eM()).b(byArray, string2, stringArray);
        }
        catch (RemoteException remoteException) {
            GamesLog.g("GamesClientImpl", "service died");
            return -1;
        }
    }

    public int d(byte[] byArray, String string2) {
        try {
            return ((IGamesService)this.eM()).b(byArray, string2, null);
        }
        catch (RemoteException remoteException) {
            GamesLog.g("GamesClientImpl", "service died");
            return -1;
        }
    }

    public RealTimeSocket i(String string2, String string3) {
        if (string3 == null || !ParticipantUtils.aV(string3)) {
            throw new IllegalArgumentException("Bad participant ID");
        }
        RealTimeSocket realTimeSocket = this.Iv.get(string3);
        if (realTimeSocket == null || realTimeSocket.isClosed()) {
            return this.aC(string3);
        }
        return realTimeSocket;
    }

    private RealTimeSocket aC(String string2) {
        try {
            ParcelFileDescriptor parcelFileDescriptor = ((IGamesService)this.eM()).aJ(string2);
            if (parcelFileDescriptor != null) {
                GamesLog.f("GamesClientImpl", "Created native libjingle socket.");
                LibjingleNativeSocket libjingleNativeSocket = new LibjingleNativeSocket(parcelFileDescriptor);
                this.Iv.put(string2, libjingleNativeSocket);
                return libjingleNativeSocket;
            }
            GamesLog.f("GamesClientImpl", "Unable to create native libjingle socket, resorting to old socket.");
            String string3 = ((IGamesService)this.eM()).aE(string2);
            if (string3 == null) {
                return null;
            }
            LocalSocket localSocket = new LocalSocket();
            try {
                localSocket.connect(new LocalSocketAddress(string3));
            }
            catch (IOException iOException) {
                GamesLog.h("GamesClientImpl", "connect() call failed on socket: " + iOException.getMessage());
                return null;
            }
            RealTimeSocketImpl realTimeSocketImpl = new RealTimeSocketImpl(localSocket, string2);
            this.Iv.put(string2, realTimeSocketImpl);
            return realTimeSocketImpl;
        }
        catch (RemoteException remoteException) {
            GamesLog.h("GamesClientImpl", "Unable to create socket. Service died.");
            return null;
        }
    }

    public void aY(int n2) {
        try {
            ((IGamesService)this.eM()).aY(n2);
        }
        catch (RemoteException remoteException) {
            GamesLog.g("GamesClientImpl", "service died");
        }
    }

    public Intent gB() {
        Intent intent;
        try {
            intent = ((IGamesService)this.eM()).gB();
        }
        catch (RemoteException remoteException) {
            GamesLog.g("GamesClientImpl", "service died");
            intent = null;
        }
        return intent;
    }

    public Intent a(int n2, byte[] byArray, int n3, Bitmap bitmap, String string2) {
        Intent intent;
        try {
            intent = ((IGamesService)this.eM()).a(n2, byArray, n3, string2);
            fq.b(bitmap, (Object)"Must provide a non null icon");
            intent.putExtra("com.google.android.gms.games.REQUEST_ITEM_ICON", (Parcelable)bitmap);
        }
        catch (RemoteException remoteException) {
            GamesLog.g("GamesClientImpl", "service died");
            intent = null;
        }
        return intent;
    }

    public int gC() {
        int n2 = 2;
        try {
            n2 = ((IGamesService)this.eM()).gC();
        }
        catch (RemoteException remoteException) {
            GamesLog.g("GamesClientImpl", "service died");
        }
        return n2;
    }

    public int gD() {
        int n2 = 2;
        try {
            n2 = ((IGamesService)this.eM()).gD();
        }
        catch (RemoteException remoteException) {
            GamesLog.g("GamesClientImpl", "service died");
        }
        return n2;
    }

    public void b(a.d<Requests.UpdateRequestsResult> d2, String[] stringArray) {
        try {
            ((IGamesService)this.eM()).a((IGamesCallbacks)new RequestsUpdatedBinderCallbacks(d2), stringArray);
        }
        catch (RemoteException remoteException) {
            GamesLog.g("GamesClientImpl", "service died");
        }
    }

    public void c(a.d<Requests.UpdateRequestsResult> d2, String[] stringArray) {
        try {
            ((IGamesService)this.eM()).b((IGamesCallbacks)new RequestsUpdatedBinderCallbacks(d2), stringArray);
        }
        catch (RemoteException remoteException) {
            GamesLog.g("GamesClientImpl", "service died");
        }
    }

    public void a(a.d<Requests.LoadRequestsResult> d2, int n2, int n3, int n4) {
        try {
            ((IGamesService)this.eM()).a((IGamesCallbacks)new RequestsLoadedBinderCallbacks(d2), n2, n3, n4);
        }
        catch (RemoteException remoteException) {
            GamesLog.g("GamesClientImpl", "service died");
        }
    }

    public void b(a.d<GamesMetadata.LoadExtendedGamesResult> d2, String string2, int n2, boolean bl2, boolean bl3) {
        try {
            ((IGamesService)this.eM()).a((IGamesCallbacks)new ExtendedGamesLoadedBinderCallback(d2), string2, n2, bl2, bl3);
        }
        catch (RemoteException remoteException) {
            GamesLog.g("GamesClientImpl", "service died");
        }
    }

    public void i(a.d<GamesMetadata.LoadExtendedGamesResult> d2, String string2) {
        try {
            ((IGamesService)this.eM()).e(new ExtendedGamesLoadedBinderCallback(d2), string2);
        }
        catch (RemoteException remoteException) {
            GamesLog.g("GamesClientImpl", "service died");
        }
    }

    public void j(a.d<GamesMetadata.LoadGameInstancesResult> d2, String string2) {
        try {
            ((IGamesService)this.eM()).f(new GameInstancesLoadedBinderCallback(d2), string2);
        }
        catch (RemoteException remoteException) {
            GamesLog.g("GamesClientImpl", "service died");
        }
    }

    public void a(a.d<GamesMetadata.LoadExtendedGamesResult> d2, int n2, int n3, boolean bl2, boolean bl3) {
        try {
            ((IGamesService)this.eM()).a((IGamesCallbacks)new ExtendedGamesLoadedBinderCallback(d2), n2, n3, bl2, bl3);
        }
        catch (RemoteException remoteException) {
            GamesLog.g("GamesClientImpl", "service died");
        }
    }

    public void a(a.d<GamesMetadata.LoadExtendedGamesResult> d2, String string2, int n2, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        try {
            ((IGamesService)this.eM()).a((IGamesCallbacks)new ExtendedGamesLoadedBinderCallback(d2), string2, n2, bl2, bl3, bl4, bl5);
        }
        catch (RemoteException remoteException) {
            GamesLog.g("GamesClientImpl", "service died");
        }
    }

    public void c(a.d<GamesMetadata.LoadExtendedGamesResult> d2, String string2, int n2, boolean bl2, boolean bl3) {
        try {
            ((IGamesService)this.eM()).c(new ExtendedGamesLoadedBinderCallback(d2), string2, n2, bl2, bl3);
        }
        catch (RemoteException remoteException) {
            GamesLog.g("GamesClientImpl", "service died");
        }
    }

    public void k(a.d<GamesMetadata.LoadGameSearchSuggestionsResult> d2, String string2) {
        try {
            ((IGamesService)this.eM()).q(new GameSearchSuggestionsLoadedBinderCallback(d2), string2);
        }
        catch (RemoteException remoteException) {
            GamesLog.g("GamesClientImpl", "service died");
        }
    }

    public void b(a.d<Leaderboards.LeaderboardMetadataResult> d2, String string2, boolean bl2) {
        try {
            ((IGamesService)this.eM()).d((IGamesCallbacks)new LeaderboardsLoadedBinderCallback(d2), string2, bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.g("GamesClientImpl", "service died");
        }
    }

    public void a(a.d<Leaderboards.LeaderboardMetadataResult> d2, String string2, String string3, boolean bl2) {
        try {
            ((IGamesService)this.eM()).b((IGamesCallbacks)new LeaderboardsLoadedBinderCallback(d2), string2, string3, bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.g("GamesClientImpl", "service died");
        }
    }

    public void a(a.d<Leaderboards.LoadScoresResult> d2, String string2, String string3, int n2, int n3, int n4, boolean bl2) {
        try {
            ((IGamesService)this.eM()).a((IGamesCallbacks)new LeaderboardScoresLoadedBinderCallback(d2), string2, string3, n2, n3, n4, bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.g("GamesClientImpl", "service died");
        }
    }

    public void b(a.d<Leaderboards.LoadScoresResult> d2, String string2, String string3, int n2, int n3, int n4, boolean bl2) {
        try {
            ((IGamesService)this.eM()).b(new LeaderboardScoresLoadedBinderCallback(d2), string2, string3, n2, n3, n4, bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.g("GamesClientImpl", "service died");
        }
    }

    public void b(a.d<Players.LoadPlayersResult> d2, int n2, boolean bl2, boolean bl3) {
        try {
            ((IGamesService)this.eM()).b((IGamesCallbacks)new PlayersLoadedBinderCallback(d2), n2, bl2, bl3);
        }
        catch (RemoteException remoteException) {
            GamesLog.g("GamesClientImpl", "service died");
        }
    }

    public void c(a.d<Players.LoadPlayersResult> d2, int n2, boolean bl2, boolean bl3) {
        try {
            ((IGamesService)this.eM()).c(new PlayersLoadedBinderCallback(d2), n2, bl2, bl3);
        }
        catch (RemoteException remoteException) {
            GamesLog.g("GamesClientImpl", "service died");
        }
    }

    public void d(a.d<Players.LoadPlayersResult> d2, int n2, boolean bl2, boolean bl3) {
        try {
            ((IGamesService)this.eM()).e(new PlayersLoadedBinderCallback(d2), n2, bl2, bl3);
        }
        catch (RemoteException remoteException) {
            GamesLog.g("GamesClientImpl", "service died");
        }
    }

    public void a(a.d<Players.LoadPlayersResult> d2, String string2, int n2, boolean bl2) {
        try {
            ((IGamesService)this.eM()).a((IGamesCallbacks)new PlayersLoadedBinderCallback(d2), string2, n2, bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.g("GamesClientImpl", "service died");
        }
    }

    public void d(a.d<Players.LoadPlayersResult> d2, String string2, int n2, boolean bl2, boolean bl3) {
        try {
            ((IGamesService)this.eM()).b((IGamesCallbacks)new PlayersLoadedBinderCallback(d2), string2, n2, bl2, bl3);
        }
        catch (RemoteException remoteException) {
            GamesLog.g("GamesClientImpl", "service died");
        }
    }

    public void e(a.d<Players.LoadExtendedPlayersResult> d2, int n2, boolean bl2, boolean bl3) {
        try {
            ((IGamesService)this.eM()).d(new ExtendedPlayersLoadedBinderCallback(d2), n2, bl2, bl3);
        }
        catch (RemoteException remoteException) {
            GamesLog.g("GamesClientImpl", "service died");
        }
    }

    public void h(a.d<Players.LoadOwnerCoverPhotoUrisResult> d2) {
        try {
            ((IGamesService)this.eM()).j(new OwnerCoverPhotoUrisLoadedBinderCallback(d2));
        }
        catch (RemoteException remoteException) {
            GamesLog.g("GamesClientImpl", "service died");
        }
    }

    public void b(a.d<Achievements.LoadAchievementsResult> d2, String string2, String string3, boolean bl2) {
        try {
            ((IGamesService)this.eM()).a((IGamesCallbacks)new AchievementsLoadedBinderCallback(d2), string2, string3, bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.g("GamesClientImpl", "service died");
        }
    }

    public void b(a.d<TurnBasedMultiplayer.InitiateMatchResult> d2, String string2, String string3) {
        try {
            ((IGamesService)this.eM()).d((IGamesCallbacks)new TurnBasedMatchInitiatedBinderCallbacks(d2), string2, string3);
        }
        catch (RemoteException remoteException) {
            GamesLog.g("GamesClientImpl", "service died");
        }
    }

    public void c(a.d<TurnBasedMultiplayer.InitiateMatchResult> d2, String string2, String string3) {
        try {
            ((IGamesService)this.eM()).e(new TurnBasedMatchInitiatedBinderCallbacks(d2), string2, string3);
        }
        catch (RemoteException remoteException) {
            GamesLog.g("GamesClientImpl", "service died");
        }
    }

    public void c(a.d<Invitations.LoadInvitationsResult> d2, String string2, int n2) {
        try {
            ((IGamesService)this.eM()).b((IGamesCallbacks)new InvitationsLoadedBinderCallback(d2), string2, n2, false);
        }
        catch (RemoteException remoteException) {
            GamesLog.g("GamesClientImpl", "service died");
        }
    }

    public void l(a.d<Invitations.LoadInvitationsResult> d2, String string2) {
        try {
            ((IGamesService)this.eM()).k(new InvitationsLoadedBinderCallback(d2), string2);
        }
        catch (RemoteException remoteException) {
            GamesLog.g("GamesClientImpl", "service died");
        }
    }

    public void a(a.d<TurnBasedMultiplayer.LoadMatchesResult> d2, String string2, int n2, int[] nArray) {
        try {
            ((IGamesService)this.eM()).a((IGamesCallbacks)new TurnBasedMatchesLoadedBinderCallbacks(d2), string2, n2, nArray);
        }
        catch (RemoteException remoteException) {
            GamesLog.g("GamesClientImpl", "service died");
        }
    }

    public void i(a.d<Acls.LoadAclResult> d2) {
        try {
            ((IGamesService)this.eM()).h(new NotifyAclLoadedBinderCallback(d2));
        }
        catch (RemoteException remoteException) {
            GamesLog.g("GamesClientImpl", "service died");
        }
    }

    public void m(a.d<Status> d2, String string2) {
        try {
            ((IGamesService)this.eM()).j(new NotifyAclUpdatedBinderCallback(d2), string2);
        }
        catch (RemoteException remoteException) {
            GamesLog.g("GamesClientImpl", "service died");
        }
    }

    public void c(a.d<Notifications.GameMuteStatusChangeResult> d2, String string2, boolean bl2) {
        try {
            ((IGamesService)this.eM()).a((IGamesCallbacks)new GameMuteStatusChangedBinderCallback(d2), string2, bl2);
        }
        catch (RemoteException remoteException) {
            GamesLog.g("GamesClientImpl", "service died");
        }
    }

    public void n(a.d<Notifications.GameMuteStatusLoadResult> d2, String string2) {
        try {
            ((IGamesService)this.eM()).i(new GameMuteStatusLoadedBinderCallback(d2), string2);
        }
        catch (RemoteException remoteException) {
            GamesLog.g("GamesClientImpl", "service died");
        }
    }

    public void j(a.d<Notifications.ContactSettingLoadResult> d2) {
        try {
            ((IGamesService)this.eM()).i(new ContactSettingsLoadedBinderCallback(d2));
        }
        catch (RemoteException remoteException) {
            GamesLog.g("GamesClientImpl", "service died");
        }
    }

    public void a(a.d<Status> d2, boolean bl2, Bundle bundle) {
        try {
            ((IGamesService)this.eM()).a((IGamesCallbacks)new ContactSettingsUpdatedBinderCallback(d2), bl2, bundle);
        }
        catch (RemoteException remoteException) {
            GamesLog.g("GamesClientImpl", "service died");
        }
    }

    public void a(a.d<Requests.SendRequestResult> d2, String string2, String[] stringArray, int n2, byte[] byArray, int n3) {
        try {
            ((IGamesService)this.eM()).a((IGamesCallbacks)new RequestSentBinderCallbacks(d2), string2, stringArray, n2, byArray, n3);
        }
        catch (RemoteException remoteException) {
            GamesLog.g("GamesClientImpl", "service died");
        }
    }

    public void a(a.d<Requests.UpdateRequestsResult> d2, String string2, String string3, String[] stringArray) {
        try {
            ((IGamesService)this.eM()).a((IGamesCallbacks)new RequestsUpdatedBinderCallbacks(d2), string2, string3, stringArray);
        }
        catch (RemoteException remoteException) {
            GamesLog.g("GamesClientImpl", "service died");
        }
    }

    public void a(a.d<Requests.LoadRequestsResult> d2, String string2, String string3, int n2, int n3, int n4) {
        try {
            ((IGamesService)this.eM()).a((IGamesCallbacks)new RequestsLoadedBinderCallbacks(d2), string2, string3, n2, n3, n4);
        }
        catch (RemoteException remoteException) {
            GamesLog.g("GamesClientImpl", "service died");
        }
    }

    public void d(a.d<Requests.LoadRequestSummariesResult> d2, String string2, int n2) {
        try {
            ((IGamesService)this.eM()).a((IGamesCallbacks)new RequestSummariesLoadedBinderCallbacks(d2), string2, n2);
        }
        catch (RemoteException remoteException) {
            GamesLog.g("GamesClientImpl", "service died");
        }
    }

    private void gE() {
        for (RealTimeSocket realTimeSocket : this.Iv.values()) {
            try {
                realTimeSocket.close();
            }
            catch (IOException iOException) {
                GamesLog.a("GamesClientImpl", "IOException:", iOException);
            }
        }
        this.Iv.clear();
    }

    public void a(IBinder iBinder, Bundle bundle) {
        if (this.isConnected()) {
            try {
                ((IGamesService)this.eM()).a(iBinder, bundle);
            }
            catch (RemoteException remoteException) {
                GamesLog.g("GamesClientImpl", "service died");
            }
        }
    }

    public void gF() {
        if (this.isConnected()) {
            try {
                ((IGamesService)this.eM()).gF();
            }
            catch (RemoteException remoteException) {
                GamesLog.g("GamesClientImpl", "service died");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Room G(DataHolder dataHolder) {
        RoomBuffer roomBuffer = new RoomBuffer(dataHolder);
        Room room = null;
        try {
            if (roomBuffer.getCount() > 0) {
                room = (Room)((Room)roomBuffer.get(0)).freeze();
            }
        }
        finally {
            roomBuffer.close();
        }
        return room;
    }

    @Override
    protected void a(int n2, IBinder iBinder, Bundle bundle) {
        if (n2 == 0 && bundle != null) {
            this.Iz = bundle.getBoolean("show_welcome_popup");
        }
        super.a(n2, iBinder, bundle);
    }

    @Override
    protected /* synthetic */ IInterface r(IBinder iBinder) {
        return this.L(iBinder);
    }

    final class RequestSummariesLoadedCallback
    extends ResultDataHolderCallback<a.d<Requests.LoadRequestSummariesResult>>
    implements Requests.LoadRequestSummariesResult {
        RequestSummariesLoadedCallback(a.d<Requests.LoadRequestSummariesResult> resultHolder, DataHolder dataHolder) {
            super(GamesClientImpl.this, resultHolder, dataHolder);
        }

        @Override
        protected void a(a.d<Requests.LoadRequestSummariesResult> d2, DataHolder dataHolder) {
            d2.b(this);
        }
    }

    final class RequestsLoadedCallback
    extends ff.b<a.d<Requests.LoadRequestsResult>>
    implements Requests.LoadRequestsResult {
        private final Status wJ;
        private final Bundle Js;

        RequestsLoadedCallback(a.d<Requests.LoadRequestsResult> resultHolder, Status status, Bundle requestData) {
            super(resultHolder);
            this.wJ = status;
            this.Js = requestData;
        }

        protected void c(a.d<Requests.LoadRequestsResult> d2) {
            d2.b(this);
        }

        @Override
        public Status getStatus() {
            return this.wJ;
        }

        @Override
        public GameRequestBuffer getRequests(int requestType) {
            String string2 = RequestType.bd(requestType);
            if (!this.Js.containsKey(string2)) {
                return null;
            }
            DataHolder dataHolder = (DataHolder)this.Js.get(string2);
            return new GameRequestBuffer(dataHolder);
        }

        @Override
        protected void dx() {
            this.release();
        }

        @Override
        public void release() {
            for (String string2 : this.Js.keySet()) {
                DataHolder dataHolder = (DataHolder)this.Js.getParcelable(string2);
                if (dataHolder == null) continue;
                dataHolder.close();
            }
        }

        @Override
        protected /* synthetic */ void a(Object object) {
            this.c((a.d)object);
        }
    }

    final class RequestsUpdatedCallback
    extends ResultDataHolderCallback<a.d<Requests.UpdateRequestsResult>>
    implements Requests.UpdateRequestsResult {
        private final RequestUpdateOutcomes Ju;

        RequestsUpdatedCallback(a.d<Requests.UpdateRequestsResult> resultHolder, DataHolder dataHolder) {
            super(GamesClientImpl.this, resultHolder, dataHolder);
            this.Ju = RequestUpdateOutcomes.J(dataHolder);
        }

        @Override
        protected void a(a.d<Requests.UpdateRequestsResult> d2, DataHolder dataHolder) {
            d2.b(this);
        }

        @Override
        public int getRequestOutcome(String requestId) {
            return this.Ju.getRequestOutcome(requestId);
        }

        @Override
        public Set<String> getRequestIds() {
            return this.Ju.getRequestIds();
        }
    }

    final class RequestSentCallback
    extends ResultDataHolderCallback<a.d<Requests.SendRequestResult>>
    implements Requests.SendRequestResult {
        private final GameRequest Jn;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        RequestSentCallback(a.d<Requests.SendRequestResult> resultHolder, DataHolder dataHolder) {
            super(GamesClientImpl.this, resultHolder, dataHolder);
            GameRequestBuffer gameRequestBuffer = new GameRequestBuffer(dataHolder);
            try {
                this.Jn = gameRequestBuffer.getCount() > 0 ? (GameRequest)((GameRequest)gameRequestBuffer.get(0)).freeze() : null;
            }
            finally {
                gameRequestBuffer.close();
            }
        }

        @Override
        protected void a(a.d<Requests.SendRequestResult> d2, DataHolder dataHolder) {
            d2.b(this);
        }
    }

    final class SignOutCompleteCallback
    extends ff.b<a.d<Status>> {
        private final Status wJ;

        public SignOutCompleteCallback(a.d<Status> resultHolder, Status status) {
            super(resultHolder);
            this.wJ = status;
        }

        public void c(a.d<Status> d2) {
            d2.b(this.wJ);
        }

        @Override
        protected void dx() {
        }

        @Override
        public /* synthetic */ void a(Object object) {
            this.c((a.d)object);
        }
    }

    final class ContactSettingsUpdatedCallback
    extends ff.b<a.d<Status>> {
        private final Status wJ;

        ContactSettingsUpdatedCallback(a.d<Status> resultHolder, int statusCode) {
            super(resultHolder);
            this.wJ = new Status(statusCode);
        }

        protected void c(a.d<Status> d2) {
            d2.b(this.wJ);
        }

        @Override
        protected void dx() {
        }

        @Override
        protected /* synthetic */ void a(Object object) {
            this.c((a.d)object);
        }
    }

    final class ContactSettingsLoadedCallback
    extends ResultDataHolderCallback<a.d<Notifications.ContactSettingLoadResult>>
    implements Notifications.ContactSettingLoadResult {
        ContactSettingsLoadedCallback(a.d<Notifications.ContactSettingLoadResult> resultHolder, DataHolder dataHolder) {
            super(GamesClientImpl.this, resultHolder, dataHolder);
        }

        @Override
        protected void a(a.d<Notifications.ContactSettingLoadResult> d2, DataHolder dataHolder) {
            d2.b(this);
        }
    }

    final class GameMuteStatusLoadedCallback
    extends ff.b<a.d<Notifications.GameMuteStatusLoadResult>>
    implements Notifications.GameMuteStatusLoadResult {
        private final Status wJ;
        private final String IP;
        private final boolean IQ;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public GameMuteStatusLoadedCallback(a.d<Notifications.GameMuteStatusLoadResult> resultHolder, DataHolder dataHolder) {
            super(resultHolder);
            try {
                this.wJ = new Status(dataHolder.getStatusCode());
                if (dataHolder.getCount() > 0) {
                    this.IP = dataHolder.getString("external_game_id", 0, 0);
                    this.IQ = dataHolder.getBoolean("muted", 0, 0);
                } else {
                    this.IP = null;
                    this.IQ = false;
                }
            }
            finally {
                dataHolder.close();
            }
        }

        protected void c(a.d<Notifications.GameMuteStatusLoadResult> d2) {
            d2.b(this);
        }

        @Override
        protected void dx() {
        }

        @Override
        public Status getStatus() {
            return this.wJ;
        }

        @Override
        protected /* synthetic */ void a(Object object) {
            this.c((a.d)object);
        }
    }

    final class GameMuteStatusChangedCallback
    extends ff.b<a.d<Notifications.GameMuteStatusChangeResult>>
    implements Notifications.GameMuteStatusChangeResult {
        private final Status wJ;
        private final String IP;
        private final boolean IQ;

        public GameMuteStatusChangedCallback(a.d<Notifications.GameMuteStatusChangeResult> resultHolder, int statusCode, String externalGameId, boolean isMuted) {
            super(resultHolder);
            this.wJ = new Status(statusCode);
            this.IP = externalGameId;
            this.IQ = isMuted;
        }

        protected void c(a.d<Notifications.GameMuteStatusChangeResult> d2) {
            d2.b(this);
        }

        @Override
        protected void dx() {
        }

        @Override
        public Status getStatus() {
            return this.wJ;
        }

        @Override
        protected /* synthetic */ void a(Object object) {
            this.c((a.d)object);
        }
    }

    final class NotifyAclUpdatedCallback
    extends ff.b<a.d<Status>> {
        private final Status wJ;

        NotifyAclUpdatedCallback(a.d<Status> resultHolder, int statusCode) {
            super(resultHolder);
            this.wJ = new Status(statusCode);
        }

        protected void c(a.d<Status> d2) {
            d2.b(this.wJ);
        }

        @Override
        protected void dx() {
        }

        @Override
        protected /* synthetic */ void a(Object object) {
            this.c((a.d)object);
        }
    }

    final class NotifyAclLoadedCallback
    extends ResultDataHolderCallback<a.d<Acls.LoadAclResult>>
    implements Acls.LoadAclResult {
        NotifyAclLoadedCallback(a.d<Acls.LoadAclResult> resultHolder, DataHolder dataHolder) {
            super(GamesClientImpl.this, resultHolder, dataHolder);
        }

        @Override
        protected void a(a.d<Acls.LoadAclResult> d2, DataHolder dataHolder) {
            d2.b(this);
        }
    }

    final class RealTimeMessageSentCallback
    extends ff.b<RealTimeMultiplayer.ReliableMessageSentCallback> {
        private final int Ah;
        private final String Jj;
        private final int Jk;

        RealTimeMessageSentCallback(RealTimeMultiplayer.ReliableMessageSentCallback listener, int statusCode, int token, String recipientParticipantId) {
            super(listener);
            this.Ah = statusCode;
            this.Jk = token;
            this.Jj = recipientParticipantId;
        }

        @Override
        public void a(RealTimeMultiplayer.ReliableMessageSentCallback reliableMessageSentCallback) {
            if (reliableMessageSentCallback != null) {
                reliableMessageSentCallback.onRealTimeMessageSent(this.Ah, this.Jk, this.Jj);
            }
        }

        @Override
        protected void dx() {
        }
    }

    final class MessageReceivedCallback
    extends ff.b<RealTimeMessageReceivedListener> {
        private final RealTimeMessage Je;

        MessageReceivedCallback(RealTimeMessageReceivedListener listener, RealTimeMessage message) {
            super(listener);
            this.Je = message;
        }

        @Override
        public void a(RealTimeMessageReceivedListener realTimeMessageReceivedListener) {
            if (realTimeMessageReceivedListener != null) {
                realTimeMessageReceivedListener.onRealTimeMessageReceived(this.Je);
            }
        }

        @Override
        protected void dx() {
        }
    }

    final class P2PDisconnectedCallback
    extends ff.b<RoomStatusUpdateListener> {
        private final String Jg;

        P2PDisconnectedCallback(RoomStatusUpdateListener listener, String participantId) {
            super(listener);
            this.Jg = participantId;
        }

        @Override
        public void a(RoomStatusUpdateListener roomStatusUpdateListener) {
            if (roomStatusUpdateListener != null) {
                roomStatusUpdateListener.onP2PDisconnected(this.Jg);
            }
        }

        @Override
        protected void dx() {
        }
    }

    final class P2PConnectedCallback
    extends ff.b<RoomStatusUpdateListener> {
        private final String Jg;

        P2PConnectedCallback(RoomStatusUpdateListener listener, String participantId) {
            super(listener);
            this.Jg = participantId;
        }

        @Override
        public void a(RoomStatusUpdateListener roomStatusUpdateListener) {
            if (roomStatusUpdateListener != null) {
                roomStatusUpdateListener.onP2PConnected(this.Jg);
            }
        }

        @Override
        protected void dx() {
        }
    }

    final class PeerDisconnectedCallback
    extends AbstractPeerStatusCallback {
        PeerDisconnectedCallback(RoomStatusUpdateListener listener, DataHolder dataHolder, String[] participantIds) {
            super(listener, dataHolder, participantIds);
        }

        @Override
        protected void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeersDisconnected(room, arrayList);
        }
    }

    final class PeerConnectedCallback
    extends AbstractPeerStatusCallback {
        PeerConnectedCallback(RoomStatusUpdateListener listener, DataHolder dataHolder, String[] participantIds) {
            super(listener, dataHolder, participantIds);
        }

        @Override
        protected void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeersConnected(room, arrayList);
        }
    }

    final class PeerDeclinedCallback
    extends AbstractPeerStatusCallback {
        PeerDeclinedCallback(RoomStatusUpdateListener listener, DataHolder dataHolder, String[] participantIds) {
            super(listener, dataHolder, participantIds);
        }

        @Override
        protected void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeerDeclined(room, arrayList);
        }
    }

    final class PeerLeftRoomCallback
    extends AbstractPeerStatusCallback {
        PeerLeftRoomCallback(RoomStatusUpdateListener listener, DataHolder dataHolder, String[] participantIds) {
            super(listener, dataHolder, participantIds);
        }

        @Override
        protected void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeerLeft(room, arrayList);
        }
    }

    final class PeerJoinedRoomCallback
    extends AbstractPeerStatusCallback {
        PeerJoinedRoomCallback(RoomStatusUpdateListener listener, DataHolder dataHolder, String[] participantIds) {
            super(listener, dataHolder, participantIds);
        }

        @Override
        protected void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeerJoined(room, arrayList);
        }
    }

    final class PeerInvitedToRoomCallback
    extends AbstractPeerStatusCallback {
        PeerInvitedToRoomCallback(RoomStatusUpdateListener listener, DataHolder dataHolder, String[] participantIds) {
            super(listener, dataHolder, participantIds);
        }

        @Override
        protected void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room, ArrayList<String> arrayList) {
            roomStatusUpdateListener.onPeerInvitedToRoom(room, arrayList);
        }
    }

    final class DisconnectedFromRoomCallback
    extends AbstractRoomStatusCallback {
        DisconnectedFromRoomCallback(RoomStatusUpdateListener listener, DataHolder dataHolder) {
            super(listener, dataHolder);
        }

        @Override
        public void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            roomStatusUpdateListener.onDisconnectedFromRoom(room);
        }
    }

    final class ConnectedToRoomCallback
    extends AbstractRoomStatusCallback {
        ConnectedToRoomCallback(RoomStatusUpdateListener listener, DataHolder dataHolder) {
            super(listener, dataHolder);
        }

        @Override
        public void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            roomStatusUpdateListener.onConnectedToRoom(room);
        }
    }

    final class RoomAutoMatchingCallback
    extends AbstractRoomStatusCallback {
        RoomAutoMatchingCallback(RoomStatusUpdateListener listener, DataHolder dataHolder) {
            super(listener, dataHolder);
        }

        @Override
        public void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            roomStatusUpdateListener.onRoomAutoMatching(room);
        }
    }

    final class RoomConnectingCallback
    extends AbstractRoomStatusCallback {
        RoomConnectingCallback(RoomStatusUpdateListener listener, DataHolder dataHolder) {
            super(listener, dataHolder);
        }

        @Override
        public void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            roomStatusUpdateListener.onRoomConnecting(room);
        }
    }

    final class RoomConnectedCallback
    extends AbstractRoomCallback {
        RoomConnectedCallback(RoomUpdateListener listener, DataHolder dataHolder) {
            super(listener, dataHolder);
        }

        @Override
        public void a(RoomUpdateListener roomUpdateListener, Room room, int n2) {
            roomUpdateListener.onRoomConnected(n2, room);
        }
    }

    final class LeftRoomCallback
    extends ff.b<RoomUpdateListener> {
        private final int Ah;
        private final String Ja;

        LeftRoomCallback(RoomUpdateListener listener, int statusCode, String roomId) {
            super(listener);
            this.Ah = statusCode;
            this.Ja = roomId;
        }

        @Override
        public void a(RoomUpdateListener roomUpdateListener) {
            roomUpdateListener.onLeftRoom(this.Ah, this.Ja);
        }

        @Override
        protected void dx() {
        }
    }

    final class JoinedRoomCallback
    extends AbstractRoomCallback {
        public JoinedRoomCallback(RoomUpdateListener listener, DataHolder dataHolder) {
            super(listener, dataHolder);
        }

        @Override
        public void a(RoomUpdateListener roomUpdateListener, Room room, int n2) {
            roomUpdateListener.onJoinedRoom(n2, room);
        }
    }

    final class RoomCreatedCallback
    extends AbstractRoomCallback {
        public RoomCreatedCallback(RoomUpdateListener listener, DataHolder dataHolder) {
            super(listener, dataHolder);
        }

        @Override
        public void a(RoomUpdateListener roomUpdateListener, Room room, int n2) {
            roomUpdateListener.onRoomCreated(n2, room);
        }
    }

    abstract class AbstractPeerStatusCallback
    extends AbstractRoomStatusCallback {
        private final ArrayList<String> II;

        AbstractPeerStatusCallback(RoomStatusUpdateListener listener, DataHolder dataHolder, String[] participantIds) {
            super(listener, dataHolder);
            this.II = new ArrayList();
            int n2 = participantIds.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                this.II.add(participantIds[i2]);
            }
        }

        @Override
        protected void a(RoomStatusUpdateListener roomStatusUpdateListener, Room room) {
            this.a(roomStatusUpdateListener, room, this.II);
        }

        protected abstract void a(RoomStatusUpdateListener var1, Room var2, ArrayList<String> var3);
    }

    abstract class AbstractRoomStatusCallback
    extends ff.d<RoomStatusUpdateListener> {
        AbstractRoomStatusCallback(RoomStatusUpdateListener listener, DataHolder dataHolder) {
            super(listener, dataHolder);
        }

        @Override
        protected void a(RoomStatusUpdateListener roomStatusUpdateListener, DataHolder dataHolder) {
            this.a(roomStatusUpdateListener, GamesClientImpl.this.G(dataHolder));
        }

        protected abstract void a(RoomStatusUpdateListener var1, Room var2);
    }

    abstract class AbstractRoomCallback
    extends ff.d<RoomUpdateListener> {
        AbstractRoomCallback(RoomUpdateListener listener, DataHolder dataHolder) {
            super(listener, dataHolder);
        }

        @Override
        protected void a(RoomUpdateListener roomUpdateListener, DataHolder dataHolder) {
            this.a(roomUpdateListener, GamesClientImpl.this.G(dataHolder), dataHolder.getStatusCode());
        }

        protected abstract void a(RoomUpdateListener var1, Room var2, int var3);
    }

    final class TurnBasedMatchCanceledCallback
    extends ff.b<a.d<TurnBasedMultiplayer.CancelMatchResult>>
    implements TurnBasedMultiplayer.CancelMatchResult {
        private final Status wJ;
        private final String JA;

        TurnBasedMatchCanceledCallback(a.d<TurnBasedMultiplayer.CancelMatchResult> resultHolder, Status status, String externalMatchId) {
            super(resultHolder);
            this.wJ = status;
            this.JA = externalMatchId;
        }

        public void c(a.d<TurnBasedMultiplayer.CancelMatchResult> d2) {
            d2.b(this);
        }

        @Override
        protected void dx() {
        }

        @Override
        public Status getStatus() {
            return this.wJ;
        }

        @Override
        public String getMatchId() {
            return this.JA;
        }

        @Override
        public /* synthetic */ void a(Object object) {
            this.c((a.d)object);
        }
    }

    final class TurnBasedMatchLeftCallback
    extends TurnBasedMatchCallback<a.d<TurnBasedMultiplayer.LeaveMatchResult>>
    implements TurnBasedMultiplayer.LeaveMatchResult {
        TurnBasedMatchLeftCallback(a.d<TurnBasedMultiplayer.LeaveMatchResult> resultHolder, DataHolder dataHolder) {
            super(GamesClientImpl.this, resultHolder, dataHolder);
        }

        @Override
        protected void k(a.d<TurnBasedMultiplayer.LeaveMatchResult> d2) {
            d2.b(this);
        }
    }

    final class TurnBasedMatchUpdatedCallback
    extends TurnBasedMatchCallback<a.d<TurnBasedMultiplayer.UpdateMatchResult>>
    implements TurnBasedMultiplayer.UpdateMatchResult {
        TurnBasedMatchUpdatedCallback(a.d<TurnBasedMultiplayer.UpdateMatchResult> resultHolder, DataHolder dataHolder) {
            super(GamesClientImpl.this, resultHolder, dataHolder);
        }

        @Override
        protected void k(a.d<TurnBasedMultiplayer.UpdateMatchResult> d2) {
            d2.b(this);
        }
    }

    final class TurnBasedMatchInitiatedCallback
    extends TurnBasedMatchCallback<a.d<TurnBasedMultiplayer.InitiateMatchResult>>
    implements TurnBasedMultiplayer.InitiateMatchResult {
        TurnBasedMatchInitiatedCallback(a.d<TurnBasedMultiplayer.InitiateMatchResult> resultHolder, DataHolder dataHolder) {
            super(GamesClientImpl.this, resultHolder, dataHolder);
        }

        @Override
        protected void k(a.d<TurnBasedMultiplayer.InitiateMatchResult> d2) {
            d2.b(this);
        }
    }

    final class TurnBasedMatchLoadedCallback
    extends TurnBasedMatchCallback<a.d<TurnBasedMultiplayer.LoadMatchResult>>
    implements TurnBasedMultiplayer.LoadMatchResult {
        TurnBasedMatchLoadedCallback(a.d<TurnBasedMultiplayer.LoadMatchResult> resultHolder, DataHolder dataHolder) {
            super(GamesClientImpl.this, resultHolder, dataHolder);
        }

        @Override
        protected void k(a.d<TurnBasedMultiplayer.LoadMatchResult> d2) {
            d2.b(this);
        }
    }

    static abstract class TurnBasedMatchCallback<T extends a.d<?>>
    extends ResultDataHolderCallback<T> {
        final TurnBasedMatch Jd;
        final /* synthetic */ GamesClientImpl IJ;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        TurnBasedMatchCallback(T listener, DataHolder dataHolder) {
            this.IJ = var1_1;
            super((GamesClientImpl)var1_1, listener, dataHolder);
            TurnBasedMatchBuffer turnBasedMatchBuffer = new TurnBasedMatchBuffer(dataHolder);
            try {
                this.Jd = turnBasedMatchBuffer.getCount() > 0 ? (TurnBasedMatch)((TurnBasedMatch)turnBasedMatchBuffer.get(0)).freeze() : null;
            }
            finally {
                turnBasedMatchBuffer.close();
            }
        }

        @Override
        protected void a(T t2, DataHolder dataHolder) {
            this.k(t2);
        }

        abstract void k(T var1);

        public TurnBasedMatch getMatch() {
            return this.Jd;
        }
    }

    final class SubmitScoreCallback
    extends ResultDataHolderCallback<a.d<Leaderboards.SubmitScoreResult>>
    implements Leaderboards.SubmitScoreResult {
        private final ScoreSubmissionData Jy;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SubmitScoreCallback(a.d<Leaderboards.SubmitScoreResult> resultHolder, DataHolder dataHolder) {
            super(GamesClientImpl.this, resultHolder, dataHolder);
            try {
                this.Jy = new ScoreSubmissionData(dataHolder);
            }
            finally {
                dataHolder.close();
            }
        }

        @Override
        public void a(a.d<Leaderboards.SubmitScoreResult> d2, DataHolder dataHolder) {
            d2.b(this);
        }

        @Override
        public ScoreSubmissionData getScoreData() {
            return this.Jy;
        }
    }

    final class OwnerCoverPhotoUrisLoadedCallback
    extends ff.b<a.d<Players.LoadOwnerCoverPhotoUrisResult>>
    implements Players.LoadOwnerCoverPhotoUrisResult {
        private final Status wJ;
        private final Bundle Jf;

        OwnerCoverPhotoUrisLoadedCallback(a.d<Players.LoadOwnerCoverPhotoUrisResult> resultHolder, int statusCode, Bundle bundle) {
            super(resultHolder);
            this.wJ = new Status(statusCode);
            this.Jf = bundle;
        }

        protected void c(a.d<Players.LoadOwnerCoverPhotoUrisResult> d2) {
            d2.b(this);
        }

        @Override
        protected void dx() {
        }

        @Override
        public Status getStatus() {
            return this.wJ;
        }

        @Override
        protected /* synthetic */ void a(Object object) {
            this.c((a.d)object);
        }
    }

    final class ExtendedPlayersLoadedCallback
    extends ResultDataHolderCallback<a.d<Players.LoadExtendedPlayersResult>>
    implements Players.LoadExtendedPlayersResult {
        private final ExtendedPlayerBuffer IN;

        ExtendedPlayersLoadedCallback(a.d<Players.LoadExtendedPlayersResult> resultHolder, DataHolder dataHolder) {
            super(GamesClientImpl.this, resultHolder, dataHolder);
            this.IN = new ExtendedPlayerBuffer(dataHolder);
        }

        @Override
        protected void a(a.d<Players.LoadExtendedPlayersResult> d2, DataHolder dataHolder) {
            d2.b(this);
        }
    }

    final class PlayersLoadedCallback
    extends ResultDataHolderCallback<a.d<Players.LoadPlayersResult>>
    implements Players.LoadPlayersResult {
        private final PlayerBuffer Ji;

        PlayersLoadedCallback(a.d<Players.LoadPlayersResult> resultHolder, DataHolder dataHolder) {
            super(GamesClientImpl.this, resultHolder, dataHolder);
            this.Ji = new PlayerBuffer(dataHolder);
        }

        @Override
        protected void a(a.d<Players.LoadPlayersResult> d2, DataHolder dataHolder) {
            d2.b(this);
        }

        @Override
        public PlayerBuffer getPlayers() {
            return this.Ji;
        }
    }

    final class TurnBasedMatchesLoadedCallback
    extends ff.b<a.d<TurnBasedMultiplayer.LoadMatchesResult>>
    implements TurnBasedMultiplayer.LoadMatchesResult {
        private final Status wJ;
        private final LoadMatchesResponse JG;

        TurnBasedMatchesLoadedCallback(a.d<TurnBasedMultiplayer.LoadMatchesResult> resultHolder, Status status, Bundle matchData) {
            super(resultHolder);
            this.wJ = status;
            this.JG = new LoadMatchesResponse(matchData);
        }

        protected void c(a.d<TurnBasedMultiplayer.LoadMatchesResult> d2) {
            d2.b(this);
        }

        @Override
        protected void dx() {
        }

        @Override
        public Status getStatus() {
            return this.wJ;
        }

        @Override
        public LoadMatchesResponse getMatches() {
            return this.JG;
        }

        @Override
        public void release() {
            this.JG.close();
        }

        @Override
        protected /* synthetic */ void a(Object object) {
            this.c((a.d)object);
        }
    }

    final class RequestRemovedCallback
    extends ff.b<OnRequestReceivedListener> {
        private final String Jo;

        RequestRemovedCallback(OnRequestReceivedListener listener, String requestId) {
            super(listener);
            this.Jo = requestId;
        }

        protected void b(OnRequestReceivedListener onRequestReceivedListener) {
            onRequestReceivedListener.onRequestRemoved(this.Jo);
        }

        @Override
        protected void dx() {
        }

        @Override
        protected /* synthetic */ void a(Object object) {
            this.b((OnRequestReceivedListener)object);
        }
    }

    final class RequestReceivedCallback
    extends ff.b<OnRequestReceivedListener> {
        private final GameRequest Jn;

        RequestReceivedCallback(OnRequestReceivedListener listener, GameRequest request) {
            super(listener);
            this.Jn = request;
        }

        protected void b(OnRequestReceivedListener onRequestReceivedListener) {
            onRequestReceivedListener.onRequestReceived(this.Jn);
        }

        @Override
        protected void dx() {
        }

        @Override
        protected /* synthetic */ void a(Object object) {
            this.b((OnRequestReceivedListener)object);
        }
    }

    final class MatchRemovedCallback
    extends ff.b<OnTurnBasedMatchUpdateReceivedListener> {
        private final String Jb;

        MatchRemovedCallback(OnTurnBasedMatchUpdateReceivedListener listener, String matchId) {
            super(listener);
            this.Jb = matchId;
        }

        protected void b(OnTurnBasedMatchUpdateReceivedListener onTurnBasedMatchUpdateReceivedListener) {
            onTurnBasedMatchUpdateReceivedListener.onTurnBasedMatchRemoved(this.Jb);
        }

        @Override
        protected void dx() {
        }

        @Override
        protected /* synthetic */ void a(Object object) {
            this.b((OnTurnBasedMatchUpdateReceivedListener)object);
        }
    }

    final class MatchUpdateReceivedCallback
    extends ff.b<OnTurnBasedMatchUpdateReceivedListener> {
        private final TurnBasedMatch Jd;

        MatchUpdateReceivedCallback(OnTurnBasedMatchUpdateReceivedListener listener, TurnBasedMatch match) {
            super(listener);
            this.Jd = match;
        }

        protected void b(OnTurnBasedMatchUpdateReceivedListener onTurnBasedMatchUpdateReceivedListener) {
            onTurnBasedMatchUpdateReceivedListener.onTurnBasedMatchReceived(this.Jd);
        }

        @Override
        protected void dx() {
        }

        @Override
        protected /* synthetic */ void a(Object object) {
            this.b((OnTurnBasedMatchUpdateReceivedListener)object);
        }
    }

    final class InvitationRemovedCallback
    extends ff.b<OnInvitationReceivedListener> {
        private final String IV;

        InvitationRemovedCallback(OnInvitationReceivedListener listener, String invitationId) {
            super(listener);
            this.IV = invitationId;
        }

        protected void b(OnInvitationReceivedListener onInvitationReceivedListener) {
            onInvitationReceivedListener.onInvitationRemoved(this.IV);
        }

        @Override
        protected void dx() {
        }

        @Override
        protected /* synthetic */ void a(Object object) {
            this.b((OnInvitationReceivedListener)object);
        }
    }

    final class InvitationReceivedCallback
    extends ff.b<OnInvitationReceivedListener> {
        private final Invitation IU;

        InvitationReceivedCallback(OnInvitationReceivedListener listener, Invitation invitation) {
            super(listener);
            this.IU = invitation;
        }

        protected void b(OnInvitationReceivedListener onInvitationReceivedListener) {
            onInvitationReceivedListener.onInvitationReceived(this.IU);
        }

        @Override
        protected void dx() {
        }

        @Override
        protected /* synthetic */ void a(Object object) {
            this.b((OnInvitationReceivedListener)object);
        }
    }

    final class InvitationsLoadedCallback
    extends ResultDataHolderCallback<a.d<Invitations.LoadInvitationsResult>>
    implements Invitations.LoadInvitationsResult {
        private final InvitationBuffer IW;

        InvitationsLoadedCallback(a.d<Invitations.LoadInvitationsResult> resultHolder, DataHolder dataHolder) {
            super(GamesClientImpl.this, resultHolder, dataHolder);
            this.IW = new InvitationBuffer(dataHolder);
        }

        @Override
        protected void a(a.d<Invitations.LoadInvitationsResult> d2, DataHolder dataHolder) {
            d2.b(this);
        }

        @Override
        public InvitationBuffer getInvitations() {
            return this.IW;
        }
    }

    final class PlayerLeaderboardScoreLoadedCallback
    extends ff.d<a.d<Leaderboards.LoadPlayerScoreResult>>
    implements Leaderboards.LoadPlayerScoreResult {
        private final Status wJ;
        private final LeaderboardScoreEntity Jh;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        PlayerLeaderboardScoreLoadedCallback(a.d<Leaderboards.LoadPlayerScoreResult> resultHolder, DataHolder scoreHolder) {
            super(resultHolder, scoreHolder);
            this.wJ = new Status(scoreHolder.getStatusCode());
            LeaderboardScoreBuffer leaderboardScoreBuffer = new LeaderboardScoreBuffer(scoreHolder);
            try {
                this.Jh = leaderboardScoreBuffer.getCount() > 0 ? (LeaderboardScoreEntity)leaderboardScoreBuffer.get(0).freeze() : null;
            }
            finally {
                leaderboardScoreBuffer.close();
            }
        }

        @Override
        protected void a(a.d<Leaderboards.LoadPlayerScoreResult> d2, DataHolder dataHolder) {
            d2.b(this);
        }

        @Override
        public Status getStatus() {
            return this.wJ;
        }

        @Override
        public LeaderboardScore getScore() {
            return this.Jh;
        }
    }

    final class LeaderboardScoresLoadedCallback
    extends ResultDataHolderCallback<a.d<Leaderboards.LoadScoresResult>>
    implements Leaderboards.LoadScoresResult {
        private final LeaderboardEntity IX;
        private final LeaderboardScoreBuffer IY;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        LeaderboardScoresLoadedCallback(a.d<Leaderboards.LoadScoresResult> resultHolder, DataHolder leaderboard, DataHolder scores) {
            super(GamesClientImpl.this, resultHolder, scores);
            LeaderboardBuffer leaderboardBuffer = new LeaderboardBuffer(leaderboard);
            try {
                this.IX = leaderboardBuffer.getCount() > 0 ? (LeaderboardEntity)((Leaderboard)leaderboardBuffer.get(0)).freeze() : null;
            }
            finally {
                leaderboardBuffer.close();
            }
            this.IY = new LeaderboardScoreBuffer(scores);
        }

        @Override
        protected void a(a.d<Leaderboards.LoadScoresResult> d2, DataHolder dataHolder) {
            d2.b(this);
        }

        @Override
        public Leaderboard getLeaderboard() {
            return this.IX;
        }

        @Override
        public LeaderboardScoreBuffer getScores() {
            return this.IY;
        }
    }

    final class LeaderboardsLoadedCallback
    extends ResultDataHolderCallback<a.d<Leaderboards.LeaderboardMetadataResult>>
    implements Leaderboards.LeaderboardMetadataResult {
        private final LeaderboardBuffer IZ;

        LeaderboardsLoadedCallback(a.d<Leaderboards.LeaderboardMetadataResult> resultHolder, DataHolder dataHolder) {
            super(GamesClientImpl.this, resultHolder, dataHolder);
            this.IZ = new LeaderboardBuffer(dataHolder);
        }

        @Override
        protected void a(a.d<Leaderboards.LeaderboardMetadataResult> d2, DataHolder dataHolder) {
            d2.b(this);
        }

        @Override
        public LeaderboardBuffer getLeaderboards() {
            return this.IZ;
        }
    }

    final class GameSearchSuggestionsLoadedCallback
    extends ResultDataHolderCallback<a.d<GamesMetadata.LoadGameSearchSuggestionsResult>>
    implements GamesMetadata.LoadGameSearchSuggestionsResult {
        private final DataHolder IR;

        GameSearchSuggestionsLoadedCallback(a.d<GamesMetadata.LoadGameSearchSuggestionsResult> resultHolder, DataHolder data) {
            super(GamesClientImpl.this, resultHolder, data);
            this.IR = data;
        }

        @Override
        protected void a(a.d<GamesMetadata.LoadGameSearchSuggestionsResult> d2, DataHolder dataHolder) {
            d2.b(this);
        }
    }

    final class GameInstancesLoadedCallback
    extends ResultDataHolderCallback<a.d<GamesMetadata.LoadGameInstancesResult>>
    implements GamesMetadata.LoadGameInstancesResult {
        private final GameInstanceBuffer IO;

        GameInstancesLoadedCallback(a.d<GamesMetadata.LoadGameInstancesResult> resultHolder, DataHolder dataHolder) {
            super(GamesClientImpl.this, resultHolder, dataHolder);
            this.IO = new GameInstanceBuffer(dataHolder);
        }

        @Override
        protected void a(a.d<GamesMetadata.LoadGameInstancesResult> d2, DataHolder dataHolder) {
            d2.b(this);
        }
    }

    final class ExtendedGamesLoadedCallback
    extends ResultDataHolderCallback<a.d<GamesMetadata.LoadExtendedGamesResult>>
    implements GamesMetadata.LoadExtendedGamesResult {
        private final ExtendedGameBuffer IM;

        ExtendedGamesLoadedCallback(a.d<GamesMetadata.LoadExtendedGamesResult> resultHolder, DataHolder dataHolder) {
            super(GamesClientImpl.this, resultHolder, dataHolder);
            this.IM = new ExtendedGameBuffer(dataHolder);
        }

        @Override
        protected void a(a.d<GamesMetadata.LoadExtendedGamesResult> d2, DataHolder dataHolder) {
            d2.b(this);
        }
    }

    final class GamesLoadedCallback
    extends ResultDataHolderCallback<a.d<GamesMetadata.LoadGamesResult>>
    implements GamesMetadata.LoadGamesResult {
        private final GameBuffer IS;

        GamesLoadedCallback(a.d<GamesMetadata.LoadGamesResult> resultHolder, DataHolder dataHolder) {
            super(GamesClientImpl.this, resultHolder, dataHolder);
            this.IS = new GameBuffer(dataHolder);
        }

        @Override
        protected void a(a.d<GamesMetadata.LoadGamesResult> d2, DataHolder dataHolder) {
            d2.b(this);
        }

        @Override
        public GameBuffer getGames() {
            return this.IS;
        }
    }

    final class AchievementUpdatedCallback
    extends ff.b<a.d<Achievements.UpdateAchievementResult>>
    implements Achievements.UpdateAchievementResult {
        private final Status wJ;
        private final String IK;

        AchievementUpdatedCallback(a.d<Achievements.UpdateAchievementResult> resultHolder, int statusCode, String achievementId) {
            super(resultHolder);
            this.wJ = new Status(statusCode);
            this.IK = achievementId;
        }

        protected void c(a.d<Achievements.UpdateAchievementResult> d2) {
            d2.b(this);
        }

        @Override
        protected void dx() {
        }

        @Override
        public Status getStatus() {
            return this.wJ;
        }

        @Override
        public String getAchievementId() {
            return this.IK;
        }

        @Override
        protected /* synthetic */ void a(Object object) {
            this.c((a.d)object);
        }
    }

    final class AchievementsLoadedCallback
    extends ResultDataHolderCallback<a.d<Achievements.LoadAchievementsResult>>
    implements Achievements.LoadAchievementsResult {
        private final AchievementBuffer IL;

        AchievementsLoadedCallback(a.d<Achievements.LoadAchievementsResult> resultHolder, DataHolder dataHolder) {
            super(GamesClientImpl.this, resultHolder, dataHolder);
            this.IL = new AchievementBuffer(dataHolder);
        }

        @Override
        protected void a(a.d<Achievements.LoadAchievementsResult> d2, DataHolder dataHolder) {
            d2.b(this);
        }

        @Override
        public AchievementBuffer getAchievements() {
            return this.IL;
        }
    }

    static abstract class ResultDataHolderCallback<R extends a.d<?>>
    extends ff.d<R>
    implements Releasable,
    Result {
        final Status wJ;
        final DataHolder BB;
        final /* synthetic */ GamesClientImpl IJ;

        public ResultDataHolderCallback(R resultHolder, DataHolder dataHolder) {
            this.IJ = var1_1;
            super(resultHolder, dataHolder);
            this.wJ = new Status(dataHolder.getStatusCode());
            this.BB = dataHolder;
        }

        @Override
        public Status getStatus() {
            return this.wJ;
        }

        @Override
        public void release() {
            if (this.BB != null) {
                this.BB.close();
            }
        }
    }

    final class RequestSummariesLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final a.d<Requests.LoadRequestSummariesResult> Jq;

        public RequestSummariesLoadedBinderCallbacks(a.d<Requests.LoadRequestSummariesResult> resultHolder) {
            this.Jq = fq.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void F(DataHolder dataHolder) {
            GamesClientImpl.this.a(new RequestSummariesLoadedCallback(this.Jq, dataHolder));
        }
    }

    final class RequestsLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final a.d<Requests.LoadRequestsResult> Jr;

        public RequestsLoadedBinderCallbacks(a.d<Requests.LoadRequestsResult> resultHolder) {
            this.Jr = fq.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void b(int n2, Bundle bundle) {
            bundle.setClassLoader(this.getClass().getClassLoader());
            Status status = new Status(n2);
            GamesClientImpl.this.a(new RequestsLoadedCallback(this.Jr, status, bundle));
        }
    }

    final class RequestSentBinderCallbacks
    extends AbstractGamesCallbacks {
        private final a.d<Requests.SendRequestResult> Jp;

        public RequestSentBinderCallbacks(a.d<Requests.SendRequestResult> resultHolder) {
            this.Jp = fq.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void E(DataHolder dataHolder) {
            GamesClientImpl.this.a(new RequestSentCallback(this.Jp, dataHolder));
        }
    }

    final class RequestsUpdatedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final a.d<Requests.UpdateRequestsResult> Jt;

        public RequestsUpdatedBinderCallbacks(a.d<Requests.UpdateRequestsResult> resultHolder) {
            this.Jt = fq.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void D(DataHolder dataHolder) {
            GamesClientImpl.this.a(new RequestsUpdatedCallback(this.Jt, dataHolder));
        }
    }

    final class SignOutCompleteBinderCallbacks
    extends AbstractGamesCallbacks {
        private final a.d<Status> wH;

        public SignOutCompleteBinderCallbacks(a.d<Status> resultHolder) {
            this.wH = fq.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void du() {
            Status status = new Status(0);
            GamesClientImpl.this.a(new SignOutCompleteCallback(this.wH, status));
        }
    }

    final class ContactSettingsUpdatedBinderCallback
    extends AbstractGamesCallbacks {
        private final a.d<Status> wH;

        ContactSettingsUpdatedBinderCallback(a.d<Status> holder) {
            this.wH = fq.b(holder, (Object)"Holder must not be null");
        }

        @Override
        public void aV(int n2) {
            GamesClientImpl.this.a(new ContactSettingsUpdatedCallback(this.wH, n2));
        }
    }

    final class ContactSettingsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final a.d<Notifications.ContactSettingLoadResult> wH;

        ContactSettingsLoadedBinderCallback(a.d<Notifications.ContactSettingLoadResult> holder) {
            this.wH = fq.b(holder, (Object)"Holder must not be null");
        }

        @Override
        public void B(DataHolder dataHolder) {
            GamesClientImpl.this.a(new ContactSettingsLoadedCallback(this.wH, dataHolder));
        }
    }

    final class GameMuteStatusLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final a.d<Notifications.GameMuteStatusLoadResult> wH;

        GameMuteStatusLoadedBinderCallback(a.d<Notifications.GameMuteStatusLoadResult> holder) {
            this.wH = fq.b(holder, (Object)"Holder must not be null");
        }

        @Override
        public void z(DataHolder dataHolder) {
            GamesClientImpl.this.a(new GameMuteStatusLoadedCallback(this.wH, dataHolder));
        }
    }

    final class GameMuteStatusChangedBinderCallback
    extends AbstractGamesCallbacks {
        private final a.d<Notifications.GameMuteStatusChangeResult> wH;

        GameMuteStatusChangedBinderCallback(a.d<Notifications.GameMuteStatusChangeResult> holder) {
            this.wH = fq.b(holder, (Object)"Holder must not be null");
        }

        @Override
        public void a(int n2, String string2, boolean bl2) {
            GamesClientImpl.this.a(new GameMuteStatusChangedCallback(this.wH, n2, string2, bl2));
        }
    }

    final class NotifyAclUpdatedBinderCallback
    extends AbstractGamesCallbacks {
        private final a.d<Status> wH;

        NotifyAclUpdatedBinderCallback(a.d<Status> resultHolder) {
            this.wH = fq.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void aU(int n2) {
            GamesClientImpl.this.a(new NotifyAclUpdatedCallback(this.wH, n2));
        }
    }

    final class NotifyAclLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final a.d<Acls.LoadAclResult> wH;

        NotifyAclLoadedBinderCallback(a.d<Acls.LoadAclResult> resultHolder) {
            this.wH = fq.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void A(DataHolder dataHolder) {
            GamesClientImpl.this.a(new NotifyAclLoadedCallback(this.wH, dataHolder));
        }
    }

    final class RealTimeReliableMessageBinderCallbacks
    extends AbstractGamesCallbacks {
        final RealTimeMultiplayer.ReliableMessageSentCallback Jl;

        public RealTimeReliableMessageBinderCallbacks(RealTimeMultiplayer.ReliableMessageSentCallback messageSentCallbacks) {
            this.Jl = messageSentCallbacks;
        }

        @Override
        public void b(int n2, int n3, String string2) {
            GamesClientImpl.this.a(new RealTimeMessageSentCallback(this.Jl, n2, n3, string2));
        }
    }

    final class RoomBinderCallbacks
    extends AbstractGamesCallbacks {
        private final RoomUpdateListener Jv;
        private final RoomStatusUpdateListener Jw;
        private final RealTimeMessageReceivedListener Jx;

        public RoomBinderCallbacks(RoomUpdateListener roomCallbacks) {
            this.Jv = fq.b(roomCallbacks, (Object)"Callbacks must not be null");
            this.Jw = null;
            this.Jx = null;
        }

        public RoomBinderCallbacks(RoomUpdateListener roomCallbacks, RoomStatusUpdateListener roomStatusCallbacks, RealTimeMessageReceivedListener realTimeMessageReceivedCallbacks) {
            this.Jv = fq.b(roomCallbacks, (Object)"Callbacks must not be null");
            this.Jw = roomStatusCallbacks;
            this.Jx = realTimeMessageReceivedCallbacks;
        }

        @Override
        public void s(DataHolder dataHolder) {
            GamesClientImpl.this.a(new RoomCreatedCallback(this.Jv, dataHolder));
        }

        @Override
        public void t(DataHolder dataHolder) {
            GamesClientImpl.this.a(new JoinedRoomCallback(this.Jv, dataHolder));
        }

        @Override
        public void onLeftRoom(int statusCode, String externalRoomId) {
            GamesClientImpl.this.a(new LeftRoomCallback(this.Jv, statusCode, externalRoomId));
        }

        @Override
        public void w(DataHolder dataHolder) {
            GamesClientImpl.this.a(new RoomConnectedCallback(this.Jv, dataHolder));
        }

        @Override
        public void u(DataHolder dataHolder) {
            GamesClientImpl.this.a(new RoomConnectingCallback(this.Jw, dataHolder));
        }

        @Override
        public void v(DataHolder dataHolder) {
            GamesClientImpl.this.a(new RoomAutoMatchingCallback(this.Jw, dataHolder));
        }

        @Override
        public void x(DataHolder dataHolder) {
            GamesClientImpl.this.a(new ConnectedToRoomCallback(this.Jw, dataHolder));
        }

        @Override
        public void y(DataHolder dataHolder) {
            GamesClientImpl.this.a(new DisconnectedFromRoomCallback(this.Jw, dataHolder));
        }

        @Override
        public void e(DataHolder dataHolder, String[] stringArray) {
            GamesClientImpl.this.a(new PeerConnectedCallback(this.Jw, dataHolder, stringArray));
        }

        @Override
        public void f(DataHolder dataHolder, String[] stringArray) {
            GamesClientImpl.this.a(new PeerDisconnectedCallback(this.Jw, dataHolder, stringArray));
        }

        @Override
        public void a(DataHolder dataHolder, String[] stringArray) {
            GamesClientImpl.this.a(new PeerInvitedToRoomCallback(this.Jw, dataHolder, stringArray));
        }

        @Override
        public void b(DataHolder dataHolder, String[] stringArray) {
            GamesClientImpl.this.a(new PeerJoinedRoomCallback(this.Jw, dataHolder, stringArray));
        }

        @Override
        public void c(DataHolder dataHolder, String[] stringArray) {
            GamesClientImpl.this.a(new PeerLeftRoomCallback(this.Jw, dataHolder, stringArray));
        }

        @Override
        public void d(DataHolder dataHolder, String[] stringArray) {
            GamesClientImpl.this.a(new PeerDeclinedCallback(this.Jw, dataHolder, stringArray));
        }

        @Override
        public void onP2PConnected(String participantId) {
            GamesClientImpl.this.a(new P2PConnectedCallback(this.Jw, participantId));
        }

        @Override
        public void onP2PDisconnected(String participantId) {
            GamesClientImpl.this.a(new P2PDisconnectedCallback(this.Jw, participantId));
        }

        @Override
        public void onRealTimeMessageReceived(RealTimeMessage message) {
            GamesClientImpl.this.a(new MessageReceivedCallback(this.Jx, message));
        }
    }

    final class TurnBasedMatchCanceledBinderCallbacks
    extends AbstractGamesCallbacks {
        private final a.d<TurnBasedMultiplayer.CancelMatchResult> Jz;

        public TurnBasedMatchCanceledBinderCallbacks(a.d<TurnBasedMultiplayer.CancelMatchResult> resultHolder) {
            this.Jz = fq.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void f(int n2, String string2) {
            Status status = new Status(n2);
            GamesClientImpl.this.a(new TurnBasedMatchCanceledCallback(this.Jz, status, string2));
        }
    }

    final class TurnBasedMatchLeftBinderCallbacks
    extends AbstractGamesCallbacks {
        private final a.d<TurnBasedMultiplayer.LeaveMatchResult> JC;

        public TurnBasedMatchLeftBinderCallbacks(a.d<TurnBasedMultiplayer.LeaveMatchResult> resultHolder) {
            this.JC = fq.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void q(DataHolder dataHolder) {
            GamesClientImpl.this.a(new TurnBasedMatchLeftCallback(this.JC, dataHolder));
        }
    }

    final class TurnBasedMatchUpdatedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final a.d<TurnBasedMultiplayer.UpdateMatchResult> JE;

        public TurnBasedMatchUpdatedBinderCallbacks(a.d<TurnBasedMultiplayer.UpdateMatchResult> resultHolder) {
            this.JE = fq.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void p(DataHolder dataHolder) {
            GamesClientImpl.this.a(new TurnBasedMatchUpdatedCallback(this.JE, dataHolder));
        }
    }

    final class TurnBasedMatchInitiatedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final a.d<TurnBasedMultiplayer.InitiateMatchResult> JB;

        public TurnBasedMatchInitiatedBinderCallbacks(a.d<TurnBasedMultiplayer.InitiateMatchResult> resultHolder) {
            this.JB = fq.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void o(DataHolder dataHolder) {
            GamesClientImpl.this.a(new TurnBasedMatchInitiatedCallback(this.JB, dataHolder));
        }
    }

    final class TurnBasedMatchLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final a.d<TurnBasedMultiplayer.LoadMatchResult> JD;

        public TurnBasedMatchLoadedBinderCallbacks(a.d<TurnBasedMultiplayer.LoadMatchResult> resultHolder) {
            this.JD = fq.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void n(DataHolder dataHolder) {
            GamesClientImpl.this.a(new TurnBasedMatchLoadedCallback(this.JD, dataHolder));
        }
    }

    final class TurnBasedMatchesLoadedBinderCallbacks
    extends AbstractGamesCallbacks {
        private final a.d<TurnBasedMultiplayer.LoadMatchesResult> JF;

        public TurnBasedMatchesLoadedBinderCallbacks(a.d<TurnBasedMultiplayer.LoadMatchesResult> resultHolder) {
            this.JF = fq.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void a(int n2, Bundle bundle) {
            bundle.setClassLoader(this.getClass().getClassLoader());
            Status status = new Status(n2);
            GamesClientImpl.this.a(new TurnBasedMatchesLoadedCallback(this.JF, status, bundle));
        }
    }

    final class SubmitScoreBinderCallbacks
    extends AbstractGamesCallbacks {
        private final a.d<Leaderboards.SubmitScoreResult> wH;

        public SubmitScoreBinderCallbacks(a.d<Leaderboards.SubmitScoreResult> resultHolder) {
            this.wH = fq.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void d(DataHolder dataHolder) {
            GamesClientImpl.this.a(new SubmitScoreCallback(this.wH, dataHolder));
        }
    }

    final class OwnerCoverPhotoUrisLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final a.d<Players.LoadOwnerCoverPhotoUrisResult> wH;

        OwnerCoverPhotoUrisLoadedBinderCallback(a.d<Players.LoadOwnerCoverPhotoUrisResult> holder) {
            this.wH = fq.b(holder, (Object)"Holder must not be null");
        }

        @Override
        public void c(int n2, Bundle bundle) {
            bundle.setClassLoader(this.getClass().getClassLoader());
            GamesClientImpl.this.a(new OwnerCoverPhotoUrisLoadedCallback(this.wH, n2, bundle));
        }
    }

    final class ExtendedPlayersLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final a.d<Players.LoadExtendedPlayersResult> wH;

        ExtendedPlayersLoadedBinderCallback(a.d<Players.LoadExtendedPlayersResult> holder) {
            this.wH = fq.b(holder, (Object)"Holder must not be null");
        }

        @Override
        public void f(DataHolder dataHolder) {
            GamesClientImpl.this.a(new ExtendedPlayersLoadedCallback(this.wH, dataHolder));
        }
    }

    final class PlayersLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final a.d<Players.LoadPlayersResult> wH;

        PlayersLoadedBinderCallback(a.d<Players.LoadPlayersResult> holder) {
            this.wH = fq.b(holder, (Object)"Holder must not be null");
        }

        @Override
        public void e(DataHolder dataHolder) {
            GamesClientImpl.this.a(new PlayersLoadedCallback(this.wH, dataHolder));
        }
    }

    final class RequestReceivedBinderCallback
    extends AbstractGamesCallbacks {
        private final OnRequestReceivedListener Jm;

        RequestReceivedBinderCallback(OnRequestReceivedListener listener) {
            this.Jm = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void m(DataHolder dataHolder) {
            GameRequestBuffer gameRequestBuffer = new GameRequestBuffer(dataHolder);
            GameRequest gameRequest = null;
            try {
                if (gameRequestBuffer.getCount() > 0) {
                    gameRequest = (GameRequest)((GameRequest)gameRequestBuffer.get(0)).freeze();
                }
            }
            finally {
                gameRequestBuffer.close();
            }
            if (gameRequest != null) {
                GamesClientImpl.this.a(new RequestReceivedCallback(this.Jm, gameRequest));
            }
        }

        @Override
        public void onRequestRemoved(String requestId) {
            GamesClientImpl.this.a(new RequestRemovedCallback(this.Jm, requestId));
        }
    }

    final class MatchUpdateReceivedBinderCallback
    extends AbstractGamesCallbacks {
        private final OnTurnBasedMatchUpdateReceivedListener Jc;

        MatchUpdateReceivedBinderCallback(OnTurnBasedMatchUpdateReceivedListener listener) {
            this.Jc = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void r(DataHolder dataHolder) {
            TurnBasedMatchBuffer turnBasedMatchBuffer = new TurnBasedMatchBuffer(dataHolder);
            TurnBasedMatch turnBasedMatch = null;
            try {
                if (turnBasedMatchBuffer.getCount() > 0) {
                    turnBasedMatch = (TurnBasedMatch)((TurnBasedMatch)turnBasedMatchBuffer.get(0)).freeze();
                }
            }
            finally {
                turnBasedMatchBuffer.close();
            }
            if (turnBasedMatch != null) {
                GamesClientImpl.this.a(new MatchUpdateReceivedCallback(this.Jc, turnBasedMatch));
            }
        }

        @Override
        public void onTurnBasedMatchRemoved(String matchId) {
            GamesClientImpl.this.a(new MatchRemovedCallback(this.Jc, matchId));
        }
    }

    final class InvitationReceivedBinderCallback
    extends AbstractGamesCallbacks {
        private final OnInvitationReceivedListener IT;

        InvitationReceivedBinderCallback(OnInvitationReceivedListener listener) {
            this.IT = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void l(DataHolder dataHolder) {
            InvitationBuffer invitationBuffer = new InvitationBuffer(dataHolder);
            Invitation invitation = null;
            try {
                if (invitationBuffer.getCount() > 0) {
                    invitation = (Invitation)((Invitation)invitationBuffer.get(0)).freeze();
                }
            }
            finally {
                invitationBuffer.close();
            }
            if (invitation != null) {
                GamesClientImpl.this.a(new InvitationReceivedCallback(this.IT, invitation));
            }
        }

        @Override
        public void onInvitationRemoved(String invitationId) {
            GamesClientImpl.this.a(new InvitationRemovedCallback(this.IT, invitationId));
        }
    }

    final class InvitationsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final a.d<Invitations.LoadInvitationsResult> wH;

        InvitationsLoadedBinderCallback(a.d<Invitations.LoadInvitationsResult> resultHolder) {
            this.wH = fq.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void k(DataHolder dataHolder) {
            GamesClientImpl.this.a(new InvitationsLoadedCallback(this.wH, dataHolder));
        }
    }

    final class PlayerLeaderboardScoreLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final a.d<Leaderboards.LoadPlayerScoreResult> wH;

        PlayerLeaderboardScoreLoadedBinderCallback(a.d<Leaderboards.LoadPlayerScoreResult> resultHolder) {
            this.wH = fq.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void C(DataHolder dataHolder) {
            GamesClientImpl.this.a(new PlayerLeaderboardScoreLoadedCallback(this.wH, dataHolder));
        }
    }

    final class LeaderboardScoresLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final a.d<Leaderboards.LoadScoresResult> wH;

        LeaderboardScoresLoadedBinderCallback(a.d<Leaderboards.LoadScoresResult> resultHolder) {
            this.wH = fq.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void a(DataHolder dataHolder, DataHolder dataHolder2) {
            GamesClientImpl.this.a(new LeaderboardScoresLoadedCallback(this.wH, dataHolder, dataHolder2));
        }
    }

    final class LeaderboardsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final a.d<Leaderboards.LeaderboardMetadataResult> wH;

        LeaderboardsLoadedBinderCallback(a.d<Leaderboards.LeaderboardMetadataResult> resultHolder) {
            this.wH = fq.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void c(DataHolder dataHolder) {
            GamesClientImpl.this.a(new LeaderboardsLoadedCallback(this.wH, dataHolder));
        }
    }

    final class GameSearchSuggestionsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final a.d<GamesMetadata.LoadGameSearchSuggestionsResult> wH;

        GameSearchSuggestionsLoadedBinderCallback(a.d<GamesMetadata.LoadGameSearchSuggestionsResult> holder) {
            this.wH = fq.b(holder, (Object)"Holder must not be null");
        }

        @Override
        public void j(DataHolder dataHolder) {
            GamesClientImpl.this.a(new GameSearchSuggestionsLoadedCallback(this.wH, dataHolder));
        }
    }

    final class GameInstancesLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final a.d<GamesMetadata.LoadGameInstancesResult> wH;

        GameInstancesLoadedBinderCallback(a.d<GamesMetadata.LoadGameInstancesResult> holder) {
            this.wH = fq.b(holder, (Object)"Holder must not be null");
        }

        @Override
        public void i(DataHolder dataHolder) {
            GamesClientImpl.this.a(new GameInstancesLoadedCallback(this.wH, dataHolder));
        }
    }

    final class ExtendedGamesLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final a.d<GamesMetadata.LoadExtendedGamesResult> wH;

        ExtendedGamesLoadedBinderCallback(a.d<GamesMetadata.LoadExtendedGamesResult> holder) {
            this.wH = fq.b(holder, (Object)"Holder must not be null");
        }

        @Override
        public void h(DataHolder dataHolder) {
            GamesClientImpl.this.a(new ExtendedGamesLoadedCallback(this.wH, dataHolder));
        }
    }

    final class GamesLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final a.d<GamesMetadata.LoadGamesResult> wH;

        GamesLoadedBinderCallback(a.d<GamesMetadata.LoadGamesResult> holder) {
            this.wH = fq.b(holder, (Object)"Holder must not be null");
        }

        @Override
        public void g(DataHolder dataHolder) {
            GamesClientImpl.this.a(new GamesLoadedCallback(this.wH, dataHolder));
        }
    }

    final class AchievementUpdatedBinderCallback
    extends AbstractGamesCallbacks {
        private final a.d<Achievements.UpdateAchievementResult> wH;

        AchievementUpdatedBinderCallback(a.d<Achievements.UpdateAchievementResult> resultHolder) {
            this.wH = fq.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void e(int n2, String string2) {
            GamesClientImpl.this.a(new AchievementUpdatedCallback(this.wH, n2, string2));
        }
    }

    final class AchievementsLoadedBinderCallback
    extends AbstractGamesCallbacks {
        private final a.d<Achievements.LoadAchievementsResult> wH;

        AchievementsLoadedBinderCallback(a.d<Achievements.LoadAchievementsResult> resultHolder) {
            this.wH = fq.b(resultHolder, (Object)"Holder must not be null");
        }

        @Override
        public void b(DataHolder dataHolder) {
            GamesClientImpl.this.a(new AchievementsLoadedCallback(this.wH, dataHolder));
        }
    }
}

