/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.text.TextUtils;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.data.b;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;

public final class PlayerRef
extends b
implements Player {
    private final PlayerColumnNames Ii;

    public PlayerRef(DataHolder holder, int dataRow) {
        this(holder, dataRow, null);
    }

    public PlayerRef(DataHolder holder, int dataRow, String prefix) {
        super(holder, dataRow);
        this.Ii = new PlayerColumnNames(prefix);
    }

    @Override
    public String getPlayerId() {
        return this.getString(this.Ii.Ij);
    }

    @Override
    public String getDisplayName() {
        return this.getString(this.Ii.Ik);
    }

    @Override
    public void getDisplayName(CharArrayBuffer dataOut) {
        this.a(this.Ii.Ik, dataOut);
    }

    @Override
    public boolean hasIconImage() {
        return this.getIconImageUri() != null;
    }

    @Override
    public Uri getIconImageUri() {
        return this.ah(this.Ii.Il);
    }

    @Override
    public String getIconImageUrl() {
        return this.getString(this.Ii.Im);
    }

    @Override
    public boolean hasHiResImage() {
        return this.getHiResImageUri() != null;
    }

    @Override
    public Uri getHiResImageUri() {
        return this.ah(this.Ii.In);
    }

    @Override
    public String getHiResImageUrl() {
        return this.getString(this.Ii.Io);
    }

    @Override
    public long getRetrievedTimestamp() {
        return this.getLong(this.Ii.Ip);
    }

    @Override
    public long getLastPlayedWithTimestamp() {
        if (!this.hasColumn(this.Ii.Ir)) {
            return -1L;
        }
        return this.getLong(this.Ii.Ir);
    }

    @Override
    public int gh() {
        return this.getInteger(this.Ii.Iq);
    }

    @Override
    public Player freeze() {
        return new PlayerEntity(this);
    }

    @Override
    public int hashCode() {
        return PlayerEntity.a(this);
    }

    @Override
    public boolean equals(Object obj) {
        return PlayerEntity.a(this, obj);
    }

    public String toString() {
        return PlayerEntity.b(this);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        PlayerEntity playerEntity = (PlayerEntity)this.freeze();
        playerEntity.writeToParcel(dest, flags);
    }

    private static final class PlayerColumnNames {
        public final String Ij;
        public final String Ik;
        public final String Il;
        public final String Im;
        public final String In;
        public final String Io;
        public final String Ip;
        public final String Iq;
        public final String Ir;

        public PlayerColumnNames(String prefix) {
            if (TextUtils.isEmpty((CharSequence)prefix)) {
                this.Ij = "external_player_id";
                this.Ik = "profile_name";
                this.Il = "profile_icon_image_uri";
                this.Im = "profile_icon_image_url";
                this.In = "profile_hi_res_image_uri";
                this.Io = "profile_hi_res_image_url";
                this.Ip = "last_updated";
                this.Iq = "is_in_circles";
                this.Ir = "played_with_timestamp";
            } else {
                this.Ij = prefix + "external_player_id";
                this.Ik = prefix + "profile_name";
                this.Il = prefix + "profile_icon_image_uri";
                this.Im = prefix + "profile_icon_image_url";
                this.In = prefix + "profile_hi_res_image_uri";
                this.Io = prefix + "profile_hi_res_image_url";
                this.Ip = prefix + "last_updated";
                this.Iq = prefix + "is_in_circles";
                this.Ir = prefix + "played_with_timestamp";
            }
        }
    }
}

