/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntityCreator;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.internal.fb;
import com.google.android.gms.internal.fo;
import com.google.android.gms.internal.gm;

public final class PlayerEntity
extends GamesDowngradeableSafeParcel
implements Player {
    public static final Parcelable.Creator<PlayerEntity> CREATOR = new PlayerEntityCreatorCompat();
    private final int xH;
    private final String Ie;
    private final String HA;
    private final Uri HF;
    private final Uri HG;
    private final long If;
    private final int Ig;
    private final long Ih;
    private final String HQ;
    private final String HR;

    public PlayerEntity(Player player) {
        this.xH = 4;
        this.Ie = player.getPlayerId();
        this.HA = player.getDisplayName();
        this.HF = player.getIconImageUri();
        this.HQ = player.getIconImageUrl();
        this.HG = player.getHiResImageUri();
        this.HR = player.getHiResImageUrl();
        this.If = player.getRetrievedTimestamp();
        this.Ig = player.gh();
        this.Ih = player.getLastPlayedWithTimestamp();
        fb.d(this.Ie);
        fb.d(this.HA);
        fb.x(this.If > 0L);
    }

    PlayerEntity(int versionCode, String playerId, String displayName, Uri iconImageUri, Uri hiResImageUri, long retrievedTimestamp, int isInCircles, long lastPlayedWithTimestamp, String iconImageUrl, String hiResImageUrl) {
        this.xH = versionCode;
        this.Ie = playerId;
        this.HA = displayName;
        this.HF = iconImageUri;
        this.HQ = iconImageUrl;
        this.HG = hiResImageUri;
        this.HR = hiResImageUrl;
        this.If = retrievedTimestamp;
        this.Ig = isInCircles;
        this.Ih = lastPlayedWithTimestamp;
    }

    public int getVersionCode() {
        return this.xH;
    }

    @Override
    public String getPlayerId() {
        return this.Ie;
    }

    @Override
    public String getDisplayName() {
        return this.HA;
    }

    @Override
    public void getDisplayName(CharArrayBuffer dataOut) {
        gm.b(this.HA, dataOut);
    }

    @Override
    public boolean hasIconImage() {
        return this.getIconImageUri() != null;
    }

    @Override
    public Uri getIconImageUri() {
        return this.HF;
    }

    @Override
    public String getIconImageUrl() {
        return this.HQ;
    }

    @Override
    public boolean hasHiResImage() {
        return this.getHiResImageUri() != null;
    }

    @Override
    public Uri getHiResImageUri() {
        return this.HG;
    }

    @Override
    public String getHiResImageUrl() {
        return this.HR;
    }

    @Override
    public long getRetrievedTimestamp() {
        return this.If;
    }

    @Override
    public long getLastPlayedWithTimestamp() {
        return this.Ih;
    }

    @Override
    public int gh() {
        return this.Ig;
    }

    @Override
    public Player freeze() {
        return this;
    }

    @Override
    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return PlayerEntity.a(this);
    }

    static int a(Player player) {
        return fo.hashCode(player.getPlayerId(), player.getDisplayName(), player.getIconImageUri(), player.getHiResImageUri(), player.getRetrievedTimestamp());
    }

    public boolean equals(Object obj) {
        return PlayerEntity.a(this, obj);
    }

    static boolean a(Player player, Object object) {
        if (!(object instanceof Player)) {
            return false;
        }
        if (player == object) {
            return true;
        }
        Player player2 = (Player)object;
        return fo.equal(player2.getPlayerId(), player.getPlayerId()) && fo.equal(player2.getDisplayName(), player.getDisplayName()) && fo.equal(player2.getIconImageUri(), player.getIconImageUri()) && fo.equal(player2.getHiResImageUri(), player.getHiResImageUri()) && fo.equal(player2.getRetrievedTimestamp(), player.getRetrievedTimestamp());
    }

    public String toString() {
        return PlayerEntity.b(this);
    }

    static String b(Player player) {
        return fo.e(player).a("PlayerId", player.getPlayerId()).a("DisplayName", player.getDisplayName()).a("IconImageUri", player.getIconImageUri()).a("IconImageUrl", player.getIconImageUrl()).a("HiResImageUri", player.getHiResImageUri()).a("HiResImageUrl", player.getHiResImageUrl()).a("RetrievedTimestamp", player.getRetrievedTimestamp()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (!this.eK()) {
            PlayerEntityCreator.a(this, dest, flags);
        } else {
            dest.writeString(this.Ie);
            dest.writeString(this.HA);
            dest.writeString(this.HF == null ? null : this.HF.toString());
            dest.writeString(this.HG == null ? null : this.HG.toString());
            dest.writeLong(this.If);
        }
    }

    static final class PlayerEntityCreatorCompat
    extends PlayerEntityCreator {
        PlayerEntityCreatorCompat() {
        }

        @Override
        public PlayerEntity ao(Parcel parcel) {
            boolean bl2 = PlayerEntity.c(PlayerEntity.eJ());
            if (bl2 || PlayerEntity.al(PlayerEntity.class.getCanonicalName())) {
                return super.ao(parcel);
            }
            String string2 = parcel.readString();
            String string3 = parcel.readString();
            String string4 = parcel.readString();
            String string5 = parcel.readString();
            Uri uri = string4 == null ? null : Uri.parse((String)string4);
            Uri uri2 = string5 == null ? null : Uri.parse((String)string5);
            long l2 = parcel.readLong();
            int n2 = -1;
            long l3 = -1L;
            String string6 = null;
            String string7 = null;
            return new PlayerEntity(4, string2, string3, uri, uri2, l2, n2, l3, string6, string7);
        }

        @Override
        public /* synthetic */ Object createFromParcel(Parcel x0) {
            return this.ao(x0);
        }
    }
}

