/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.content.Context;
import android.content.Intent;
import android.os.Looper;
import android.view.View;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.a;
import com.google.android.gms.games.GamesMetadata;
import com.google.android.gms.games.Notifications;
import com.google.android.gms.games.Players;
import com.google.android.gms.games.achievement.Achievements;
import com.google.android.gms.games.internal.GamesClientImpl;
import com.google.android.gms.games.internal.api.AchievementsImpl;
import com.google.android.gms.games.internal.api.AclsImpl;
import com.google.android.gms.games.internal.api.GamesMetadataImpl;
import com.google.android.gms.games.internal.api.InvitationsImpl;
import com.google.android.gms.games.internal.api.LeaderboardsImpl;
import com.google.android.gms.games.internal.api.MultiplayerImpl;
import com.google.android.gms.games.internal.api.NotificationsImpl;
import com.google.android.gms.games.internal.api.PlayersImpl;
import com.google.android.gms.games.internal.api.RealTimeMultiplayerImpl;
import com.google.android.gms.games.internal.api.RequestsImpl;
import com.google.android.gms.games.internal.api.TurnBasedMultiplayerImpl;
import com.google.android.gms.games.internal.game.Acls;
import com.google.android.gms.games.leaderboard.Leaderboards;
import com.google.android.gms.games.multiplayer.Invitations;
import com.google.android.gms.games.multiplayer.Multiplayer;
import com.google.android.gms.games.multiplayer.realtime.RealTimeMultiplayer;
import com.google.android.gms.games.multiplayer.turnbased.TurnBasedMultiplayer;
import com.google.android.gms.games.request.Requests;
import com.google.android.gms.internal.fc;
import com.google.android.gms.internal.fq;

public final class Games {
    public static final String EXTRA_PLAYER_IDS = "players";
    static final Api.c<GamesClientImpl> wx = new Api.c();
    private static final Api.b<GamesClientImpl, GamesOptions> wy = new Api.b<GamesClientImpl, GamesOptions>(){

        @Override
        public GamesClientImpl a(Context context, Looper looper, fc fc2, GamesOptions gamesOptions, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
            if (gamesOptions == null) {
                gamesOptions = new GamesOptions();
            }
            return new GamesClientImpl(context, looper, fc2.eG(), fc2.eC(), connectionCallbacks, onConnectionFailedListener, fc2.eF(), fc2.eD(), fc2.eH(), gamesOptions.HZ, gamesOptions.Ia, gamesOptions.Ib, gamesOptions.Ic, gamesOptions.Id);
        }

        @Override
        public int getPriority() {
            return 1;
        }
    };
    public static final Scope SCOPE_GAMES = new Scope("https://www.googleapis.com/auth/games");
    public static final Api<GamesOptions> API = new Api<GamesOptions>(wy, wx, SCOPE_GAMES);
    public static final Scope HV = new Scope("https://www.googleapis.com/auth/games.firstparty");
    public static final Api<GamesOptions> HW = new Api<GamesOptions>(wy, wx, HV);
    public static final GamesMetadata GamesMetadata = new GamesMetadataImpl();
    public static final Achievements Achievements = new AchievementsImpl();
    public static final Leaderboards Leaderboards = new LeaderboardsImpl();
    public static final Invitations Invitations = new InvitationsImpl();
    public static final TurnBasedMultiplayer TurnBasedMultiplayer = new TurnBasedMultiplayerImpl();
    public static final RealTimeMultiplayer RealTimeMultiplayer = new RealTimeMultiplayerImpl();
    public static final Multiplayer HX = new MultiplayerImpl();
    public static final Players Players = new PlayersImpl();
    public static final Notifications Notifications = new NotificationsImpl();
    public static final Requests Requests = new RequestsImpl();
    public static final Acls HY = new AclsImpl();

    private Games() {
    }

    public static GamesClientImpl c(GoogleApiClient googleApiClient) {
        fq.b(googleApiClient != null, (Object)"GoogleApiClient parameter is required.");
        fq.a(googleApiClient.isConnected(), "GoogleApiClient must be connected.");
        GamesClientImpl gamesClientImpl = googleApiClient.a(wx);
        fq.a(gamesClientImpl != null, "GoogleApiClient is not configured to use the Games Api. Pass Games.API into GoogleApiClient.Builder#addApi() to use this feature.");
        return gamesClientImpl;
    }

    public static void setGravityForPopups(GoogleApiClient apiClient, int gravity) {
        Games.c(apiClient).aX(gravity);
    }

    public static void setViewForPopups(GoogleApiClient apiClient, View gamesContentView) {
        fq.f(gamesContentView);
        Games.c(apiClient).f(gamesContentView);
    }

    public static String getCurrentAccountName(GoogleApiClient apiClient) {
        return Games.c(apiClient).gl();
    }

    public static String getAppId(GoogleApiClient apiClient) {
        return Games.c(apiClient).gz();
    }

    public static Intent getSettingsIntent(GoogleApiClient apiClient) {
        return Games.c(apiClient).gx();
    }

    public static PendingResult<Status> signOut(GoogleApiClient apiClient) {
        return apiClient.b(new SignOutImpl(){

            @Override
            protected void a(GamesClientImpl gamesClientImpl) {
                gamesClientImpl.b(this);
            }
        });
    }

    public static int getSdkVariant(GoogleApiClient apiClient) {
        return Games.c(apiClient).gy();
    }

    private static abstract class SignOutImpl
    extends BaseGamesApiMethodImpl<Status> {
        private SignOutImpl() {
        }

        public Status f(Status status) {
            return status;
        }

        @Override
        public /* synthetic */ Result d(Status status) {
            return this.f(status);
        }
    }

    public static abstract class BaseGamesApiMethodImpl<R extends Result>
    extends a.b<R, GamesClientImpl> {
        public BaseGamesApiMethodImpl() {
            super(wx);
        }
    }

    public static final class GamesOptions
    implements Api.ApiOptions.Optional {
        final boolean HZ;
        final boolean Ia;
        final int Ib;
        final boolean Ic;
        final int Id;

        private GamesOptions() {
            this.HZ = false;
            this.Ia = true;
            this.Ib = 17;
            this.Ic = false;
            this.Id = 4368;
        }

        private GamesOptions(Builder builder) {
            this.HZ = builder.HZ;
            this.Ia = builder.Ia;
            this.Ib = builder.Ib;
            this.Ic = builder.Ic;
            this.Id = builder.Id;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            boolean HZ = false;
            boolean Ia = true;
            int Ib = 17;
            boolean Ic = false;
            int Id = 4368;

            private Builder() {
            }

            public Builder setShowConnectingPopup(boolean showConnectingPopup) {
                this.Ia = showConnectingPopup;
                this.Ib = 17;
                return this;
            }

            public Builder setShowConnectingPopup(boolean showConnectingPopup, int gravity) {
                this.Ia = showConnectingPopup;
                this.Ib = gravity;
                return this;
            }

            public Builder setSdkVariant(int variant) {
                this.Id = variant;
                return this;
            }

            public GamesOptions build() {
                return new GamesOptions(this);
            }
        }
    }
}

