/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntityCreator;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.internal.fo;
import com.google.android.gms.internal.gm;

public final class GameEntity
extends GamesDowngradeableSafeParcel
implements Game {
    public static final Parcelable.Creator<GameEntity> CREATOR = new GameEntityCreatorCompat();
    private final int xH;
    private final String xI;
    private final String HA;
    private final String HB;
    private final String HC;
    private final String HD;
    private final String HE;
    private final Uri HF;
    private final Uri HG;
    private final Uri HH;
    private final boolean HI;
    private final boolean HJ;
    private final String HK;
    private final int HL;
    private final int HM;
    private final int HN;
    private final boolean HO;
    private final boolean HP;
    private final String HQ;
    private final String HR;
    private final String HS;
    private final boolean HT;
    private final boolean HU;

    public GameEntity(Game game) {
        this.xH = 3;
        this.xI = game.getApplicationId();
        this.HB = game.getPrimaryCategory();
        this.HC = game.getSecondaryCategory();
        this.HD = game.getDescription();
        this.HE = game.getDeveloperName();
        this.HA = game.getDisplayName();
        this.HF = game.getIconImageUri();
        this.HQ = game.getIconImageUrl();
        this.HG = game.getHiResImageUri();
        this.HR = game.getHiResImageUrl();
        this.HH = game.getFeaturedImageUri();
        this.HS = game.getFeaturedImageUrl();
        this.HI = game.gb();
        this.HJ = game.gd();
        this.HK = game.ge();
        this.HL = game.gf();
        this.HM = game.getAchievementTotalCount();
        this.HN = game.getLeaderboardCount();
        this.HO = game.isRealTimeMultiplayerEnabled();
        this.HP = game.isTurnBasedMultiplayerEnabled();
        this.HT = game.isMuted();
        this.HU = game.gc();
    }

    GameEntity(int versionCode, String applicationId, String displayName, String primaryCategory, String secondaryCategory, String description, String developerName, Uri iconImageUri, Uri hiResImageUri, Uri featuredImageUri, boolean playEnabledGame, boolean instanceInstalled, String instancePackageName, int gameplayAclStatus, int achievementTotalCount, int leaderboardCount, boolean realTimeEnabled, boolean turnBasedEnabled, String iconImageUrl, String hiResImageUrl, String featuredImageUrl, boolean muted, boolean identitySharingConfirmed) {
        this.xH = versionCode;
        this.xI = applicationId;
        this.HA = displayName;
        this.HB = primaryCategory;
        this.HC = secondaryCategory;
        this.HD = description;
        this.HE = developerName;
        this.HF = iconImageUri;
        this.HQ = iconImageUrl;
        this.HG = hiResImageUri;
        this.HR = hiResImageUrl;
        this.HH = featuredImageUri;
        this.HS = featuredImageUrl;
        this.HI = playEnabledGame;
        this.HJ = instanceInstalled;
        this.HK = instancePackageName;
        this.HL = gameplayAclStatus;
        this.HM = achievementTotalCount;
        this.HN = leaderboardCount;
        this.HO = realTimeEnabled;
        this.HP = turnBasedEnabled;
        this.HT = muted;
        this.HU = identitySharingConfirmed;
    }

    public int getVersionCode() {
        return this.xH;
    }

    @Override
    public String getApplicationId() {
        return this.xI;
    }

    @Override
    public String getDisplayName() {
        return this.HA;
    }

    @Override
    public void getDisplayName(CharArrayBuffer dataOut) {
        gm.b(this.HA, dataOut);
    }

    @Override
    public String getPrimaryCategory() {
        return this.HB;
    }

    @Override
    public String getSecondaryCategory() {
        return this.HC;
    }

    @Override
    public String getDescription() {
        return this.HD;
    }

    @Override
    public void getDescription(CharArrayBuffer dataOut) {
        gm.b(this.HD, dataOut);
    }

    @Override
    public String getDeveloperName() {
        return this.HE;
    }

    @Override
    public void getDeveloperName(CharArrayBuffer dataOut) {
        gm.b(this.HE, dataOut);
    }

    @Override
    public Uri getIconImageUri() {
        return this.HF;
    }

    @Override
    public String getIconImageUrl() {
        return this.HQ;
    }

    @Override
    public Uri getHiResImageUri() {
        return this.HG;
    }

    @Override
    public String getHiResImageUrl() {
        return this.HR;
    }

    @Override
    public Uri getFeaturedImageUri() {
        return this.HH;
    }

    @Override
    public String getFeaturedImageUrl() {
        return this.HS;
    }

    @Override
    public boolean isMuted() {
        return this.HT;
    }

    @Override
    public boolean gc() {
        return this.HU;
    }

    @Override
    public boolean gb() {
        return this.HI;
    }

    @Override
    public boolean gd() {
        return this.HJ;
    }

    @Override
    public String ge() {
        return this.HK;
    }

    @Override
    public int gf() {
        return this.HL;
    }

    @Override
    public int getAchievementTotalCount() {
        return this.HM;
    }

    @Override
    public int getLeaderboardCount() {
        return this.HN;
    }

    @Override
    public boolean isRealTimeMultiplayerEnabled() {
        return this.HO;
    }

    @Override
    public boolean isTurnBasedMultiplayerEnabled() {
        return this.HP;
    }

    @Override
    public Game freeze() {
        return this;
    }

    @Override
    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return GameEntity.a(this);
    }

    static int a(Game game) {
        return fo.hashCode(game.getApplicationId(), game.getDisplayName(), game.getPrimaryCategory(), game.getSecondaryCategory(), game.getDescription(), game.getDeveloperName(), game.getIconImageUri(), game.getHiResImageUri(), game.getFeaturedImageUri(), game.gb(), game.gd(), game.ge(), game.gf(), game.getAchievementTotalCount(), game.getLeaderboardCount(), game.isRealTimeMultiplayerEnabled(), game.isTurnBasedMultiplayerEnabled(), game.isMuted(), game.gc());
    }

    public boolean equals(Object obj) {
        return GameEntity.a(this, obj);
    }

    static boolean a(Game game, Object object) {
        if (!(object instanceof Game)) {
            return false;
        }
        if (game == object) {
            return true;
        }
        Game game2 = (Game)object;
        return fo.equal(game2.getApplicationId(), game.getApplicationId()) && fo.equal(game2.getDisplayName(), game.getDisplayName()) && fo.equal(game2.getPrimaryCategory(), game.getPrimaryCategory()) && fo.equal(game2.getSecondaryCategory(), game.getSecondaryCategory()) && fo.equal(game2.getDescription(), game.getDescription()) && fo.equal(game2.getDeveloperName(), game.getDeveloperName()) && fo.equal(game2.getIconImageUri(), game.getIconImageUri()) && fo.equal(game2.getHiResImageUri(), game.getHiResImageUri()) && fo.equal(game2.getFeaturedImageUri(), game.getFeaturedImageUri()) && fo.equal(game2.gb(), game.gb()) && fo.equal(game2.gd(), game.gd()) && fo.equal(game2.ge(), game.ge()) && fo.equal(game2.gf(), game.gf()) && fo.equal(game2.getAchievementTotalCount(), game.getAchievementTotalCount()) && fo.equal(game2.getLeaderboardCount(), game.getLeaderboardCount()) && fo.equal(game2.isRealTimeMultiplayerEnabled(), game.isRealTimeMultiplayerEnabled()) && fo.equal(game2.isTurnBasedMultiplayerEnabled(), game.isTurnBasedMultiplayerEnabled() && fo.equal(game2.isMuted(), game.isMuted()) && fo.equal(game2.gc(), game.gc()));
    }

    public String toString() {
        return GameEntity.b(this);
    }

    static String b(Game game) {
        return fo.e(game).a("ApplicationId", game.getApplicationId()).a("DisplayName", game.getDisplayName()).a("PrimaryCategory", game.getPrimaryCategory()).a("SecondaryCategory", game.getSecondaryCategory()).a("Description", game.getDescription()).a("DeveloperName", game.getDeveloperName()).a("IconImageUri", game.getIconImageUri()).a("IconImageUrl", game.getIconImageUrl()).a("HiResImageUri", game.getHiResImageUri()).a("HiResImageUrl", game.getHiResImageUrl()).a("FeaturedImageUri", game.getFeaturedImageUri()).a("FeaturedImageUrl", game.getFeaturedImageUrl()).a("PlayEnabledGame", game.gb()).a("InstanceInstalled", game.gd()).a("InstancePackageName", game.ge()).a("AchievementTotalCount", game.getAchievementTotalCount()).a("LeaderboardCount", game.getLeaderboardCount()).a("RealTimeMultiplayerEnabled", game.isRealTimeMultiplayerEnabled()).a("TurnBasedMultiplayerEnabled", game.isTurnBasedMultiplayerEnabled()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (!this.eK()) {
            GameEntityCreator.a(this, dest, flags);
        } else {
            dest.writeString(this.xI);
            dest.writeString(this.HA);
            dest.writeString(this.HB);
            dest.writeString(this.HC);
            dest.writeString(this.HD);
            dest.writeString(this.HE);
            dest.writeString(this.HF == null ? null : this.HF.toString());
            dest.writeString(this.HG == null ? null : this.HG.toString());
            dest.writeString(this.HH == null ? null : this.HH.toString());
            dest.writeInt(this.HI ? 1 : 0);
            dest.writeInt(this.HJ ? 1 : 0);
            dest.writeString(this.HK);
            dest.writeInt(this.HL);
            dest.writeInt(this.HM);
            dest.writeInt(this.HN);
        }
    }

    static final class GameEntityCreatorCompat
    extends GameEntityCreator {
        GameEntityCreatorCompat() {
        }

        @Override
        public GameEntity an(Parcel parcel) {
            boolean bl2 = GameEntity.c(GameEntity.eJ());
            if (bl2 || GameEntity.al(GameEntity.class.getCanonicalName())) {
                return super.an(parcel);
            }
            String string2 = parcel.readString();
            String string3 = parcel.readString();
            String string4 = parcel.readString();
            String string5 = parcel.readString();
            String string6 = parcel.readString();
            String string7 = parcel.readString();
            String string8 = parcel.readString();
            Uri uri = string8 == null ? null : Uri.parse((String)string8);
            String string9 = parcel.readString();
            Uri uri2 = string9 == null ? null : Uri.parse((String)string9);
            String string10 = parcel.readString();
            Uri uri3 = string10 == null ? null : Uri.parse((String)string10);
            boolean bl3 = parcel.readInt() > 0;
            boolean bl4 = parcel.readInt() > 0;
            String string11 = parcel.readString();
            int n2 = parcel.readInt();
            int n3 = parcel.readInt();
            int n4 = parcel.readInt();
            boolean bl5 = false;
            boolean bl6 = false;
            String string12 = null;
            String string13 = null;
            String string14 = null;
            boolean bl7 = false;
            boolean bl8 = false;
            return new GameEntity(3, string2, string3, string4, string5, string6, string7, uri, uri2, uri3, bl3, bl4, string11, n2, n3, n4, bl5, bl6, string12, string13, string14, bl7, bl8);
        }

        @Override
        public /* synthetic */ Object createFromParcel(Parcel x0) {
            return this.an(x0);
        }
    }
}

