/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive.events;

import android.app.IntentService;
import android.content.Intent;
import android.util.Log;
import com.google.android.gms.drive.events.ChangeEvent;
import com.google.android.gms.drive.events.ConflictEvent;
import com.google.android.gms.drive.events.DriveEvent;
import com.google.android.gms.internal.fq;

public abstract class DriveEventService
extends IntentService {
    private final String mName;

    protected DriveEventService(String name) {
        super(name);
        this.mName = name;
    }

    protected final void onHandleIntent(Intent intent) {
        intent.setExtrasClassLoader(this.getClassLoader());
        DriveEvent driveEvent = (DriveEvent)intent.getParcelableExtra("event");
        try {
            switch (driveEvent.getType()) {
                case 1: {
                    fq.a(driveEvent instanceof ChangeEvent, "Unexpected event type: " + driveEvent);
                    this.onChangeEvent((ChangeEvent)driveEvent);
                    break;
                }
                case 2: {
                    fq.a(driveEvent instanceof ConflictEvent, "Unexpected event type: " + driveEvent);
                    this.a((ConflictEvent)driveEvent);
                    break;
                }
                default: {
                    Log.w((String)this.mName, (String)("Unrecognized event: " + intent));
                    break;
                }
            }
        }
        catch (ClassCastException classCastException) {
            Log.wtf((String)this.mName, (String)("Service does not implement listener for type:" + driveEvent.getType()), (Throwable)classCastException);
        }
        catch (Exception exception) {
            Log.w((String)this.mName, (String)("Error handling event: " + intent), (Throwable)exception);
        }
    }

    public void onChangeEvent(ChangeEvent event) {
        Log.w((String)"DriveEventService", (String)("Unhandled ChangeEvent: " + event));
    }

    public void a(ConflictEvent conflictEvent) {
        Log.w((String)"DriveEventService", (String)("Unhandled ConflictEvent: " + conflictEvent));
    }
}

