/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.images;

import android.app.ActivityManager;
import android.content.ComponentCallbacks;
import android.content.ComponentCallbacks2;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.ResultReceiver;
import android.util.Log;
import android.widget.ImageView;
import com.google.android.gms.common.images.a;
import com.google.android.gms.internal.fa;
import com.google.android.gms.internal.fb;
import com.google.android.gms.internal.fu;
import com.google.android.gms.internal.gr;
import java.io.FileDescriptor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public final class ImageManager {
    private static final Object BY = new Object();
    private static HashSet<Uri> BZ = new HashSet();
    private static ImageManager Ca;
    private static ImageManager Cb;
    private final Context mContext;
    private final Handler mHandler;
    private final ExecutorService Cc;
    private final b Cd;
    private final fa Ce;
    private final Map<com.google.android.gms.common.images.a, ImageReceiver> Cf;
    private final Map<Uri, ImageReceiver> Cg;

    public static ImageManager create(Context context) {
        return ImageManager.a(context, false);
    }

    public static ImageManager a(Context context, boolean bl2) {
        if (bl2) {
            if (Cb == null) {
                Cb = new ImageManager(context, true);
            }
            return Cb;
        }
        if (Ca == null) {
            Ca = new ImageManager(context, false);
        }
        return Ca;
    }

    private ImageManager(Context context, boolean withMemoryCache) {
        this.mContext = context.getApplicationContext();
        this.mHandler = new Handler(Looper.getMainLooper());
        this.Cc = Executors.newFixedThreadPool(4);
        if (withMemoryCache) {
            this.Cd = new b(this.mContext);
            if (gr.fx()) {
                this.ev();
            }
        } else {
            this.Cd = null;
        }
        this.Ce = new fa();
        this.Cf = new HashMap<com.google.android.gms.common.images.a, ImageReceiver>();
        this.Cg = new HashMap<Uri, ImageReceiver>();
    }

    private void ev() {
        this.mContext.registerComponentCallbacks((ComponentCallbacks)new e(this.Cd));
    }

    public void loadImage(ImageView imageView, Uri uri) {
        a.b b2 = new a.b(imageView, uri);
        this.a(b2);
    }

    public void loadImage(ImageView imageView, int resId) {
        a.b b2 = new a.b(imageView, resId);
        this.a(b2);
    }

    public void loadImage(ImageView imageView, Uri uri, int defaultResId) {
        a.b b2 = new a.b(imageView, uri);
        b2.J(defaultResId);
        this.a(b2);
    }

    public void loadImage(OnImageLoadedListener listener, Uri uri) {
        a.c c2 = new a.c(listener, uri);
        this.a(c2);
    }

    public void loadImage(OnImageLoadedListener listener, Uri uri, int defaultResId) {
        a.c c2 = new a.c(listener, uri);
        c2.J(defaultResId);
        this.a(c2);
    }

    public void a(com.google.android.gms.common.images.a a2) {
        fb.aj("ImageManager.loadImage() must be called in the main thread");
        d d2 = new d(a2);
        d2.run();
    }

    private Bitmap a(a.a a2) {
        if (this.Cd == null) {
            return null;
        }
        Bitmap bitmap = (Bitmap)this.Cd.get(a2);
        return bitmap;
    }

    private static final class a {
        static int a(ActivityManager activityManager) {
            return activityManager.getLargeMemoryClass();
        }
    }

    private static final class b
    extends fu<a.a, Bitmap> {
        public b(Context context) {
            super(b.w(context));
        }

        protected void a(boolean bl2, a.a a2, Bitmap bitmap, Bitmap bitmap2) {
            super.entryRemoved(bl2, a2, bitmap, bitmap2);
        }

        private static int w(Context context) {
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            boolean bl2 = (context.getApplicationInfo().flags & 0x100000) != 0;
            int n2 = bl2 && gr.fu() ? a.a(activityManager) : activityManager.getMemoryClass();
            int n3 = 0x100000 * n2;
            return (int)(0.33f * (float)n3);
        }

        protected int a(a.a a2, Bitmap bitmap) {
            return bitmap.getHeight() * bitmap.getRowBytes();
        }

        @Override
        protected /* synthetic */ int sizeOf(Object x0, Object x1) {
            return this.a((a.a)x0, (Bitmap)x1);
        }

        @Override
        protected /* synthetic */ void entryRemoved(boolean x0, Object x1, Object x2, Object x3) {
            this.a(x0, (a.a)x1, (Bitmap)x2, (Bitmap)x3);
        }
    }

    private static final class e
    implements ComponentCallbacks2 {
        private final b Cd;

        public e(b b2) {
            this.Cd = b2;
        }

        public void onConfigurationChanged(Configuration newConfig) {
        }

        public void onLowMemory() {
            this.Cd.evictAll();
        }

        public void onTrimMemory(int level) {
            if (level >= 60) {
                this.Cd.evictAll();
            } else if (level >= 20) {
                this.Cd.trimToSize(this.Cd.size() / 2);
            }
        }
    }

    private final class f
    implements Runnable {
        private final Uri mUri;
        private final Bitmap mBitmap;
        private final CountDownLatch AD;
        private boolean Cl;

        public f(Uri uri, Bitmap bitmap, boolean bl2, CountDownLatch countDownLatch) {
            this.mUri = uri;
            this.mBitmap = bitmap;
            this.Cl = bl2;
            this.AD = countDownLatch;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ImageReceiver imageReceiver;
            boolean bl2;
            fb.aj("OnBitmapLoadedRunnable must be executed in the main thread");
            boolean bl3 = bl2 = this.mBitmap != null;
            if (ImageManager.this.Cd != null) {
                if (this.Cl) {
                    ImageManager.this.Cd.evictAll();
                    System.gc();
                    this.Cl = false;
                    ImageManager.this.mHandler.post((Runnable)this);
                    return;
                }
                if (bl2) {
                    ImageManager.this.Cd.put(new a.a(this.mUri), this.mBitmap);
                }
            }
            if ((imageReceiver = (ImageReceiver)((Object)ImageManager.this.Cg.remove(this.mUri))) != null) {
                this.a(imageReceiver, bl2);
            }
            this.AD.countDown();
            Object object = BY;
            synchronized (object) {
                BZ.remove(this.mUri);
            }
        }

        private void a(ImageReceiver imageReceiver, boolean bl2) {
            ArrayList arrayList = imageReceiver.Ch;
            int n2 = arrayList.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                com.google.android.gms.common.images.a a2 = (com.google.android.gms.common.images.a)arrayList.get(i2);
                if (bl2) {
                    a2.a(ImageManager.this.mContext, this.mBitmap, false);
                } else {
                    a2.a(ImageManager.this.mContext, ImageManager.this.Ce, false);
                }
                if (a2 instanceof a.c) continue;
                ImageManager.this.Cf.remove(a2);
            }
        }
    }

    private final class c
    implements Runnable {
        private final Uri mUri;
        private final ParcelFileDescriptor Cj;

        public c(Uri uri, ParcelFileDescriptor parcelFileDescriptor) {
            this.mUri = uri;
            this.Cj = parcelFileDescriptor;
        }

        @Override
        public void run() {
            fb.ak("LoadBitmapFromDiskRunnable can't be executed in the main thread");
            boolean bl2 = false;
            Bitmap bitmap = null;
            if (this.Cj != null) {
                try {
                    bitmap = BitmapFactory.decodeFileDescriptor((FileDescriptor)this.Cj.getFileDescriptor());
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    Log.e((String)"ImageManager", (String)("OOM while loading bitmap for uri: " + this.mUri), (Throwable)outOfMemoryError);
                    bl2 = true;
                }
                try {
                    this.Cj.close();
                }
                catch (IOException iOException) {
                    Log.e((String)"ImageManager", (String)"closed failed", (Throwable)iOException);
                }
            }
            CountDownLatch countDownLatch = new CountDownLatch(1);
            ImageManager.this.mHandler.post((Runnable)new f(this.mUri, bitmap, bl2, countDownLatch));
            try {
                countDownLatch.await();
            }
            catch (InterruptedException interruptedException) {
                Log.w((String)"ImageManager", (String)("Latch interrupted while posting " + this.mUri));
            }
        }
    }

    private final class ImageReceiver
    extends ResultReceiver {
        private final Uri mUri;
        private final ArrayList<com.google.android.gms.common.images.a> Ch;

        ImageReceiver(Uri uri) {
            super(new Handler(Looper.getMainLooper()));
            this.mUri = uri;
            this.Ch = new ArrayList();
        }

        public void b(com.google.android.gms.common.images.a a2) {
            fb.aj("ImageReceiver.addImageRequest() must be called in the main thread");
            this.Ch.add(a2);
        }

        public void c(com.google.android.gms.common.images.a a2) {
            fb.aj("ImageReceiver.removeImageRequest() must be called in the main thread");
            this.Ch.remove(a2);
        }

        public void ey() {
            Intent intent = new Intent("com.google.android.gms.common.images.LOAD_IMAGE");
            intent.putExtra("com.google.android.gms.extras.uri", (Parcelable)this.mUri);
            intent.putExtra("com.google.android.gms.extras.resultReceiver", (Parcelable)this);
            intent.putExtra("com.google.android.gms.extras.priority", 3);
            ImageManager.this.mContext.sendBroadcast(intent);
        }

        public void onReceiveResult(int resultCode, Bundle resultData) {
            ParcelFileDescriptor parcelFileDescriptor = (ParcelFileDescriptor)resultData.getParcelable("com.google.android.gms.extra.fileDescriptor");
            ImageManager.this.Cc.execute(new c(this.mUri, parcelFileDescriptor));
        }
    }

    private final class d
    implements Runnable {
        private final com.google.android.gms.common.images.a Ck;

        public d(com.google.android.gms.common.images.a a2) {
            this.Ck = a2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            fb.aj("LoadImageRunnable must be executed on the main thread");
            ImageReceiver imageReceiver = (ImageReceiver)((Object)ImageManager.this.Cf.get(this.Ck));
            if (imageReceiver != null) {
                ImageManager.this.Cf.remove(this.Ck);
                imageReceiver.c(this.Ck);
            }
            a.a a2 = this.Ck.Cm;
            if (a2.uri == null) {
                this.Ck.a(ImageManager.this.mContext, ImageManager.this.Ce, true);
                return;
            }
            Bitmap bitmap = ImageManager.this.a(a2);
            if (bitmap != null) {
                this.Ck.a(ImageManager.this.mContext, bitmap, true);
                return;
            }
            this.Ck.a(ImageManager.this.mContext, ImageManager.this.Ce);
            imageReceiver = (ImageReceiver)((Object)ImageManager.this.Cg.get(a2.uri));
            if (imageReceiver == null) {
                imageReceiver = new ImageReceiver(a2.uri);
                ImageManager.this.Cg.put(a2.uri, imageReceiver);
            }
            imageReceiver.b(this.Ck);
            if (!(this.Ck instanceof a.c)) {
                ImageManager.this.Cf.put(this.Ck, imageReceiver);
            }
            Object object = BY;
            synchronized (object) {
                boolean bl2 = BZ.contains(a2.uri);
                if (!bl2) {
                    BZ.add(a2.uri);
                    imageReceiver.ey();
                }
            }
        }
    }

    public static interface OnImageLoadedListener {
        public void onImageLoaded(Uri var1, Drawable var2, boolean var3);
    }
}

