/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import com.google.android.gms.cast.Cast;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.MediaStatus;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.internal.en;
import com.google.android.gms.internal.es;
import com.google.android.gms.internal.et;
import com.google.android.gms.internal.eu;
import java.io.IOException;
import org.json.JSONObject;

public class RemoteMediaPlayer
implements Cast.MessageReceivedCallback {
    private final Object li = new Object();
    private final es yE;
    private final a yF = new a();
    private OnMetadataUpdatedListener yG;
    private OnStatusUpdatedListener yH;
    public static final int RESUME_STATE_UNCHANGED = 0;
    public static final int RESUME_STATE_PLAY = 1;
    public static final int RESUME_STATE_PAUSE = 2;
    public static final int STATUS_SUCCEEDED = 0;
    public static final int STATUS_FAILED = 1;
    public static final int STATUS_CANCELED = 2;
    public static final int STATUS_TIMED_OUT = 3;
    public static final int STATUS_REPLACED = 4;

    public RemoteMediaPlayer() {
        this.yE = new es(){

            @Override
            protected void onStatusUpdated() {
                RemoteMediaPlayer.this.onStatusUpdated();
            }

            @Override
            protected void onMetadataUpdated() {
                RemoteMediaPlayer.this.onMetadataUpdated();
            }
        };
        this.yE.a(this.yF);
    }

    public PendingResult<MediaChannelResult> load(GoogleApiClient apiClient, MediaInfo mediaInfo) {
        return this.load(apiClient, mediaInfo, true, 0L, null);
    }

    public PendingResult<MediaChannelResult> load(GoogleApiClient apiClient, MediaInfo mediaInfo, boolean autoplay) {
        return this.load(apiClient, mediaInfo, autoplay, 0L, null);
    }

    public PendingResult<MediaChannelResult> load(GoogleApiClient apiClient, MediaInfo mediaInfo, boolean autoplay, long playPosition) {
        return this.load(apiClient, mediaInfo, autoplay, playPosition, null);
    }

    public PendingResult<MediaChannelResult> load(final GoogleApiClient apiClient, final MediaInfo mediaInfo, final boolean autoplay, final long playPosition, final JSONObject customData) {
        return apiClient.b(new b(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void a(en en2) {
                Object object = RemoteMediaPlayer.this.li;
                synchronized (object) {
                    RemoteMediaPlayer.this.yF.b(apiClient);
                    try {
                        RemoteMediaPlayer.this.yE.a(this.yW, mediaInfo, autoplay, playPosition, customData);
                    }
                    catch (IOException iOException) {
                        this.a(this.j(new Status(1)));
                    }
                    finally {
                        RemoteMediaPlayer.this.yF.b(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> pause(GoogleApiClient apiClient) {
        return this.pause(apiClient, null);
    }

    public PendingResult<MediaChannelResult> pause(final GoogleApiClient apiClient, final JSONObject customData) {
        return apiClient.b(new b(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void a(en en2) {
                Object object = RemoteMediaPlayer.this.li;
                synchronized (object) {
                    RemoteMediaPlayer.this.yF.b(apiClient);
                    try {
                        RemoteMediaPlayer.this.yE.a(this.yW, customData);
                    }
                    catch (IOException iOException) {
                        this.a(this.j(new Status(1)));
                    }
                    finally {
                        RemoteMediaPlayer.this.yF.b(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> stop(GoogleApiClient apiClient) {
        return this.stop(apiClient, null);
    }

    public PendingResult<MediaChannelResult> stop(final GoogleApiClient apiClient, final JSONObject customData) {
        return apiClient.b(new b(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void a(en en2) {
                Object object = RemoteMediaPlayer.this.li;
                synchronized (object) {
                    RemoteMediaPlayer.this.yF.b(apiClient);
                    try {
                        RemoteMediaPlayer.this.yE.b(this.yW, customData);
                    }
                    catch (IOException iOException) {
                        this.a(this.j(new Status(1)));
                    }
                    finally {
                        RemoteMediaPlayer.this.yF.b(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> play(GoogleApiClient apiClient) {
        return this.play(apiClient, null);
    }

    public PendingResult<MediaChannelResult> play(final GoogleApiClient apiClient, final JSONObject customData) {
        return apiClient.b(new b(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void a(en en2) {
                Object object = RemoteMediaPlayer.this.li;
                synchronized (object) {
                    RemoteMediaPlayer.this.yF.b(apiClient);
                    try {
                        RemoteMediaPlayer.this.yE.c(this.yW, customData);
                    }
                    catch (IOException iOException) {
                        this.a(this.j(new Status(1)));
                    }
                    finally {
                        RemoteMediaPlayer.this.yF.b(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> seek(GoogleApiClient apiClient, long position) {
        return this.seek(apiClient, position, 0, null);
    }

    public PendingResult<MediaChannelResult> seek(GoogleApiClient apiClient, long position, int resumeState) {
        return this.seek(apiClient, position, resumeState, null);
    }

    public PendingResult<MediaChannelResult> seek(final GoogleApiClient apiClient, final long position, final int resumeState, final JSONObject customData) {
        return apiClient.b(new b(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void a(en en2) {
                Object object = RemoteMediaPlayer.this.li;
                synchronized (object) {
                    RemoteMediaPlayer.this.yF.b(apiClient);
                    try {
                        RemoteMediaPlayer.this.yE.a(this.yW, position, resumeState, customData);
                    }
                    catch (IOException iOException) {
                        this.a(this.j(new Status(1)));
                    }
                    finally {
                        RemoteMediaPlayer.this.yF.b(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> setStreamVolume(GoogleApiClient apiClient, double volume) throws IllegalArgumentException {
        return this.setStreamVolume(apiClient, volume, null);
    }

    public PendingResult<MediaChannelResult> setStreamVolume(final GoogleApiClient apiClient, final double volume, final JSONObject customData) throws IllegalArgumentException {
        if (Double.isInfinite(volume) || Double.isNaN(volume)) {
            throw new IllegalArgumentException("Volume cannot be " + volume);
        }
        return apiClient.b(new b(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void a(en en2) {
                Object object = RemoteMediaPlayer.this.li;
                synchronized (object) {
                    RemoteMediaPlayer.this.yF.b(apiClient);
                    try {
                        RemoteMediaPlayer.this.yE.a(this.yW, volume, customData);
                    }
                    catch (IllegalStateException illegalStateException) {
                        this.a(this.j(new Status(1)));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        this.a(this.j(new Status(1)));
                    }
                    catch (IOException iOException) {
                        this.a(this.j(new Status(1)));
                    }
                    finally {
                        RemoteMediaPlayer.this.yF.b(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> setStreamMute(GoogleApiClient apiClient, boolean muteState) {
        return this.setStreamMute(apiClient, muteState, null);
    }

    public PendingResult<MediaChannelResult> setStreamMute(final GoogleApiClient apiClient, final boolean muteState, final JSONObject customData) {
        return apiClient.b(new b(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void a(en en2) {
                Object object = RemoteMediaPlayer.this.li;
                synchronized (object) {
                    RemoteMediaPlayer.this.yF.b(apiClient);
                    try {
                        RemoteMediaPlayer.this.yE.a(this.yW, muteState, customData);
                    }
                    catch (IllegalStateException illegalStateException) {
                        this.a(this.j(new Status(1)));
                    }
                    catch (IOException iOException) {
                        this.a(this.j(new Status(1)));
                    }
                    finally {
                        RemoteMediaPlayer.this.yF.b(null);
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> requestStatus(final GoogleApiClient apiClient) {
        return apiClient.b(new b(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void a(en en2) {
                Object object = RemoteMediaPlayer.this.li;
                synchronized (object) {
                    RemoteMediaPlayer.this.yF.b(apiClient);
                    try {
                        RemoteMediaPlayer.this.yE.a(this.yW);
                    }
                    catch (IOException iOException) {
                        this.a(this.j(new Status(1)));
                    }
                    finally {
                        RemoteMediaPlayer.this.yF.b(null);
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getApproximateStreamPosition() {
        Object object = this.li;
        synchronized (object) {
            return this.yE.getApproximateStreamPosition();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getStreamDuration() {
        Object object = this.li;
        synchronized (object) {
            return this.yE.getStreamDuration();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MediaStatus getMediaStatus() {
        Object object = this.li;
        synchronized (object) {
            return this.yE.getMediaStatus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MediaInfo getMediaInfo() {
        Object object = this.li;
        synchronized (object) {
            return this.yE.getMediaInfo();
        }
    }

    public void setOnStatusUpdatedListener(OnStatusUpdatedListener listener) {
        this.yH = listener;
    }

    private void onStatusUpdated() {
        if (this.yH != null) {
            this.yH.onStatusUpdated();
        }
    }

    public void setOnMetadataUpdatedListener(OnMetadataUpdatedListener listener) {
        this.yG = listener;
    }

    private void onMetadataUpdated() {
        if (this.yG != null) {
            this.yG.onMetadataUpdated();
        }
    }

    public String getNamespace() {
        return this.yE.getNamespace();
    }

    @Override
    public void onMessageReceived(CastDevice castDevice, String namespace, String message) {
        this.yE.U(message);
    }

    private static abstract class b
    extends Cast.a<MediaChannelResult> {
        eu yW = new eu(){

            @Override
            public void l(long l2) {
                b.this.a(b.this.j(new Status(4)));
            }

            @Override
            public void a(long l2, int n2, JSONObject jSONObject) {
                b.this.a(new c(new Status(n2), jSONObject));
            }
        };

        b() {
        }

        public MediaChannelResult j(final Status status) {
            return new MediaChannelResult(){

                @Override
                public Status getStatus() {
                    return status;
                }
            };
        }

        @Override
        public /* synthetic */ Result d(Status status) {
            return this.j(status);
        }
    }

    private static final class c
    implements MediaChannelResult {
        private final Status wJ;
        private final JSONObject yn;

        c(Status status, JSONObject jSONObject) {
            this.wJ = status;
            this.yn = jSONObject;
        }

        @Override
        public Status getStatus() {
            return this.wJ;
        }
    }

    public static interface MediaChannelResult
    extends Result {
    }

    private class com.google.android.gms.cast.RemoteMediaPlayer$a
    implements et {
        private GoogleApiClient yS;
        private long yT = 0L;

        public void b(GoogleApiClient googleApiClient) {
            this.yS = googleApiClient;
        }

        @Override
        public long dD() {
            return ++this.yT;
        }

        @Override
        public void a(String string2, String string3, long l2, String string4) throws IOException {
            if (this.yS == null) {
                throw new IOException("No GoogleApiClient available");
            }
            Cast.CastApi.sendMessage(this.yS, string2, string3).setResultCallback(new a(l2));
        }

        private final class a
        implements ResultCallback<Status> {
            private final long yU;

            a(long l2) {
                this.yU = l2;
            }

            public void i(Status status) {
                if (!status.isSuccess()) {
                    RemoteMediaPlayer.this.yE.a(this.yU, status.getStatusCode());
                }
            }

            @Override
            public /* synthetic */ void onResult(Result x0) {
                this.i((Status)x0);
            }
        }
    }

    public static interface OnMetadataUpdatedListener {
        public void onMetadataUpdated();
    }

    public static interface OnStatusUpdatedListener {
        public void onStatusUpdated();
    }
}

