/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.cast.b;
import com.google.android.gms.common.images.WebImage;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.internal.eo;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CastDevice
implements SafeParcelable {
    public static final Parcelable.Creator<CastDevice> CREATOR = new b();
    private final int xH;
    private String ya;
    String yb;
    private Inet4Address yc;
    private String yd;
    private String ye;
    private String yf;
    private int yg;
    private List<WebImage> yh;

    CastDevice(int versionCode, String deviceId, String hostAddress, String friendlyName, String modelName, String deviceVersion, int servicePort, List<WebImage> icons) {
        this.xH = versionCode;
        this.ya = deviceId;
        this.yb = hostAddress;
        if (this.yb != null) {
            try {
                InetAddress inetAddress = InetAddress.getByName(this.yb);
                if (inetAddress instanceof Inet4Address) {
                    this.yc = (Inet4Address)inetAddress;
                }
            }
            catch (UnknownHostException unknownHostException) {
                this.yc = null;
            }
        }
        this.yd = friendlyName;
        this.ye = modelName;
        this.yf = deviceVersion;
        this.yg = servicePort;
        this.yh = icons;
    }

    private CastDevice() {
        this(1, null, null, null, null, null, -1, new ArrayList<WebImage>());
    }

    int getVersionCode() {
        return this.xH;
    }

    public String getDeviceId() {
        return this.ya;
    }

    public Inet4Address getIpAddress() {
        return this.yc;
    }

    public String getFriendlyName() {
        return this.yd;
    }

    public String getModelName() {
        return this.ye;
    }

    public String getDeviceVersion() {
        return this.yf;
    }

    public int getServicePort() {
        return this.yg;
    }

    public List<WebImage> getIcons() {
        return Collections.unmodifiableList(this.yh);
    }

    public WebImage getIcon(int preferredWidth, int preferredHeight) {
        if (this.yh.isEmpty()) {
            return null;
        }
        if (preferredWidth <= 0 || preferredHeight <= 0) {
            return this.yh.get(0);
        }
        WebImage webImage = null;
        WebImage webImage2 = null;
        for (WebImage webImage3 : this.yh) {
            int n2 = webImage3.getWidth();
            int n3 = webImage3.getHeight();
            if (n2 >= preferredWidth && n3 >= preferredHeight) {
                if (webImage != null && (webImage.getWidth() <= n2 || webImage.getHeight() <= n3)) continue;
                webImage = webImage3;
                continue;
            }
            if (n2 >= preferredWidth || n3 >= preferredHeight || webImage2 != null && (webImage2.getWidth() >= n2 || webImage2.getHeight() >= n3)) continue;
            webImage2 = webImage3;
        }
        Object object = null;
        object = webImage != null ? webImage : (webImage2 != null ? webImage2 : this.yh.get(0));
        return object;
    }

    public boolean hasIcons() {
        return !this.yh.isEmpty();
    }

    public String toString() {
        return String.format("\"%s\" (%s)", this.yd, this.ya);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        b.a(this, out, flags);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CastDevice)) {
            return false;
        }
        CastDevice castDevice = (CastDevice)obj;
        if (this.getDeviceId() == null) {
            return castDevice.getDeviceId() == null;
        }
        return eo.a(this.ya, castDevice.ya) && eo.a(this.yc, castDevice.yc) && eo.a(this.ye, castDevice.ye) && eo.a(this.yd, castDevice.yd) && eo.a(this.yf, castDevice.yf) && this.yg == castDevice.yg && eo.a(this.yh, castDevice.yh);
    }

    public boolean isSameDevice(CastDevice castDevice) {
        if (castDevice == null) {
            return false;
        }
        if (this.getDeviceId() == null) {
            return castDevice.getDeviceId() == null;
        }
        return eo.a(this.getDeviceId(), castDevice.getDeviceId());
    }

    public int hashCode() {
        return this.ya == null ? 0 : this.ya.hashCode();
    }

    public void putInBundle(Bundle bundle) {
        if (bundle == null) {
            return;
        }
        bundle.putParcelable("com.google.android.gms.cast.EXTRA_CAST_DEVICE", (Parcelable)this);
    }

    public static CastDevice getFromBundle(Bundle extras) {
        if (extras == null) {
            return null;
        }
        extras.setClassLoader(CastDevice.class.getClassLoader());
        return (CastDevice)extras.getParcelable("com.google.android.gms.cast.EXTRA_CAST_DEVICE");
    }
}

