/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.appstate;

import android.content.Context;
import android.os.Looper;
import com.google.android.gms.appstate.AppStateBuffer;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Releasable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.a;
import com.google.android.gms.internal.ei;
import com.google.android.gms.internal.fc;
import com.google.android.gms.internal.fq;

public final class AppStateManager {
    static final Api.c<ei> wx = new Api.c();
    private static final Api.b<ei, Api.ApiOptions.NoOptions> wy = new Api.b<ei, Api.ApiOptions.NoOptions>(){

        @Override
        public ei a(Context context, Looper looper, fc fc2, Api.ApiOptions.NoOptions noOptions, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
            return new ei(context, looper, connectionCallbacks, onConnectionFailedListener, fc2.eC(), fc2.eE().toArray(new String[0]));
        }

        @Override
        public int getPriority() {
            return Integer.MAX_VALUE;
        }
    };
    public static final Scope SCOPE_APP_STATE = new Scope("https://www.googleapis.com/auth/appstate");
    public static final Api<Api.ApiOptions.NoOptions> API = new Api<Api.ApiOptions.NoOptions>(wy, wx, SCOPE_APP_STATE);

    private AppStateManager() {
    }

    public static ei a(GoogleApiClient googleApiClient) {
        fq.b(googleApiClient != null, (Object)"GoogleApiClient parameter is required.");
        fq.a(googleApiClient.isConnected(), "GoogleApiClient must be connected.");
        ei ei2 = googleApiClient.a(wx);
        fq.a(ei2 != null, "GoogleApiClient is not configured to use the AppState API. Pass AppStateManager.API into GoogleApiClient.Builder#addApi() to use this feature.");
        return ei2;
    }

    public static int getMaxStateSize(GoogleApiClient googleApiClient) {
        return AppStateManager.a(googleApiClient).dv();
    }

    public static int getMaxNumKeys(GoogleApiClient googleApiClient) {
        return AppStateManager.a(googleApiClient).dw();
    }

    private static StateResult a(final Status status) {
        return new StateResult(){

            @Override
            public Status getStatus() {
                return status;
            }

            @Override
            public StateLoadedResult getLoadedResult() {
                return null;
            }

            @Override
            public StateConflictResult getConflictResult() {
                return null;
            }

            @Override
            public void release() {
            }
        };
    }

    public static void update(GoogleApiClient googleApiClient, final int stateKey, final byte[] data) {
        googleApiClient.b(new e(){

            @Override
            protected void a(ei ei2) {
                ei2.a(null, stateKey, data);
            }
        });
    }

    public static PendingResult<StateResult> updateImmediate(GoogleApiClient googleApiClient, final int stateKey, final byte[] data) {
        return googleApiClient.b(new e(){

            @Override
            protected void a(ei ei2) {
                ei2.a(this, stateKey, data);
            }
        });
    }

    public static PendingResult<StateDeletedResult> delete(GoogleApiClient googleApiClient, final int stateKey) {
        return googleApiClient.b(new b(){

            @Override
            protected void a(ei ei2) {
                ei2.a(this, stateKey);
            }

            public StateDeletedResult c(final Status status) {
                return new StateDeletedResult(){

                    @Override
                    public Status getStatus() {
                        return status;
                    }

                    @Override
                    public int getStateKey() {
                        return stateKey;
                    }
                };
            }

            @Override
            public /* synthetic */ Result d(Status status) {
                return this.c(status);
            }
        });
    }

    public static PendingResult<StateResult> load(GoogleApiClient googleApiClient, final int stateKey) {
        return googleApiClient.a(new e(){

            @Override
            protected void a(ei ei2) {
                ei2.b(this, stateKey);
            }
        });
    }

    public static PendingResult<StateListResult> list(GoogleApiClient googleApiClient) {
        return googleApiClient.a(new c(){

            @Override
            protected void a(ei ei2) {
                ei2.a(this);
            }
        });
    }

    public static PendingResult<StateResult> resolve(GoogleApiClient googleApiClient, final int stateKey, final String resolvedVersion, final byte[] resolvedData) {
        return googleApiClient.b(new e(){

            @Override
            protected void a(ei ei2) {
                ei2.a(this, stateKey, resolvedVersion, resolvedData);
            }
        });
    }

    public static PendingResult<Status> signOut(GoogleApiClient googleApiClient) {
        return googleApiClient.b(new d(){

            @Override
            protected void a(ei ei2) {
                ei2.b(this);
            }
        });
    }

    private static abstract class d
    extends a<Status> {
        private d() {
        }

        public Status f(Status status) {
            return status;
        }

        @Override
        public /* synthetic */ Result d(Status status) {
            return this.f(status);
        }
    }

    private static abstract class c
    extends a<StateListResult> {
        private c() {
        }

        public StateListResult e(final Status status) {
            return new StateListResult(){

                @Override
                public Status getStatus() {
                    return status;
                }

                @Override
                public AppStateBuffer getStateBuffer() {
                    return new AppStateBuffer(null);
                }
            };
        }

        @Override
        public /* synthetic */ Result d(Status status) {
            return this.e(status);
        }
    }

    public static interface StateListResult
    extends Result {
        public AppStateBuffer getStateBuffer();
    }

    private static abstract class b
    extends a<StateDeletedResult> {
        private b() {
        }
    }

    public static interface StateDeletedResult
    extends Result {
        public int getStateKey();
    }

    private static abstract class e
    extends a<StateResult> {
        private e() {
        }

        public StateResult g(Status status) {
            return AppStateManager.a(status);
        }

        @Override
        public /* synthetic */ Result d(Status status) {
            return this.g(status);
        }
    }

    public static interface StateConflictResult
    extends Releasable,
    Result {
        public int getStateKey();

        public String getResolvedVersion();

        public byte[] getLocalData();

        public byte[] getServerData();
    }

    public static interface StateLoadedResult
    extends Releasable,
    Result {
        public int getStateKey();

        public byte[] getLocalData();
    }

    public static interface StateResult
    extends Releasable,
    Result {
        public StateLoadedResult getLoadedResult();

        public StateConflictResult getConflictResult();
    }

    public static abstract class a<R extends Result>
    extends a.b<R, ei> {
        public a() {
            super(wx);
        }
    }
}

