/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import com.google.android.gms.analytics.ExceptionReporter;
import com.google.android.gms.analytics.GoogleAnalytics;
import com.google.android.gms.analytics.TrackerHandler;
import com.google.android.gms.analytics.aa;
import com.google.android.gms.analytics.ad;
import com.google.android.gms.analytics.ae;
import com.google.android.gms.analytics.aj;
import com.google.android.gms.analytics.ak;
import com.google.android.gms.analytics.g;
import com.google.android.gms.analytics.h;
import com.google.android.gms.analytics.i;
import com.google.android.gms.analytics.u;
import com.google.android.gms.analytics.z;
import com.google.android.gms.internal.fq;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

public class Tracker {
    private final TrackerHandler vM;
    private final Map<String, String> vN = new HashMap<String, String>();
    private ad vO;
    private final h vP;
    private final ae vQ;
    private final g vR;
    private boolean vS;
    private a vT;
    private aj vU;

    Tracker(String trackingId, TrackerHandler handler) {
        this(trackingId, handler, h.cb(), ae.cZ(), g.ca(), new z("tracking"));
    }

    Tracker(String trackingId, TrackerHandler handler, h clientIdDefaultProvider, ae screenResolutionDefaultProvider, g appFieldsDefaultProvider, ad rateLimiter) {
        this.vM = handler;
        if (trackingId != null) {
            this.vN.put("&tid", trackingId);
        }
        this.vN.put("useSecure", "1");
        this.vP = clientIdDefaultProvider;
        this.vQ = screenResolutionDefaultProvider;
        this.vR = appFieldsDefaultProvider;
        this.vO = rateLimiter;
        this.vT = new a();
    }

    void a(Context context, aj aj2) {
        Object object;
        aa.y("Loading Tracker config values.");
        this.vU = aj2;
        if (this.vU.dj()) {
            object = this.vU.dk();
            this.set("&tid", (String)object);
            aa.y("[Tracker] trackingId loaded: " + (String)object);
        }
        if (this.vU.dl()) {
            object = Double.toString(this.vU.dm());
            this.set("&sf", (String)object);
            aa.y("[Tracker] sample frequency loaded: " + (String)object);
        }
        if (this.vU.dn()) {
            this.setSessionTimeout(this.vU.getSessionTimeout());
            aa.y("[Tracker] session timeout loaded: " + this.dc());
        }
        if (this.vU.do()) {
            this.enableAutoActivityTracking(this.vU.dp());
            aa.y("[Tracker] auto activity tracking loaded: " + this.dd());
        }
        if (this.vU.dq()) {
            if (this.vU.dr()) {
                this.set("&aip", "1");
                aa.y("[Tracker] anonymize ip loaded: true");
            }
            aa.y("[Tracker] anonymize ip loaded: false");
        }
        this.vS = this.vU.ds();
        if (this.vU.ds()) {
            object = new ExceptionReporter(this, Thread.getDefaultUncaughtExceptionHandler(), context);
            Thread.setDefaultUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)object);
            aa.y("[Tracker] report uncaught exceptions loaded: " + this.vS);
        }
    }

    public void setSessionTimeout(long sessionTimeout) {
        this.vT.setSessionTimeout(sessionTimeout * 1000L);
    }

    long dc() {
        return this.vT.dc();
    }

    public void enableAutoActivityTracking(boolean enabled) {
        this.vT.enableAutoActivityTracking(enabled);
    }

    boolean dd() {
        return this.vT.dd();
    }

    public void send(Map<String, String> params) {
        String string2;
        u.cy().a(u.a.tT);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.putAll(this.vN);
        if (params != null) {
            hashMap.putAll(params);
        }
        if (TextUtils.isEmpty((CharSequence)((CharSequence)hashMap.get("&tid")))) {
            aa.z(String.format("Missing tracking id (%s) parameter.", "&tid"));
        }
        if (TextUtils.isEmpty((CharSequence)(string2 = (String)hashMap.get("&t")))) {
            aa.z(String.format("Missing hit type (%s) parameter.", "&t"));
            string2 = "";
        }
        if (this.vT.de()) {
            hashMap.put("&sc", "start");
        }
        if (!(string2.equals("transaction") || string2.equals("item") || this.vO.cS())) {
            aa.z("Too many hits sent too quickly, rate limiting invoked.");
        } else {
            this.vM.q(hashMap);
        }
    }

    public String get(String key) {
        u.cy().a(u.a.tR);
        if (TextUtils.isEmpty((CharSequence)key)) {
            return null;
        }
        if (this.vN.containsKey(key)) {
            return this.vN.get(key);
        }
        if (key.equals("&ul")) {
            return ak.a(Locale.getDefault());
        }
        if (this.vP != null && this.vP.C(key)) {
            return this.vP.getValue(key);
        }
        if (this.vQ != null && this.vQ.C(key)) {
            return this.vQ.getValue(key);
        }
        if (this.vR != null && this.vR.C(key)) {
            return this.vR.getValue(key);
        }
        return null;
    }

    public void set(String key, String value) {
        fq.b(key, (Object)"Key should be non-null");
        u.cy().a(u.a.tS);
        this.vN.put(key, value);
    }

    public void setSampleRate(double sampleRate) {
        this.set("&sf", Double.toHexString(sampleRate));
    }

    public void setUseSecure(boolean useSecure) {
        this.set("useSecure", ak.u(useSecure));
    }

    public void setScreenName(String screenName) {
        this.set("&cd", screenName);
    }

    public void setLocation(String location) {
        this.set("&dl", location);
    }

    public void setReferrer(String referrer) {
        this.set("&dr", referrer);
    }

    public void setPage(String page) {
        this.set("&dp", page);
    }

    public void setHostname(String hostname) {
        this.set("&dh", hostname);
    }

    public void setTitle(String title) {
        this.set("&dt", title);
    }

    public void setLanguage(String language) {
        this.set("&ul", language);
    }

    public void setEncoding(String encoding) {
        this.set("&de", encoding);
    }

    public void setScreenColors(String screenColors) {
        this.set("&sd", screenColors);
    }

    public void setScreenResolution(int width, int height) {
        if (width < 0 && height < 0) {
            aa.z("Invalid width or height. The values should be non-negative.");
            return;
        }
        this.set("&sr", width + "x" + height);
    }

    public void setViewportSize(String viewportSize) {
        this.set("&vp", viewportSize);
    }

    public void setClientId(String clientId) {
        this.set("&cid", clientId);
    }

    public void setAppName(String appName) {
        this.set("&an", appName);
    }

    public void setAppId(String appId) {
        this.set("&aid", appId);
    }

    public void setAppInstallerId(String appInstallerId) {
        this.set("&aiid", appInstallerId);
    }

    public void setAppVersion(String appVersion) {
        this.set("&av", appVersion);
    }

    public void setAnonymizeIp(boolean anonymize) {
        this.set("&aip", ak.u(anonymize));
    }

    public void enableAdvertisingIdCollection(boolean enabled) {
        if (!enabled) {
            this.vN.put("&ate", null);
            this.vN.put("&adid", null);
        } else {
            if (this.vN.containsKey("&ate")) {
                this.vN.remove("&ate");
            }
            if (this.vN.containsKey("&adid")) {
                this.vN.remove("&adid");
            }
        }
    }

    private class com.google.android.gms.analytics.Tracker$a
    implements GoogleAnalytics.a {
        private Timer vV;
        private TimerTask vW;
        private boolean vX = false;
        private boolean vY = false;
        private int vZ = 0;
        private long wa = -1L;
        private boolean wb = false;
        private long wc;
        private i tg;

        public com.google.android.gms.analytics.Tracker$a() {
            this.tg = new i(){

                @Override
                public long currentTimeMillis() {
                    return System.currentTimeMillis();
                }
            };
        }

        public void setSessionTimeout(long sessionTimeout) {
            this.wa = sessionTimeout;
            this.df();
        }

        public long dc() {
            return this.wa;
        }

        public void enableAutoActivityTracking(boolean enabled) {
            this.vY = enabled;
            this.df();
        }

        public boolean dd() {
            return this.vY;
        }

        public boolean de() {
            boolean bl2 = this.wb;
            this.wb = false;
            return bl2;
        }

        private void df() {
            GoogleAnalytics googleAnalytics = GoogleAnalytics.cM();
            if (googleAnalytics == null) {
                aa.w("GoogleAnalytics isn't initialized for the Tracker!");
                return;
            }
            if (this.wa >= 0L || this.vY) {
                googleAnalytics.a(Tracker.this.vT);
            } else {
                googleAnalytics.b(Tracker.this.vT);
            }
        }

        @Override
        public void f(Activity activity) {
            u.cy().a(u.a.uQ);
            this.dg();
            if (!this.vX && this.vZ == 0 && this.dh()) {
                this.wb = true;
            }
            this.vX = true;
            ++this.vZ;
            if (this.vY) {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("&t", "appview");
                u.cy().t(true);
                Tracker.this.set("&cd", Tracker.this.vU != null ? Tracker.this.vU.h(activity) : activity.getClass().getCanonicalName());
                Tracker.this.send(hashMap);
                u.cy().t(false);
            }
        }

        @Override
        public void g(Activity activity) {
            u.cy().a(u.a.uR);
            --this.vZ;
            this.vZ = Math.max(0, this.vZ);
            this.wc = this.tg.currentTimeMillis();
            if (this.vZ == 0) {
                this.dg();
                this.vW = new a();
                this.vV = new Timer("waitForActivityStart");
                this.vV.schedule(this.vW, 1000L);
            }
        }

        private synchronized void dg() {
            if (this.vV != null) {
                this.vV.cancel();
                this.vV = null;
            }
        }

        boolean dh() {
            return this.wa == 0L || this.wa > 0L && this.tg.currentTimeMillis() > this.wc + this.wa;
        }

        private class a
        extends TimerTask {
            private a() {
            }

            @Override
            public void run() {
                a.this.vX = false;
            }
        }
    }
}

