<?php
// Enable error reporting for debugging (remove in production)
// error_reporting(E_ALL);
// ini_set('display_errors', 1);

ob_start();
session_start();

include('../includes/connection.php'); // This includes your MySQLi connection

// Date handling
$date = new DateTime();
if (empty($_REQUEST['hday']) || empty($_REQUEST['hmonth']) || empty($_REQUEST['hyear'])) {
    $day = $date->format('j');
    $month = $date->format('n');
    $year = $date->format('Y');
} else {
    $day = $_REQUEST['hday'];
    $month = $_REQUEST['hmonth'];
    $year = $_REQUEST['hyear'];
}

$cal_date = sprintf("%d/%d/%d", $month, $day, $year);
$hdate = date('Y-m-d', strtotime($cal_date));

// Fetch horoscope data using MySQLi
$query = "SELECT sign, english_content FROM daily WHERE hdate = '" . mysqli_real_escape_string($link, $hdate) . "'";
$result = mysqli_query($link, $query);

// Initialize content variables
$content1 = $content2 = $content3 = $content4 = $content5 = $content6 = 
$content7 = $content8 = $content9 = $content10 = $content11 = $content12 = '';

if ($result) {
    while ($row = mysqli_fetch_assoc($result)) {
        switch ($row['sign']) {
            case 'Aries': $content1 = $row['english_content']; break;
            case 'Taurus': $content2 = $row['english_content']; break;
            case 'Gemini': $content3 = $row['english_content']; break;
            case 'Cancer': $content4 = $row['english_content']; break;
            case 'Leo': $content5 = $row['english_content']; break;
            case 'Virgo': $content6 = $row['english_content']; break;
            case 'Libra': $content7 = $row['english_content']; break;
            case 'Scorpio': $content8 = $row['english_content']; break;
            case 'Sagittarius': $content9 = $row['english_content']; break;
            case 'Capricorn': $content10 = $row['english_content']; break;
            case 'Aquarius': $content11 = $row['english_content']; break;
            case 'Pisces': $content12 = $row['english_content']; break;
        }
    }
    mysqli_free_result($result);
}

// No need to close connection as it will close automatically at script end
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8"> 
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Daily Horoscope Predictions for Your Zodiac Sign</title>
    <meta name="keywords" content="Daily Horoscope">
    <meta name="description" content="Explore daily horoscope predictions and astrology insights on Find Your Fate. Get accurate readings and guidance for your zodiac sign. Discover more now!"> 
    <meta name="original-source" content="https://horoscope.findyourfate.com/daily-horoscope.php">
    <link rel="canonical" href="https://horoscope.findyourfate.com/daily-horoscope.php" />
    <!-- Rest of your head content remains the same -->
    <link rel="alternate" hreflang="en" href="https://horoscope.findyourfate.com/daily-horoscope.php" />
    <link rel="alternate" hreflang="ar" href="https://horoscope.findyourfate.com/daily-horoscope-arabic.php" />
    <link rel="alternate" hreflang="zh" href="https://horoscope.findyourfate.com/daily-horoscope-chinese.php" />
    <link rel="alternate" hreflang="nl" href="https://horoscope.findyourfate.com/daily-horoscope-dutch.php" />
    <link rel="alternate" hreflang="fr" href="https://horoscope.findyourfate.com/daily-horoscope-french.php" />
    <link rel="alternate" hreflang="de" href="https://horoscope.findyourfate.com/daily-horoscope-german.php" />
    <link rel="alternate" hreflang="hi" href="https://horoscope.findyourfate.com/daily-horoscope-hindi.php" />
    <link rel="alternate" hreflang="ja" href="https://horoscope.findyourfate.com/daily-horoscope-japanese.php" />
    <link rel="alternate" hreflang="ms" href="https://horoscope.findyourfate.com/daily-horoscope-malay.php" />
    <link rel="alternate" hreflang="pt" href="https://horoscope.findyourfate.com/daily-horoscope-portuguese.php" />
    <link rel="alternate" hreflang="ru" href="https://horoscope.findyourfate.com/daily-horoscope-russian.php" />
    <link rel="alternate" hreflang="es" href="https://horoscope.findyourfate.com/daily-horoscope-spanish.php" />
    <link rel="alternate" hreflang="ta" href="https://horoscope.findyourfate.com/daily-horoscope-tamil.php" />
    <link rel="alternate" hreflang="te" href="https://horoscope.findyourfate.com/daily-horoscope-telugu.php" />
    <link rel="alternate" hreflang="x-default" href="https://horoscope.findyourfate.com/daily-horoscope.php" />
    <meta name="author" content="Nimmi">
    <link rel="preload" href="https://www.findyourfate.com/includes/bootstrap-mainmenu.css" as="style">
    <link rel="preload" href="https://www.findyourfate.com/includes/touchy.css" as="style">
    <link rel="preload" href="https://horoscope.findyourfate.com/includes/subdomainhoroscope.js" as="script">
    <link rel="stylesheet" href='https://www.findyourfate.com/includes/touchy.css' media='all'>
    <link rel="stylesheet" href='https://www.findyourfate.com/includes/bootstrap-mainmenu.css' media='all'>
    <link rel="apple-touch-icon" sizes="120x120" href="/apple-touch-icon-120x120-precomposed.png" /> 
    <link rel="apple-touch-icon" sizes="152x152" href="/apple-touch-icon-152x152-precomposed.png" />
    
    <style type="text/css">
        .dropbtn{cursor: pointer; background-color: unset;border:none;}
        .dropbtn:hover, .dropbtn:focus {background-color: unset;border:none;}
        .dropdown{position: relative;display: inline-block;margin: 10px 0 5px 0;}
        .dropdown-content { display: none;line-height:20px; position: absolute; background-color: #8a6d3b; min-width: 240px; overflow: auto; box-shadow: 0px 8px 16px 0px rgba(0,0,0,0.2); z-index: 1; border-radius:2px;}
        .dropdown-content a {cursor: pointer; padding: 5px 0px 5px 10px;color: #fff;font-size: 15px;letter-spacing: 0.50px;text-decoration: none; display: block;border-bottom: 1px dotted #e7e7e7;}
        .dropdown a:hover {cursor: pointer;background-color: unset;color: #eeaf0c;}
        @media only screen and (min-device-width: 320px) and (max-device-width: 480px){
            .dropdown {margin: 5px 0 10px 0;}
            .dropdown-content {right:0;}
        }
        @media (max-width: 767px){.hidden-xs{display: none!important;}}
        @media (max-width: 991px) and (min-width: 768px){.hidden-sm {display: none!important;}}
        .dropdown:hover .dropdown-content {display: block;}
    </style>
    <style>
        #adsize_custom{height: 100%; width:100%;align:center; max-height: 350px; min-height:350px;padding:15px;display:block;} 
        #topmenu{min-height: 51px; max-height: 110px; height: 100%;}
    </style>
    
    <script type="text/javascript" src='https://www.findyourfate.com/includes/top-footer-menu-cls.js'></script>
    <script type="text/javascript" src='https://horoscope.findyourfate.com/includes/subdomainhoroscope.js'></script>
    <script type="text/javascript" src='https://horoscope.findyourfate.com/includes/subdomainhoroscope-as.js'></script>
    <script type="text/javascript">headad();</script>
</head>  
<body>
    <div class='touchy-search-wrapper'>
        <form action='https://www.findyourfate.com/google-search.html' id='searchform cse-search-box'>
            <input type='hidden' name='cx' value='partner-pub-7449524369049758:6676479963'>
            <input type='hidden' name='cof' value='FORID:10'>
            <input type='hidden' name='ie' value='UTF-8'>
            <input type='text' name='q' class='touchy-search-field' placeholder='Search findyourfate.com'>
            <div class='touchy-clear-search-wrapper'>
                <div class='touchy-clear-search'></div>
                <input type='submit' name='submit' class='touchy-search' value='Search'>
            </div>
        </form>
    </div>
    
    <!-- Rest of your HTML structure remains largely the same -->
    <div class="container-fluid">
        <!-- ... Header content ... -->
    </div>

    <!-- Zodiac sign content display -->
    <div class="row"> 
        <div class="col-sm-3 col-md-3 col-xs-3 col-lg-3">
            <div style="text-align:center;padding-top:10px;">
                <a href="https://horoscope.findyourfate.com/ariesdailyhoroscope.html">
                    <img src="data:image/png;base64,R0lGODlhAQABAAD/ACwAAAAAAQABAAACADs=" 
                         data-src="images/daily-aries.jpg" 
                         width="100" height="102" 
                         class="img-responsive" 
                         alt="daily-aries" 
                         id="aimaghome" 
                         style="border:none;">
                </a>
            </div>
        </div>
        <div class="col-sm-9 col-md-9 col-xs-9 col-lg-9">
            <a onMouseOver="this.style.color='#79a0db'" 
               onMouseOut="this.style.color='#acd6fc'" 
               href="https://horoscope.findyourfate.com/ariesdailyhoroscope.html">
                <div style="text-align:left;">
                    <p style="color:#acd6fc;font-size:23px">Aries >></p>
                </div>
                <div style="text-align:justify; color:#ffffff; line-height:20px; text-transform:none;">
                    <?php echo htmlspecialchars(substr($content1, 0, 150)) . '...'; ?>
                </div>
                <div style="text-align:left;padding-top:10px; color:#ffffff; text-decoration:underline;">
                    Read Today's Full Aries Horoscope >>
                </div>
            </a>
        </div>
    </div><br>

    <div class="row"> 
        <div class="col-sm-3 col-md-3 col-xs-3 col-lg-3">
            <div style="text-align:center;padding-top:10px;">
                <a href="https://horoscope.findyourfate.com/taurusdailyhoroscope.html">
                    <img src="data:image/png;base64,R0lGODlhAQABAAD/ACwAAAAAAQABAAACADs=" 
                         data-src="images/daily-taurus.jpg" 
                         width="100" height="102" 
                         class="img-responsive" 
                         alt="daily-taurus" 
                         id="timaghome" 
                         style="border:none;">
                </a>
            </div>
        </div>
        <div class="col-sm-9 col-md-9 col-xs-9 col-lg-9">
            <a onMouseOver="this.style.color='#79a0db'" 
               onMouseOut="this.style.color='#acd6fc'" 
               href="https://horoscope.findyourfate.com/taurusdailyhoroscope.html">
                <div style="text-align:left;">
                    <p style="color:#acd6fc;font-size:23px">Taurus >></p>
                </div>
                <div style="text-align:justify; color:#ffffff; line-height:20px; text-transform:none;">
                    <?php echo htmlspecialchars(substr($content2, 0, 150)) . '...'; ?>
                </div>
                <div style="text-align:left;padding-top:10px; color:#ffffff; text-decoration:underline;">
                    Read Today's Full Taurus Horoscope >>
                </div>
            </a>
        </div>
    </div><br>

    <div class="row"> 
        <div class="col-sm-3 col-md-3 col-xs-3 col-lg-3">
            <div style="text-align:center;padding-top:10px;">
                <a href="https://horoscope.findyourfate.com/geminidailyhoroscope.html">
                    <img src="data:image/png;base64,R0lGODlhAQABAAD/ACwAAAAAAQABAAACADs=" 
                         data-src="images/daily-gemini.jpg" 
                         width="100" height="102" 
                         class="img-responsive" 
                         alt="daily-gemini" 
                         id="gimaghome" 
                         style="border:none;">
                </a>
            </div>
        </div>
        <div class="col-sm-9 col-md-9 col-xs-9 col-lg-9">
            <a onMouseOver="this.style.color='#79a0db'" 
               onMouseOut="this.style.color='#acd6fc'" 
               href="https://horoscope.findyourfate.com/geminidailyhoroscope.html">
                <div style="text-align:left;">
                    <p style="color:#acd6fc;font-size:23px">Gemini >></p>
                </div>
                <div style="text-align:justify; color:#ffffff; line-height:20px; text-transform:none;">
                    <?php echo htmlspecialchars(substr($content3, 0, 150)) . '...'; ?>
                </div>
                <div style="text-align:left;padding-top:10px; color:#ffffff; text-decoration:underline;">
                    Read Today's Full Gemini Horoscope >>
                </div>
            </a>
        </div>
    </div><br>

    <!-- Cancer -->
    <div class="row"> 
        <div class="col-sm-3 col-md-3 col-xs-3 col-lg-3">
            <div style="text-align:center;padding-top:10px;">
                <a href="https://horoscope.findyourfate.com/cancerdailyhoroscope.html">
                    <img src="data:image/png;base64,R0lGODlhAQABAAD/ACwAAAAAAQABAAACADs=" 
                         data-src="images/daily-cancer.jpg" 
                         width="100" height="102" 
                         class="img-responsive" 
                         alt="daily-cancer" 
                         id="caimaghome" 
                         style="border:none;">
                </a>
            </div>
        </div>
        <div class="col-sm-9 col-md-9 col-xs-9 col-lg-9">
            <a onMouseOver="this.style.color='#79a0db'" 
               onMouseOut="this.style.color='#acd6fc'" 
               href="https://horoscope.findyourfate.com/cancerdailyhoroscope.html">
                <div style="text-align:left;">
                    <p style="color:#acd6fc;font-size:23px">Cancer >></p>
                </div>
                <div style="text-align:justify; color:#ffffff; line-height:20px; text-transform:none;">
                    <?php echo htmlspecialchars(substr($content4, 0, 150)) . '...'; ?>
                </div>
                <div style="text-align:left;padding-top:10px; color:#ffffff; text-decoration:underline;">
                    Read Today's Full Cancer Horoscope >>
                </div>
            </a>
        </div>
    </div><br>

    <!-- Leo -->
    <div class="row"> 
        <div class="col-sm-3 col-md-3 col-xs-3 col-lg-3">
            <div style="text-align:center;padding-top:10px;">
                <a href="https://horoscope.findyourfate.com/leodailyhoroscope.html">
                    <img src="data:image/png;base64,R0lGODlhAQABAAD/ACwAAAAAAQABAAACADs=" 
                         data-src="images/daily-leo.jpg" 
                         width="100" height="102" 
                         class="img-responsive" 
                         alt="daily-leo" 
                         id="leoimaghome" 
                         style="border:none;">
                </a>
            </div>
        </div>
        <div class="col-sm-9 col-md-9 col-xs-9 col-lg-9">
            <a onMouseOver="this.style.color='#79a0db'" 
               onMouseOut="this.style.color='#acd6fc'" 
               href="https://horoscope.findyourfate.com/leodailyhoroscope.html">
                <div style="text-align:left;">
                    <p style="color:#acd6fc;font-size:23px">Leo >></p>
                </div>
                <div style="text-align:justify; color:#ffffff; line-height:20px; text-transform:none;">
                    <?php echo htmlspecialchars(substr($content5, 0, 150)) . '...'; ?>
                </div>
                <div style="text-align:left;padding-top:10px; color:#ffffff; text-decoration:underline;">
                    Read Today's Full Leo Horoscope >>
                </div>
            </a>
        </div>
    </div><br>

    <!-- Virgo -->
    <div class="row"> 
        <div class="col-sm-3 col-md-3 col-xs-3 col-lg-3">
            <div style="text-align:center;padding-top:10px;">
                <a href="https://horoscope.findyourfate.com/virgodailyhoroscope.html">
                    <img src="data:image/png;base64,R0lGODlhAQABAAD/ACwAAAAAAQABAAACADs=" 
                         data-src="images/daily-virgo.jpg" 
                         width="100" height="102" 
                         class="img-responsive" 
                         alt="daily-virgo" 
                         id="vimaghome" 
                         style="border:none;">
                </a>
            </div>
        </div>
        <div class="col-sm-9 col-md-9 col-xs-9 col-lg-9">
            <a onMouseOver="this.style.color='#79a0db'" 
               onMouseOut="this.style.color='#acd6fc'" 
               href="https://horoscope.findyourfate.com/virgodailyhoroscope.html">
                <div style="text-align:left;">
                    <p style="color:#acd6fc;font-size:23px">Virgo >></p>
                </div>
                <div style="text-align:justify; color:#ffffff; line-height:20px; text-transform:none;">
                    <?php echo htmlspecialchars(substr($content6, 0, 150)) . '...'; ?>
                </div>
                <div style="text-align:left;padding-top:10px; color:#ffffff; text-decoration:underline;">
                    Read Today's Full Virgo Horoscope >>
                </div>
            </a>
        </div>
    </div><br>

    <!-- Libra -->
    <div class="row"> 
        <div class="col-sm-3 col-md-3 col-xs-3 col-lg-3">
            <div style="text-align:center;padding-top:10px;">
                <a href="https://horoscope.findyourfate.com/libradailyhoroscope.html">
                    <img src="data:image/png;base64,R0lGODlhAQABAAD/ACwAAAAAAQABAAACADs=" 
                         data-src="images/daily-libra.jpg" 
                         width="100" height="102" 
                         class="img-responsive" 
                         alt="daily-libra" 
                         id="limaghome" 
                         style="border:none;">
                </a>
            </div>
        </div>
        <div class="col-sm-9 col-md-9 col-xs-9 col-lg-9">
            <a onMouseOver="this.style.color='#79a0db'" 
               onMouseOut="this.style.color='#acd6fc'" 
               href="https://horoscope.findyourfate.com/libradailyhoroscope.html">
                <div style="text-align:left;">
                    <p style="color:#acd6fc;font-size:23px">Libra >></p>
                </div>
                <div style="text-align:justify; color:#ffffff; line-height:20px; text-transform:none;">
                    <?php echo htmlspecialchars(substr($content7, 0, 150)) . '...'; ?>
                </div>
                <div style="text-align:left;padding-top:10px; color:#ffffff; text-decoration:underline;">
                    Read Today's Full Libra Horoscope >>
                </div>
            </a>
        </div>
    </div><br>

    <!-- Scorpio -->
    <div class="row"> 
        <div class="col-sm-3 col-md-3 col-xs-3 col-lg-3">
            <div style="text-align:center;padding-top:10px;">
                <a href="https://horoscope.findyourfate.com/scorpiodailyhoroscope.html">
                    <img src="data:image/png;base64,R0lGODlhAQABAAD/ACwAAAAAAQABAAACADs=" 
                         data-src="images/daily-scorpio.jpg" 
                         width="100" height="102" 
                         class="img-responsive" 
                         alt="daily-scorpio" 
                         id="scoimaghome" 
                         style="border:none;">
                </a>
            </div>
        </div>
        <div class="col-sm-9 col-md-9 col-xs-9 col-lg-9">
            <a onMouseOver="this.style.color='#79a0db'" 
               onMouseOut="this.style.color='#acd6fc'" 
               href="https://horoscope.findyourfate.com/scorpiodailyhoroscope.html">
                <div style="text-align:left;">
                    <p style="color:#acd6fc;font-size:23px">Scorpio >></p>
                </div>
                <div style="text-align:justify; color:#ffffff; line-height:20px; text-transform:none;">
                    <?php echo htmlspecialchars(substr($content8, 0, 150)) . '...'; ?>
                </div>
                <div style="text-align:left;padding-top:10px; color:#ffffff; text-decoration:underline;">
                    Read Today's Full Scorpio Horoscope >>
                </div>
            </a>
        </div>
    </div><br>

    <!-- Sagittarius -->
    <div class="row"> 
        <div class="col-sm-3 col-md-3 col-xs-3 col-lg-3">
            <div style="text-align:center;padding-top:10px;">
                <a href="https://horoscope.findyourfate.com/sagittariusdailyhoroscope.html">
                    <img src="data:image/png;base64,R0lGODlhAQABAAD/ACwAAAAAAQABAAACADs=" 
                         data-src="images/daily-sagittarius.jpg" 
                         width="100" height="102" 
                         class="img-responsive" 
                         alt="daily-sagittarius" 
                         id="sagimaghome" 
                         style="border:none;">
                </a>
            </div>
        </div>
        <div class="col-sm-9 col-md-9 col-xs-9 col-lg-9">
            <a onMouseOver="this.style.color='#79a0db'" 
               onMouseOut="this.style.color='#acd6fc'" 
               href="https://horoscope.findyourfate.com/sagittariusdailyhoroscope.html">
                <div style="text-align:left;">
                    <p style="color:#acd6fc;font-size:23px">Sagittarius >></p>
                </div>
                <div style="text-align:justify; color:#ffffff; line-height:20px; text-transform:none;">
                    <?php echo htmlspecialchars(substr($content9, 0, 150)) . '...'; ?>
                </div>
                <div style="text-align:left;padding-top:10px; color:#ffffff; text-decoration:underline;">
                    Read Today's Full Sagittarius Horoscope >>
                </div>
            </a>
        </div>
    </div><br>

    <!-- Capricorn -->
    <div class="row"> 
        <div class="col-sm-3 col-md-3 col-xs-3 col-lg-3">
            <div style="text-align:center;padding-top:10px;">
                <a href="https://horoscope.findyourfate.com/capricorndailyhoroscope.html">
                    <img src="data:image/png;base64,R0lGODlhAQABAAD/ACwAAAAAAQABAAACADs=" 
                         data-src="images/daily-capricorn.jpg" 
                         width="100" height="102" 
                         class="img-responsive" 
                         alt="daily-capricorn" 
                         id="capimaghome" 
                         style="border:none;">
                </a>
            </div>
        </div>
        <div class="col-sm-9 col-md-9 col-xs-9 col-lg-9">
            <a onMouseOver="this.style.color='#79a0db'" 
               onMouseOut="this.style.color='#acd6fc'" 
               href="https://horoscope.findyourfate.com/capricorndailyhoroscope.html">
                <div style="text-align:left;">
                    <p style="color:#acd6fc;font-size:23px">Capricorn >></p>
                </div>
                <div style="text-align:justify; color:#ffffff; line-height:20px; text-transform:none;">
                    <?php echo htmlspecialchars(substr($content10, 0, 150)) . '...'; ?>
                </div>
                <div style="text-align:left;padding-top:10px; color:#ffffff; text-decoration:underline;">
                    Read Today's Full Capricorn Horoscope >>
                </div>
            </a>
        </div>
    </div><br>

    <!-- Aquarius -->
    <div class="row"> 
        <div class="col-sm-3 col-md-3 col-xs-3 col-lg-3">
            <div style="text-align:center;padding-top:10px;">
                <a href="https://horoscope.findyourfate.com/aquariusdailyhoroscope.html">
                    <img src="data:image/png;base64,R0lGODlhAQABAAD/ACwAAAAAAQABAAACADs=" 
                         data-src="images/daily-aquarius.jpg" 
                         width="100" height="102" 
                         class="img-responsive" 
                         alt="daily-aquarius" 
                         id="aquimaghome" 
                         style="border:none;">
                </a>
            </div>
        </div>
        <div class="col-sm-9 col-md-9 col-xs-9 col-lg-9">
            <a onMouseOver="this.style.color='#79a0db'" 
               onMouseOut="this.style.color='#acd6fc'" 
               href="https://horoscope.findyourfate.com/aquariusdailyhoroscope.html">
                <div style="text-align:left;">
                    <p style="color:#acd6fc;font-size:23px">Aquarius >></p>
                </div>
                <div style="text-align:justify; color:#ffffff; line-height:20px; text-transform:none;">
                    <?php echo htmlspecialchars(substr($content11, 0, 150)) . '...'; ?>
                </div>
                <div style="text-align:left;padding-top:10px; color:#ffffff; text-decoration:underline;">
                    Read Today's Full Aquarius Horoscope >>
                </div>
            </a>
        </div>
    </div><br>

    <!-- Pisces -->
    <div class="row"> 
        <div class="col-sm-3 col-md-3 col-xs-3 col-lg-3">
            <div style="text-align:center;padding-top:10px;">
                <a href="https://horoscope.findyourfate.com/piscesdailyhoroscope.html">
                    <img src="data:image/png;base64,R0lGODlhAQABAAD/ACwAAAAAAQABAAACADs=" 
                         data-src="images/daily-pisces.jpg" 
                         width="100" height="102" 
                         class="img-responsive" 
                         alt="daily-pisces" 
                         id="pisimaghome" 
                         style="border:none;">
                </a>
            </div>
        </div>
        <div class="col-sm-9 col-md-9 col-xs-9 col-lg-9">
            <a onMouseOver="this.style.color='#79a0db'" 
               onMouseOut="this.style.color='#acd6fc'" 
               href="https://horoscope.findyourfate.com/piscesdailyhoroscope.html">
                <div style="text-align:left;">
                    <p style="color:#acd6fc;font-size:23px">Pisces >></p>
                </div>
                <div style="text-align:justify; color:#ffffff; line-height:20px; text-transform:none;">
                    <?php echo htmlspecialchars(substr($content12, 0, 150)) . '...'; ?>
                </div>
                <div style="text-align:left;padding-top:10px; color:#ffffff; text-decoration:underline;">
                    Read Today's Full Pisces Horoscope >>
                </div>
            </a>
        </div>
    </div><br>

    <!-- Rest of your HTML content -->
    <div style="clear: both;"></div>
    <p style="padding:10px">
        <p style="padding-left:20px;">
            <p align="left">
                <b style="font-size:24px; text-align:center;color:#c7e5fc;">Related Links</b>
            </p>
            <hr class="style4">
            <p>• <a href="https://www.findyourfate.com/rss/horoscope-feed.php" style="text-align:center;"><b>Horoscope Feed</b></a></p>
        </p>
    </p>

    <div id="adsize_custom" style="max-height: 350px;width:100%;">
        <script>fnhorodesk();</script>
    </div>
    <script>footer();</script>
    
    <button onClick="topFunction()" id="myBtn" title="Go to top">Top</button>
    
    <script type='text/javascript' src='https://www.findyourfate.com/includes/jquery.js'></script>
    <script async type='text/javascript' src='https://www.findyourfate.com/includes/touchy.js'></script>
    
    <script>
    function popupnum(){
        var theSecondDate=new Date();
        var d=theSecondDate.getUTCDate();
        var a=theSecondDate.getUTCMonth()+1;
        var y=theSecondDate.getFullYear();
        openWin=window.open("news.php?hday="+d+"&hmonth="+a+"&hyear="+y,"myWindow","top=125,left=150,width=520,height=670,buttons=no,scrollbars=no,location=no,menubar=no,resizable=yes,status=no,directories=no,toolbar=no")
    }
    
    window.onscroll = function() {scrollFunction()};
    function scrollFunction() {
        if (document.body.scrollTop > 20 || document.documentElement.scrollTop > 20) {
            document.getElementById("myBtn").style.display = "block";
        } else {
            document.getElementById("myBtn").style.display = "none";
        }
    }
    
    function topFunction() {
        document.body.scrollTop = 0;
        document.documentElement.scrollTop = 0;
    }
    
    function myFunction() {
        document.getElementById("myDropdown").classList.toggle("show");
    }
    
    window.onclick = function(event) {
        if (!event.target.matches('.dropbtn')) {
            var dropdowns = document.getElementsByClassName("dropdown-content");
            var i;
            for (i = 0; i < dropdowns.length; i++) {
                var openDropdown = dropdowns[i];
                if (openDropdown.classList.contains('show')) {
                    openDropdown.classList.remove('show');
                }
            }
        }
    }

    window.addEventListener('scroll', function() {
        var imgDefer = document.getElementsByTagName('img');
        for (var i=0; i<imgDefer.length; i++) {
            if(imgDefer[i].getAttribute('data-src')) {
                imgDefer[i].setAttribute('src',imgDefer[i].getAttribute('data-src'));
            }
        }
    });
    </script>
</body>
</html>

<?php
ob_end_flush();
?>