/*
 * Decompiled with CFR 0.152.
 */
package taurus.findyourfate.com;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.AsyncTask;
import android.os.Bundle;
import android.text.Html;
import android.text.TextUtils;
import android.util.Log;
import android.widget.Button;
import com.google.firebase.messaging.FirebaseMessaging;
import java.util.concurrent.atomic.AtomicReference;
import taurus.findyourfate.com.MainActivityfirst;
import taurus.findyourfate.com.R;

public class RegisterActivity
extends Activity {
    Button btnGCMRegister;
    Button btnAppShare;
    Context context;
    String regId;
    public static final String PROPERTY_REG_ID = "regId";
    private static final String APP_VERSION = "appVersion";
    static final String TAG = "Register Activity";

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.home);
        this.getActionBar().setTitle((CharSequence)Html.fromHtml((String)"<font color=\"#ffffff\" size=\"25px\"><b>Taurus</b></font>"));
        this.context = this.getApplicationContext();
        this.regId = this.registerGCM();
    }

    public String registerGCM() {
        FirebaseMessaging.getInstance().getToken().addOnCompleteListener(task -> {
            if (!task.isSuccessful()) {
                Log.w((String)"RegisterActivity", (String)"Fetching FCM registration token failed", (Throwable)task.getException());
                return;
            }
            String token = (String)task.getResult();
            Log.d((String)"RegisterActivity", (String)("FCM Token: " + token));
            this.storeRegistrationId(this.context, token);
        });
        if (TextUtils.isEmpty((CharSequence)this.regId)) {
            this.registerInBackground();
        }
        return this.regId;
    }

    private String getRegistrationId(Context context) {
        int currentVersion;
        SharedPreferences prefs = this.getGCMPreferences(context);
        String registrationId = prefs.getString(PROPERTY_REG_ID, "");
        if (registrationId.isEmpty()) {
            Log.i((String)TAG, (String)"Registration not found.");
            return "";
        }
        int registeredVersion = prefs.getInt(APP_VERSION, Integer.MIN_VALUE);
        if (registeredVersion != (currentVersion = RegisterActivity.getAppVersion(context))) {
            return "";
        }
        return registrationId;
    }

    private SharedPreferences getGCMPreferences(Context context) {
        return this.getSharedPreferences(RegisterActivity.class.getSimpleName(), 0);
    }

    private static int getAppVersion(Context context) {
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            return packageInfo.versionCode;
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.d((String)"RegisterActivity", (String)("I never expected this! Going down, going down!" + (Object)((Object)e)));
            throw new RuntimeException(e);
        }
    }

    @SuppressLint(value={"StaticFieldLeak"})
    private void registerInBackground() {
        new AsyncTask<Void, Void, String>(){

            protected String doInBackground(Void ... params) {
                AtomicReference<String> msg = new AtomicReference<String>("");
                try {
                    FirebaseMessaging.getInstance().getToken().addOnCompleteListener(task -> {
                        if (!task.isSuccessful()) {
                            Log.w((String)"RegisterActivity", (String)"Fetching FCM registration token failed", (Throwable)task.getException());
                            return;
                        }
                        RegisterActivity.this.regId = (String)task.getResult();
                        Log.d((String)"RegisterActivity", (String)("registerInBackground - regId: " + RegisterActivity.this.regId));
                        msg.set("Device registered, registration ID=" + RegisterActivity.this.regId);
                        RegisterActivity.this.storeRegistrationId(RegisterActivity.this.context, RegisterActivity.this.regId);
                        Intent i = new Intent(RegisterActivity.this.context, MainActivityfirst.class);
                        i.putExtra(RegisterActivity.PROPERTY_REG_ID, RegisterActivity.this.regId);
                        RegisterActivity.this.context.startActivity(i);
                    });
                }
                catch (Exception ex) {
                    msg.set("Error: " + ex.getMessage());
                    Log.d((String)"RegisterActivity", (String)("Error: " + msg));
                    Intent i = new Intent(RegisterActivity.this.context, MainActivityfirst.class);
                    i.putExtra(RegisterActivity.PROPERTY_REG_ID, RegisterActivity.this.regId);
                    RegisterActivity.this.context.startActivity(i);
                }
                Log.d((String)"RegisterActivity", (String)("AsyncTask completed: " + msg));
                return msg.get();
            }

            protected void onPostExecute(String msg) {
            }
        }.execute((Object[])new Void[]{null, null, null});
    }

    private void storeRegistrationId(Context context, String regId) {
        SharedPreferences prefs = this.getSharedPreferences(MainActivityfirst.class.getSimpleName(), 0);
        int appVersion = RegisterActivity.getAppVersion(context);
        Log.i((String)TAG, (String)("Saving regId on app version " + appVersion));
        SharedPreferences.Editor editor = prefs.edit();
        editor.putString(PROPERTY_REG_ID, regId);
        editor.putInt(APP_VERSION, appVersion);
        editor.commit();
    }

    public void onBackPressed() {
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this);
        builder.setTitle((CharSequence)"Exit!");
        builder.setMessage((CharSequence)"Are you sure you want to exit from Taurus app?").setCancelable(false).setIcon(R.drawable.alert).setPositiveButton((CharSequence)"Yes", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int id2) {
                Intent intent = new Intent("android.intent.action.MAIN");
                intent.addCategory("android.intent.category.HOME");
                intent.setFlags(0x10000000);
                RegisterActivity.this.startActivity(intent);
            }
        }).setNegativeButton((CharSequence)"No", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int id2) {
                dialog.cancel();
            }
        });
        AlertDialog alert = builder.create();
        alert.show();
    }
}

