package scorpio.findyourfate.com;
import java.util.ArrayList;
import java.util.List;

import com.google.android.gms.common.api.GoogleApiClient;

import android.annotation.SuppressLint;
import android.app.AlertDialog;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.SharedPreferences.Editor;
import android.content.res.Configuration;
import android.content.res.TypedArray;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import androidx.appcompat.app.ActionBar;
import androidx.appcompat.app.ActionBarDrawerToggle;
import androidx.appcompat.app.AppCompatActivity;
import androidx.drawerlayout.widget.DrawerLayout;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentStatePagerAdapter;
import androidx.fragment.app.FragmentTransaction;
import androidx.viewpager.widget.ViewPager;

import android.text.Html;
import android.util.Log;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.AdapterView;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.ListView;
import android.widget.PopupWindow;
import android.widget.RelativeLayout;


public class MainActivity extends  AppCompatActivity implements ActionBar.TabListener {

	private String[] tabs = {"Horoscopes", "Traits", "Compatibility"};
	ViewPager viewPager;
	TapFragmentManager fragmentManger;
	ActionBar actionBar;
	String[] menutitles;
	TypedArray menuIcons;
	private DrawerLayout mDrawerLayout;
	private ListView mDrawerList;
	private ActionBarDrawerToggle mDrawerToggle;
	private List<DrawingRowItem> rowItems;
	private CustomAdapter adapter;
	int tabsize;
	int selectedpositoin;


	public static final String MyPREFERENCES = "my";
	public static final String name = "key";
	protected static final String GSF_PACKAGE = "google services framework";
	public static SharedPreferences sharedprefer;
	public static final String PROPERTY_REG_ID = "regId";


	static final Uri APP_URI = Uri.parse("android-app://scorpio.findyourfate.com/http/scorpio.findyourfate.com/scorpio.html");
	static final Uri WEB_URL = Uri.parse("http://scorpio.findyourfate.com/scorpio.html");
	static final Uri EMPTY_WEB_URL = Uri.parse("");
	private GoogleApiClient mClient;


	@SuppressLint({"NewApi", "ResourceType"})
	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);

		setContentView(R.layout.activity_main);
		ActionBar actionBar = getSupportActionBar();
		if (actionBar != null) {
			// Enable the home button and set display options
			actionBar.setDisplayHomeAsUpEnabled(true);
			actionBar.setDisplayOptions(ActionBar.DISPLAY_SHOW_HOME | ActionBar.DISPLAY_SHOW_TITLE | ActionBar.DISPLAY_SHOW_CUSTOM);

			// Set the title of the ActionBar
			actionBar.setTitle(Html.fromHtml("<font color=\"#ffffff\" size=\"25px\"><b>" + "Scorpio" + "</b></font>"));


			// Enable the home button for backward compatibility
			if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.ICE_CREAM_SANDWICH) {
				actionBar.setHomeButtonEnabled(true);
			}

			// Show the ActionBar
			actionBar.show();
		}


		viewPager = (ViewPager) findViewById(R.id.pager);
		viewPager.setOffscreenPageLimit(0);
		actionBar = getSupportActionBar();
		actionBar.setNavigationMode(ActionBar.NAVIGATION_MODE_LIST);
		getSupportActionBar().setDisplayHomeAsUpEnabled(true);
		getSupportActionBar().setHomeButtonEnabled(true);
		fragmentManger = new TapFragmentManager(getSupportFragmentManager());
		viewPager.setAdapter(fragmentManger);


		actionBar.setNavigationMode(ActionBar.NAVIGATION_MODE_TABS);
		menutitles = getResources().getStringArray(R.array.items);
		menuIcons = getResources().obtainTypedArray(R.array.icons);
		mDrawerLayout = (DrawerLayout) findViewById(R.id.drawer_layout);
		mDrawerList = (ListView) findViewById(R.id.slider_list);
		rowItems = new ArrayList<DrawingRowItem>();
		mDrawerLayout.openDrawer(mDrawerList);

		for (int i = 0; i < menutitles.length; i++) {

			DrawingRowItem items = new DrawingRowItem(menutitles[i], menuIcons.getResourceId(i, i));
			rowItems.add(items);
		}

		getSupportActionBar().setTitle(
				Html.fromHtml("<font color=\"#ffffff\" size=\"21px\"><b>" + "Scorpio" + "</b></font>"));
		// getActionBar().setTitle(mTitle +menutitles[0]);
		adapter = new CustomAdapter(getApplicationContext(), rowItems);
		mDrawerList.setAdapter(adapter);
		mDrawerList.setOnItemClickListener(new SlideitemListener());
		getSupportActionBar().setDisplayHomeAsUpEnabled(true);
		// getSupportActionBar().setHomeAsUpIndicator(R.drawable.listicon);
		//getSupportActionBar().setHomeButtonEnabled(true);


		mDrawerToggle = new ActionBarDrawerToggle(this, mDrawerLayout,
				R.drawable.listicon, R.string.app_name) {
			public void onDrawerClosed(View view) {
				ActionBar actionBar = getSupportActionBar();
				if (actionBar != null) {
					// Enable the home button and set display options
					actionBar.setDisplayHomeAsUpEnabled(true);
					actionBar.setDisplayOptions(ActionBar.DISPLAY_SHOW_HOME | ActionBar.DISPLAY_SHOW_TITLE | ActionBar.DISPLAY_SHOW_CUSTOM);

					// Set the title of the ActionBar
					actionBar.setTitle(Html.fromHtml("<font color=\"#ffffff\" size=\"25px\"><b>" + "Scorpio" + "</b></font>"));


					// Enable the home button for backward compatibility
					if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.ICE_CREAM_SANDWICH) {
						actionBar.setHomeButtonEnabled(true);
					}

					// Show the ActionBar
					actionBar.show();
				}
				invalidateOptionsMenu();
			}


			public void onDrawerOpened(View drawerView) {
				ActionBar actionBar = getSupportActionBar();
				if (actionBar != null) {
					// Enable the home button and set display options
					actionBar.setDisplayHomeAsUpEnabled(true);
					actionBar.setDisplayOptions(ActionBar.DISPLAY_SHOW_HOME | ActionBar.DISPLAY_SHOW_TITLE | ActionBar.DISPLAY_SHOW_CUSTOM);

					// Set the title of the ActionBar
					actionBar.setTitle(Html.fromHtml("<font color=\"#ffffff\" size=\"25px\"><b>" + "Scorpio" + "</b></font>"));


					// Enable the home button for backward compatibility
					if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.ICE_CREAM_SANDWICH) {
						actionBar.setHomeButtonEnabled(true);
					}

					// Show the ActionBar
					actionBar.show();
				}
				invalidateOptionsMenu();
			}
		};

		mDrawerLayout.setDrawerListener(mDrawerToggle);
		mDrawerList.setOnItemClickListener(new AdapterView.OnItemClickListener() {
			@Override
			public void onItemClick(AdapterView<?> parent, View view,
									int position, long id) {
				String name = menutitles[+position];
				if (name.equals("")) {
				} else {
					Intent nextScreen = new Intent(MainActivity.this, listcharacter.class);
					nextScreen.putExtra("listvalue", name);
					startActivity(nextScreen);

				}
				//   Toast.makeText(drawer.this, "You Clicked at ",""+positon,Toast.LENGTH_SHORT).show();
			}
		});

		for (int i = 0; i < tabs.length; i++) {
			actionBar.addTab(actionBar.newTab().setText(tabs[i])
					.setTabListener(this));
		}
		ActionBar ActionBar = actionBar;
		viewPager.setOnPageChangeListener(new ViewPager.OnPageChangeListener() {
			@Override
			public void onPageSelected(int tabPosition) {
				ActionBar.setSelectedNavigationItem(tabPosition);

			}

			@Override
			public void onPageScrolled(int arg0, float arg1, int arg2) {
				// TODO Auto-generated method stub

			}

			@Override
			public void onPageScrollStateChanged(int arg0) {
				// TODO Auto-generated method stub
			}
		});
	}

	class SlideitemListener implements ListView.OnItemClickListener {
		@Override
		public void onItemClick(AdapterView<?> parent, View view, int position,
								long id) {
			mDrawerLayout.closeDrawer(mDrawerList);
		}
	}

	public static class PlaceholderFragment extends Fragment {
		public PlaceholderFragment() {
		}

		@Override
		public View onCreateView(LayoutInflater inflater, ViewGroup container,
								 Bundle savedInstanceState) {
			View rootView = inflater.inflate(R.layout.fragment_main, container,
					false);
			return rootView;
		}
	}

	public boolean onNavigationItemSelected(int itemPosition, long itemId) {
		// TODO Auto-generated method stub
		return false;
	}

	public class TapFragmentManager extends FragmentStatePagerAdapter {

		public TapFragmentManager(FragmentManager fm) {
			super(fm);
		}

		@Override
		public Fragment getItem(int tab_position) {

			switch (tab_position) {
				case 0:

					Fragment newFragment = new horoscope();
					return newFragment;
				case 1:

					Fragment fragment2 = new traits();
					return fragment2;
				case 2:

					Fragment fragment4 = new compatibility();
					return fragment4;
			}
			return null;
		}

		@Override
		public int getCount() {
			// TODO Auto-generated method stub
			return tabs.length;
		}
	}

	@Override
	public void onTabReselected(ActionBar.Tab tab, FragmentTransaction arg1) {

	}

	@Override
	public void onTabSelected(ActionBar.Tab tab, FragmentTransaction arg1) {
		// TODO Auto-generated method stub
		if (tab.getPosition() == 1) {
			mDrawerLayout.openDrawer(mDrawerList);
			viewPager.setCurrentItem(tab.getPosition());
		} else {
			mDrawerLayout.closeDrawer(mDrawerList);
			viewPager.setCurrentItem(tab.getPosition());
		}

	}

	@Override
	public void onTabUnselected(ActionBar.Tab arg0, FragmentTransaction arg1) {
		// TODO Auto-generated method stub
	}

	public void onDestroyView() {
		// TODO Auto-generated method stub
		this.onDestroyView();
		actionBar.setNavigationMode(ActionBar.NAVIGATION_MODE_STANDARD);
	}

	public void onPageScrolled(int i, float v, int i2) {

	}

	public void onPageSelected(int i) {

	}

	public void onPageScrollStateChanged(int i) {
	}

	@Override
	protected void onPostCreate(Bundle savedInstanceState) {
		super.onPostCreate(savedInstanceState);
		// Sync the toggle state after onRestoreInstanceState has occurred.
		mDrawerToggle.syncState();
	}

	@Override
	public void onConfigurationChanged(Configuration newConfig) {
		super.onConfigurationChanged(newConfig);
		// Pass any configuration change to the drawer toggles
		mDrawerToggle.onConfigurationChanged(newConfig);
	}


	@Override
	public boolean onPrepareOptionsMenu(Menu menu) {
		boolean drawerOpen = mDrawerLayout.isDrawerOpen(mDrawerList);
		return super.onPrepareOptionsMenu(menu);
	}

	@Override
	public void onBackPressed() {
		super.onBackPressed();
		AlertDialog.Builder builder = new AlertDialog.Builder(this);
		builder.setTitle("Exit!");
		builder.setMessage("Are you sure you want to exit from scorpio app?")
				.setCancelable(false)
				.setIcon(R.drawable.alert)
				.setPositiveButton("Yes", new DialogInterface.OnClickListener() {
					public void onClick(DialogInterface dialog, int id) {
						MainActivity.this.finish();
						Intent intent = new Intent(Intent.ACTION_MAIN);
						intent.addCategory(Intent.CATEGORY_HOME);
						intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
						startActivity(intent);
					}
				})
				.setNegativeButton("No", new DialogInterface.OnClickListener() {
					public void onClick(DialogInterface dialog, int id) {
						dialog.cancel();
					}
				});
		AlertDialog alert = builder.create();
		alert.show();
	}


	@Override
	public boolean onCreateOptionsMenu(Menu menu) {

		MenuInflater inflater = getMenuInflater();
		inflater.inflate(R.menu.main, menu);
		return super.onCreateOptionsMenu(menu);
	}


	@Override
	public boolean onOptionsItemSelected(MenuItem item) {
		// toggle nav drawer on selecting action bar app icon/title
		if (mDrawerToggle.onOptionsItemSelected(item)) {
			return true;
		}
		// Handle action bar actions click
		int id = item.getItemId();
		if (id == R.id.character) {
			Intent in = new Intent(MainActivity.this, signtraits.class);
			startActivity(in);
			return true;
		}
		if (id == R.id.card) {
			Intent in = new Intent(MainActivity.this, card.class);
			startActivity(in);
			return true;
		}
		if (id == R.id.other) {

		} else if(id==R.id.aries)
		{
			AlertDialog.Builder alertDialogBuilder = new AlertDialog.Builder(MainActivity.this);
			alertDialogBuilder.setTitle("Aries");

			alertDialogBuilder.setMessage("Aries app. describes the daily,monthly,weekly, and yearly horoscope for Arians.");
			alertDialogBuilder.setPositiveButton("Open",new DialogInterface.OnClickListener() {

				public void onClick(DialogInterface dialog,int id) {
					final String appPackageName = "aries.findyourfate.com"; // getPackageName() from Context or Activity object
					try {
						startActivity(new Intent(Intent.ACTION_VIEW, Uri.parse("market://details?id=" + appPackageName)));
					} catch (android.content.ActivityNotFoundException anfe) {
						startActivity(new Intent(Intent.ACTION_VIEW, Uri.parse("http://play.google.com/store/apps/details?id=" + appPackageName)));
					}
				}
			});
			alertDialogBuilder.setNeutralButton("Already/Never",new DialogInterface.OnClickListener() {
				public void onClick(DialogInterface dialog,int id) {
					//  MainActivity.this.finish();
					dialog.cancel();
				}
			});
			// set negative button: No message
			alertDialogBuilder.setNegativeButton("Later",new DialogInterface.OnClickListener() {
				public void onClick(DialogInterface dialog,int id) {
					// cancel the alert box and put a Toast to the user
					dialog.cancel();
				}
			});
			AlertDialog alertDialog = alertDialogBuilder.create();

			// show alert
			alertDialog.show();
		}
		else if(id==R.id.taurus)
		{
			AlertDialog.Builder alertDialogBuilder = new AlertDialog.Builder(MainActivity.this);
			alertDialogBuilder.setTitle("Taurus");

			alertDialogBuilder.setMessage("Taurus app. describes the daily,monthly,weekly, and yearly horoscope for Taureans.");
			alertDialogBuilder.setPositiveButton("Open",new DialogInterface.OnClickListener() {

				public void onClick(DialogInterface dialog,int id) {
					final String appPackageName = "taurus.findyourfate.com"; // getPackageName() from Context or Activity object
					try {
						startActivity(new Intent(Intent.ACTION_VIEW, Uri.parse("market://details?id=" + appPackageName)));
					} catch (android.content.ActivityNotFoundException anfe) {
						startActivity(new Intent(Intent.ACTION_VIEW, Uri.parse("http://play.google.com/store/apps/details?id=" + appPackageName)));
					}
				}
			});
			alertDialogBuilder.setNeutralButton("Already/Never",new DialogInterface.OnClickListener() {
				public void onClick(DialogInterface dialog,int id) {
					//  MainActivity.this.finish();
					dialog.cancel();
				}

			});

			// set negative button: No message
			alertDialogBuilder.setNegativeButton("Later",new DialogInterface.OnClickListener() {

				public void onClick(DialogInterface dialog,int id) {
					// cancel the alert box and put a Toast to the user
					dialog.cancel();
				}

			});
			AlertDialog alertDialog = alertDialogBuilder.create();

			// show alert
			alertDialog.show();
		}
		else if(id==R.id.gemini)
		{
			AlertDialog.Builder alertDialogBuilder = new AlertDialog.Builder(MainActivity.this);
			alertDialogBuilder.setTitle("Gemini");

			alertDialogBuilder.setMessage("Gemini app. describes the daily,monthly,weekly, and yearly horoscope for Gemini.");
			alertDialogBuilder.setPositiveButton("Open",new DialogInterface.OnClickListener() {

				public void onClick(DialogInterface dialog,int id) {
					final String appPackageName = "gemini.findyourfate.com"; // getPackageName() from Context or Activity object
					try {
						startActivity(new Intent(Intent.ACTION_VIEW, Uri.parse("market://details?id=" + appPackageName)));
					} catch (android.content.ActivityNotFoundException anfe) {
						startActivity(new Intent(Intent.ACTION_VIEW, Uri.parse("http://play.google.com/store/apps/details?id=" + appPackageName)));
					}
				}
			});
			alertDialogBuilder.setNeutralButton("Already/Never",new DialogInterface.OnClickListener() {
				public void onClick(DialogInterface dialog,int id) {
					//  MainActivity.this.finish();
					dialog.cancel();
				}

			});

			// set negative button: No message
			alertDialogBuilder.setNegativeButton("Later",new DialogInterface.OnClickListener() {

				public void onClick(DialogInterface dialog,int id) {
					// cancel the alert box and put a Toast to the user
					dialog.cancel();
				}

			});
			AlertDialog alertDialog = alertDialogBuilder.create();
			alertDialog.show();
		}
		else if(id==R.id.can)
		{
			AlertDialog.Builder alertDialogBuilder = new AlertDialog.Builder(MainActivity.this);
			alertDialogBuilder.setTitle("Cancer");

			alertDialogBuilder.setMessage("Cancer app. describes the daily,monthly,weekly, and yearly horoscope for Cancerian.");
			alertDialogBuilder.setPositiveButton("Open",new DialogInterface.OnClickListener() {

				public void onClick(DialogInterface dialog,int id) {
					final String appPackageName = "cancer.findyourfate.com"; // getPackageName() from Context or Activity object
					try {
						startActivity(new Intent(Intent.ACTION_VIEW, Uri.parse("market://details?id=" + appPackageName)));
					} catch (android.content.ActivityNotFoundException anfe) {
						startActivity(new Intent(Intent.ACTION_VIEW, Uri.parse("http://play.google.com/store/apps/details?id=" + appPackageName)));
					}
				}
			});
			alertDialogBuilder.setNeutralButton("Already/Never",new DialogInterface.OnClickListener() {
				public void onClick(DialogInterface dialog,int id) {
					//  MainActivity.this.finish();
					dialog.cancel();
				}

			});

			alertDialogBuilder.setNegativeButton("Later",new DialogInterface.OnClickListener() {

				public void onClick(DialogInterface dialog,int id) {
					dialog.cancel();
				}
			});
			AlertDialog alertDialog = alertDialogBuilder.create();

			// show alert
			alertDialog.show();
		}
		else if(id==R.id.leeo)
		{
			AlertDialog.Builder alertDialogBuilder = new AlertDialog.Builder(MainActivity.this);
			alertDialogBuilder.setTitle("Leo");

			alertDialogBuilder.setMessage("Leo app. describes the daily,monthly,weekly, and yearly horoscope for Leo.");
			alertDialogBuilder.setPositiveButton("Open",new DialogInterface.OnClickListener() {

				public void onClick(DialogInterface dialog,int id) {
					final String appPackageName = "leo.findyourfate.com"; // getPackageName() from Context or Activity object
					try {
						startActivity(new Intent(Intent.ACTION_VIEW, Uri.parse("market://details?id=" + appPackageName)));
					} catch (android.content.ActivityNotFoundException anfe) {
						startActivity(new Intent(Intent.ACTION_VIEW, Uri.parse("http://play.google.com/store/apps/details?id=" + appPackageName)));
					}
				}
			});
			alertDialogBuilder.setNeutralButton("Already/Never",new DialogInterface.OnClickListener() {
				public void onClick(DialogInterface dialog,int id) {
					//  MainActivity.this.finish();
					dialog.cancel();
				}

			});

			alertDialogBuilder.setNegativeButton("Later",new DialogInterface.OnClickListener() {

				public void onClick(DialogInterface dialog,int id) {
					dialog.cancel();
				}
			});
			AlertDialog alertDialog = alertDialogBuilder.create();

			// show alert
			alertDialog.show();
		}
		else if(id==R.id.virr)
		{
			AlertDialog.Builder alertDialogBuilder = new AlertDialog.Builder(MainActivity.this);
			alertDialogBuilder.setTitle("Virgo");

			alertDialogBuilder.setMessage("Virgo app. describes the daily,monthly,weekly, and yearly horoscope for Virgo.");
			alertDialogBuilder.setPositiveButton("Open",new DialogInterface.OnClickListener() {

				public void onClick(DialogInterface dialog,int id) {
					final String appPackageName = "virgo.findyourfate.com"; // getPackageName() from Context or Activity object
					try {
						startActivity(new Intent(Intent.ACTION_VIEW, Uri.parse("market://details?id=" + appPackageName)));
					} catch (android.content.ActivityNotFoundException anfe) {
						startActivity(new Intent(Intent.ACTION_VIEW, Uri.parse("http://play.google.com/store/apps/details?id=" + appPackageName)));
					}
				}
			});
			alertDialogBuilder.setNeutralButton("Already/Never",new DialogInterface.OnClickListener() {
				public void onClick(DialogInterface dialog,int id) {
					//  MainActivity.this.finish();
					dialog.cancel();
				}

			});

			alertDialogBuilder.setNegativeButton("Later",new DialogInterface.OnClickListener() {

				public void onClick(DialogInterface dialog,int id) {
					dialog.cancel();
				}
			});
			AlertDialog alertDialog = alertDialogBuilder.create();

			// show alert
			alertDialog.show();
		}

		else if(id==R.id.lib)
		{
			AlertDialog.Builder alertDialogBuilder = new AlertDialog.Builder(MainActivity.this);
			alertDialogBuilder.setTitle("Libra");

			alertDialogBuilder.setMessage("Libra app. describes the daily,monthly,weekly, and yearly horoscope for Libra.");
			alertDialogBuilder.setPositiveButton("Open",new DialogInterface.OnClickListener() {

				public void onClick(DialogInterface dialog,int id) {
					final String appPackageName = "libra.findyourfate.com"; // getPackageName() from Context or Activity object
					try {
						startActivity(new Intent(Intent.ACTION_VIEW, Uri.parse("market://details?id=" + appPackageName)));
					} catch (android.content.ActivityNotFoundException anfe) {
						startActivity(new Intent(Intent.ACTION_VIEW, Uri.parse("http://play.google.com/store/apps/details?id=" + appPackageName)));
					}
				}
			});
			alertDialogBuilder.setNeutralButton("Already/Never",new DialogInterface.OnClickListener() {
				public void onClick(DialogInterface dialog,int id) {
					//  MainActivity.this.finish();
					dialog.cancel();
				}

			});

			alertDialogBuilder.setNegativeButton("Later",new DialogInterface.OnClickListener() {

				public void onClick(DialogInterface dialog,int id) {
					dialog.cancel();
				}
			});
			AlertDialog alertDialog = alertDialogBuilder.create();
			alertDialog.show();
		}

		else if(id==R.id.sagitt)
		{
			AlertDialog.Builder alertDialogBuilder = new AlertDialog.Builder(MainActivity.this);
			alertDialogBuilder.setTitle("Sagittarius");

			alertDialogBuilder.setMessage("Sagittarius Horoscopes gives you the daily, monthly, weekly, and yearly horoscope forecast with accurate astrology predictions in Career, Health, Love, Fashion, Finance, etc.");
			alertDialogBuilder.setPositiveButton("Open",new DialogInterface.OnClickListener() {

				public void onClick(DialogInterface dialog,int id) {
					final String appPackageName = "sagittarius.findyourfate.com"; // getPackageName() from Context or Activity object
					try {
						startActivity(new Intent(Intent.ACTION_VIEW, Uri.parse("market://details?id=" + appPackageName)));
					} catch (android.content.ActivityNotFoundException anfe) {
						startActivity(new Intent(Intent.ACTION_VIEW, Uri.parse("http://play.google.com/store/apps/details?id=" + appPackageName)));
					}
				}
			});
			alertDialogBuilder.setNeutralButton("Already/Never",new DialogInterface.OnClickListener() {
				public void onClick(DialogInterface dialog,int id) {
					//  MainActivity.this.finish();
					dialog.cancel();
				}

			});
			alertDialogBuilder.setNegativeButton("Later",new DialogInterface.OnClickListener() {
				public void onClick(DialogInterface dialog,int id) {
					dialog.cancel();
				}
			});
			AlertDialog alertDialog = alertDialogBuilder.create();
			alertDialog.show();
		}
		else if(id==R.id.caapri)
		{
			AlertDialog.Builder alertDialogBuilder = new AlertDialog.Builder(MainActivity.this);
			alertDialogBuilder.setTitle("Capricorn");

			alertDialogBuilder.setMessage("Capricorn Horoscopes gives you the daily, monthly, weekly, and yearly horoscope forecast with accurate astrology predictions in Career, Health, Love, Fashion, Finance, etc.");
			alertDialogBuilder.setPositiveButton("Open",new DialogInterface.OnClickListener() {

				public void onClick(DialogInterface dialog,int id) {
					final String appPackageName = "capricorn.findyourfate.com"; // getPackageName() from Context or Activity object
					try {
						startActivity(new Intent(Intent.ACTION_VIEW, Uri.parse("market://details?id=" + appPackageName)));
					} catch (android.content.ActivityNotFoundException anfe) {
						startActivity(new Intent(Intent.ACTION_VIEW, Uri.parse("http://play.google.com/store/apps/details?id=" + appPackageName)));
					}
				}
			});
			alertDialogBuilder.setNeutralButton("Already/Never",new DialogInterface.OnClickListener() {
				public void onClick(DialogInterface dialog,int id) {
					//  MainActivity.this.finish();
					dialog.cancel();
				}
			});
			alertDialogBuilder.setNegativeButton("Later",new DialogInterface.OnClickListener() {
				public void onClick(DialogInterface dialog,int id) {
					dialog.cancel();
				}
			});
			AlertDialog alertDialog = alertDialogBuilder.create();
			alertDialog.show();
		}
		else if(id==R.id.aquaar)
		{
			AlertDialog.Builder alertDialogBuilder = new AlertDialog.Builder(MainActivity.this);
			alertDialogBuilder.setTitle("Aquarius");

			alertDialogBuilder.setMessage("Aquarius  Horoscopes gives you the daily, monthly, weekly, and yearly horoscope forecast with accurate astrology predictions in Career, Health, Love, Fashion, Finance, etc.");
			alertDialogBuilder.setPositiveButton("Open",new DialogInterface.OnClickListener() {

				public void onClick(DialogInterface dialog,int id) {
					final String appPackageName = "aquarius.findyourfate.com"; // getPackageName() from Context or Activity object
					try {
						startActivity(new Intent(Intent.ACTION_VIEW, Uri.parse("market://details?id=" + appPackageName)));
					} catch (android.content.ActivityNotFoundException anfe) {
						startActivity(new Intent(Intent.ACTION_VIEW, Uri.parse("http://play.google.com/store/apps/details?id=" + appPackageName)));
					}
				}
			});
			alertDialogBuilder.setNeutralButton("Already/Never",new DialogInterface.OnClickListener() {
				public void onClick(DialogInterface dialog,int id) {
					//  MainActivity.this.finish();
					dialog.cancel();
				}
			});
			alertDialogBuilder.setNegativeButton("Later",new DialogInterface.OnClickListener() {
				public void onClick(DialogInterface dialog,int id) {
					dialog.cancel();
				}
			});
			AlertDialog alertDialog = alertDialogBuilder.create();
			alertDialog.show();
		}

		else if(id==R.id.piic)
		{
			AlertDialog.Builder alertDialogBuilder = new AlertDialog.Builder(MainActivity.this);
			alertDialogBuilder.setTitle("Pisces");

			alertDialogBuilder.setMessage("Pisces  Horoscopes gives you the daily, monthly, weekly, and yearly horoscope forecast with accurate astrology predictions in Career, Health, Love, Fashion, Finance, etc.");
			alertDialogBuilder.setPositiveButton("Open",new DialogInterface.OnClickListener() {

				public void onClick(DialogInterface dialog,int id) {
					final String appPackageName = "pisces.findyourfate.com"; // getPackageName() from Context or Activity object
					try {
						startActivity(new Intent(Intent.ACTION_VIEW, Uri.parse("market://details?id=" + appPackageName)));
					} catch (android.content.ActivityNotFoundException anfe) {
						startActivity(new Intent(Intent.ACTION_VIEW, Uri.parse("http://play.google.com/store/apps/details?id=" + appPackageName)));
					}
				}
			});
			alertDialogBuilder.setNeutralButton("Already/Never",new DialogInterface.OnClickListener() {
				public void onClick(DialogInterface dialog,int id) {
					//  MainActivity.this.finish();
					dialog.cancel();
				}
			});
			alertDialogBuilder.setNegativeButton("Later",new DialogInterface.OnClickListener() {
				public void onClick(DialogInterface dialog,int id) {
					dialog.cancel();
				}
			});
			AlertDialog alertDialog = alertDialogBuilder.create();
			alertDialog.show();
		} else  if(id==R.id.share)
		{
			Intent emailIntent = new Intent(android.content.Intent.ACTION_SEND);
			emailIntent.setType("text/plain");
			emailIntent.putExtra(android.content.Intent.EXTRA_SUBJECT, "Scorpio - Findyourfate.com ");
			emailIntent.putExtra(android.content.Intent.EXTRA_TEXT, "Hi,I would like to suggest, this Scorpio App to you. \n\n Click this Link to Download app \"http://goo.gl/BvjaNx\"\n\n Regards");
			startActivity(emailIntent);
		}
		else if(id==R.id.exit)
		{
			AlertDialog.Builder builder = new AlertDialog.Builder(this);
			builder.setTitle("Exit!");
			builder.setMessage("Are you sure want to exit from Scorpio Apps?")
					.setCancelable(false)
					.setIcon(R.drawable.alert)
					.setPositiveButton("Yes", new DialogInterface.OnClickListener() {
						public void onClick(DialogInterface dialog, int id) {
							Intent intent = new Intent(Intent.ACTION_MAIN);
							intent.addCategory(Intent.CATEGORY_HOME);
							intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
							startActivity(intent);
						}
					})
					.setNegativeButton("No", new DialogInterface.OnClickListener() {
						public void onClick(DialogInterface dialog, int id) {
							dialog.cancel();
						}
					});
			AlertDialog alert = builder.create();
			alert.show();
		} else if (id == R.id.notifi) {
			initiatePopupWindow();

		} else {

		}
		return super.onOptionsItemSelected(item);
	}

	PopupWindow popupWindow;
	Button btnClosePopup, btnokpop;
	CheckBox checkb;
	String key;
	String regId;

	private void initiatePopupWindow() {
		if (isFinishing() || isDestroyed()) {
			Log.w("PopupWindow", "Activity is not in a valid state to show the popup.");
			return;
		}
		LayoutInflater layoutInflater = (LayoutInflater) getBaseContext().getSystemService(LAYOUT_INFLATER_SERVICE);
		final View popupView = layoutInflater.inflate(R.layout.screen_popup, null);
		popupWindow = new PopupWindow(
				popupView,
				ViewGroup.LayoutParams.WRAP_CONTENT,
				ViewGroup.LayoutParams.WRAP_CONTENT);
		popupWindow.setFocusable(true);
		regId = getIntent().getStringExtra("REGID");

		Button btnClosePopup = (Button) popupView.findViewById(R.id.btn_close_popup);
		Button btnokpop = (Button) popupView.findViewById(R.id.btn_ok_popup);

		CheckBox checkb = (CheckBox) popupView.findViewById(R.id.checkBox);

		sharedprefer = getSharedPreferences(MyPREFERENCES, Context.MODE_PRIVATE);

		if (sharedprefer.contains(name)) {
			String notfykey = sharedprefer.getString("key", name);
			String notifyKey = null;
			checkb.setChecked("yes".equals(notifyKey));

		}

		btnClosePopup.setOnClickListener(v -> popupWindow.dismiss());


		btnokpop.setOnClickListener(v -> {
			String key = checkb.isChecked() ? "yes" : "no";

			//Toast.makeText(MainActivity.this, key, Toast.LENGTH_LONG).show();
			SharedPreferences.Editor editor = sharedprefer.edit();
			editor.putString(name, key);
			editor.apply();
			popupWindow.dismiss();

			Intent int_dr1 = new Intent(MainActivity.this, showlink.class);
			int_dr1.putExtra("regId", regId);
			int_dr1.putExtra("statlink", key);
			int_dr1.addFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP);
			startActivity(int_dr1);


		});
		try {
			popupWindow.showAtLocation(findViewById(android.R.id.content), Gravity.CENTER, 0, 0);
		} catch (WindowManager.BadTokenException e) {
			Log.e("popupWindow", "Failed to show popup:" + e.getMessage());
		}
	}
}
