package  libra.findyourfate.com;  

import android.app.IntentService;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.SystemClock;
import android.support.v4.app.NotificationCompat;
import android.util.Log;
 
import com.google.android.gms.gcm.GoogleCloudMessaging;
 
public class GCMNotificationIntentService extends IntentService {
 
  public static final int NOTIFICATION_ID = 1;
  private NotificationManager mNotificationManager;
  NotificationCompat.Builder builder;
 
  public GCMNotificationIntentService() {
    super("GcmIntentService");
     }
   public static final String TAG = "GCMNotificationIntentService";
 
  @Override
  protected void onHandleIntent(Intent intent) {
    Bundle extras = intent.getExtras();
    Bundle extras1 = intent.getExtras();
    Bundle extras2 = intent.getExtras();
    GoogleCloudMessaging gcm = GoogleCloudMessaging.getInstance(this);
 
    String messageType = gcm.getMessageType(intent);
 
    if (!extras.isEmpty()) {
      if (GoogleCloudMessaging.MESSAGE_TYPE_SEND_ERROR
          .equals(messageType)) {
        sendNotification("Send error: " + extras.toString(),extras1.toString(),extras2.toString());
      } else if (GoogleCloudMessaging.MESSAGE_TYPE_DELETED
          .equals(messageType)) {
        sendNotification("Deleted messages on server: "
            + extras.toString(),extras1.toString(),extras2.toString());
      } else if (GoogleCloudMessaging.MESSAGE_TYPE_MESSAGE
          .equals(messageType)) {
       for (int i = 0; i < 3; i++) {
          Log.i(TAG,
              "Working... " + (i + 1) + "/5 @ "
                  + SystemClock.elapsedRealtime());
          try {
            Thread.sleep(5000);
          } catch (InterruptedException e) {
          }
          }
        Log.i(TAG, "Completed work @ " + SystemClock.elapsedRealtime());
 
        sendNotification(""+extras.get(Config.MESSAGE_KEY),""+extras1.get(Config.MESSAGE_KEY1),""+extras2.get(Config.MESSAGE_KEY2));
        Log.i(TAG, "Received: " + extras.toString()+extras1.toString());
      }
    }
    GcmBroadcastReceiver.completeWakefulIntent(intent);
  }
  
  private void sendNotification(String msg,String plink,String typemode) {
	    Log.d(TAG, "Preparing to send notification...: " + msg+"&tit:"+plink+"&pagelink="+typemode);
	    
	 NotificationCompat.Builder mBuilder =
	            new NotificationCompat.Builder(this)
	                    .setSmallIcon(R.drawable.libra)
	                    .setContentTitle(plink)
	                    .setContentText(msg)  
	     .setWhen(System.currentTimeMillis())
	    .setAutoCancel(true) 
	    .setDefaults(Notification.DEFAULT_ALL);
	      
	    Intent intent  =new Intent(getApplicationContext(), shownote.class);
	    intent.putExtra("pagelink",typemode); 
	    intent.putExtra("pagetitle", plink);
	    intent.putExtra("pagedec", msg);
	     
	    PendingIntent contentIntent = PendingIntent.getActivity(getApplicationContext(), 0, intent,PendingIntent.FLAG_UPDATE_CURRENT | PendingIntent.FLAG_ONE_SHOT);
      
	    mBuilder.setContentIntent(contentIntent);
	    NotificationManager mNotificationManager =
	            (NotificationManager) this.getSystemService(Context.NOTIFICATION_SERVICE); 
	    mNotificationManager.notify(NOTIFICATION_ID, mBuilder.build());
	     Log.d(TAG, "Notification sent successfully.");
	  }
}