package libra.findyourfate.com;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Build;

import androidx.core.app.NotificationCompat;

import com.google.firebase.messaging.FirebaseMessagingService;
import com.google.firebase.messaging.RemoteMessage;
import android.util.Log;




public class GCMNotificationIntentService extends FirebaseMessagingService {

    public static final int NOTIFICATION_ID = 1;
    private static final String TAG = "FCMNotificationService";
    private NotificationManager mNotificationManager;
    NotificationCompat.Builder builder;

    @Override
    public void onMessageReceived(RemoteMessage remoteMessage) {
        super.onMessageReceived(remoteMessage);

        // Logging the message data payload
        Log.d(TAG, "From: " + remoteMessage.getFrom());
        Log.d(TAG, "Message data payload: " + remoteMessage.getData());

        // Extracting data from the payload
        String msg = remoteMessage.getData().get("message"); // Replace with your key
        String plink = remoteMessage.getData().get("pagetitle"); // Replace with your key
        String typemode = remoteMessage.getData().get("pagelink"); // Replace with your key

        sendNotification(msg, plink, typemode);
    }

    private void sendNotification(String msg, String plink, String typemode) {
        Log.d(TAG, "Preparing to send notification...: " + msg + "&title: " + plink + "&pagelink=" + typemode);

        NotificationManager mNotificationManager = (NotificationManager) getSystemService(Context.NOTIFICATION_SERVICE);

        // Create notification channel for Android 8.0+
        String channelId = "default_channel";
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
            NotificationChannel channel = new NotificationChannel(channelId, "Default Channel", NotificationManager.IMPORTANCE_DEFAULT);
            channel.setDescription("Default channel for notifications");
            mNotificationManager.createNotificationChannel(channel);
        }

        // Create the notification
        NotificationCompat.Builder mBuilder = new NotificationCompat.Builder(this, channelId)
                .setSmallIcon(R.drawable.cancer) // Replace with your app icon
                .setContentTitle(plink)
                .setContentText(msg)
                .setWhen(System.currentTimeMillis())
                .setAutoCancel(true)
                .setDefaults(Notification.DEFAULT_ALL);

        // Intent to open activity when notification is clicked
        Intent intent = new Intent(this, shownote.class);
        intent.putExtra("pagelink", typemode);
        intent.putExtra("pagetitle", plink);
        intent.putExtra("pagedec", msg);

        PendingIntent contentIntent = PendingIntent.getActivity(this, 0, intent, PendingIntent.FLAG_UPDATE_CURRENT | PendingIntent.FLAG_ONE_SHOT);
        mBuilder.setContentIntent(contentIntent);

        // Notify the user
        mNotificationManager.notify(NOTIFICATION_ID, mBuilder.build());
        Log.d(TAG, "Notification sent successfully.");
    }

    @Override
    public void onNewToken(String token) {
        super.onNewToken(token);
        Log.d(TAG, "Refreshed token: " + token);

        // Send the token to your server for further processing
        // Example: sendTokenToServer(token);
    }
}