/*
 * Decompiled with CFR 0.152.
 */
package leo.findyourfate.com;

import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.util.Log;
import androidx.core.app.NotificationCompat;
import com.google.firebase.messaging.FirebaseMessagingService;
import com.google.firebase.messaging.RemoteMessage;
import leo.findyourfate.com.R;
import leo.findyourfate.com.shownote;

public class GCMNotificationIntentService
extends FirebaseMessagingService {
    public static final int NOTIFICATION_ID = 1;
    private static final String TAG = "FCMNotificationService";
    private NotificationManager mNotificationManager;
    NotificationCompat.Builder builder;

    public void onMessageReceived(RemoteMessage remoteMessage) {
        super.onMessageReceived(remoteMessage);
        Log.d((String)TAG, (String)("From: " + remoteMessage.getFrom()));
        Log.d((String)TAG, (String)("Message data payload: " + remoteMessage.getData()));
        String msg = (String)remoteMessage.getData().get("message");
        String plink = (String)remoteMessage.getData().get("pagetitle");
        String typemode = (String)remoteMessage.getData().get("pagelink");
        this.sendNotification(msg, plink, typemode);
    }

    private void sendNotification(String msg, String plink, String typemode) {
        Log.d((String)TAG, (String)("Preparing to send notification...: " + msg + "&title: " + plink + "&pagelink=" + typemode));
        NotificationManager mNotificationManager = (NotificationManager)this.getSystemService("notification");
        String channelId = "default_channel";
        if (Build.VERSION.SDK_INT >= 26) {
            NotificationChannel channel = new NotificationChannel(channelId, (CharSequence)"Default Channel", 3);
            channel.setDescription("Default channel for notifications");
            mNotificationManager.createNotificationChannel(channel);
        }
        NotificationCompat.Builder mBuilder = new NotificationCompat.Builder((Context)this, channelId).setSmallIcon(R.drawable.cancer).setContentTitle((CharSequence)plink).setContentText((CharSequence)msg).setWhen(System.currentTimeMillis()).setAutoCancel(true).setDefaults(-1);
        Intent intent = new Intent((Context)this, shownote.class);
        intent.putExtra("pagelink", typemode);
        intent.putExtra("pagetitle", plink);
        intent.putExtra("pagedec", msg);
        PendingIntent contentIntent = PendingIntent.getActivity((Context)this, (int)0, (Intent)intent, (int)0x48000000);
        mBuilder.setContentIntent(contentIntent);
        mNotificationManager.notify(1, mBuilder.build());
        Log.d((String)TAG, (String)"Notification sent successfully.");
    }

    public void onNewToken(String token) {
        super.onNewToken(token);
        Log.d((String)TAG, (String)("Refreshed token: " + token));
    }
}

