/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.apache.http.impl.client;

import org.shaded.apache.http.ConnectionReuseStrategy;
import org.shaded.apache.http.HttpVersion;
import org.shaded.apache.http.annotation.ThreadSafe;
import org.shaded.apache.http.auth.AuthSchemeRegistry;
import org.shaded.apache.http.client.AuthenticationHandler;
import org.shaded.apache.http.client.CookieStore;
import org.shaded.apache.http.client.CredentialsProvider;
import org.shaded.apache.http.client.HttpRequestRetryHandler;
import org.shaded.apache.http.client.RedirectHandler;
import org.shaded.apache.http.client.UserTokenHandler;
import org.shaded.apache.http.client.protocol.RequestAddCookies;
import org.shaded.apache.http.client.protocol.RequestClientConnControl;
import org.shaded.apache.http.client.protocol.RequestDefaultHeaders;
import org.shaded.apache.http.client.protocol.RequestProxyAuthentication;
import org.shaded.apache.http.client.protocol.RequestTargetAuthentication;
import org.shaded.apache.http.client.protocol.ResponseProcessCookies;
import org.shaded.apache.http.conn.ClientConnectionManager;
import org.shaded.apache.http.conn.ClientConnectionManagerFactory;
import org.shaded.apache.http.conn.ConnectionKeepAliveStrategy;
import org.shaded.apache.http.conn.routing.HttpRoutePlanner;
import org.shaded.apache.http.conn.scheme.PlainSocketFactory;
import org.shaded.apache.http.conn.scheme.Scheme;
import org.shaded.apache.http.conn.scheme.SchemeRegistry;
import org.shaded.apache.http.conn.ssl.SSLSocketFactory;
import org.shaded.apache.http.cookie.CookieSpecRegistry;
import org.shaded.apache.http.impl.DefaultConnectionReuseStrategy;
import org.shaded.apache.http.impl.auth.BasicSchemeFactory;
import org.shaded.apache.http.impl.auth.DigestSchemeFactory;
import org.shaded.apache.http.impl.client.AbstractHttpClient;
import org.shaded.apache.http.impl.client.BasicCookieStore;
import org.shaded.apache.http.impl.client.BasicCredentialsProvider;
import org.shaded.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;
import org.shaded.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.shaded.apache.http.impl.client.DefaultProxyAuthenticationHandler;
import org.shaded.apache.http.impl.client.DefaultRedirectHandler;
import org.shaded.apache.http.impl.client.DefaultTargetAuthenticationHandler;
import org.shaded.apache.http.impl.client.DefaultUserTokenHandler;
import org.shaded.apache.http.impl.conn.DefaultHttpRoutePlanner;
import org.shaded.apache.http.impl.conn.SingleClientConnManager;
import org.shaded.apache.http.impl.cookie.BestMatchSpecFactory;
import org.shaded.apache.http.impl.cookie.BrowserCompatSpecFactory;
import org.shaded.apache.http.impl.cookie.NetscapeDraftSpecFactory;
import org.shaded.apache.http.impl.cookie.RFC2109SpecFactory;
import org.shaded.apache.http.impl.cookie.RFC2965SpecFactory;
import org.shaded.apache.http.params.BasicHttpParams;
import org.shaded.apache.http.params.HttpConnectionParams;
import org.shaded.apache.http.params.HttpParams;
import org.shaded.apache.http.params.HttpProtocolParams;
import org.shaded.apache.http.protocol.BasicHttpContext;
import org.shaded.apache.http.protocol.BasicHttpProcessor;
import org.shaded.apache.http.protocol.HttpContext;
import org.shaded.apache.http.protocol.HttpRequestExecutor;
import org.shaded.apache.http.protocol.RequestContent;
import org.shaded.apache.http.protocol.RequestExpectContinue;
import org.shaded.apache.http.protocol.RequestTargetHost;
import org.shaded.apache.http.protocol.RequestUserAgent;
import org.shaded.apache.http.util.VersionInfo;

@ThreadSafe
public class DefaultHttpClient
extends AbstractHttpClient {
    public DefaultHttpClient(ClientConnectionManager conman, HttpParams params) {
        super(conman, params);
    }

    public DefaultHttpClient(HttpParams params) {
        super(null, params);
    }

    public DefaultHttpClient() {
        super(null, null);
    }

    protected HttpParams createHttpParams() {
        BasicHttpParams params = new BasicHttpParams();
        HttpProtocolParams.setVersion(params, HttpVersion.HTTP_1_1);
        HttpProtocolParams.setContentCharset(params, "ISO-8859-1");
        HttpProtocolParams.setUseExpectContinue(params, true);
        HttpConnectionParams.setTcpNoDelay(params, true);
        HttpConnectionParams.setSocketBufferSize(params, 8192);
        VersionInfo vi = VersionInfo.loadVersionInfo("org.shaded.apache.http.client", this.getClass().getClassLoader());
        String release = vi != null ? vi.getRelease() : "UNAVAILABLE";
        HttpProtocolParams.setUserAgent(params, "Apache-HttpClient/" + release + " (java 1.5)");
        return params;
    }

    protected HttpRequestExecutor createRequestExecutor() {
        return new HttpRequestExecutor();
    }

    protected ClientConnectionManager createClientConnectionManager() {
        SchemeRegistry registry = new SchemeRegistry();
        registry.register(new Scheme("http", PlainSocketFactory.getSocketFactory(), 80));
        registry.register(new Scheme("https", SSLSocketFactory.getSocketFactory(), 443));
        ClientConnectionManager connManager = null;
        HttpParams params = this.getParams();
        ClientConnectionManagerFactory factory = null;
        String className = (String)params.getParameter("http.connection-manager.factory-class-name");
        if (className != null) {
            try {
                Class<?> clazz = Class.forName(className);
                factory = (ClientConnectionManagerFactory)clazz.newInstance();
            }
            catch (ClassNotFoundException ex) {
                throw new IllegalStateException("Invalid class name: " + className);
            }
            catch (IllegalAccessException ex) {
                throw new IllegalAccessError(ex.getMessage());
            }
            catch (InstantiationException ex) {
                throw new InstantiationError(ex.getMessage());
            }
        }
        connManager = factory != null ? factory.newInstance(params, registry) : new SingleClientConnManager(this.getParams(), registry);
        return connManager;
    }

    protected HttpContext createHttpContext() {
        BasicHttpContext context = new BasicHttpContext();
        context.setAttribute("http.scheme-registry", this.getConnectionManager().getSchemeRegistry());
        context.setAttribute("http.authscheme-registry", this.getAuthSchemes());
        context.setAttribute("http.cookiespec-registry", this.getCookieSpecs());
        context.setAttribute("http.cookie-store", this.getCookieStore());
        context.setAttribute("http.auth.credentials-provider", this.getCredentialsProvider());
        return context;
    }

    protected ConnectionReuseStrategy createConnectionReuseStrategy() {
        return new DefaultConnectionReuseStrategy();
    }

    protected ConnectionKeepAliveStrategy createConnectionKeepAliveStrategy() {
        return new DefaultConnectionKeepAliveStrategy();
    }

    protected AuthSchemeRegistry createAuthSchemeRegistry() {
        AuthSchemeRegistry registry = new AuthSchemeRegistry();
        registry.register("Basic", new BasicSchemeFactory());
        registry.register("Digest", new DigestSchemeFactory());
        return registry;
    }

    protected CookieSpecRegistry createCookieSpecRegistry() {
        CookieSpecRegistry registry = new CookieSpecRegistry();
        registry.register("best-match", new BestMatchSpecFactory());
        registry.register("compatibility", new BrowserCompatSpecFactory());
        registry.register("netscape", new NetscapeDraftSpecFactory());
        registry.register("rfc2109", new RFC2109SpecFactory());
        registry.register("rfc2965", new RFC2965SpecFactory());
        return registry;
    }

    protected BasicHttpProcessor createHttpProcessor() {
        BasicHttpProcessor httpproc = new BasicHttpProcessor();
        httpproc.addInterceptor(new RequestDefaultHeaders());
        httpproc.addInterceptor(new RequestContent());
        httpproc.addInterceptor(new RequestTargetHost());
        httpproc.addInterceptor(new RequestClientConnControl());
        httpproc.addInterceptor(new RequestUserAgent());
        httpproc.addInterceptor(new RequestExpectContinue());
        httpproc.addInterceptor(new RequestAddCookies());
        httpproc.addInterceptor(new ResponseProcessCookies());
        httpproc.addInterceptor(new RequestTargetAuthentication());
        httpproc.addInterceptor(new RequestProxyAuthentication());
        return httpproc;
    }

    protected HttpRequestRetryHandler createHttpRequestRetryHandler() {
        return new DefaultHttpRequestRetryHandler();
    }

    protected RedirectHandler createRedirectHandler() {
        return new DefaultRedirectHandler();
    }

    protected AuthenticationHandler createTargetAuthenticationHandler() {
        return new DefaultTargetAuthenticationHandler();
    }

    protected AuthenticationHandler createProxyAuthenticationHandler() {
        return new DefaultProxyAuthenticationHandler();
    }

    protected CookieStore createCookieStore() {
        return new BasicCookieStore();
    }

    protected CredentialsProvider createCredentialsProvider() {
        return new BasicCredentialsProvider();
    }

    protected HttpRoutePlanner createHttpRoutePlanner() {
        return new DefaultHttpRoutePlanner(this.getConnectionManager().getSchemeRegistry());
    }

    protected UserTokenHandler createUserTokenHandler() {
        return new DefaultUserTokenHandler();
    }
}

